/*
 *        cw_keyer.cpp  -  cw_keyer support
 *			   part of OMAC project
 *	  (C)2001 Michal Karas OM4AA <om4aa@qsl.net>
 *
 *
 *	  Copying policy: GNU GPL
 */


#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>
#include <pc.h>
#include <dos.h>
#include <unistd.h>

#include "cw_keyer.h"

CW_keyer::~CW_keyer()
{
	deinit();
}

void CW_keyer::init()
{
	FILE	*f;

        cprintf("Inicializujem cw_keyer:");

        if ((f = fopen(CW_CONFIG, "r")) == NULL) {
        	fprintf(stderr, "\n%s: Sbor neexistuje", CW_CONFIG);
                cprintf("\n\rcw_keyer: Nastavujem pvodn hodnoty.\n\r");
		delay(1000);

                strcpy(message[0], DEFAULT_MSG1);
                strcpy(message[1], DEFAULT_MSG2);
                strcpy(message[2], DEFAULT_MSG3);
                strcpy(message[3], DEFAULT_MSG4);
                strcpy(message[4], DEFAULT_MSG5);
                strcpy(message[5], DEFAULT_MSG6);
                strcpy(message[6], DEFAULT_MSG7);
                strcpy(message[7], DEFAULT_MSG8);

                strcpy(port_name, DEFAULT_PORT);
                inverted = 0;
        } else {
        	fscanf(f, "%u\n%u\n%u\n%u\n%4s\n", &speed, &tone, &inverted, &auto_msg, port_name);

                for (int i = 0; i < MESSAGES_COUNT; i++) {
			fgets(message[i], MESSAGE_LENGTH, f);
			if (message[i][strlen(message[i]) - 1] == '\n')
				message[i][strlen(message[i]) - 1] = '\0';
		}
                fclose(f);
        }

        if (speed < 168 || speed > 285)
        	speed = DEFAULT_SPEED;
        if (!tone || tone > 3400)
        	tone = DEFAULT_TONE;

        getPortAddr(port_name);
        enabled = 1;
        if (!port) {
        	fprintf(stderr, "\n%s: Port nie je dostupn\n", port_name);
                fprintf(stdout, "\n");
                getch();
                enabled = 0;
        } else {
	        openPort();
                PttOff();
                textcolor(13);
                cprintf("       [  %s (io=0x%x)  ]\n\r", port_name, port);
                textcolor(10);
        }
        config_saved = 0;
        to_port = enabled;
}

void CW_keyer::deinit()
{
	FILE	*f;

        if (config_saved)
        	return;

        if ((f = fopen(CW_CONFIG, "w")) == NULL) {
        	fprintf(stderr, "%s: Chyba pri zpise do sboru\n", CW_CONFIG);
                printf("cw_keyer: Nastavenie nebude uloen.\n");
                getch();
                return;
        }

        fprintf(f, "%u\n%u\n%u\n%u\n%s", speed, tone, inverted, auto_msg, port_name);
        for (int i = 0; i < MESSAGES_COUNT; i++) {
		fprintf(f, "\n");
        	fputs(message[i], f);
	}

        fclose(f);
        if (port)
	        closePort();

        config_saved = 1;
}

void CW_keyer::getPortAddr(const char *name)
{
	if (!strcmp(name, COM1))
        	_dosmemgetw(0x0400, 1, &port);
        else if (!strcmp(name, COM2))
        	_dosmemgetw(0x0402, 1, &port);
        else if (!strcmp(name, COM3))
        	_dosmemgetw(0x0404, 1, &port);
        else if (!strcmp(name, COM4))
        	_dosmemgetw(0x0406, 1, &port);
        else if (!strcmp(name, LPT1))
        	_dosmemgetw(0x0408, 1, &port);
        else if (!strcmp(name, LPT2))
        	_dosmemgetw(0x040a, 1, &port);
        else if (!strcmp(name, LPT3))
        	_dosmemgetw(0x040c, 1, &port);
        else if (!strcmp(name, LPT4))
        	_dosmemgetw(0x040e, 1, &port);
        else
        	port = 0;

        if (!strncmp(name, "LPT", 3))
        	port_type = LPT;
        if (!strncmp(name, "COM", 3))
        	port_type = COM;
}

void CW_keyer::openPort()
{
	if (port_type == LPT)
	        outportb(port, 0x01);	// Log1 => Pin2
}

void CW_keyer::closePort()
{
	outportb(port, 0x00);
}

void CW_keyer::KeyDwn()
{
        if (port_type == LPT)
		outportb(port + 2, 0xf5); // Log1 => Pin17 & Pin14 (negative!)
        if (port_type == COM)
        	outportb(port, 0xff);
}

void CW_keyer::KeyUp()
{
	if (port_type == LPT)
		outportb(port + 2, 0xfd); // Log1 => Pin14 (negative!)
        if (port_type == COM)
        	outportb(port, 0x00);
}

void CW_keyer::scanPaddle()
{
	static int key_now, key_before = 0;

        if (!enabled)
        	return;

        if (port_type == LPT) {
	        key_now = inportb(port + 1);

//                gotoxy(10, 23); printf("0x%x", key_now);
                if (key_now == 0x00)	// squeeze
                	if (key_before == 0x80)		// before tid
                        	key_now = 0x40; 	// now tad
                        else if (key_before == 0x40)	// before tad
                        	key_now = 0x80;		// now tid

                if (key_now == 0x6f)	// tid
	                if (inverted)
                               	ta();
                        else
                               	ti();

                if (key_now == 0x7f)	// tad
                       	if (inverted)
                               	ti();
                        else
                               	ta();

              	key_before = key_now;
	}
}

void CW_keyer::PttOn()
{
	if (port_type == LPT)
        	outportb(port + 2, 0xfd);
        delay(TX_DELAY);
}

void CW_keyer::PttOff()
{
	if (port_type == LPT)
        	outportb(port + 2, 0xff);
}

char *CW_keyer::getPortName()
{
	return port_name;
}

void CW_keyer::SpeedUp(int test)
{
	if (enabled && speed < 280) {
		speed += 3;
                if (test) {
                	to_port = 0;
	        	sendChar(TEST_CHAR);
                        to_port = 1;
                }
        }
}

void CW_keyer::SpeedDwn(int test)
{
        if (enabled && speed > 165) {
		speed -= 3;
                if (test) {
                	to_port = 0;
	        	sendChar(TEST_CHAR);
                        to_port = 1;
                }
        }
}

int CW_keyer::getSpeed()
{
	return speed;
}

void CW_keyer::ToneUp(int test)
{
        if (enabled && tone < 3300) {
		tone += 30;
                if (test) {
                	to_port = 0;
		        sendChar(TEST_CHAR);
                        to_port = 1;
                }
        }
}

void CW_keyer::ToneDwn(int test)
{
        if (enabled && tone > 300) {
		tone -= 30;
                if (test) {
                	to_port = 0;
			sendChar(TEST_CHAR);
                        to_port = 1;
                }
        }
}

int CW_keyer::getTone()
{
	return tone;
}

char *CW_keyer::getMessage(int msg_num, struct qso_info *qso)
{
        if (!enabled)
                return NULL;

        static char	msg[MESSAGE_LENGTH * 5];
        int		n = 0;


        for (int i = 0; i < (signed)sizeof(msg); i++)
        	msg[i] = '\0';

        for (int i = 0; i < (signed)strlen(message[msg_num - 1]); i++)
        	if (message[msg_num - 1][i] == MY_CALL) {
                	strcat(msg, qso->my_call);
                        n += strlen(qso->my_call) - 1;
                } else if (message[msg_num - 1][i] == HIS_CALL) {
                	strcat(msg, qso->his_call);
                        n += strlen(qso->his_call) - 1;
                } else if (message[msg_num - 1][i] == MY_RST) {
                	strcat(msg, qso->my_rst);
                        n += strlen(qso->my_rst) - 1;
                } else if (message[msg_num - 1][i] == HIS_RST) {
                	strcat(msg, qso->his_rst);
                        n += strlen(qso->his_rst) - 1;
                } else if (message[msg_num - 1][i] == HIS_NR) {
                	strcat(msg, qso->his_nr);
                        n += strlen(qso->his_nr) - 1;
                } else if (message[msg_num - 1][i] == MY_NR) {
                	strcat(msg, qso->my_nr);
                        n += strlen(qso->my_nr) - 1;
                } else
                	msg[i + n] = message[msg_num - 1][i];


	return msg;
}

void CW_keyer::sendMessage(int msg_num, struct qso_info *qso_inf)
{
        if (!enabled)
                return;

        PttOn();
	for (int i = 0; i < (signed)strlen(message[msg_num - 1]) && !kbhit(); i++)
        	sendChar(message[msg_num - 1][i], qso_inf);
        PttOff();
}

void CW_keyer::sendKey(char key)
{
        if (enabled) {
        	PttOn();
                sendChar(key, NULL);
                PttOff();
        }
}

void CW_keyer::sendChar(char c, struct qso_info *qso)
{
	switch (tolower(c)) {
        	case 'a': ti(); ta();				break;
        	case 'b': ta(); ti(); ti(); ti();		break;
        	case 'c': ta(); ti(); ta(); ti();		break;
        	case 'd': ta(); ti(); ti();			break;
        	case 'e': ti();					break;
        	case 'f': ti(); ti(); ta(); ti();		break;
        	case 'g': ta(); ta(); ti();			break;
        	case 'h': ti(); ti(); ti(); ti();		break;
        	case 'i': ti(); ti();				break;
        	case 'j': ti(); ta(); ta(); ta();		break;
        	case 'k': ta(); ti(); ta();			break;
        	case 'l': ti(); ta(); ti(); ti();		break;
        	case 'm': ta(); ta();				break;
        	case 'n': ta(); ti();				break;
                case 'o': ta(); ta(); ta();			break;
        	case 'p': ti(); ta(); ta(); ti();		break;
        	case 'q': ta(); ta(); ti(); ta();		break;
        	case 'r': ti(); ta(); ti();			break;
        	case 's': ti(); ti(); ti();			break;
        	case 't': ta();					break;
        	case 'u': ti(); ti(); ta();			break;
        	case 'v': ti(); ti(); ti(); ta();		break;
        	case 'w': ti(); ta(); ta();			break;
        	case 'x': ta(); ti(); ti(); ta();		break;
        	case 'y': ta(); ti(); ta(); ta();		break;
        	case 'z': ta(); ta(); ti(); ti();		break;
        	case '1': ti(); ta(); ta(); ta(); ta();		break;
        	case '2': ti(); ti(); ta(); ta(); ta();		break;
        	case '3': ti(); ti(); ti(); ta(); ta();		break;
        	case '4': ti(); ti(); ti(); ti(); ta();		break;
        	case '5': ti(); ti(); ti(); ti(); ti();		break;
        	case '6': ta(); ti(); ti(); ti(); ti();		break;
        	case '7': ta(); ta(); ti(); ti(); ti();		break;
        	case '8': ta(); ta(); ta(); ti(); ti();		break;
        	case '9': ta(); ta(); ta(); ta(); ti();		break;
        	case '0': ta(); ta(); ta(); ta(); ta();		break;
        	case '/': ta(); ti(); ti(); ta(); ti();		break;
                case '?': ti(); ti(); ta(); ta(); ti(); ti();	break;
                case ' ': qrx(3);				break;
                case MY_CALL:
                	for (int i = 0; i < (signed)strlen(qso->my_call) && !kbhit(); i++)
                        	sendChar(qso->my_call[i]);
                        return;
                case HIS_CALL:
                	for (int i = 0; i < (signed)strlen(qso->his_call) && !kbhit(); i++)
                        	sendChar(qso->his_call[i]);
                        return;
                case MY_RST:
                	for (int i = 0; i < (signed)strlen(qso->my_rst) && !kbhit(); i++)
                        	sendChar(qso->my_rst[i]);
                        return;
                case HIS_RST:
                	for (int i = 0; i < (signed)strlen(qso->his_rst) && !kbhit(); i++)
                        	sendChar(qso->his_rst[i]);
                        return;
                case HIS_NR:
                	for (int i = 0; i < (signed)strlen(qso->his_nr) && !kbhit(); i++)
                        	sendChar(qso->his_nr[i]);
                        return;
                case MY_NR:
                	for (int i = 0; i < (signed)strlen(qso->my_nr) && !kbhit(); i++)
                        	sendChar(qso->my_nr[i]);
                        return;
                case SPEED_UP:
                	SpeedUp(0);
                        return;
                case SPEED_DWN:
                	SpeedDwn(0);
                        return;
                default: qrx();
        }
        qrx(2);
}

void CW_keyer::ti()
{
        sound(tone);
        if (to_port)
	        KeyDwn();
        qrx();
        nosound();
        KeyUp();
        qrx();
}

void CW_keyer::ta()
{
	sound(tone);
        if (to_port)
	        KeyDwn();
        qrx(3);
        nosound();
        KeyUp();
        qrx();
}

void CW_keyer::qrx(int length)
{
/* very stupid algorythm, but I have no time to write better :-( */
        if (_os_flavor[0] == 'M' && _os_flavor[1] == 'S')
        for (int i = 0; i < length; i++)
		delay(300 - speed);
/*        else
        	usleep((length*50000)/20); // 20 wpm*/
}

int CW_keyer::invert()
{
	return inverted = !inverted;
}

int CW_keyer::isInverted()
{
	return inverted;
}

void CW_keyer::enable()
{
        if (port) // Enable only if port exist
		enabled = 1;
}

void CW_keyer::disable()
{
	enabled = 0;
}

int CW_keyer::isEnabled()
{
	return enabled;
}

int CW_keyer::setAutoMesg()
{
        if (auto_msg < 2)
                auto_msg++;
        else
                auto_msg = 0;

        return auto_msg;
}

int CW_keyer::getAutoMesg()
{
	return auto_msg;
}
