#define WANTVXDWRAPS

#include <basedef.h>
#include <vmm.h>
#include <debug.h>
#include <vxdwraps.h>
#include <vwin32.h>
#include <winerror.h>

#define SMRPORT_VERSION 0x400

typedef DIOCPARAMETERS *LPDIOC;

typedef struct __TBytePort
{
	WORD address; 
	BYTE value;
}TBytePort;

typedef struct __TWordPort
{
	WORD address; 
	WORD value;
}TWordPort;

typedef struct __TDWordPort
{
	WORD address; 
	DWORD value;
}TDWordPort;
               
#pragma VxD_LOCKED_CODE_SEG
#pragma VxD_LOCKED_DATA_SEG

void(_cdecl *lpCallProcedure)(void);


DWORD _stdcall SMPORT_W32_DeviceIOControl(DWORD, DWORD, DWORD, LPDIOC);
DWORD _stdcall SMPORT_W32_Proc1(DWORD, DWORD, LPDIOC); //GetVersion
DWORD _stdcall SMPORT_W32_Proc2(DWORD, DWORD, LPDIOC);
DWORD _stdcall SMPORT_W32_Proc3(DWORD, DWORD, LPDIOC);
DWORD _stdcall SMPORT_W32_Proc4(DWORD, DWORD, LPDIOC);
DWORD _stdcall SMPORT_W32_Proc5(DWORD, DWORD, LPDIOC);
DWORD _stdcall SMPORT_W32_Proc6(DWORD, DWORD, LPDIOC);
DWORD _stdcall SMPORT_W32_Proc7(DWORD, DWORD, LPDIOC);

DWORD ( _stdcall *SMPORT_W32_Proc[] )(DWORD, DWORD, LPDIOC) = {
        SMPORT_W32_Proc1,
        SMPORT_W32_Proc2,
		  SMPORT_W32_Proc3,
		  SMPORT_W32_Proc4,
		  SMPORT_W32_Proc5,
		  SMPORT_W32_Proc6,
		  SMPORT_W32_Proc7};


#define MAX_SMPORT_W32_API (sizeof(SMPORT_W32_Proc)/sizeof(DWORD))

/****************************************************************************
                  SMPORT_W32_DeviceIOControl
****************************************************************************/
DWORD _stdcall SMPORT_W32_DeviceIOControl(DWORD  dwService,
                                           DWORD  dwDDB,
                                           DWORD  hDevice,
                                           LPDIOC lpDIOCParms)
{
    DWORD dwRetVal = 0;
    if ( dwService == DIOC_OPEN )
    {
          lpCallProcedure=NULL;
          dwRetVal = 0;
    }
    else if ( dwService == DIOC_CLOSEHANDLE )
    {
        dwRetVal = VXD_SUCCESS;
    }
    else if ( dwService > MAX_SMPORT_W32_API )
    {  
        dwRetVal = ERROR_NOT_SUPPORTED;
    }
    else
    {
        dwRetVal = (SMPORT_W32_Proc[dwService-1])(dwDDB, hDevice, lpDIOCParms);
    }
    return(dwRetVal);
}

DWORD _stdcall SMPORT_W32_Proc1(DWORD dwDDB, DWORD hDevice, LPDIOC lpDIOCParms)
{
    PDWORD pdwOut;
	pdwOut = (PDWORD)lpDIOCParms->lpvOutBuffer; 
	*pdwOut = 0x00000001;
    return(NO_ERROR);
}

DWORD _stdcall SMPORT_W32_Proc2(DWORD dwDDB, DWORD hDevice, LPDIOC lpDIOCParms) //ReadByte
{
	PWORD pwIn,pwOut;
	BYTE value;
	WORD address;
	pwIn = (PWORD)lpDIOCParms->lpvInBuffer;
	address = *pwIn;
	__asm
	{
		mov dx,address
		in al,dx
		mov value,al
	}
	pwOut = (PWORD)lpDIOCParms->lpvOutBuffer;
	pwOut[0] = (WORD)value;
	return(NO_ERROR);
}

DWORD _stdcall SMPORT_W32_Proc3(DWORD dwDDB, DWORD hDevice, LPDIOC lpDIOCParms)//WriteByte
{
    PWORD pwOut;
	TBytePort * pByteData;
	BYTE value;
	WORD address;
	pByteData = (TBytePort*)lpDIOCParms->lpvInBuffer;
	pwOut = (PWORD)lpDIOCParms->lpvInBuffer;
	address = pByteData->address;
	value = pByteData->value;
	__asm
	{
		mov dx,address
        mov al,value
		out dx,al
	}
	*pwOut = address;
	return(NO_ERROR);
}

DWORD _stdcall SMPORT_W32_Proc4(DWORD dwDDB, DWORD hDevice, LPDIOC lpDIOCParms)//ReadWord
{
	PWORD pwIn,pwOut;
	WORD address,value;
	pwIn = (PWORD)lpDIOCParms->lpvInBuffer;
	address=(WORD)pwIn[0];
	__asm
	{
		mov dx,address
		in ax,dx
		mov value,ax
	}
	pwOut = (PWORD)lpDIOCParms->lpvOutBuffer;
	*pwOut = value;
	return(NO_ERROR);
}

DWORD _stdcall SMPORT_W32_Proc5(DWORD dwDDB, DWORD hDevice, LPDIOC lpDIOCParms)//WriteWord
{
    PWORD pwOut;
	TWordPort *pWordData; 
	WORD address, value;
	pWordData = (TWordPort*)lpDIOCParms->lpvInBuffer;
	pwOut = (PWORD)lpDIOCParms->lpvOutBuffer;
	address = pWordData->address;
	value = pWordData->value;
	__asm
	{
		mov dx,address
        mov ax,value
		out dx,ax
	}
	*pwOut = value;
	return(NO_ERROR);
}

DWORD _stdcall SMPORT_W32_Proc6(DWORD dwDDB, DWORD hDevice, LPDIOC lpDIOCParms)//Read DWORD
{
	PWORD pwIn;
	PDWORD	pdwOut;
	WORD address;
	DWORD value;
	pwIn = (PWORD)lpDIOCParms->lpvInBuffer;
	address= *pwIn;
	__asm
	{
		mov dx,address
		in eax,dx
		mov value,eax
	}
	pdwOut = (PDWORD)lpDIOCParms->lpvOutBuffer;
	*pdwOut = value;
	return(NO_ERROR);
}

DWORD _stdcall SMPORT_W32_Proc7(DWORD dwDDB, DWORD hDevice, LPDIOC lpDIOCParms)//ReadDWORD
{
	TDWordPort *pDWordData; 
    PWORD pwOut;
	WORD address;
	DWORD value;
	pDWordData = (TDWordPort*)lpDIOCParms->lpvInBuffer;
	pwOut = (PWORD)lpDIOCParms->lpvOutBuffer;
	address = pDWordData->address;
	value = pDWordData->value;
	__asm
	{
		mov dx,address
        mov eax,value
		out dx,eax
	}
	*pwOut = value;
	return(NO_ERROR);
}



