Program Dec2Hex;
{ Program to calculate "Decades" table for PIC DDS.
  Input data are in NUMS.TXT, output data are in hexnums.txt.
}

Uses
  Crt,Dos;
Const
  Hex       : Array [0..15] Of Char=('0','1','2','3','4','5','6','7',
                                     '8','9','A','B','C','D','E','F');
Var
  HexNum,Line   : String;
  I,J,K         : Byte;
  AddMF         : Boolean;
  MF,CLK        : Real;
  DecNum        : LongInt;
  Out,Config    : Text;
  F1,F          : Array [1..24] Of Real;
  Error         : Word;
  FileInfo      : SearchRec;

{ ---------------------- D2H ----------------------- }

  Function D2H(DecN: LongInt): String;
  Var  HexN          : String;
  Begin
    HexN:='';
    Repeat
      HexN:=Hex[DecN MOD 16]+HexN;
      DecN:=DecN DIV 16;
    Until DecN<16;
    HexN:=Hex[DecN]+HexN;
    While Length(HexN)<8 Do HexN:='0'+HexN;
    D2H:=HexN;
  End;

{ ====================================================================== }

Begin
  ClrScr;
  Assign(Config,'nums.txt');
  FindFirst('nums.txt',AnyFile,FileInfo);
  If DOSError<>0 Then
    Begin
      Write('Give CLOCK frequency in MHz: ');ReadLn(CLK);
      Write('Give intermediate frequency in MHz: ');ReadLn(MF);
      Rewrite(Config);
      WriteLn(Config,CLK:10:6,' MHz CLOCK');
      WriteLn(Config,MF:10:6);
      WriteLn(Config,'10');
      WriteLn(Config,'100');
      WriteLn(Config,'1000');
      WriteLn(Config,'10000');
      WriteLn(Config,'100000');
      WriteLn(Config,'1000000');
      WriteLn(Config,'10000000');
      Close(Config);
    End;
  Reset(Config);

  ClrScr;

  ReadLn(Config,Line);
  If Line[1]=' ' Then Line:=Copy(Line,2,Length(Line)-1);
  If Line[1]=' ' Then Line:=Copy(Line,2,Length(Line)-1);
  Line:=Copy(Line,Pos('=',Line)+1,Length(Line)-Pos('=',Line));
  Line:=Copy(Line,1,Pos(' ',Line)-1);
  Val(Line,CLK,Error);

  CLK:=1000000*CLK;

  I:=0;
  Repeat
    ReadLn(Config,Line);
    If I=0 Then
      Begin
        If Line[1]=' ' Then Line:=Copy(Line,2,Length(Line)-1);
        If Line[1]=' ' Then Line:=Copy(Line,2,Length(Line)-1);
      End;
    Inc(I);
    Line:=Copy(Line,Pos('=',Line)+1,Length(Line)-Pos('=',Line));
    Val(Line,F1[I],Error);
    F[I]:=F1[I];
  Until Eof(Config);
  Close(Config);
  J:=I;
  Assign(Out,'hexnums.txt');Rewrite(Out);
  For I:=1 To J Do
    Begin
      HexNum:=D2H(Round(F[I]*65536*(65536/CLK)));
      WriteLn(Out,'            retlw    0',Copy(HexNum,7,2),'h     ;',F1[I]:16:6);
      WriteLn(Out,'            retlw    0',Copy(HexNum,5,2),'h');
      WriteLn(Out,'            retlw    0',Copy(HexNum,3,2),'h');
      WriteLn(Out,'            retlw    0',Copy(HexNum,1,2),'h');
      WriteLn(Out,'');
    End;
  Close(Out);
End.