#include <windows.h>
#include <dos.h>

unsigned long i,j,rxi,txi,ltxi,footi;
unsigned long txbys,rxbys,rxackc,rxackc2;
DCB dcb;
HANDLE hCom;
DWORD dwError;
BOOL fSuccess;
BYTE txbuf[32000];
BYTE rxbuf[1000];
BYTE rxack,lixo,lixoc;

unsigned int cksum,cksum2,buflen,txctr,txctr2,clonelen;
COMMTIMEOUTS cto;

HFILE hFile;
OFSTRUCT      OFS;
#define DIRPATHSIZE 150
char          FName[DIRPATHSIZE];


int WINAPI WinMain(HINSTANCE  hInstance, HINSTANCE  hPrevInstance,
                   LPSTR  lpszCmdLine, int  nCmdShow)
{
hCom = CreateFile("COM2",GENERIC_READ | GENERIC_WRITE, 0,
    NULL, OPEN_EXISTING, 0, NULL);
if (hCom==INVALID_HANDLE_VALUE)
   {MessageBox(NULL,"Can't open COM port", "Error",MB_ICONERROR); return(0);}

GetCommState(hCom, &dcb);
dcb.BaudRate = 9600;
dcb.ByteSize = 8;
dcb.Parity = NOPARITY;
dcb.StopBits = TWOSTOPBITS;
SetCommState(hCom, &dcb);

GetCommTimeouts(hCom, &cto);
cto.ReadIntervalTimeout=20; //15ok
cto.ReadTotalTimeoutMultiplier=0;
cto.ReadTotalTimeoutConstant=500;
cto.WriteTotalTimeoutMultiplier=0;
cto.WriteTotalTimeoutConstant=0;
SetCommTimeouts(hCom, &cto);

GetCurrentDirectory (DIRPATHSIZE, FName);
lstrcat (FName, "\\RADIO.BIN");
hFile = OpenFile(FName, &OFS, OF_READ);
if (hFile)
  { buflen=_lread(hFile,txbuf,16000);
    _lclose(hFile);
  }

txi=0;
cksum=0;
clonelen=txbuf[buflen-6]+txbuf[buflen-5]*256+txbuf[buflen-4]+txbuf[buflen-3]*256;
if (clonelen>=buflen)
   {MessageBox(NULL,"Incorrect file format", "Error",MB_ICONERROR); return(0);}
if (txbuf[clonelen]!='<')
   {MessageBox(NULL,"Incorrect file format", "Error",MB_ICONERROR); return(0);}
footi=strchr(&txbuf[clonelen],'>')-&txbuf;
footi+=3;

while (footi<buflen)
  {
   ltxi=txi;
	txi=txbuf[footi]+txbuf[footi+1]*256;
   footi+=2;
   if (txi!=ltxi)
      {MessageBox(NULL,"Incorrect file format", "Error",MB_ICONERROR); return(0);}
	txctr=txbuf[footi]+txbuf[footi+1]*256;
   footi+=4;
   for (i=txi;i<txi+txctr;cksum+=txbuf[i++]);
   if (txi+txctr==clonelen)
      {if (clonelen==4818) txbuf[txi+txctr-1]+=txbuf[txi]-cksum;  //vx-1 has 0 total cksum of 1..n, no ack
       else txbuf[txi+txctr-1]=cksum-txbuf[txi+txctr-1];}

   while (txctr>0)
     {if (txctr>16) txctr2=16; else txctr2=txctr;
      WriteFile(hCom,&txbuf[txi],txctr2,&txbys,NULL);
      ReadFile(hCom,&rxbuf,txbys+1,&rxackc,NULL);
      if (rxackc<txbys) {MessageBox(NULL,"Radio off or defective cable", "Error",MB_ICONERROR); return(0);}
      txi+=txbys;
      txctr-=txbys;
     }
   if (rxackc>txbys)
     {rxack=rxbuf[rxackc-1];}
   else
     if (txi<clonelen)
	      {ReadFile(hCom,&rxack,1,&rxackc2,NULL);
    	    if (rxackc2!=1)
         	 {MessageBox(NULL,"No acknowledge from radio", "Error",MB_ICONERROR);return(0);}
          if ((rxack!=6) && !(clonelen==4818)) {MessageBox(NULL,"Wrong acknowledge from radio", "Error",MB_ICONERROR); return(0);}
         }
  }
CloseHandle(hCom);
MessageBox(NULL,"Done","Success", MB_ICONINFORMATION);
MessageBeep(MB_ICONEXCLAMATION);

  return 0;
}