;
; Private definitions for LCD DDS                                     
;

INDEX       equ        0Ch         ; INDEX register
Count       equ        0Dh         ; incremental register
Help        equ        0Eh         ; another dummy register

NUM0        equ        0Fh
NUM1        equ       010h
NUM2        equ       011h
NUM3        equ       012h
NUM4        equ       013h
NUM5        equ       014h
NUM6        equ       015h

CHAR        equ       016h         ; LCD subroutines internal use

ResB        equ       017h         ; the lowest byte
LowB        equ       018h         ; low byte of the resulted frequency
MidB        equ       019h         ; middle byte
HigB        equ       01Ah         ; high byte

R_B         equ       01Bh         ; the lowest byte
L_B         equ       01Ch         ; low byte of the inc/dec value
M_B         equ       01Dh         ; middle byte
H_B         equ       01Eh         ; high byte

TEMP        equ       01Fh         ; temporary register
NUMINDEX    equ       020h         ; NUM pointer

R1          equ       021h         ; Timing counters
R2          equ       022h
R3          equ       023h
R4          equ       024h

T1          equ       025h
T2          equ       026h

Semaphore   equ       027h
BAND        equ       028h
SHIFT0      equ       029h
SHIFT1      equ       02Ah
SHIFT2      equ       02Bh
SHIFT3      equ       02Ch
SHIFT4      equ       02Dh
SHIFT5      equ       02Eh
SHIFT6      equ       02Fh
SHIFT7      equ       030h

;ͻ
; LCD variables                                                       
;ͼ

;Xtal       equ       8            ; MHz
DELAY15000  equ       .39          ; 1+15000*Xtal/4/770
DELAY4100   equ       .11          ; 1+4100*Xtal/4/770
DELAY100    equ       1            ; 1+100*Xtal/4/770

LINE0       equ       0
LINE1       equ       040h
                                   ; PORTB bits
E           equ       2            ; LCD Enable control line          RA2
R_W         equ       0            ; LCD Read/Write control line      RA0
RS          equ       1            ; LCD Register-Select control line RA1
                                   ; LCD Data are sent through  RB4 - RB7

;ͻ
; DDS variables                                                       
;ͼ

DDS_DATA    equ       0            ; data RA0 (the same as R_W)
W_CLK       equ       1            ; clock RA1 (the same as RS)
FQ_UD       equ       3            ; frequency update RB3 !!!!

;

