REM ***********************************************************************************************************************
REM ***********************************************************************************************************************
REM ***********************************************************************************************************************
REM * WA2HIP Ham Radio Log Processing Application
REM * Copyright (C) By John R. Petrocelli  {WA2HIP}
REM * Version 1.1.16   28-July-2013
REM * *****
REM * *****
REM * Version History (Note: Updata "Display Program Information and Version" 
REM *                        as necessary!!):
REM *
REM *     Version 1.1.13 - 12-Jul-2013 - First Version
REM *
REM =
REM *     Version 1.1.14 - 27-Jul-2013 - Added ability to include system date and/or time in output.
REM *                                  - Added ability to pass user text to output via config/INI file
REM *
REM *     Version 1.1.15 - 27-Jul-2013 - Fixed minor problem with Band.  Can possibly be lower case.
REM *                                  - Example: "20M" or "20m"
REM *                                  - Added fix to account for possibility of this anomally
REM *
REM *     Version 1.1.16 - 28-Jul-2013 - Made Getting Frequency from ADIF Band Tag optional
REM *
REM =
REM =
REM *
REM *
REM * *****
REM * Environment  - Microsoft Windows and VBScript. Run in Command Window - CMD file (batch file) preferred.
REM * Requirements - Properly formatted ADIF file for input
REM * *****
REM * Prolog
REM *
REM * Program reads a properly formatted ADIF file and for each ADIF tag will output the data in a
REM * delimited format.  Delimiter is User-Defined in the Config file
REM *  
REM * Any ADIF field is a valid for the parsing of the ADIF file
Rem *       Additionally, the user may "pad" the output with blanks by entering an unknown (to the ADIF specification)
REM *                     value in the MetaData list in the config file
REM *       Output will be in the order specified in the MetaData in the config file
REM *
REM * *****

REM ***********************************************************************************************************************
REM ***********************************************************************************************************************

REM We use "Option Explicit" to help us check for coding mistakes
Option Explicit

REM ====  Display Program Information and Version
Const Program_Version = "Version 1.1.16   28-Jul-2013"
wscript.echo  "**************************************************"
wscript.echo  "* WA2HIP Ham Radio ADIF to Delimited text        *"
wscript.echo  "*        Processing Application                  *"
wscript.echo  "*  Copyright (C) By John R. Petrocelli  {WA2HIP} *"
wscript.echo  "*   " + Program_Version
wscript.echo  "**************************************************"

REM ======================================================================================
REM ==== Define variables
REM ======================================================================================

  Dim Input_File, Output_File
  Dim Array_Count
  Dim MetaDataArray()

  Dim ADIF_Record_Count, Lines_Output

  Dim ADIF_Buffer
  Dim pcount
  Dim Parm
  Dim Field_Value
  Dim Loc_Offset, Loc_End, Temp_String, Field_Len, Temp_String2, Temp_String3
  Dim Start_Value, End_Value, Len_Value, Len_Field_Data
  Dim Delim, HeaderYN, Echo_Output

  Dim regEx, str1

  Dim Output_Buffer

  Dim Freq_From_Band

REM ======================================================================================
REM ==== Set Default/initial values
REM ======================================================================================

  ADIF_Record_Count = 0
  Lines_Output = 0
  Delim = ","
  Freq_From_Band = "Y"

REM ======================================================================================
REM ==== Define user Options.  Will be read from INI file
REM ======================================================================================

REM ==== Set Default INI file name
  Const Log_Main_ini_default = "ADIF2Comma.ini"

REM ==== Define variable for active INI file name
  Dim Log_Main_ini, Log_Main_ini_cmd_line

REM ==== Call subroutine to look for alternate INI file on command line or set it to default name
  call Get_ini_file_name

REM ==== Call subroutine to read INI file
  call Read_INI_File

REM ======================================================================================
REM ==== Define file variables/constants
REM ======================================================================================

  Dim ADIF_Line, File_ADIF_File, File_ADIF_obj, File_Delim_File, File_Delim_obj


  Const ForReading = 1, ForWriting = 2, ForAppending = 8 

REM ======================================================================================
REM ==== Open input file for reading
REM ======================================================================================

  Set File_ADIF_obj = CreateObject("Scripting.FileSystemObject")
  Set File_ADIF_File = File_ADIF_obj.OpenTextFile(Input_File, ForReading)

REM ======================================================================================
REM ==== Open Output file for reading
REM ======================================================================================

  Dim filesys, fileoutput

  Set filesys = CreateObject("Scripting.FileSystemObject")
  Set fileoutput = filesys.OpenTextFile(Output_File, ForWriting, True)
  fileoutput.Close
  Set fileoutput = filesys.OpenTextFile(Output_File, ForAppending, True)

REM ======================================================================================
REM ==== Read input file until the "<EOH>" (End of Header) tag is found
REM ======================================================================================

  Do Until (InStr(UCase(ADIF_Line),"<EOH>"))
    ADIF_Line = File_ADIF_File.ReadLine
  Loop

REM ======================================================================================
REM ==== If User chose to have header record in output file then write header record
REM ======================================================================================

   IF (HeaderYN = "Y") Then

     Output_Buffer = ""
     For pcount = 0 to Array_Count
       If (pcount = 0) then
         output_Buffer = Ucase(MetaDataArray(pcount))
                       Else
          output_Buffer = Output_Buffer & Delim & Ucase(MetaDataArray(pcount))
       End If
     Next

     fileoutput.writeline Output_Buffer

REM ======================================================================================
REM ==== Echo to screen if user specified 
REM ======================================================================================

     If (Echo_Output = "Y") Then
       wscript.echo Output_Buffer
     End If

     Output_Buffer = ""

   End If


REM ======================================================================================
REM ==== Process ADIF file until end of file
REM ======================================================================================

  Do Until File_ADIF_File.AtEndOfStream

REM ==== Initialize values
    Output_Buffer = ""
    ADIF_Buffer = ""
    ADIF_Line = ""

REM ==== Collect ADIF data into buffer until the "<EOR>" (End of record) tag found
    Do Until (InStr(UCase(ADIF_Line),"<EOR>") > 0)
      ADIF_Line = File_ADIF_File.ReadLine

REM ==== Build ADIF buffer from data
      If (InStr(ADIF_Line,"<") & InStr(ADIF_Line,">")) Then
        ADIF_Buffer = ADIF_Buffer & ADIF_Line

      end if

REM ==== Check for end of file - be sure we do not try to read beyond the end of the file 
    If (File_ADIF_File.AtEndOfStream)  then
      exit do
    end if

    Loop  


REM ==== Increment ADIF record counter
    If (InStr(UCase(ADIF_Line),"<EOR>") > 0) then
      ADIF_Record_Count = ADIF_Record_Count + 1

      Call Process_Adif_Record
    End If

  Loop


rem File_ADIF_obj.close

REM ==== Close files
  set File_ADIF_obj = Nothing
  set filesys = Nothing

  
REM ==== Echo status to screen
wscript.echo "**************************"
wscript.echo "* ADIF Records Found: " & ADIF_Record_Count
wscript.echo "*        Lines Ouput: " & Lines_Output
wscript.echo "**************************"



REM =========================================================================================================
REM =========================================================================================================
REM =========================================================================================================
REM =========================================================================================================


REM =================================================================================
REM Subroutine to Process ADIF Record(s) and Build the ADIF Buffer
REM ====
REM Passed parameter(s)  <NONE>
REM Returns Public variables
REM ====
REM
REM =================================================================================
Sub Process_Adif_Record


REM ==== Define variables
  Dim Temp_Field_Value


REM ==== loop thru array of MetaData and process/search for each related value
For pcount = 0 to Array_Count
 
REM ==== Set Variable to what tag we are looing for in the ADIF Buffer
    Parm = Ucase(MetaDataArray(pcount))

REM ==== Special case if there is a "=" as the first character
REM ==== of the Metadata
REM ==== Be sure it is more than just an "="
REM
    If Mid(Parm,1,1) = "="  And Len(Parm) > 1 then
      Field_Value = Mid(MetaDataArray(pcount),2,Len(MetaDataArray(pcount))-1)

REM ==== Special handling for "=Date()"
      If Ucase(Field_Value) = "DATE()"  then  Field_Value = Year(Now()) & "-" & Right("0" & Month(Now()),2) & "-" & Right("0" & Day(Now()),2)

REM ==== Special handling for "=Time()"
      If Ucase(Field_Value) = "TIME()"  then  Field_Value = Right("0" & Hour(Now()),2) & ":" & Right("0" & Minute(Now()),2)

REM ==== Build the output buffer
      Call Build_Output_Buffer
     ' Next
                                              Else
REM ==== Otherwise Clear Field_Value
      Field_Value = ""
    'End If

REM ==== Find the offset in the ADIF Buffer that has the desired Tag
      Loc_Offset = InStr(UCase(ADIF_Buffer),"<" & Parm)


REM ==== If we found the tag then continue to process
      If Loc_Offset > 0 then

REM ==== Get Data
        Call Get_Field

REM ==== Build Output Buffer
        Call Build_Output_Buffer
      
                        else
        
REM ==== Special handling for Freq/Band
      
        If Ucase(MetaDataArray(pcount)) = "FREQ"  then
          If (Freq_From_Band = "Y") Then Parm = "BAND"
        end if

REM ==== Locate the data in the ADIF buffer
        Loc_Offset = InStr(UCase(ADIF_Buffer),"<" & Parm)

REM ==== If found then process
        If Loc_Offset > 0 then

REM ==== Get the Field value
          Call Get_Field

REM ==== Convert BAND to FREQ (generic value) if option set to "Y" in config/INI file
          If ((Ucase(MetaDataArray(pcount)) = "FREQ")  and (Freq_From_Band = "Y"))  then
            Temp_Field_Value = "0.000"
            Select Case UCase(Trim(Field_Value))
              Case "160M" Temp_Field_Value =  "1.600"
              Case  "80M" Temp_Field_Value =  "3.500"
              Case  "60M" Temp_Field_Value =  "5.330"
              Case  "40M" Temp_Field_Value =  "7.000"
              Case  "30M" Temp_Field_Value = "10.000"
              Case  "20M" Temp_Field_Value = "14.000"
              Case  "17M" Temp_Field_Value = "18.068"
              Case  "15M" Temp_Field_Value = "21.000"
              Case  "12M" Temp_Field_Value = "24.000"
              Case  "10M" Temp_Field_Value = "28.000"
              Case   "6M" Temp_Field_Value = "50.000"
            end Select

REM ==== Set the Field_Value to the Frequency
            Field_Value = Temp_Field_Value
          end if

REM ==== Build output buffer
          Call Build_Output_Buffer

                      else
        
REM ==== If here, no special handling so just build the output buffer
          Call Build_Output_Buffer

        End If

      end if

    End If


Next  

REM ==== Increment Counter of output lines
    Lines_Output = Lines_Output + 1

REM ==== Write the output buffer to file
    fileoutput.writeline Output_Buffer

REM ==== If user wants echo to screen, echo to screen
    If (Echo_Output = "Y") Then
      wscript.echo Output_Buffer & "'"
    End If

REM ==== Clear/Reset output buffer.
    Output_Buffer = ""


end Sub



REM =================================================================================
REM Subroutine to Retrieve data based on ADIF Tag
REM ====
REM Passed parameter(s)  <NONE>
REM Returns Public variables
REM ====
REM
REM =================================================================================
Sub Get_Field


REM ==== Create a temporary string that begins with the targeted TAG
     Temp_String = Mid(ADIF_Buffer,Loc_Offset, Len(ADIF_Buffer)-Loc_Offset)

REM ==== Create a temporary string that contains ONLY the Tag & data
     Temp_String2 = Mid(Temp_String,1,Instr(Temp_String,">"))

REM ==== Clean spirious characters from the temporary string
     Set regEx = New RegExp
     regEx.Pattern = "[A-Z]|_|:|>|<|-"
     regEx.IgnoreCase = True
     regEx.Global = True
     regEx.MultiLine = True

REM ==== Determine the length of the actual data
     Len_Field_Data = Trim(regEx.Replace(Temp_String2, " "))

REM ==== clear regEx
     Set regEx = Nothing

REM ==== Get the field's (Tag's) data
     Field_Value = Mid(Temp_String,Len(Temp_String2)+1, Len_Field_Data)

end Sub



REM =================================================================================
REM Subroutine to Build the Output Buffer
REM ====
REM Passed parameter(s)  <NONE>
REM Returns Public variables
REM ====
REM
REM =================================================================================
Sub Build_Output_Buffer

REM ==== Build the Field value

REM ==== Special case for QSO_Date.  Format as YYYY-MM-DD
      If (Parm = "QSO_DATE") Then
        Field_Value = Mid(Field_Value,1,4) & "-" & Mid(Field_Value,5,2) & "-" & Mid(Field_Value,7,2)
      end if

REM ==== Special case for QSO_Date_OFF.  Format as YYYY-MM-DD
      If (Parm = "QSO_DATE_OFF") Then
        Field_Value = Mid(Field_Value,1,4) & "-" & Mid(Field_Value,5,2) & "-" & Mid(Field_Value,7,2)
      end if

REM ==== Special case for TIME_ON.  Format as HH:MM
      If (Parm = "TIME_ON") Then
        Field_Value = Mid(Field_Value,1,2) & ":" & Mid(Field_Value,3,2)
      end if

REM ==== Special case for TIME_OFF.  Format as HH:MM
      If (Parm = "TIME_OFF") Then
        Field_Value = Mid(Field_Value,1,2) & ":" & Mid(Field_Value,3,2)
      end if


REM ==== Concatenate new data to output buffer.
REM ==== Delimiter put into string as needed
      if (Len(Trim(Output_Buffer)) = 0)  then
        Output_Buffer = Output_Buffer & Field_Value
                                      Else
        Output_Buffer = Output_Buffer & Delim & Field_Value
      End If


End Sub



REM =================================================================================
REM Subroutine to read INI file
REM ====
REM Passed parameter(s)  <NONE>
REM Returns INI variables and array(s)
REM ====
REM
REM =================================================================================
Sub Read_INI_File

  Dim INI_Line, File_INI_File, File_INI_obj, INI_Tag, ECHO_INI_YN
  Dim xl_count

rem  Dim Input_File, Output_File
rem   Dim Array_Count
  Dim debug_msgs

  
  wscript.echo "============================================================================"
  wscript.echo "= Processing INI file"
  wscript.echo "=    '" & Log_Main_ini & "'"
  wscript.echo "============================================================================"

REM ==== Initialize variables
REM  ADIF_Supplemental = ""
  
REM ==== Open INI file for reading  
  Const ForReading_INI = 1
  Set File_INI_obj = CreateObject("Scripting.FileSystemObject")
  Set File_INI_File = File_INI_obj.OpenTextFile(Log_Main_ini, ForReading_INI)
  
  Do Until File_INI_File.AtEndOfStream
  
    INI_Line = File_INI_File.ReadLine

    If mid(INI_Line,1,1) <> " "  and  mid(INI_Line,1,1) <> "#"  and  mid(INI_Line,1,1) <> "!"  then 
	
      INI_Tag = "ECHO_INI_YN="
      if InStr(INI_Line,INI_Tag)  then ECHO_INI_YN  = UCase(trim(mid(INI_Line,(InStr(INI_Line,INI_Tag)+len(INI_Tag)))))
	  
      INI_Tag = "Input_File="
      if InStr(INI_Line,INI_Tag)  then Input_File     =             trim(mid(INI_Line,(InStr(INI_Line,INI_Tag)+len(INI_Tag))))

      INI_Tag = "Output_File="
      if InStr(INI_Line,INI_Tag)  then Output_File    =             trim(mid(INI_Line,(InStr(INI_Line,INI_Tag)+len(INI_Tag))))

      INI_Tag = "Delim="
      if InStr(INI_Line,INI_Tag)  then Delim          =             trim(mid(INI_Line,(InStr(INI_Line,INI_Tag)+len(INI_Tag))))
	
      INI_Tag = "HeaderYN="
      if InStr(INI_Line,INI_Tag)  then HeaderYN       =       UCase(trim(mid(INI_Line,(InStr(INI_Line,INI_Tag)+len(INI_Tag)))))

      INI_Tag = "Echo_Output="
      if InStr(INI_Line,INI_Tag)  then Echo_Output    =       UCase(trim(mid(INI_Line,(InStr(INI_Line,INI_Tag)+len(INI_Tag)))))

      INI_Tag = "Freq_From_Band="
      if InStr(INI_Line,INI_Tag)  then Freq_From_Band =       UCase(trim(mid(INI_Line,(InStr(INI_Line,INI_Tag)+len(INI_Tag)))))


	
      INI_Tag = "<MetaData_Start>"
      if InStr(INI_Line,INI_Tag)  then 
        Array_Count = -1
        Do Until (INI_Line = "<MetaData_End>")
          INI_Line = File_INI_File.ReadLine
          if (INI_Line <> "<MetaData_End>") then
            Array_Count = Array_Count + 1
            Redim Preserve MetaDataArray(Array_Count)
            MetaDataArray(Array_Count) = Trim(INI_Line)
          End if
        loop
      end if
    end if
  Loop


   

REM ==== Make Numeric Character variables to be true numeric values
  debug_msgs              = debug_msgs              * 1
rem  Process_Location_Data   = Process_Location_Data   * 1
rem  Process_Head_Dist_Data  = Process_Head_Dist_Data  * 1
rem  Get_Can_Prov            = Get_Can_Prov            * 1
rem  Text_Reform_DateTime    = Text_Reform_DateTime    * 1
rem  HTML_Reform_DateTime    = HTML_Reform_DateTime    * 1
  
  if ECHO_INI_YN = "Y"  then
    wscript.echo "Input_File    '" & Input_File   & "'"
    wscript.echo "Output_File   '" & Output_File  & "'"
    wscript.echo "Delim         '" & Delim        & "'"
    wscript.echo "HeaderYN      '" & HeaderYN     & "'"
    wscript.echo "Echo_Output   '" & Echo_Output  & "'"
  
    if Array_Count  > -1  then
      wscript.echo "<MetaData>"
      For xl_count = 0 to Array_Count
	    wscript.echo  xl_Count & "  '" & MetaDataArray(xl_count) & "'"
	  next
    end if
  
  end if
  
end sub

REM =========================================================================================================
REM =========================================================================================================

REM =================================================================================
REM Subroutine to set the INI file name either using default name or name specified
REM on the commane line
REM ====
REM Passed parameter(s)  <NONE>
REM Returns INI file name in variable  "Log_Main_ini"
REM ====
REM
REM =================================================================================
Sub Get_ini_file_name

  Log_Main_ini = Log_Main_ini_default
  
  dim cmd_line_arg, i_arg

  rem num_cmd_line_arg = wscript.arguments.count

  rem wscript.echo "Number of Args: " & num_cmd_line_arg

  For i_arg = 0 to (wscript.arguments.count - 1)
     rem wscript.echo "arg(" & trim(i_arg) &  ")= '" & trim(wscript.arguments(i_arg)) & "'"
     if instr(trim(UCase(wscript.arguments(i_arg))),"INI=")  then
       Log_Main_ini = mid(trim(wscript.arguments(i_arg)),5)
     end if
     rem wscript.echo "atg_ini= '" & arg_ini & "'"   
  Next

end sub

REM =========================================================================================================
REM =========================================================================================================


REM =========================================================================================================
REM =========================================================================================================
REM =========================================================================================================
REM =========================================================================================================
REM =========================================================================================================