#include <conio.h>
#include <FCNTL.H>
#include <SYS/STAT.H>
#include <PROCESS.H>
#include <IO.H>
#include <dir.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <DOS.H>

char 		SAVE;

extern int      VER;
extern int 	DAT;

struct
  setup1
     {
      char START[40];           // VERSION LINE
      int GRIDCOLOR;		// Color for Grid...
      int TOP_LINE;		// Color for top line
      int BOTTOM_LINE;          // Color for bottom line
      char PROGDIR[MAXPATH];	// Where main programs are
      char PRINT;		// Not use at this time old var
      char SAFE_ESC;		// IF 1 you must end a y to exit
      char X_FILE[40];		// File name to use in recording
      char EXT[10];		// Ext to use for recording file
      char TOP_FILE[40];	// defaut file to load in top
      char BOTTOM_FILE[40];	// defaut file to load in bottom
      char REC[40];		// Program to record with
      int  NAME;		// File pos in Pramater List
      char PARM[80];         	// Prama List for recording
      char MW[10][40];      	// most wanted list
      int  MIN_MATCH;		// COMPARE: MINUM score to match files to put in list
      int  SAMPLE_SIZE;		// SAMPLE: Size of sampe to look in for SOT
      int  LOW_VALUE;		// LOW_VALUE: value to trip on for findfirst & last
      int  SCREEN_SAVER;	// If >0 turn screen saver on. How many Secs.
      char EDIT_ONLY;           // If >0 then not sound card can be used.
      char SQ;		        // this is the SQ setting for recording.
      long COMPARE;		// This is the lowest value will be put into
				// buffer to in a seach.
      char FILTER;		// This is the FILTER Value used by Z;
      char CLOCK;

     } S1;



int RESULT;


void print_screen()
  {
   char buff[80];
   char *bp=&buff[0];
   char strout[80];
   char *so=&strout[0];
   char parm[300];
   char strin[80];
   char *p[9];
   char outname[80];
   char *pon=&outname[0];
   char number_of_parm;
   char count;
   p[1]=&parm[0];
   p[2]=&parm[40];
   p[3]=&parm[80];
   p[4]=&parm[120];
   p[5]=&parm[160];
   p[6]=&parm[200];
   p[7]=&parm[240];

   textbackground(GREEN);
   gotoxy(15,3);
   cprintf("%2i",S1.GRIDCOLOR);
   gotoxy(27,3);
   cprintf("%2i",S1.TOP_LINE);
   gotoxy(44,3);
   cprintf("%2i",S1.BOTTOM_LINE);
   gotoxy(63,3);
   if (S1.SAFE_ESC==0)
	  {
	  cprintf("OFF");
	  }
	  else
	  {
	  cprintf(" ON");
	  }
   gotoxy(18,5);
   cprintf("%-35s",S1.X_FILE);
   gotoxy(63,5);
   cprintf("%-4s",S1.EXT);
   gotoxy(18,7);
   cprintf("%-35s",S1.TOP_FILE);
   gotoxy(18,9);
   cprintf("%-35s",S1.BOTTOM_FILE);
   gotoxy(18,11);
   cprintf("%-35s",S1.REC);
   gotoxy(18,13);
   cprintf("%2i", S1.NAME);
   gotoxy(26,13);
   cprintf("%-35s",S1.PARM);
   gotoxy(18,17);
   cprintf("%-35s",S1.PROGDIR);
   gotoxy(18,19);
   if (S1.PRINT==0)
	{
	 cprintf("OFF");
	}
	else
	{
	 cprintf(" ON");
	}
   gotoxy(50,19);
   cprintf("%3i",S1.SCREEN_SAVER);
   gotoxy(66,19);
   if (S1.EDIT_ONLY==0) cprintf("NO "); else cprintf("YES ");
   textbackground(BLUE);
   gotoxy(1,1);
   number_of_parm=sscanf(S1.PARM,"%s %s %s %s %s %s %s",
			  p[1],p[2],p[3],p[4],p[5],p[6],p[7]);
   count=0;
   strcpy(strin,"");
   while (count<number_of_parm)
    {
       count++;
       strcat(strin," ");
       if (count==S1.NAME)
	   {
	    strcpy(pon,S1.X_FILE);
	    strcat(pon,S1.EXT);
	    strcpy(p[count],pon);
	   }
       strcat(strin,p[count]);

    }
   sprintf(bp,"%-s %-32s",S1.REC,strin);
   strncpy(so,bp,50);
   strout[50]=0;
   gotoxy(18,15);
   cprintf("%s",strout);
   gotoxy(12,25);
   cprintf("Press F1 to abort...      F10 to save and exit...");
   textbackground(GREEN);
   return;
  }

char get_string(int x,int y,int max_len,char *pb)
{
  char buff[80];
  char strin[80];
  char strout[80];
  char *lb=&buff[0];
  char *si=&strin[0];
  char *so=&strout[0];
  char time_to_end=0;
  char ch;
  char fn;
  char r;
  int current=strlen(pb);
  RESULT=0;
  strcpy(lb,pb);
  gotoxy(x,y);
  sprintf(si,"%-35s",buff);
  strncpy(so,si,max_len);
  strout[max_len]=0;
  cprintf("%s",strout);
  gotoxy(current+x,y);

  while (!(time_to_end))
   {
    ch=getch();
    fn=0;
    if (ch==0) fn=getch();
    if (fn==68)
       {
	 buff[current]=0;
	 time_to_end=1;
	 strcpy(pb,lb);
	 r=2;
	 SAVE=1;
       }
    if (fn==59)
       {
	 buff[current]=0;
	 time_to_end=1;
	 strcpy(pb,lb);
	 r=2;
       }
    if (ch==8)
       {
	if (current==0) current++;
	current--;
	buff[current]=0;
       }
    if ((ch==32) || isalpha(ch) || isdigit(ch) || ispunct(ch))
	{
	 if (current>max_len) current--;
	 buff[current]=ch;
	 current++;
	 buff[current]=0;
	}

    if (ch==27 || fn==72)
	{
	 time_to_end=1;
	 r=0;
	}

    if (ch==13 || fn==80)
	 {
	  buff[current]=0;
	  current++;
	  time_to_end=1;
	  strcpy(pb,lb);
	  r=1;
	 }
    gotoxy(x,y);
    sprintf(si,"%-35s",buff);
    strncpy(so,si,max_len);
    strout[max_len]=0;
    cprintf("%s",strout);
    gotoxy(current+x,y);
   }

return r;

}



int get_number(int x,int y,int l)
{
  char ch;
  char fn;
  int time_to_end=0;
  RESULT=0;
  gotoxy(x,y);
  cprintf("%2i",l);

  while (!(time_to_end))
   {
    ch=getch();
    if (ch==0) fn=getch(); else fn=0;
    if (ch==13)
	 {
	  time_to_end=1;
	  RESULT=0;
	  return l;
	 }
    if (fn==68) {
		 time_to_end=1;
		 RESULT=1;
		 SAVE=1;
		 return l;
		}
    if (fn==59) {
		 time_to_end=1;
		 RESULT=1;
		 return l;
		}
    if (ch==27) {
		 time_to_end=1;
		 l=-1;
		 return l;
		}

    if (fn==80) l++;
    if (fn==72) l--;

    if (l>15) l=0;
    if (l<0) l=15;
    gotoxy(x,y);
    cprintf("%2i",l);
   }

  return l;
}

char get_grid()
{
 int temp;
 char r=1;
 temp=get_number(15,3,S1.GRIDCOLOR);
 if (temp==-2) return 2;
 if (temp<0) {
	      r=0;
	     }
	     else
	     {
	      S1.GRIDCOLOR=temp;
	     }
 return r;

}

char get_scr()
{
 int temp;
 char r=1;
 char t[5];
 sprintf(t,"%3i",S1.SCREEN_SAVER);
 get_string(50,19,3,t);
 temp=atoi(t);
 if (temp==-2) return 2;
 if (temp<0) {
	      r=0;
	     }
	     else
	     {
	      S1.SCREEN_SAVER=temp;
	     }
 return r;

}

char get_top_color()
{
 int temp;
 char r=1;
 temp=get_number(27,3,S1.TOP_LINE);
 if (temp==-2) return 2;

 if (temp==-1)
     {
      r=0;
     }
     else
     {
     S1.TOP_LINE=temp;
     }

 return r;

}

char get_bottom_color()
{
 int temp;
 char r=1;
 temp=get_number(44,3,S1.BOTTOM_LINE);
 if (temp==-2)
       {
	return 2;
       }
 if (temp==-1) {
		r=0;
	       }
	       else
	       {
		S1.BOTTOM_LINE=temp;
	       }
 return r;

}

char get_name()
{
 int temp;
 char r=1;
 temp=get_number(18,13,S1.NAME);
 if (temp==-2) {
		return 2;
	       }
 if (temp==-1) {
		r=0;
	       }
	       else
	       {
		S1.NAME=temp;
	       }

 return r;

}

char get_safe_esc()
 {
  char ch=0,fn;
  char r=1;
  char time_to_end=0;
  gotoxy(63,3);
  while (!(time_to_end))
   {
    ch=getch();
    if (ch==32)
       {
	if (S1.SAFE_ESC==0) S1.SAFE_ESC=1; else S1.SAFE_ESC=0;
       }
    if (ch==0)
	 {
	  fn=getch();
	 }
	 else
	 {
	  fn=0;
	 }
     if (fn==80)
	{
	 if (S1.SAFE_ESC==0) S1.SAFE_ESC=1; else S1.SAFE_ESC=0;
	}
     if (fn==72)
	{
	 if (S1.SAFE_ESC==0) S1.SAFE_ESC=1; else S1.SAFE_ESC=0;
	}
     if (ch==27)
	{
	time_to_end=1;
	r=0;
	}
     if (ch==13)
	{
	time_to_end=1;
	RESULT=0;
	}
     if (fn==68)
	{
	 time_to_end=1;
	 RESULT=1;
	 r=2;
	 SAVE=1;
	}
     if (fn==59)
	{
	 time_to_end=1;
	 RESULT=1;
	 r=2;
	}

    print_screen();
    gotoxy(63,3);
   }
   return r;
}

char get_print()
 {
  char ch=0,fn;
  char r=1;
  char time_to_end=0;
  gotoxy(21,19);
  while (!(time_to_end))
   {
    ch=getch();
    if (ch==32)
       {
	if (S1.PRINT==0) S1.PRINT=1; else S1.PRINT=0;
       }
    if (ch==0)
	 {
	  fn=getch();
	 }
	 else
	 {
	  fn=0;
	 }
     if (fn==80)
	{
	 if (S1.PRINT==0) S1.PRINT=1; else S1.PRINT=0;
	}
     if (fn==72)
	{
	 if (S1.PRINT==0) S1.PRINT=1; else S1.PRINT=0;
	}
     if (ch==27)
	{
	time_to_end=1;
	r=0;
	}
     if (ch==13)
	{
	time_to_end=1;
	RESULT=0;
	}
     if (fn==68)
	{
	 time_to_end=1;
	 RESULT=1;
	 r=2;
	 SAVE=1;
	}
     if (fn==59)
	{
	 time_to_end=1;
	 RESULT=0;
	 r=2;
	}
    print_screen();
    gotoxy(21,19);
   }
   return r;
}



char get_edit()
 {
  char ch=0,fn;
  char r=1;
  char time_to_end=0;
  gotoxy(67,19);
  while (!(time_to_end))
   {
    ch=getch();
    if (ch==32)
       {
	if (S1.EDIT_ONLY==0) S1.EDIT_ONLY=1; else S1.EDIT_ONLY=0;
       }
    if (ch==0)
	 {
	  fn=getch();
	 }
	 else
	 {
	  fn=0;
	 }
     if (fn==80)
	{
	 if (S1.EDIT_ONLY==0) S1.EDIT_ONLY=1; else S1.EDIT_ONLY=0;
	}
     if (fn==72)
	{
	 if (S1.EDIT_ONLY==0) S1.EDIT_ONLY=1; else S1.EDIT_ONLY=0;
	}
     if (ch==27)
	{
	time_to_end=1;
	r=0;
	}
     if (ch==13)
	{
	time_to_end=1;
	RESULT=0;
	}
     if (fn==68)
	{
	 time_to_end=1;
	 RESULT=1;
	 r=2;
	 SAVE=1;
	}
     if (fn==59)
	{
	 time_to_end=1;
	 RESULT=0;
	 r=2;
	}
    print_screen();
    gotoxy(67,19);
   }
   return r;
}

char get_x_file()
 {
  char r;
  r=get_string(18,5,34,&S1.X_FILE[0]);
  print_screen();
  return r;
 }

char get_ext()
 {
  char r;
  r=get_string(63,5,4,&S1.EXT[0]);
  print_screen();
  return r;
 }

char get_top_file()
 {
  char r;
  r=get_string(18,7,34,&S1.TOP_FILE[0]);
  print_screen();
  return r;
 }

char get_bottom_file()
 {
  char r;
  r=get_string(18,9,34,&S1.BOTTOM_FILE[0]);
  print_screen();
  return r;

 }

char get_rec()
 {
  char r;
  r=get_string(18,11,34,&S1.REC[0]);
  print_screen();
  return r;
 }

char get_parm()
 {
  char r;
  r=get_string(26,13,34,&S1.PARM[0]);
  print_screen();
  return r;
 }

char get_program()
 {
  char r;
  r=get_string(18,17,34,&S1.PROGDIR[0]);
  print_screen();
  return r;
 }

void main()
{
     int setfile;
     char time_to_end,w,r;
     int size;
     char *c_ptr;
     char config_dir[MAXPATH];
     char config_file[MAXPATH];
     SAVE=0;
     clrscr();
     if ((c_ptr=getenv("XMIT"))==NULL)
       {
	strcpy(config_dir,"");
       }
       else
       {
	strcpy(config_dir,c_ptr);
       }

     if (_argc>1)
	{
	 strcpy(config_file,_argv[1]);
	}
	else
	{
	 strcpy(config_file,"XMIT_ID.CFG");
	}
     strcat(config_dir,config_file);
     if ((setfile=open(config_dir, O_BINARY, S_IWRITE))==-1)
       { // create new file
	cprintf("Creating new file.....\n\r");

	if ((setfile=open(config_dir,O_CREAT | O_BINARY, S_IWRITE))==-1)
	     {
	      perror("File open error");
	      printf("%s %s",config_dir,config_file);
	      getch();
	      exit(1);
	     }
	if ((size=write(setfile,&S1,sizeof(S1)))==-1)
	     {
	      perror("File write error");
	      cprintf("size: %i\r\n",size);
	      getch();
	      exit(1);
	     }
	cprintf("size: %i",size);
	getch();
       }
     else
       {
	int bytes;
	lseek(setfile,0,SEEK_SET);
	if ((bytes=read(setfile,&S1,sizeof(S1)))==-1)
	    {
	    perror("Read error");
	    getch();
	    exit(1);
	    }
	   else
	    {
	     lseek(setfile,0,SEEK_SET);
	     read(setfile,&S1,sizeof(S1));
	    }
	if (bytes<0) printf("File save FAIL....");
       }

   close(setfile);
   if ((strcmp(S1.START,"CONFIG FILE XMIT_ID VER 200.")!=0))
    {
     S1.GRIDCOLOR=1;
     S1.TOP_LINE=10;
     S1.BOTTOM_LINE=14;
     S1.PRINT=0;
     S1.SAFE_ESC=0;  //   1234567890123456789012345678
     strcpy(&S1.START[0],"CONFIG FILE XMIT_ID VER 200.");
     S1.START[29]=0X1A;
     S1.START[30]=0X1A;
     S1.START[31]=0;
     S1.START[32]=0;
     S1.START[33]=1;
     strcpy(&S1.X_FILE[0],"FOX");
     strcpy(&S1.TOP_FILE[0],"TEST1.RAW");
     strcpy(&S1.BOTTOM_FILE[0],"TEST2.RAW");
     strcpy(&S1.REC[0],"");
     S1.NAME=2;
     strcpy(&S1.EXT[0],".RAW");
     strcpy(&S1.PARM[0],"");
     strcpy(&S1.PROGDIR[0],"C:\\XMIT\\");
     S1.SQ=20;
     S1.COMPARE=6000;
     S1.FILTER=10;
     S1.SAMPLE_SIZE=50;
     S1.LOW_VALUE=500;
    }
   if (S1.PRINT>1) S1.PRINT=0;
   textbackground(BLUE);
   textcolor(WHITE);
   clrscr();
   gotoxy(5,1);
   cprintf("Setup program for XMIT_ID.  Version %3i.%3i      File %s\n\r\n",VER,DAT,config_dir);
   gotoxy(5,3);
   cprintf("GridColor     TopLine       BottomLine           Safe_ESC");
   gotoxy(5,5);
   cprintf("X_FILE     :");
   gotoxy(54,5);
   cprintf("EXT:");
   gotoxy(5,7);
   cprintf("Top_FILE   :");
   gotoxy(5,9);
   cprintf("Bottom_FILE:");
   gotoxy(5,11);
   cprintf("Rec_name   :");
   gotoxy(5,13);
   cprintf("NAME       :");
   gotoxy(21,13);
   cprintf("PARM");
   gotoxy(5,17);
   cprintf("Program dir:");
   gotoxy(5,15);
   cprintf("Rec Shell  :");
   gotoxy(5,19);
   cprintf("Print First:");
   gotoxy(23,19);
   cprintf("Screen Saver: (0 disable):");
   gotoxy(55,19);
   cprintf("Edit only:");
   print_screen();
   time_to_end=0;
   w=1;
   r=0;
   while (!(time_to_end))
    {
    switch (w)
     {

     case 1 : {
		r=get_grid();
		break;
	      }
     case 2 : {
		r=get_top_color();
		break;
	      }
     case 3 : {
		r=get_bottom_color();
		break;
	      }
     case 4 : {
		r=get_safe_esc();
		break;
	      }
     case 5 : {
		r=get_x_file();
		break;
	      }
     case 6 : {
		r=get_ext();
		break;
	      }
     case 7 : {
		r=get_top_file();
		break;
	      }
     case 8 : {
		r=get_bottom_file();
		break;
	      }
     case 9 : {
		r=get_rec();
		break;
	      }
     case 10: {
		r=get_name();
		break;
	      }
     case 11: {
		r=get_parm();
		break;
	      }
     case 12: {
		r=get_program();
		break;
	      }
     case 13: {
		r=get_print();
		break;
	      }
     case 0 : {
		w=13;
		break;
	      }
     case 14: {
		r=get_scr();
		break;
	      }
     case 15: {
		r=get_edit();
		break;
	      }
     case 16: {
		w=0;
		break;
	      }

     }
   if (r==0) w=w-1;
   if (r==1) w=w+1;
   if (r==2) time_to_end=1;
   if (r==3) time_to_end=1;
   if (RESULT==1)
       {
	time_to_end=1;
	r=3;
       }
   }
   textbackground(BLUE);
   textcolor(WHITE);
   clrscr();
   if (SAVE==0)
	{
	 printf("File not saved\n\r");
	 printf("Operation aborted.\n\r");
	 exit(0);
	}
   unlink(config_dir);
   if ((setfile=open(config_dir,O_CREAT | O_BINARY, S_IWRITE))==-1)
	{
	 perror("File open error");
	 printf("file name is: %s \n\r",config_dir);
	 getch();
	 exit(1);
	}

   if ((size=write(setfile,&S1,sizeof(S1)))==-1)
	{
	 perror("File write error");
	 cprintf("size: %i %s\r\n",size,config_dir);
	 getch();
	 exit(1);
	}
   cprintf("size: %i\r\n",size);
   close(setfile);
   cprintf("File SAVED at %s\n\r",config_dir);
   return;
}
