#include <graphics.h>
#include <dos.h>
#include <dir.h>
#include <stdlib.h>
#include <FCNTL.H>
#include <SYS/STAT.H>
#include <PROCESS.H>
#include <IO.H>
#include <conio.h>
#include <string.h>
#include <stdio.h>
#include "setup.h"


struct LOG_FILE
	     {
	      unsigned long pos;
	      unsigned char hour;
	      unsigned char min;
		       char day;
		       char mon;
		       char name[16];
	     } LOG;


extern unsigned char REC_BUF_A;

int  VALID_LOG;
extern char LOG_FILE[MAXPATH];
extern int TAB_POS;
extern int FILE2;
extern int DISPLAY_SIZE;

extern long get_file_pos2(void);
extern long *set_file_pos2(long);

extern void error(int,char *);
//************************************************************************
//
// LOG file that file is made my JOY sub routine
//
// sub functions are:
//
// get_log(void) This funtion see if there is a LOG file
//
// go_next_tab(void) This will find the next pos in the log file.
//
// go_back_tab(void) This will find on tab back from the log file.
//
// go_end_end(void) This will find the end of the log file
//
//************************************************************************


char get_log(void)
 {
   int text;

   if ((text=open(LOG_FILE, O_BINARY, S_IREAD))==-1)
      {
	 VALID_LOG=0;
      }
      else
      {
	VALID_LOG=1;
      };
   close(text);
   return VALID_LOG;
 }


char go_next_tab(void)

 {   // Look for next tab POS
     int fno;
     long t;
     fno=open(LOG_FILE, O_BINARY, S_IREAD );
     if (fno<0) {
		     close(fno);
		     printf("COULD NOT OPEND FILE");
		     // getch();
		     return 0;
		    }
     t=get_file_pos2();
     TAB_POS++;
     lseek(fno,(TAB_POS)*sizeof(LOG),SEEK_SET);
     read(fno,&LOG,sizeof(LOG));

     if (eof(fno))
	   {
	    set_file_pos2(t);
	    TAB_POS--;
	    return 0;
	   };
      if (LOG.pos==0)
	  {
	   set_file_pos2(t);
	   TAB_POS--;
	   close(fno);
	   return 0;
	  }
	  else
	  {
	   set_file_pos2(LOG.pos);
	   close(fno);
	  };


     if (strcmp(LOG.name,"END")==0)
	      {
	       //printf("END was True\n\r");
	       set_file_pos2(t);
	       TAB_POS--;
	       close(fno);
	       return 0;
	      }
	      else
	      {
	       //printf("End was False\n\r");
	       set_file_pos2(LOG.pos);
	       close(fno);
	      }
  return 1;
}


char go_back_tab(void)
{
 int fno;
 if (TAB_POS==0){
		   set_file_pos2(0);
		   return 0;
		}
 TAB_POS--;
 fno=open(LOG_FILE, O_BINARY, S_IREAD);
 if (fno<0) {
		 close(fno);
		 TAB_POS++;
		 return 0;
		}
 lseek(fno,TAB_POS*sizeof(LOG),SEEK_SET);
 read(fno,&LOG,sizeof(LOG));
 set_file_pos2(LOG.pos);
 close(fno);
 return 1;
}

char get_tab_end(void)

{
 int fno,time_to_end=0;
 TAB_POS=0;
 fno=open(LOG_FILE, O_BINARY, S_IREAD );
 if (fno>0)
     {
      do
	{
	 long file_pointer;
	 TAB_POS++;
	 file_pointer=lseek(fno,
	 TAB_POS*sizeof(LOG_FILE),SEEK_SET);
	 if (file_pointer>0)
	     {
	      read(fno,&LOG,sizeof(LOG));
	     }
	 if (LOG.pos==0)
	      {
	       time_to_end=-1;
	      }
	 if (strcmp(LOG.name,"END")==0) time_to_end=-1;
	 if (eof(fno)) time_to_end=-1;
	} while (!time_to_end);
     }
 close(fno);
 set_file_pos2(filelength(FILE2)-DISPLAY_SIZE+5);
 return 1;
}

extern char get_string(int x,int y,int max_len,char *pb);

int display_list(void *p,int start,int high)
{
  struct _posxy
   {
    int x;
    int y;
    int trans;
    unsigned long pos;
    unsigned char hour;
    unsigned char min;
    char day;
    char mon;
    char name[16];
   } *posxy;
  int loaded,count;
  long l;
  posxy=p;
  loaded=4;
  count=start;
  l=posxy[start-1].pos;
  while (loaded<24)
   {
    posxy[count].y=loaded;
    posxy[count].x=5;
    count++;
    loaded++;
    if (posxy[count].pos==0) loaded=25;
   }
  textcolor(WHITE);
  loaded=start;
  clrscr();
  cprintf("FILE: %s\n\r",LOG_FILE);
  cprintf("     Trans#  POS          Time     Date      Name             Seconds \n\r");
  cprintf("===========================================================================\n\r");
  textcolor(YELLOW);
  l=0;
  while (loaded<count)
   {
    gotoxy(posxy[loaded].x,posxy[loaded].y);
    if (high==loaded) textcolor(WHITE); else textcolor(YELLOW);
    cprintf(" %2i ",posxy[loaded].trans);
    cprintf(
     "     %-10lu   %#02i:%#02i    %#02i/%#02i    %-16s    %-li\n\r",
	    posxy[loaded].pos,
	    posxy[loaded].hour,
	    posxy[loaded].min,
	    posxy[loaded].mon,
	    posxy[loaded].day,
	    posxy[loaded].name,
	    ((posxy[loaded].pos-l)/10000));
      l=posxy[loaded].pos;
      loaded++;
   }
   return 1;
}



int change_tab_pos(void)
{
  int fno;
  int input,time_to_end;
  char num[10];
  int loaded=0;
  int count;
  int highlight,screen;
  int byte;
  struct _posxy
   {
    int x;
    int y;
    int trans;
    unsigned long pos;
    unsigned char hour;
    unsigned char min;
    char day;
    char mon;
    char name[16];
   } *posxy;
  posxy=&REC_BUF_A;
  restorecrtmode();
  textcolor(WHITE);
  textbackground(BLUE);
  clrscr();
  //       1234567890123456789012345678
  cprintf("Loading File : %s ",LOG_FILE);
  gotoxy(1,2);
  if ((fno=open(LOG_FILE, O_BINARY,S_IREAD))<0)
      {
       printf("File: %i ",fno);
       perror("Can not open file");
       close(fno);
       getch();
       return 0;
      }
  count=0;
  while (!loaded)
   {
    byte=read(fno,&LOG,sizeof(LOG));
    if(byte<sizeof(LOG))
	{
	 loaded=-1;
	 printf("Max File %i \n\r",HANDLE_MAX);
	 perror("Can not read log file ");
	 getch();
	 return 0;
	}

    posxy[count].x=1;
    posxy[count].y=1;
    posxy[count].trans=count;
    posxy[count].pos=LOG.pos;
    posxy[count].hour=LOG.hour;
    posxy[count].min=LOG.min;
    posxy[count].day=LOG.day;
    posxy[count].mon=LOG.mon;
    strcpy(posxy[count].name,LOG.name);
    if (LOG.pos==0) loaded=1;
    count++;
   }

  close(fno);
  highlight=1;
  screen=0;
  display_list(posxy,0,1);
  time_to_end=0;
  screen=1;
  while (!time_to_end)
   {
    int ch,fk;
    ch=getch();
    if (!ch) fk=getch(); else fk=0;
    if (ch==13)
	 {
	  TAB_POS=highlight-1;
	  if (TAB_POS<0) TAB_POS=0;
	  go_next_tab();
	  time_to_end=1;
	 }
    if (fk==72)
	 {
	  highlight--;
	 }
    if (fk==80)
	{
	 highlight++;
	}
    if (ch==27)
	{
	 time_to_end=1;
	}
    if (fk==71) highlight=1;
    if (fk==79) highlight=count-2;
    if (fk==73) highlight=highlight-20;
    if (fk==81) highlight=highlight+20;
    if (highlight<2) highlight=1;
    if (highlight>(count-2)) highlight=count-2;
    screen=(highlight/20)*20;
    if (screen==-1) screen=0;
    display_list(posxy,screen,highlight);
  }
   return 1;
}

char goto_tab_time(void)
{
 int fno,time_to_end=0;
  int input;
  char num[10];
  restorecrtmode();
  textcolor(WHITE);
  textbackground(BLUE);
  clrscr();
  //       1234567890123456789012345678901234567890
  cprintf("Enter the time to find min only: ");
  strcpy(num,"0");
  get_string(37,1,10,num);
  input=atoi(num);
  fno=open(LOG_FILE, O_BINARY, S_IREAD );
  if (fno>0)
     {
      do
	{
	 long file_pointer;
	 TAB_POS++;
	 file_pointer=lseek(fno,
	 TAB_POS*sizeof(LOG_FILE),SEEK_SET);
	 if (file_pointer>0)
	     {
	      read(fno,&LOG,sizeof(LOG));
	      if (LOG.min>=input) time_to_end=1;
	     }
	 if (strcmp(LOG.name,"END")==0)
	      {
	       time_to_end=-1;
	      }
	} while (!time_to_end);
     }
 close(fno);
 TAB_POS--;
 go_next_tab();
 return 1;
}


void write_log
     (int log_file,
      int count,
      unsigned long byte_count,
      unsigned long tdata)
{
 struct date d;
 struct time t;
 gettime(&t);
 LOG.hour=t.ti_hour;
 LOG.min=t.ti_min;
 getdate(&d);
 LOG.day=d.da_day;
 LOG.mon=d.da_mon;
 LOG.pos=byte_count;
 strcpy(LOG.name,"NOT TESTED");

 if (write(log_file,&LOG,sizeof(LOG))<sizeof(LOG))
	   error(200,"Writting log");

 printf("Pos: %5li    # of Trans: %3i",byte_count/10000,count);

 printf("     Length: %3lu",(byte_count-tdata)/10000);

 printf("  Time: %02u:%02u\n\r",LOG.hour,LOG.min);

 return ;
}
