#ifndef __SB_H
#define __SB_H

#include <dos.h>

#define NumberOfTimes1 10   // Resetting
#define NumberOfTimes2 50   // Data present test
#define Threshold 10        // Limit : 128 Thr en 128+thr

unsigned Port = 0x210; // current port
char Found = 0;        // port is SB port
unsigned Cnt1, Cnt2;    // Reset & wait
long SB_POINTER;


int monitor();
void Rec_SB();
void Play_SB();
void speakeroff();
void speakeron();
int Get_SB();



//int Port;
//long SB_POINTER;
long SB_BUF;

int monitor()
{
  // wait until input is no longer between 128 - threshold
  // and 128+threshold
  unsigned short h;     // sample byte
  int count;
  long int counter;


  counter=0;
  count=0;
  do
   {
     outportb(Port + 0xc,0x20);  // read byte
     do {                        // data present ?
	} while (!(inportb(Port + 0xe) >=128));
     h = inportb(Port + 0xa);
     if (h >= 126) h=h -127;
     count++;
     counter=counter+h;

   } while (count<5000);
   counter = counter / 5000;



return counter;
}  // end of Wait for sound






void speakeroff()
{
  // turns speaker off and requires 230ms to accomplish
     outportb(Port + 0xc,0xd3);  // read byte
     delay(300);
return;
}

void speakeron()
{
  // turns speaker on and requires 113ms to accomplish
     outportb(Port + 0xc,0xd1);  // read byte
     delay(200);
return;
}  // end of Turn ON Sound

int Get_SB()
{
	int Cnt1,Cnt2;
	int Found=0;
	Cnt1 = NumberOfTimes1;          // initialize counter
	while ((Port <= 0x260) && !Found) {
		outportb(Port + 0x6,1);  // reset Sound Blaster
		outportb(Port + 0x6,0);
		Cnt2 = NumberOfTimes2;   // Data test
		while ((Cnt2 > 0) && (inportb(Port + 0xe) < 128))
		--Cnt2;
		if ((Cnt2==0) || (inportb(Port + 0xA) != 0xaa)) {
		--Cnt1;         // port 2xah <> aah
		  if (Cnt1 == 0) {
			Cnt1 = NumberOfTimes1;   // resetting failed
			Port = Port + 0x10;     // try next
		      }
		    }
		    else                 // resetting successful
		    Found = 1;           // port found
		}
		if (!Found) Port = 0;

return Port;
}

#endif