#include <sys\stat.h>
#include <stdio.h>
#include <bios.h>
#include <stdlib.h>
#include <ctype.h>
#include <conio.h>
#include <dos.h>
#include <mem.h>
#include <fcntl.h>
#include "sbdefs.h"

#define true = 1;
#define false = 0;
int 		FALSE=0;
int 		TRUE=1;
extern char 	XSET;
extern void error(int error_number,char *from);

// Structure for storing data associated with each SB card.
typedef struct {
	int base,                         // SB card base I/O address
	 MixerAddr, MixerData,            // mixer chip addresses
	 Reset, WrBuf,                    // DSP addresses
    DataAvail, ReadData,             // DSP addresses
    irq,                             // IRQ number
	 dma8,                            // 8-bit DMA channel
    dma16,                           // 16-bit DMA channel
    midi,                            // midi port
    cardtype;                        // card type number from environment
    void interrupt (*intvecsave)();  // previous interrupt vector
    int intrnum;                     // interrupt number
    int intrmask;                    // interrupt mask
   } cardinfo;


// Structure for retrieving DMA controller register port addresses.
typedef struct {
   unsigned char addr, count, page, mask, mode, FF;
   } dmaportstruct;


// Constant array that defines port addresses for DMA controller registers.
const dmaportstruct dmaportarray[8] = {
    {0x0,  0x1,  0x87, 0xA,  0xB,  0xC},   // chan 0
    {0x2,  0x3,  0x83, 0xA,  0xB,  0xC},   // chan 1
	 {0x4,  0x5,  0x81, 0xA,  0xB,  0xC},   // chan 2  DON'T USE
    {0x6,  0x7,  0x82, 0xA,  0xB,  0xC},   // chan 3
	 {0x0,  0x0,  0x00, 0xD4, 0xD6, 0xD8},  // chan 4  DON'T USE
	 {0xC4, 0xC6, 0x8B, 0xD4, 0xD6, 0xD8},  // chan 5
    {0xC8, 0xCA, 0x89, 0xD4, 0xD6, 0xD8},  // chan 6
    {0xCC, 0xCE, 0x8A, 0xD4, 0xD6, 0xD8}   // chan 7
   };




#define BUFSIZE (20*1024)      // size of the DMA buffer
#define NUMBUFS 2
#define TIMECONST 156         // 156 = approx 10 KHz sample rate

extern unsigned char            REC_BUF_A[BUFSIZE];
extern unsigned char            REC_BUF_B[BUFSIZE];
extern char                     REC_BUF_AB;
char                            END_OF_TRANS;

int                             COUNT;
unsigned long int               BYTE_COUNT;
unsigned long int               TDATA;

int                             POS_Y;
int                             LOG_FIL_N;
int                             HANDLE;
int                             BUSY;

cardinfo      card1;


unsigned int  inpage,                  // DMA pages for input
	      inoffset,                // offsets for DMA input
	      count = BUFSIZE;         // size of the DMA buffers

int      NumFilledInBufs   = 0,   // number of filled input buffers
			NumRecBufToFill   = 0,   // next input buffer to fill from DMA buffer
			NumRecBufToEmpty  = 0,   // next input buffer to copy to disk
			HalfBufToEmpty    = 0,   // which half of input DMA buffer to empty
			NumBufsWritten    = 0;   // number of buffers written to disk



int base16(char **str, int *val)
/* Takes a double pointer to a string, interprets the characters as a
 * base-16 number, and advances the pointer.
 * Returns 0 if successful, 1 if not.
 */
{
   char c;
   int digit;
   *val = 0;

	while ((**str != ' ') && (**str != '\0')) {
		c = toupper(**str);
		if (c >= '0' && c <= '9')
	 digit = c - '0';
      else if (c >= 'A' && c <= 'F')
	 digit = c - 'A'  + 10;
		else
	 return 1;          // error in string

      *val = *val * 16 + digit;
      (*str)++;
   }
   return 0;
}



int base10(char **str, int *val)
/* Takes a double pointer to a string, interprets the characters as a
 * base-10 number, and advances the pointer.
 * Returns 0 if successful, 1 if not.
 */
{
   char c;
   int digit;
	*val = 0;

	while ((**str != ' ') && (**str != '\0')) {
      c = toupper(**str);
      if (c >= '0' && c <= '9')
	 digit = c - '0';
      else
	 return 1;          // error in string

      *val = *val * 10 + digit;
      (*str)++;
   }
   return 0;
}



int ReadBlasterEnv(char *name, int *port, int *irq, int *dma8, int *dma16,
 int *midi, int *cardtype)
/* Gets the Blaster environment statement and stores the values in the
 * variables whose addresses were passed to it.
 *
 * Input:
 *   name  - environment name to get, usually "BLASTER"
 *
 * Returns:
 *   0  if successful
 *   1  if there was an error reading the port address.
 *   2  if there was an error reading the IRQ number.
 *   3  if there was an error reading the 8-bit DMA channel.
 *   4  if there was an error reading the 16-bit DMA channel.
 *   5  if there was an error reading the MIDI address.
 *   6  if there was an error reading the card type number.
 */
{
	char     *env;
	unsigned val;
	int      digit;

	env = getenv(name);

	if (!env)
		return 7;   // if there was no environment entry for name.

	while (*env) {
		switch(toupper( *(env++) )) {
	 case 'A':
		 if (base16(&env, port))
			 return 1;
		 break;
	 case 'I':
		 if (base10(&env, irq))
			 return 2;
		 break;
	 case 'D':
		 if (base10(&env, dma8))
	       return 3;
		 break;
	 case 'H':
	    if (base10(&env, dma16))
	       return 4;
		 break;
	 case 'P':
	    if (base16(&env, midi))
	       return 5;
	    break;
	 case 'T':
		 if (base10(&env, cardtype))
			 return 6;
	    break;
	 default:
	    break;
      }
   }

   return 0;
}



void SegToPhys(unsigned char far *ptr, unsigned long size, unsigned long *physaddr, unsigned long *endaddr)
// Converts a segmented address to a physical memory address.
{
   *physaddr=(unsigned long)(((unsigned long)FP_SEG(ptr) << 4) + FP_OFF(ptr));
   *endaddr = *physaddr+size-1;
}



unsigned int PhysToPage(unsigned long physaddr, unsigned long endaddr, unsigned int *page, unsigned int *offset)
/* Converts a physical memory address to a DMA-page address.  Returns the
 * number of bytes in this block of memory that aren't in a different DMA
 * page.
 *  INPUT:
 *   physaddr - a physical (not segmented) address specifying the start
 *              of the DMA buffer.
 *   endaddr  - a physical address specifying the last byte of the DMA
 *              buffer.
 *  OUTPUT:
 *   page     - the DMA page of the buffer.
 *   offset   - the offset of the buffer.
 *  RETURN VALUE:
 *   The minimum of (endaddr-physaddr+1, number of bytes in this page
 *   starting at physaddr).
 */
{
   unsigned int remaining;
   *page=physaddr >> 16;
	*offset=physaddr & 0xFFFF;

	remaining=0xFFFF - *offset + 1;   /* bytes remaining in page */
	if (remaining>endaddr-physaddr)   /* if more bytes left in page than in buffer */
      return endaddr-physaddr+1;     /* return number of bytes in buffer */
   else return remaining;            /* else return number of bytes left in page */
}



void dspout(cardinfo *card, unsigned int val)
// Output a byte to the Sound Blaster Digital Sound Processor.
{
	while (inp(card->WrBuf) & 0x80);
   outp(card->WrBuf, val);
}



unsigned char dspin(cardinfo *card, unsigned int *val)
// Read a byte from the Digital Sound Processor.
{
   while (!(inp(card->DataAvail) & 0x80)) {
		;
	}
   *val=inp(card->ReadData);

   return 1;    // used to be meaningful
}



void SetupDMA(int dmachan, unsigned short page, unsigned short ofs,
 unsigned short DMAcount, unsigned char dmacmd)
// This programs the DMA controller.
// NOTE:  This function supports 8-bit DMA channels ONLY (because this pro-
// gram only uses 8-bit voice mode.  The SetupDMA function in the program
{
   dmaportstruct dmaports;

/**** There MUST be parens around the values to be output, or the compiler
 **** will convert them to unsigned chars BEFORE it does the operations
 **** on them.
 ****/
   dmaports = dmaportarray[dmachan];

	outp(dmaports.mask, 4 | dmachan);            // mask off dma channel
   outp(dmaports.FF, 0);                        // clear flip-flop
/* This next value to DMAC is different between auto-init and non-auto-init.
 * (0x58 vs. 0x48) */
   outp(dmaports.mode , dmacmd | dmachan);      // set mode
   outp(dmaports.addr, (ofs & 0xFF));           // low byte base addr
   outp(dmaports.addr, (ofs >> 8));             // high byte base addr
	outp(dmaports.page, page);                   // physical page number
   outp(dmaports.count,((DMAcount-1) & 0xFF));  // count low byte
	outp(dmaports.count,((DMAcount-1) >> 8));    // count high byte
   outp(dmaports.mask, dmachan);                // enable dma channel
}



void SetupDSP
	  (cardinfo *card,
      unsigned char dspcmd,
      unsigned short DSPcount,
      unsigned char tc)
// Programs the Sound Blaster card.
{
	// Program the time constant.
	dspout(card, dspcmdTimeConst);
   dspout(card, tc);

   // Program the DMA buffer size.
	dspout(card, dspcmdBlockSize);
   dspout(card, (DSPcount-1) & 0xFF);
	dspout(card, (DSPcount-1) >> 8);

   // Send the play or record command.
   dspout(card, dspcmd);
}



void SetupInputDMA(unsigned int page, unsigned int ofs, int count,
 unsigned char tc)
// Program the DMA Controller and Sound Blaster for DMA input.
{
   SetupDMA(card1.dma8, page, ofs, count, DMAMODEWRITE);
	SetupDSP(&card1, dspcmdAUTODMAADC, count/2, tc);
}


void DrainInputBuffer(void)
// Copies half the DMA buffer to one of the record buffers.
{

   ++NumRecBufToFill;
   if (NumRecBufToFill >= NUMBUFS)
      NumRecBufToFill =  0;

	// Increment count of filled input buffers.
	++NumFilledInBufs;

   // Next time use other half of DMA buffer.
   HalfBufToEmpty ^= 1;

}




void interrupt InputSBISR(void)
// Service interrupts from SB doing input.
{
	// Make sure this wasn't a spurious interrupt.
   if (card1.irq == 7) {
      outp(PIC1MODE, 0xB);                // select In Service Register
      if ((inp(PIC1MODE) & 0x80) == 0)    // if bit 7 == 0, spurious interrupt
	 return;
   }

   inp(card1.DataAvail);                  // acknowledge interrupt

	DrainInputBuffer();

   if (card1.irq > 8)                     // If irq 10, send EOI to second PIC.
      outp(PIC2MODE, PICEOI);
	outp(PIC1MODE,PICEOI);                 // Send EOI to first PIC.
}



int GetCardInfo(char *name, cardinfo *card)
// Read a blaster environment string.
{
	int result;
	int dummy;

	result=ReadBlasterEnv(name, &card->base, &card->irq, &card->dma8, &dummy,
	 &dummy, &card->cardtype);

	if (result != 0) {
		switch (result) {
	 case 1:
		 printf("Error in %s port address.\n",name);
		 break;
	 case 2:
		 printf("Error in %s IRQ number.\n",name);
		 break;
	 case 3:
		 printf("Error in %s 8-bit DMA channel.\n",name);
		 break;
	 case 4:
		 printf("Error in %s 16-bit DMA channel.\n",name);
		 break;
	 case 5:
		 printf("Error in %s MIDI address.\n",name);
		 break;
	 case 6:
		 printf("Error in %s card type number.\n",name);
		 break;
	 case 7:
		 printf("Error:  %s environment variable not set.\n",name);
		 break;
		}
	}

	card->WrBuf     = card->base + dspoffsetWrBuf;
	card->Reset     = card->base + dspoffsetReset;
	card->ReadData  = card->base + dspoffsetReadData;
   card->DataAvail = card->base + dspoffsetDataAvail;
   card->MixerAddr = card->base + dspoffsetMixerAddr;
	card->MixerData = card->base + dspoffsetMixerData;

   return result;
}



void EnableCardInterrupt(cardinfo *card, void interrupt (*newvect)())
{
   int intrmask;

   // calculate interrupt number for IRQ
   if (card->irq < 8)
		card->intrnum = card->irq + 8;          // IRQs 0-7 map to interrupts 8-15.
   else
      card->intrnum = card->irq - 8 + 0x70;   // IRQs 8-15 map to interrupts 70H-78H.

	// generate 16-bit mask for IRQ
   card->intrmask = 1 << card->irq;

	card->intvecsave = getvect(card->intrnum); // save previous interrupt vector

   setvect(card->intrnum, newvect);           // set new interrupt vector

   // enable interrupts at interrupt controllers
   intrmask = card->intrmask;
	outp(PIC1MASK, inp(PIC1MASK) & ~intrmask);
   intrmask >>= 8;
	outp(PIC2MASK, inp(PIC2MASK) & ~intrmask);
}



void DisableCardInterrupt(cardinfo *card)
{
	int intrmask;

	// disable interrupts at interrupt controllers
	intrmask = card->intrmask;
	outp(PIC1MASK, inp(PIC1MASK) | intrmask);
	intrmask >>= 8;
	outp(PIC2MASK, inp(PIC2MASK) | intrmask);

	// Restore previous vector
	setvect(card->intrnum, card->intvecsave);
}



void WriteBufsToDisk(int handle)
// Writes all the record buffers that have data to the disk.
{
	unsigned nread;
	unsigned buffer;
	buffer=(BUFSIZE/2)*NumRecBufToEmpty;
	// While there are input buffers with data, write them to disk
	while (NumFilledInBufs > 0)
	 {
	  if (REC_BUF_AB==0)

		 {
	if (!(FIND_SOT(&REC_BUF_A[buffer])==0))
	  {
		BUSY=TRUE;
		_dos_write(handle,&REC_BUF_A[buffer],
				BUFSIZE/2,
				&nread);
		if (nread<(BUFSIZE/2))
		  {
			perror("Can not write: ");
			return;
		  }
		BYTE_COUNT=BYTE_COUNT+(unsigned int long)(BUFSIZE/2);
	  }
	  else
	  {
		if (BUSY==TRUE)
		  {
			END_OF_TRANS=TRUE;
			_dos_write(handle,&REC_BUF_A[buffer],
			 BUFSIZE/2,
			 &nread);
			BYTE_COUNT=BYTE_COUNT+(unsigned int long)(BUFSIZE/2);
		  }
			BUSY=FALSE;
	  }
		 }
		 else
		 {
	if (!(FIND_SOT(&REC_BUF_B[buffer])==0))
	  {
		BUSY=TRUE;
		_dos_write(handle,&REC_BUF_B[buffer],
				BUFSIZE/2,
				&nread);
		if (nread<(BUFSIZE/2))
		  {
			perror("Can not write: ");
			return;
		  }
		BYTE_COUNT=BYTE_COUNT+(unsigned int long)(BUFSIZE/2);
	  }
	  else
	  {
		if (BUSY==TRUE)
		  {
			END_OF_TRANS=TRUE;
			_dos_write(handle,&REC_BUF_B[buffer],
			 BUFSIZE/2,
			 &nread);
			BYTE_COUNT=BYTE_COUNT+(unsigned int long)(BUFSIZE/2);
		  }
		BUSY=FALSE;
	  }
		 } // end of if BUFF_AB
	  save_buf();
	  ++NumBufsWritten;
	  --NumFilledInBufs;
	  ++NumRecBufToEmpty;
	  if (NumRecBufToEmpty >= NUMBUFS) NumRecBufToEmpty = 0;
	  if (END_OF_TRANS==TRUE)
		 {
	COUNT++;
	gotoxy(1,POS_Y);
	write_log(LOG_FIL_N,COUNT,BYTE_COUNT,TDATA);
	TDATA=BYTE_COUNT;
	POS_Y++;
	if (POS_Y>25) POS_Y=25;
	END_OF_TRANS=FALSE;
		 }

	 }  // end while wend

}

extern void SetMixer(void);

int save_buf()

{
 if (BUSY==TRUE)
	  {
		textbackground(RED);
		textcolor(WHITE);
		gotoxy(70,1);
		cprintf("BUSY");
		textbackground(BLUE);
	  }
	  else
	  {
		textbackground(BLUE);
		textcolor(WHITE);
		gotoxy(70,1);
		cprintf("    ");
		textbackground(BLUE);
		BUSY=FALSE;
	  }

 return 0;
}



int REC_SOT(char *file)
{
  unsigned int  byte_write ;
  char          set_buf;
  int           code=0;
  char          log_name[128];
  char          drive[5];
  char          dir[128];
  char          ext[5];
  char          a,f;
  unsigned char rt;
  int i,b,c;
  unsigned long physaddr,endaddr;
  unsigned char done=0;
  int result;

  COUNT=0;
  POS_Y=5;
  BYTE_COUNT=0;
  TDATA=0;
  BUSY=0;
  if( heapfillfree( 1 ) < 0 )
	{
	 error(400,"Heap corrupted." );
	 return 1 ;
	}
//  _voc_set_speaker(TRUE);

  unlink(file);
  HANDLE=open(file,O_CREAT | O_BINARY, S_IWRITE);
  if (HANDLE==-1)
		{
		 error(600,file);
		 return 1;
		}
  _splitpath(file,drive,dir,log_name,ext);
  strcat(log_name,".LOG");
  unlink(log_name);
  LOG_FIL_N=open(log_name,O_CREAT | O_BINARY, S_IWRITE);
  if (LOG_FIL_N==-1)
		{
		 error(600,file);
		 return 1;
		}
	gotoxy(1,5);
	write_log(LOG_FIL_N,0,1l,1l);
	if (XSET==1) SetMixer();
	NumBufsWritten    = 0;   // number of buffers written to disk
	result=GetCardInfo("BLASTER", &card1);
	if (result!=0) error(300,"RECORDING");
	REC_BUF_AB=0;
	gotoxy(1,24);
	printf(" ESC to save and exit recording.           N to save file goto next file name.\n\r");
	printf("                 B  blank file continue to record to this file.");
	if (result != 0) return 1;
	SegToPhys(REC_BUF_A,BUFSIZE,&physaddr,&endaddr);
	if (PhysToPage(physaddr,endaddr,&inpage,&inoffset) < BUFSIZE)
	  {
		REC_BUF_AB=1;
		SegToPhys(REC_BUF_B,BUFSIZE,&physaddr,&endaddr);
		PhysToPage(physaddr,endaddr,&inpage,&inoffset);
	  }
		/*
		 * The program should dynamically allocate buffers until a buffer is
		 * found that doesn't cross a DMA page boundary.  I took a short cut
		 * here by just using an array, which usually works if it's much less
		 * than 64K bytes.
		 */
	EnableCardInterrupt(&card1, InputSBISR);
	// Start recording
	SetupInputDMA(inpage,inoffset,count,TIMECONST);

	while (!done)
	  {
		 WriteBufsToDisk(HANDLE);     // write all full input buffers
		 gotoxy(1,10);
		 printf("I am in this looping... %3i",rt);
		 rt++;
		 if (bioskey(2)) done=!done;

		 if (kbhit())
			{
			 printf("Getting char......");
			 a=getch();
			 printf("Got it.....");
			 if (!a) f=getch();
			 printf("Function......");
			 a=toupper(a);
			 gotoxy(1,11);
			 printf("Keypressed: %u %u",a,f);

			 switch (a)
			  {
				case 27:
					 {
					  done=!done;
					  code=1;
					  break;
					 }
				case 'B':
					 {
					  done=!done;
					  code=0;
					  break;
					 }
				case 'N':
					 {
					  done=!done;
					  code=-1;
					  break;
					 }
			  } // end of switch
			  printf("End of case");
			  printf("Test this thing");
			} // end of if kbhit
		if (BYTE_COUNT>9000000l && BUSY==FALSE)
		  {
			done=!done;
			code=-1;
		  };

	  } // end of while !done
		 // Stop recording.
	dspout(&card1,dspcmdHaltDMA8);
	DisableCardInterrupt(&card1);
	BYTE_COUNT=0;
	TDATA=0;
	write_log(LOG_FIL_N,COUNT,BYTE_COUNT,TDATA);
	close(HANDLE);
	close(LOG_FIL_N);
	return code;
}

