#include <alloc.h>
#include <conio.h>
#include <string.h>
#include <process.h>
#include <graphics.h>
#include <stdio.h>
#include <dir.h>
#include "setup.h"

int MODE;
int Z;

extern int change_tab_pos(void);
extern int goto_tab_time(void);

extern long find_last ();   // This finds the last key-down of the transmitter
extern void new_search();   // This function inputs new search parameters for
extern long f_next_kd ();   // This find the next place for key down.
extern long f_next_ku ();   // This find the next place for key up.

extern void init_var(void);
extern void close_var(void);
extern long fast_forward(void);

extern void draw_lines(char valid);
extern void draw_adv_lines(char valid);
extern void draw_agv(char valid);
extern void draw_two();
extern void make_grid(char valid);
extern void grid_four(char valid);
extern void draw_four(char valid);


//**********************************
//
// externs from FILE_IO.C
//
//**********************************


extern int open_file(void);

extern char *set_file_name1(char *temp);
extern char *get_file_name1(char *temp);
extern char *set_file_name2(char *temp);
extern char *get_file_name2(char *temp);

extern long get_file_pos1(void);
extern long *set_file_pos1(long int input);
extern long *move_pos1(long temp);
extern long get_file_pos2(void);
extern long *set_file_pos2(long int input);
extern long *move_pos2(long temp);

extern int time_in_file(char intput);

extern char get_hst(void);

extern char get_log(void);
extern char go_next_tab(void);
extern char go_back_tab(void);
extern char get_tab_end(void);

extern char xchange_files(void);

extern char set_tad(void);
extern char set_sad(void);


extern char check_pos(void);
extern char change_display_size(void);

extern void close_all(void);
extern char over_lay(void);


extern void help(void);
extern void closing(void);
extern void pick_top(void);
extern void top_ten_list(void);
extern void hst_prt(void);

extern unsigned long play_file(char far *file,unsigned long pos);
extern int  joy(char *pb,int sq);
extern void int_rec(void);

extern void ifexist(int);

// In GRID.C

unsigned char filter_in(unsigned char aa, unsigned char bb);


// In HST.C

char hst(char *pb);

// In INPUT_F.C

char get_file_name(int x,int y,int max_len,char *pb);
void get_file(char *so,char *pb);

// In SAVE.C

void reload_a();
void reload_b();
void saveboth();
void save();

// Compare.c

void compare(void);

void make_cmp(const unsigned char *ba,unsigned char *bb,int ln_in);
/* Fist buf is input outputs a buf in bb that has not noise +/-5
ln_in is size in bytes
*/
long comp_two(const unsigned char *bc,const unsigned char *bd,int comp);
int sort_nums( const void *a, const void *b );
void comp_file(void);
void comp_eof(void);

extern long indata1(void);


extern long indata2(void);

extern void shell(void);


extern struct
       LIST  {
	    long score;
	    long tads;
	    char name[16];
	    int x;
	    int y;
	    int color;
	  } LT[];



int safe()
 {
   char c;

   textcolor(WHITE);
   textbackground(RED);
   gotoxy(10,10);
   printf("                                        ");
   gotoxy(10,11);
   printf("       Do You want to exit? (y/n) :     ");
   gotoxy(10,12);
   printf("                                        ");

   c=getch();
   if (c=='Y' || c=='y') return -1;
   return 0;
 }


int sw_ch(int ch)
 {
   switch (ch)
	 {
	   case 27:     {                   // ESC
			 if (S1.SAFE_ESC==0)
			       return 127;  // end program
			    else
			       if (safe()) return 127;

			 return 1;
			}
	   case  9:	{    // Look for next tab POS
			 go_next_tab();
			 return 1;
			}

	   case 43:     {
			 move_pos2(+50);  // + key move bottom by 50
			 return 2;
			}

	   case 45:     {
			 move_pos2(-50);  // - key move bottom by -50
			 return 2;
			}

	   case 59:     {
			 move_pos2(-10);  // ; key
			 return 2;       // move bottom by -10

			}

	   case 39:     {
			 move_pos2(+10);  // ' key
			 return 2;       // move bottom by 10

			}

	   case 55:     {
			 extern int DISPLAY_SIZE;
			 move_pos1(DISPLAY_SIZE*-1);   // 7 key
			 return 3;                     // move top by -600
			}

	   case 57:     {
			 extern int DISPLAY_SIZE;
			 move_pos1(DISPLAY_SIZE);  // 9 key
			 return 3;                 // move top by 600
			}

	   case 49:     {
			 extern int DISPLAY_SIZE;
			 move_pos2(DISPLAY_SIZE*-1); // 1 key
			 return 2;                   // move bottom by -600
			}

	   case 51:     {
			 extern int DISPLAY_SIZE;
			 move_pos2(DISPLAY_SIZE); // 3 key
			 return  2;               // move bottom by 600
			}

	   case 93:     {
			 move_pos2(+1);   // ] key
					  // move bottom by 1
			 return 2;
			}

	   case 91:     {
			 move_pos2(-1);   // [ key
			 return 2;       // move bottom by -1

			}

	   case 46:     {
			 move_pos2(+10000); // . key
			 return 2;         // move bottom by 10000

			}

	   case 44:     {
			 move_pos2(-10000); // , key
			 return 2;         // move bottom by -10000

			}

	   case '4':    {
			 move_pos2(-600000l);
			 return  2;

			}

	   case '6':    {
			 move_pos2(+600000l);
			 return  2;
			}


	   case 'R':    {
			 extern int TAB_POS;
			 TAB_POS=0;
			 int_rec();
			 return 1;
			}

	   case 'X':    {
			 xchange_files();
			 printf("xchange files");
			 return  1;
			}


/*	   case '?':    {
			 hst_prt();
			 return 1;
			} */


	   case 'W':   {
			draw_two();
			while (!(kbhit()));
			return 1;
		       }

	   case 'I':   {
			extern char FILE_NAME2[MAXPATH];
			hst(FILE_NAME2);
			open_file();
			MODE=1;
			Z=0;
			return 1;
		       }

	   case 'T':   {
			set_tad();
			gotoxy(1,3);
			printf("TAD POS SAVED.");
			return 0;
		       }
	   case 'S':   {
			set_sad();
			gotoxy(1,3);
			printf("SAD POS SAVED.");
			return 0;
		       }

	   case 'Q':   {
			MODE=2;
			return 1;
		       }

	   case 'A':   {
			if (MODE==2)
			    {
			     MODE=1;
			     return 1;
			    }
			MODE=2;
			return 1;
		       }
	   case 'G':   {
			extern LIST_NUMBER;
			comp_file();
			while (!(kbhit()));
			MODE=1;
			LIST_NUMBER=0;
			Z=0;
			return 1;
		       }

	  case 'P':    {
			  extern char FILE_NAME2[MAXPATH];
			  long POS2;
			  POS2=get_file_pos2();
			  POS2=play_file(FILE_NAME2,POS2);
			  set_file_pos2(POS2);
			  return 1;
		       }
	   case 'Z':   {
			if (Z==0)
			    {
			     Z=1;
			     return 1;
			    }
			Z=0;
			return 1;
		       }

	   case 'D':   {
			change_display_size();
			return 1;
		       }

	   case 'C':   {
			compare();
			MODE=1;
			Z=0;
			return 1;
		       }

	   case 'M':   {
			gotoxy(1,15);
			printf("Memory left %10lu",coreleft());
			return 0;
		       }
	   case 32:	{
			 return 1;
			}
/*	   case 'Y':   {
			restorecrtmode();
			exit(1);
		       }*/

	} // end of case statement for ch
  return 0;
}

int sw_fk(int fk)
{
      switch (fk)

	{
	  case 19:    {
		       if (S1.EDIT_ONLY==0)
			{
			 int result;
			 extern char *b[10];
			 extern char TEMP_FILE[MAXPATH];
			 restorecrtmode();
			 clrscr();
			 close_all();
			 ifexist(0);
			 strcpy(b[S1.NAME],TEMP_FILE);   // X_FILE is a prt to
			 result=spawnlp
				(P_WAIT, b[0],
				 b[1],b[1],b[2],b[3],b[4],b[5],NULL);
			 if (result == 1)
			   {
			    restorecrtmode();
			    perror("\n\rError from spawnl");
			    printf("\n\rPress any key to continue.");
			    getch();
			    break;
			   }
			 printf("\n\rPress any key to return to data graphic.");
			 set_file_name2(TEMP_FILE);
			 open_file();
			 set_file_pos2(0);
			 MODE=1;
			 Z=0;
			 return 1;
			}
		       break;
		      }
	  case 15:	{        		// shift-tab
			 go_back_tab();
			 return 1;

			}

	  case 74:      {                      // ALT - load list
			 extern LIST_NUMBER;

			 if (LIST_NUMBER==1) break;
			 LIST_NUMBER--;
			 close_all();
			 set_file_name1(LT[LIST_NUMBER].name);
			 open_file();
			 set_file_pos1(0);
			 MODE=1;
			 Z=0;
			 return 1;

			}
	  case 78:      {                      // ALT +  load list
			 extern int LIST_NUMBER;
			 extern int NUM_LIST;
			 if (LIST_NUMBER>=NUM_LIST) break;
			 close_all();
			 set_file_name1(LT[LIST_NUMBER].name);
			 set_file_pos1(0);
			 open_file();
			 LIST_NUMBER++;
			 MODE=1;
			 Z=0;
			 return 1;

			}

	  case 71:      {  // Set home pos
			 extern int TAB_POS;
			 set_file_pos2(0);
			 TAB_POS=0;
			 return  1;

			}
	  case 79:      {  // END this go to end of file & set TAB_POS too.
			 get_tab_end();
			 return 1;
			}

	  case 59:      {       // F1 key
			help();
			MODE=1;
			Z=0;
			return 1;

			}

	  case 60:      {       // F2 key
			new_search();
			MODE=1;
			Z=0;
			return 1;
			}

	  case 105:     {       // Alt-F2 key
			top_ten_list();
			set_file_pos1(0);
			MODE=1;
			Z=0;
			return 1;

			}

	  case 61:      {       // F3 key
			set_file_pos2(f_next_kd());
			MODE=1;
			Z=0;
			return 1;
			}

	  case 62:      {       // F4 key
			set_file_pos2(find_last());
			MODE=1;
			Z=0;
			return 1;
			}

	  case 63:      {       // F5 key
			Z=0;
			MODE=1;
			reload_a();
			open_file();
			set_file_pos1(0);
			return 1;
			}

	  case 108:     {       // Alt-F5 key
			pick_top();
			MODE=1;
			Z=0;
			return 1;

			}

	  case 64:      {       // F6 key
			extern int TAB_POS;
			reload_b();
			Z=0;
			MODE=1;
			open_file();
			set_file_pos2(0);
			TAB_POS=0;
			return 1;
			}

	  case 65:      {       // F7 key
			 set_file_pos1(indata1());
			 MODE=1;
			 Z=0;
			 return 1;
			}

	  case 66:      {       // F8 key
			 set_file_pos2(indata2());
			 MODE=1;
			 Z=0;
			 return 1;
			}
	  case 31:	{	// ALT S
			 extern long int SAD;
			 set_file_pos2(SAD);
			 return 1;
			}
	  case 20:	{	// ALT T
			 extern long int TAD;
			 extern int DISPLAY_SIZE;
			 set_file_pos2(TAD-DISPLAY_SIZE);
			 return 1;
			}

	  case 67:      {       // F9 key
			 shell();
			 MODE=1;
			 Z=0;
			 return 1;
			}

	  case 68:      {       // F10 key
			 save();
			 MODE=1;
			 Z=0;
			 return  1;
			}

	  case 133:     {       // F11 key
			 saveboth();
			 MODE=1;
			 Z=0;
			 return  1;
			}

	  case 134:     {       // F12 key
			 over_lay();
			 return 1;
			}

	  case 34:      {
			 comp_eof();
			 MODE=1;
			 Z=0;
			 return 1;
			}
	  case 148:	{
			 change_tab_pos();
			 MODE=1;
			 Z=0;
			 return 1;
			}
	  case 101:	{
			 goto_tab_time();
			 MODE=1;
			 Z=0;
			 return 1;
			}
	} // end case for fk
return 0;
}


int key_input(int ch,int fk)
 {
  char valid;
  if (ch>0) valid=sw_ch(ch);
  if (fk>0) valid=sw_fk(fk);
  return valid;
 }


int heap_check()
{
 int hcf;
 hcf=heapcheckfree(1);
 if (hcf<0)
     {
      restorecrtmode();
      clrscr();
      switch( hcf )
	{
	 case _HEAPCORRUPT: printf( "Heap corrupted.\n" );
			    break;

	 case _BADVALUE   : printf( "Bad value in free space.\n" );
			    break;

	 default          : printf( "Unknown error.\n" );
			    break;
	}
      exit(1);
     }
return 0;
}