#include <dos.h>
#include <dir.h>
#include <stdlib.h>
#include <FCNTL.H>
#include <SYS/STAT.H>
#include <PROCESS.H>
#include <IO.H>
#include <string.h>
#include <stdio.h>
#include "setup.h"


char FILE_NAME[MAXPATH];
char FILE_NAME1[MAXPATH];
char FILE_NAME2[MAXPATH];
char TEMP_FILE[MAXPATH];
char LOG_FILE[MAXPATH];
char HST_FILE[MAXPATH];

char VALID_HST=0;
extern char VALID_LOG;

extern int OVERLAY=200;                        // this is use to overlay grids.
int DISPLAY_SIZE=600;                   // this is the defaut size for grids

int TAB_POS=0;
int TAB_FLAG=3;

int FILE1=0;
int FILE2=0;
int TEMP_F=0;
long int FILE_POS1=0;
long int FILE_POS2=0;
long int TAD=0,SAD=0;





char get_hst(void);
char get_log(void);


//***********************************************************************
//
// Open file open the top and bottom lines
//
//
//***********************************************************************


int open_file()
  {
   char drive[MAXDRIVE];
   char dir[MAXDIR];
   char file[MAXFILE];
   char ext[MAXEXT];

   if (FILE1!=0) close(FILE1);
   if (FILE2!=0) close(FILE2);
   FILE2 = open(FILE_NAME2, O_BINARY, S_IREAD );
   if(FILE2==-1)
      {
       FILE2=0;
      }
   FILE1 = open(FILE_NAME1, O_BINARY, S_IREAD );
   if(FILE1==-1)
      {
       FILE1=0;
      }
  _splitpath(FILE_NAME2,drive,dir,file,ext);
  _makepath(HST_FILE,drive,dir,file,".HST");
  _makepath(LOG_FILE,drive,dir,file,".LOG");

   return 0;
  }



//***********************************************************************
//
// This is used to see the next available file that is usable for
//
// reocording too.
//
//***********************************************************************

extern int GOOD_NUM;
void ifexist(int counter)

 {
    char temp[10];
    int trying=1;

    strcpy(TEMP_FILE,S1.X_FILE);
    strcat(TEMP_FILE,S1.EXT);
    while (trying==1)
     {

      TEMP_F = open(TEMP_FILE, O_BINARY, S_IREAD );
      close(TEMP_F);
      if (TEMP_F==-1)
	   {
	     GOOD_NUM=counter;
	     return;
	   }
      sprintf((char *)temp,"%0.3i",counter);
      strcpy(TEMP_FILE,S1.X_FILE);
      strcat(TEMP_FILE,temp);
      strcat(TEMP_FILE,S1.EXT);
      counter++;
      if (counter>999) return;
      printf("%s\n\r",TEMP_FILE);

     } // end of trying

 }




//**********************************************************************
//
// get_file_name get the file name return the a pointer the that file
//
// in memory.
//
//
//**********************************************************************

char *set_file_name1(char *temp)
 {
  strcpy(FILE_NAME1,temp);
  return FILE_NAME1;
 }

char *get_file_name1(char *temp)
 {
   char drive[MAXDRIVE];
   char dir[MAXDIR];
   char file[MAXFILE];
   char ext[MAXEXT];

  _splitpath(FILE_NAME1,drive,dir,file,ext);
  strcpy(temp,file);
  strcat(temp,ext);
  return FILE_NAME1;
 }

char *set_file_name2(char *temp)
 {
  strcpy(FILE_NAME2,temp);
  return FILE_NAME2;
 }

char *get_file_name2(char *temp)
 {
  char drive[MAXDRIVE];
  char dir[MAXDIR];
  char file[MAXFILE];
  char ext[MAXEXT];
  _splitpath(FILE_NAME2,drive,dir,file,ext);
  strcpy(temp,file);
  strcat(temp,ext);
  return FILE_NAME2;
 }

//**********************************************************************
//
//  get_file_pos  This returns a long pointer where the file pointer is
//
//  set_file_pos  This can set the file pos and return the file pointer
//		  new address...
//
//  move_pos      This function input a value and add it too the
//                current value
//
//
//**********************************************************************


long get_file_pos1(void)
 {
  return FILE_POS1;
 }

long *set_file_pos1(long input)
 {
  long fl;
  fl=filelength(FILE1);
  if (input>fl) input=fl-DISPLAY_SIZE+50;
  FILE_POS1=input;
  lseek(FILE1,input,SEEK_SET);

  return &FILE_POS1;
 }

long *move_pos1(long temp)
 {
  FILE_POS1=FILE_POS1+temp;
  return  &FILE_POS1;
 }

long get_file_pos2(void)
 {
  return FILE_POS2;
 }

long *set_file_pos2(unsigned long input)
 {
  long fl;
  fl=filelength(FILE2);
  if (input>fl) input=fl-DISPLAY_SIZE+50;
  FILE_POS2=input;
  lseek(FILE2,input,SEEK_SET);
  return &FILE_POS2;

 }

long *move_pos2(long temp)
 {
  FILE_POS2=FILE_POS2+temp;
  return &FILE_POS2;
 }




//********************************************************************
//
// time_in_file(min pointer,sec pointer) return 0 on exit
//
//
//
//********************************************************************



char time_in_file(char input)
 {
  long int min,sec,hour;
  long int sr=10000l;
  long int msz=(60*sr);
  long int hsz=(60*msz);
  long temp;
  temp=FILE_POS2;
  hour=temp/hsz;
  temp=temp-(hsz*hour);
  min=temp/msz;
  temp=temp-(min*msz);
  sec=temp/sr;
  if (input==1) return (int)min;
  if (input==0) return (int)sec;
  return (int)hour;
 }

//*****************************************************************
//
// char get_hst(void) this see if there is a HST file
//
//*****************************************************************


char get_hst(void)
 {
  int text;
  if ((text=open(HST_FILE, O_BINARY, S_IREAD))==-1)
      {
	 VALID_HST=0;
      }
      else
      {
	VALID_HST=1;
      }
  close(text);

  return VALID_HST;
 }




//**********************************************************************
//
// xchange files closing top and bottom lines the exchange them then
//
// reopen both files
//
//
//**********************************************************************

xchange_files(void)
 {
   long l;
   char TEMP[MAXPATH];
   strcpy(TEMP,FILE_NAME1);
   strcpy(FILE_NAME1,FILE_NAME2);
   strcpy(FILE_NAME2,TEMP);
   l=FILE_POS1;
   FILE_POS1=FILE_POS2;
   FILE_POS2=l;
   open_file();
   return 0;
 }




//**********************************************************************
//
// set_tab
//
//
//
//
//
//**********************************************************************

char set_tad(void)
{
  if (DISPLAY_SIZE==600)
      {
       TAD=FILE_POS2+600;
      }
      else
      {
       TAD=FILE_POS2+1200;
      }
 return 0;
}

char set_sad(void)

{
 SAD=FILE_POS2;
 return 0;
}

char change_display_size(void)
 {
  if (DISPLAY_SIZE==600)
       {
	DISPLAY_SIZE=1200;
	return 0;
       }
   DISPLAY_SIZE=600;
  return 0;
 }


int set_overlay(int over)
 {
  OVERLAY=over;
  return OVERLAY;
 }

char over_lay(void)
{
 if (OVERLAY==200) {
		     OVERLAY=0;
		     return 0;
		   }

 if (OVERLAY==0)   {
		    OVERLAY=200;
		    return 1;
		   }

 return 2;
}

int overlay(void)
{
 return OVERLAY;
}


//**********************************************************************
//
// check_pos(void) this will correct any non valid pos in file
//
// by check the end of file and see if it is less then 0
//
//
//
//
//
//**********************************************************************




char check_pos(void)
    {
       long len_file1;
       long len_file2;
       len_file1=filelength(FILE1);
       len_file2=filelength(FILE2);
       if (FILE_POS1>len_file1)
	 {
	    FILE_POS1=len_file1-550;
	 }
       if (FILE_POS2>len_file2)
	 {
	   FILE_POS2=len_file2-550;
	 }
       if (FILE_POS1<1) FILE_POS1=0;
       if (FILE_POS2<1) FILE_POS2=0;
       return 0;
    }

unsigned char *get_buffer(int valid)
{
 int tf;
 long pos;
 int bytes;
 extern unsigned char *BUFFER;
 register int counter;
 if (valid==1)
     {
      tf=FILE1;
      if (FILE_POS1>-1l)
	   {
	    pos=FILE_POS1;
	   }
	   else
	   {
	    pos=0;
	    FILE_POS1=0;
	   }
     }
     else
     {
      tf=FILE2;
      if (FILE_POS2>-1l)
	   {
	    pos=FILE_POS2;
	   }
	   else
	   {
	    pos=0;
	    FILE_POS2=0;
	   }
     }
 lseek(tf, pos, SEEK_SET);
 counter=0;
 while (counter < DISPLAY_SIZE)
  {
   BUFFER[counter]=127;
   counter++;
  }
 bytes=read(tf,BUFFER,DISPLAY_SIZE+100);
 if (bytes!=DISPLAY_SIZE+100)
      {
       pos=filelength(tf)+50-DISPLAY_SIZE;
       lseek(tf,pos, SEEK_SET);
       read(tf,BUFFER,DISPLAY_SIZE);
       if (valid==1) FILE_POS1=pos; else FILE_POS2=pos;
      }
 return BUFFER;
}


//**********************************************************************
//
// close_all(void) this closing all file used in this part of the
//
// program
//
//
//**********************************************************************


void close_all(void)
 {
  close(FILE1);    // close all open files to clean up..
  close(FILE2);
 }

