#include <graphics.h>
#include <alloc.h>
#include <conio.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>

extern void close_all(void);
extern void close_var(void);

void fatal_error(int error_number,char *from)
{
 restorecrtmode();
 textbackground(RED);
 textcolor(YELLOW);
 clrscr();
 cprintf("A fatal error has occurred.\n\r\n\r");
 switch (error_number)

 {
  case 100:
	{
	 cprintf("Could not open config file: %s \n\n\r",from);
	 cprintf("The DOS error reported is: %s\n\n\r",strerror(errno));
	 cprintf("One possible solution is to:\n\n\r");
	 cprintf("Run XSETUP %s at the command prompt to\n\n\r",from);
	 cprintf("correct this problem.\n\n\r");
	 break;
	}
  case 200:
	{
	 cprintf("Could not seek in config file: %s \n\n\r",from);
	 cprintf("The DOS error reported is: %s\n\n\r",strerror(errno));
	 cprintf("One possible solution is to:\n\n\r");
	 cprintf("Run XSETUP %s at the command prompt to\n\n\r",from);
	 cprintf("correct this problem.\n\n\r");
	 break;
	}
  case 300:
	{
	 cprintf("Could not read in config file: %s\n\n\r",from);
	 cprintf("The DOS error reported is: %s\n\n\r",strerror(errno));
	 cprintf("One possible solution is to:\n\n\r");
	 cprintf("Run XSETUP %s at the command prompt to \n\n\r",from);
	 cprintf("correct this problem.\n\n\r");
	 break;
	}
  case 400:
	{
	 extern int VER,DAT;
	 cprintf("This is not a current config file for XMIT version: %3i.%3i\n\n\r",
		  VER,DAT);
	 cprintf("This file name was: %s\n\n\r",from);
	 cprintf("One possible solution is to:\n\n\r");
	 cprintf("Run XSETUP %s at the command prompt to\n\n\r",from);
	 cprintf("correct this problem.\n\n\r");
	 break;
	}
  case 500:
	{
	 cprintf("This program could not find enough Ram\n\n\r");
	 cprintf("in the memory below 640K.  I was trying to\n\n\r");
	 cprintf("find space for: %s\n\r\n",from);
	 cprintf("The program found only: %lu\n\n\r",coreleft());
	 cprintf("One possible solution is to:\n\n\r");
	 cprintf("Please unload all TSR's and run again \n\n\r");
	 cprintf("or try to allocate more ram for the app.\n\n\r");
	 break;
	}

  case 600:
	{
	 cprintf("This program could not find EGAVGA.BGI driver\n\n\r");
	 cprintf("please make check that EGAVGA.BGI driver file\n\n\r");
	 cprintf("is located in the directory specify by\n\n\r");
	 cprintf("SET XMIT=\n\n\r");
	 cprintf("Error reported by the system is: %s\n\n\r",from);
	 break;
	}


  default:
	{
	 printf("Unknown Error\n\r");
	 break;
	}
 }
 cprintf("Please correct this problem and run the program again.\n\r");
 getch();
 close_all();
 closegraph();
 close_var();
 getch();
 exit(1);
}



void error(int error_number,char *from)
{
 restorecrtmode();
 textbackground(RED);
 textcolor(YELLOW);
 clrscr();
 cprintf("An error has occurred.  This error is not fatal.\n\r\n\r");
 switch (error_number)

 {
  case 100:
	{
	 cprintf("Could not seek in bottom line: %s \n\n\r",from);
	 cprintf("The DOS error reported is: %s\n\n\r",strerror(errno));
	 cprintf("One possible solution is to:\n\n\r");
	 cprintf("Please reload file in bottom line and try again.\n\n\r");
	 break;
	}
  case 200:
	{
	 cprintf("Could not write in:  %s \n\n\r",from);
	 cprintf("The DOS error reported is: %s\n\n\r",strerror(errno));
	 cprintf("One possible solution is to:\n\n\r");
	 cprintf("check to see if the drive is full.\n\n\r",from);
	 break;
	}
  case 300:
	{
	 cprintf("Sound Blaster error: %s\n\n\r",from);
	 cprintf("The DOS error reported is: %s\n\n\r",strerror(errno));
	 cprintf("One possible solution is to:\n\n\r");
	 cprintf("Check sound card SET BLASTER setup\n\n\r");
	 break;
	}
  case 400:
	{
	 cprintf("This is a memory error: %s\n\n\r",from);
	 cprintf("Please report this to the programmer");
	 break;
	}
  case 500:
	{
	 cprintf("This program could not open the file: %s \n\n\r",from);
	 break;
	}
  case 600:
	{
	 cprintf("This program could not open the file: %s\n\r\n",from);
	 break;
	}

  case 1000:
	{
	 cprintf("In saving the file: %s\n\r\n",from);
	 cprintf("I could not create this file.\n\r");
	 cprintf("The DOS error reported is: %s\n\n\r",strerror(errno));
	 break;
	}
  case 1200:
	{
	 cprintf("The number of bytes written does not match the number\n\n\r");
	 cprintf("of bytes read. This may not be an error please check the\n\n\r");
	 cprintf("file.\n\n\r");
	 cprintf("The DOS error reported is: %s\n\n\r",strerror(errno));
	 break;
	}

  default:
	{
	 cprintf("Error: \n\r");
	 cprintf("Dos ERROR: %s\n\n\r",strerror(errno));
	 cprintf("Error Number: %i Error String: %s\n\n\r",error_number,from);
	 break;
	}
 }
 cprintf("You may continue running the program by pressing any key...\n\r");
 cprintf("If you see this message more than once the program will abort.\n\r");
 getch();
 return ;
}

