#include <stdio.h>
#include <conio.h>
#include <dos.h>




unsigned char init_port(int port,long baud,int parity,int stop,int word)
{
 unsigned char al;
 union REGS regs;

 if (baud==9600) al=128+64+32;
 if (baud==4800) al=128+64;
 if (baud==2400) al=128+32;
 if (baud==1200) al=128;
 if (baud==600) al=64+32;
 if (baud==300)  al=64;
 if (baud==38400l) al=32;
 if (parity==1) al=al+8;
 if (parity==2) al=al+16;
 if (parity==3) al=al+16+8;
 if (stop==2) al=al+4;
 if (word==8) al=al+3;
 if (word==7) al=al+2;
 regs.h.ah = 0;  // set baud rate and parameters.
 regs.h.al = al;
 regs.h.dh = 0;
 regs.h.dl = port;
 printf("al %xh\n\r",al);
 int86(14, &regs, &regs);
 serror(regs.h.ah,regs.h.al);
 return regs.h.al;
}

serror(int ah,int al)
{
 if (ah &&   1) printf("Data ready\n\r");
 if (ah &&   2) printf("Overrun error\n\r");
 if (ah &&   4) printf("Parity Error\n\r");
 if (ah &&   8) printf("Framing error\n\r");
 if (ah &&  16) printf("Break detected\n\r");
 if (ah &&  32) printf("Transmit holding regiser empty\n\r");
 if (ah &&  64) printf("Transmit shift register empty\n\r");
 if (ah && 128) printf("Time out\n\r");
 if (al &&   1) printf("CTS\n\r");
 if (al &&   2) printf("DSR\n\r");
 if (al &&   4) printf("Trailing edge ring indicator\n\r");
 if (al &&   8) printf("Change om recoeive line signal\n\r");
 if (al &&  16) printf("CTS\n\r");
 if (al &&  32) printf("DSR\n\r");
 if (al &&  64) printf("Ring Indicator\n\r");
 if (al && 128) printf("Receive line signal detected\n\r");
 printf("\n\n\n\r");
return;
}


int init_fossil()
{
 union REGS regs;

 regs.h.ah = 4;  // init fossil driver
 regs.h.dh = 0;
 regs.h.dl = 1;
 int86(14, &regs, &regs);
 printf("version   : %i\n\r",regs.h.bh);
 return (regs.h.al+regs.h.ah*256);
}


int read_port(int port)
{
 union REGS regs;

 regs.h.ah = 2;  // read port with wait
 regs.h.al = 0;
 regs.h.dh = 0;
 regs.h.dl = port;
 int86(14, &regs, &regs);
 if (regs.h.ah && 128)
      {
       printf("Error in reading\n\r");
       //serror(regs.h.ah,0);
       //getch();
      }

 return (regs.h.al);
}

int purge(int port)
{
 union REGS regs;

 regs.h.ah = 0x0a;  // purge input buffer
 regs.h.al = 0;
 regs.h.dh = 0;
 regs.h.dl = port;
 int86(14, &regs, &regs);
 return 0;
}

int write_port(int port,int ch)
{
 union REGS regs;

 regs.h.ah = 1;  // write port with wait
 regs.h.al = ch;
 regs.h.dh = 0;
 regs.h.dl = port;
 int86(14, &regs, &regs);
 if (regs.h.ah && 128) printf("Error in writing\n\r");
 return (regs.h.al);
}


int request_status(int port)

{
 union REGS regs;

 regs.h.ah = 3;  // request status of port
 regs.h.dh = 0;
 regs.h.dl = port;
 int86(14, &regs, &regs);
 serror(regs.h.ah,regs.h.al);
 return (regs.h.al+regs.h.ah*256);
}


int get_sch(int port)
{
 union REGS regs;
 int rp=0;
 regs.h.ah = 3;  // request status of port
 regs.h.dh = 0;
 regs.h.dl = port;
 int86(14, &regs, &regs);
 if (regs.h.al && 32) rp=read_port(port);
 return rp;
}



main ()

{
 int time_to_end=0;
 int count=0;
 clrscr();
 printf("init port   %x\n\r",init_port(1,9600,0,1,8));
 count = 0;
 do
  {
   int rp;
   //write_port(1,'Q');
   rp=get_sch(1);
   if (rp>0) printf("%c",rp);
   if (kbhit()) time_to_end=-1;
   count++;
   if (count==1000)
	  {
	   count=0;
	   // time_to_end=-1;
	  }
  }
 while (!(time_to_end));
 printf("\n\rExit\n\r");
 getch();
 if (kbhit()) getch();
 return;
}
