#include "setup.h"
#include <dos.h>
#include <dir.h>
#include <stdlib.h>
#include <string.h>
#include <SYS\STAT.H>
#include <io.h>
#include <FCNTL.H>
#include <stdio.H>

char CONFIG_FILE_NAME[MAXPATH];
char CONFIG_DIR[MAXPATH];
char CONFIG_FILE[MAXPATH];

extern void fatal_error(int error_number,char *from);
extern char *b[10];

void set_config_file(void)
{
 char *c_ptr;

 if ((c_ptr=getenv("XMIT"))==NULL)
       {
	strcpy(CONFIG_DIR,"");
       }
       else
       {
	strcpy(CONFIG_DIR,c_ptr);
       }

 if (_argc>1)
	{
	 strcpy(CONFIG_FILE_NAME,_argv[1]);
	}
	else
	{
	 strcpy(CONFIG_FILE_NAME,"XMIT_ID.CFG");
	}

 strcpy(CONFIG_FILE,CONFIG_DIR);
 strcat(CONFIG_FILE,CONFIG_FILE_NAME);
 return;
}

void load_config(void)
{
char parm[80];
 int setfile;

 set_config_file();
 setfile=open(CONFIG_FILE, O_BINARY);
 if (setfile==-1)
     {
      fatal_error(100,CONFIG_DIR);
     }
 if (lseek(setfile,0,SEEK_SET)<0)
     {
      close(setfile);
      fatal_error(200,CONFIG_FILE);
     }
 if ((read(setfile,(void *)&S1,sizeof(S1)))==-1)
      {
       close(setfile);
       fatal_error(300,CONFIG_FILE);
      }
 if (strcmp(S1.START,"CONFIG FILE XMIT_ID VER 200.")!=0)
     {
      close(setfile);
      fatal_error(400,CONFIG_FILE);
     }

 close(setfile);
 strupr((char *)S1.REC);
 strcpy(b[0],S1.REC);
 strcpy(b[1],"");
 strcpy(b[2],"");
 strcpy(b[3],"");
 strcpy(b[4],"");
 strcpy(b[5],"");
 strcpy(b[6],"");

 strcpy((char *)&parm,(char *)&S1.PARM);
 sscanf((char *)&parm,"%s %s %s %s %s %s",
			   (char *)b[1],(char *)b[2],(char *)b[3],
			   (char *)b[4],(char *)b[5],(char *)b[6]);

  return;
}


void save_config(void)
{
 char parm[80];
 int setfile;

 unlink(CONFIG_FILE);
 setfile=open(CONFIG_FILE, O_BINARY | O_CREAT, S_IWRITE);
 if (setfile==-1)
     {
      fatal_error(100,CONFIG_DIR);
     }
 if ((write(setfile,(void *)&S1,sizeof(S1)))==-1)
      {
       close(setfile);
       fatal_error(300,CONFIG_FILE);
      }
 close(setfile);
}