/* Rtc_Pcf8563 Set Time. 
 * Sets a PCF8563 clock chip to a time that is input from the serial monitor, 
 * then loop continuously reading time and 
 * printing the time and date to the serial monitor
 *
 * SCK - A5, SDA - A4, INT - D3/INT1
 *
 * After loading and starting the sketch, use the serial monitor
 * to type in the settings, then to see the clock
 * 
 * setup:  see Pcf8563 data sheet.
 *         1x 10Kohm pullup on Pin3 INT
 *         No pullups on Pin5 or Pin6 (I2C internals used)
 *
 * Joe Robertson, jmr
 * modified by Jim Giammanco Sept 2019
 */
 
#include <Wire.h>
#include <Rtc_Pcf8563.h>

//initialize the real time clock object
// I2C 8 bit slave addresses default to 0xA2 (write) and 0xA3 (read)
// so the 7 bit slave address is 0x61
Rtc_Pcf8563 rtc;  
int setMonth;
int setDay;
int setWeekday;
int setYear;
int setHour;
int setMinute;
int setSecond;

void setup()
{
  Serial.begin(9600);
  Serial.setTimeout(30000);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }
  Serial.println("Setting RTC N5IB v1.0");
  
  //clear out the RTC registers
  rtc.initClock();
  


  while (Serial.available() > 0) Serial.read();  // clear the serial buffer
  Serial.print("Month ");
  setMonth = Serial.parseInt();
  if (setMonth==0) setMonth=1;
  Serial.println();
  Serial.println(setMonth);

  Serial.println(); //send CR+LF
  while (Serial.available() > 0) Serial.read();  // clear the serial buffer
  Serial.print("Day ");
  setDay = Serial.parseInt();
  if (setDay==0) setDay=1;
  Serial.println(setDay);

  Serial.println(); //send CR+LF
  while (Serial.available() > 0) Serial.read();  // clear the serial buffer
  Serial.print("Day of week [Sunday=0] ");
  setWeekday = Serial.parseInt();
  if (setWeekday==0) setWeekday=1;
  Serial.println(setWeekday);
    
  Serial.println(); //send CR+LF
  while (Serial.available() > 0) Serial.read();  // clear the serial buffer
  Serial.print("Year -20yy ");
  setYear = Serial.parseInt();
  if (setYear==0) setYear=19;
  Serial.println(setYear);
  Serial.println(); //send CR+LF
    
  while (Serial.available() > 0) Serial.read();  // clear the serial buffer
  Serial.print("Hour ");
  setHour = Serial.parseInt();
  if (setHour==0) setHour=0;
  Serial.println(setHour);

  Serial.println(); //send CR+LF
  while (Serial.available() > 0) Serial.read();  // clear the serial buffer
  Serial.print("Minute: ");
  setMinute = Serial.parseInt();
  if (setMinute==0) setMinute=0;
  Serial.println(setMinute);

  Serial.println(); //send CR+LF
  while (Serial.available() > 0) Serial.read();  // clear the serial buffer
  Serial.print("Second: ");
  setSecond = Serial.parseInt();
  if (setSecond==0) setSecond=0;
  Serial.println(setSecond);
  
  // set RTC day, weekday, month, century(1=1900, 0=2000), year(0-99)
  //rtc.setDate(setDay, setWeekday, setMonth, 0, setYear);
  //set RTC hr, min, sec
  //rtc.setTime(setHour, setMinute, setSecond);
  rtc.setDateTime(setDay,setWeekday,setMonth,0,setYear,setHour,setMinute,setSecond);
}

void loop()
{
  delay(1000);
  //both format functions call the internal getTime() so that the 
  //formatted strings are at the current time/date.
  Serial.print(rtc.formatTime());
  Serial.println();
  Serial.print(rtc.formatDate());
  Serial.println();
//  Serial.print("testing...");  // for debugging
}




