/*
SD card SPI bus tester
 Jim Giammanco, N5IB  19 Sept 2019
 
 Micro SD card interface is assuemed attached to SPI bus as follows:
   MOSI - pin D11
   MISO - pin D12
   CLK - pin D13
   CS - pin D9 (SDChipSel)
   in addition digital pin D0 must be setas an output, even id no used
*/
#define MOSIpin 11
#define MISOpin 12
#define CLKpin 13
#define CSpin 9
 
#include <SPI.h>  // library that supports SPI bus operations
#include <SD.h>  // library that supports SD card file operations
#include <Wire.h>  // library that supports 

char DataFile[ ] = "TestFile.txt";  // a file name to write 

void setup() {
  pinMode(MISOpin,INPUT); // 
  pinMode(10, OUTPUT);
  
  // Open serial communications and wait for port to open:
  Serial.begin(9600);
  Serial.setTimeout(10000);
  
  Wire.begin();
    
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }
  Serial.println("Initializing uSD Card");
  // see if the card is present and can be initialized:
  if (!SD.begin(CSpin)) {
    Serial.println("*Card failed/not present*");
    // if card won't open, hang here, don't do anything more
    while (1);
  }
  Serial.print("uSD OK, "); // otherwise confirm card is OK 
  Serial.print("File: ");
  Serial.print(DataFile);
  Serial.println(); //send CR+LF

  analogReference(EXTERNAL);  // use a regulated +5 V supply for the pressure sensor and ADC reference
  
}

void loop() {
  // make a string for assembling the data to log:
  String dataString = "Test data record";

  //  open the file. note that only one file can be open at a time,
  //  so you have to close this one before opening another.

  File dataFile = SD.open(DataFile, FILE_WRITE);
  // if the file is available, write to it, then close it
  if (dataFile) {
    dataFile.println(dataString);
    dataFile.close();
    // print to the serial port too:
    Serial.println(dataString);
  }
  // if the file isn't open, pop up an error:
  else {
   Serial.println("*file open error*");
  }
  delay(5000);
}

