/*
  Get basic environmental readings from the BME280
  By: Nathan Seidle
  SparkFun Electronics
  Date: March 9th, 2018
  License: This code is public domain but you buy me a beer if you use this and we meet someday (Beerware license).
  
  This example shows how to read humidity, pressure, and current temperature from the BME280 over I2C.

  Hardware connections:
  BME280 -> Arduino
  GND -> GND
  3.3 -> 3.3
  SDA -> A4
  SCL -> A5
*/

#include <Wire.h>

#include "SparkFunBME280.h"
BME280 mySensor;

void setup()
{
  Serial.begin(9600);
  Serial.println("Reading basic values from BME280");

  Wire.begin();
  mySensor.setI2CAddress(0x76); //set I2C addr 0x76, default for the SparkFun 0x77
  if (mySensor.beginI2C() == false) //Begin communication over I2C,
  {
    Serial.println("The sensor did not respond. Please check wiring.");
    while(1); //Freeze
  }
}

void loop()
{
  delay(5000);
  Serial.print("R H: ");
  Serial.print(mySensor.readFloatHumidity(), 0);
  Serial.print(" %, ");

  Serial.print(" Barometer: ");
  Serial.print(mySensor.readFloatPressure()/100,1);
  Serial.print(" hPa, ");
  //Serial.print(" Alt: ");
  //Serial.print(mySensor.readFloatAltitudeMeters(), 1);
  //Serial.print(mySensor.readFloatAltitudeFeet(), 1);

  Serial.print(" Temp: ");
  //Serial.print(mySensor.readTempC(), 2);
  Serial.print(mySensor.readTempF(), 1);
  Serial.print(" F ");

  Serial.println();
}
