/***
EEPROM initialization
Uses the Serial Monitor to prompt for an address and then for a data value to be written to that address

This routine uses the "Put" and "Get" functions
The address and the data value must be integers

***/

#include <EEPROM.h> // library to support EEPROM operations

int PROM_addr;
int PROM_data;
int PROM_readback;

void setup() {
  Serial.begin(9600);
  Serial.setTimeout(30000); // wait up to 30 seconds for keyboard input
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }
}

void loop() {

   Serial.print("Enter integer EEPROM address (0-255):  "); // prompt for an address
   PROM_addr = Serial.parseInt();  // get address from Serial Monitor keyboard input
   Serial.println(PROM_addr); // echo the address that was entered

   Serial.print("Enter signed integer data value (0 to +/- 32767):  "); // prompt for an address
   PROM_data = Serial.parseInt();  // get data from Serial Monitor keyboard input
   Serial.println(PROM_data); // echo the data that was entered

   delay(2000);
   Serial.print("Will now write ");
   Serial.print(PROM_data);
   Serial.print(" into PROM address ");
   Serial.println(PROM_addr);

   EEPROM.put(PROM_addr,PROM_data); // write data to EEPROM

   Serial.println();
   Serial.println("Pausing for a moment to catch my breath...");
   Serial.println();
   delay(4000);

   Serial.print("If I recall correctly, PROM address ");
   Serial.print(PROM_addr);
   Serial.print(" now contains the value: ");
   EEPROM.get(PROM_addr,PROM_readback); // retrieve data from EEPROM 
   Serial.println(PROM_readback);
   Serial.println();
   Serial.println("Good night, going to sleep now...");

   while(1) {   //hang here forever
   }

}
