/$ GridFunc

Chekgrid(string gr)
  /* return 1 if the grid is bad, 0 otherwise. */
{
  int i, error;
  gr = strupr(gr);
  i = 0;
  do {
    if (i == 2 || i == 3) 
      {
      if (substr(gr,i,1) >= '0' && substr(gr,i,1) <= '9')
	error = 0;   /*2nd two characters are numbers*/
      else 
	error = 1;
      }
    else if (substr(gr,i,1) >= 'A' && substr(gr,i,1) <= 'Z')
      error = 0;   /*first and last 2 characters are letters*/
    else
      error = 1;
    i++;
  } while (!(i == 6 || error));
  return error;
}

Calclon(string gr)
{
  float lon, lonmin;
  /*finds the lon of center of the sub-square*/

  lon = ((float)('A' - (char)substr(gr,0,1))) * 20.0 +
            ((float)('0' - (char)substr(gr,2,1))) * 2.0 + 180.0;

  lonmin = (float) (((char)substr(gr,4,1) - 'A')) * 5.0 + 2.5;

  lon = lon - lonmin / 60.0;

  return lon;
}

Calclat(string gr)
{
  float lat, latmin;
  /*finds the lat/lon of center of the sub-square*/

  lat = ((char)substr(gr,1,1) - 'A') * 10 + (char)substr(gr,3,1) - '0' - 90;

  latmin = (float) (((char)substr(gr,5,1) - 'A')) * 2.5 + 1.25;

  lat = lat + latmin/60.0;
  
  return lat;
}

Roundoff(float x)
{
  int retint;
  
  retint = (int)x;
  
  if ((x - retint) > 0.5)
    retint++;
    
  return retint;
}