/$ BD_full

#define AL         6378206.4   /*Clarke 1866 ellipsoid*/
#define BL         6356583.8
#define D2R  0.0174533         /* pi/180.0 */
#define Pi2  3.1415927 * 2.0

my_atan2(float Y, float X)
{
  float retval;

  retval = atan2(Y, X);
  if(retval < 0.0) retval = Pi2 + retval;

  return retval;
}

BearingDist(float Eplat,
		  float Eplon,
		  float Stlat,
		  float Stlon)

  /*		  float * Az,
		  float * Baz,
		  float * Dist) */
{

  /*Taken directly from:       */
  /*Thomas, P.D., 1970, Spheroidal Geodesics, reference systems,*/
  /*    & local geometry, U.S. Naval Oceanographic Office SP-138,*/
  /*    165 pp.*/

  /*assumes North Latitude and East Longitude are positive*/

  /*EpLat, EpLon = MyLat, MyLon*/
  /*Stlat, Stlon = HisLat, HisLon*/
  /*Az, BAz = direct & reverse azimuith*/
  /*Dist = Dist (km);  */
  float BOA, F, P1R, P2R, L1R, L2R, DLR, T1R, T2R, TM, DTM, STM, CTM, SDTM,
	CDTM, KL, KK, SDLMR, L, CD, DL, SD, T, U, V, D, X, E, Y, A, FF64,
	TDLPM, HAPBR, HAMBR, A1M2, A2M1, Az;

/*  if((fabs(Eplat - Stlat) < 1.0e-10) && (fabs(Eplon - Stlon) < 1.0e-10)) {
    *Az = 0.0;
    *Baz = 0.0;
    *Dist = 0.0; 
    return 0;
  } */

  BOA = BL / AL;
  F = 1.0 - BOA;
  P1R = Eplat * D2R;
  P2R = Stlat * D2R;
  L1R = Eplon * D2R;
  L2R = Stlon * D2R;
  DLR = L1R - L2R;
  T1R = atan(BOA * tan(P1R));
  T2R = atan(BOA * tan(P2R));
  TM = (T1R + T2R) / 2.0;
  DTM = (T2R - T1R) / 2.0;
  STM = sin(TM);
  CTM = cos(TM);
  SDTM = sin(DTM);
  CDTM = cos(DTM);
  KL = STM * CDTM;
  KK = SDTM * CTM;
  SDLMR = sin(DLR / 2.0);
  L = SDTM * SDTM + SDLMR * SDLMR * (CDTM * CDTM - STM * STM);
  CD = 1.0 - 2.0 * L;
  DL = acos(CD);
  SD = sin(DL);
  T = DL / SD;
  U = 2.0 * KL * KL / (1.0 - L);
  V = 2.0 * KK * KK / L;
  D = 4.0 * T * T;
  X = U + V;
  E = -2.0 * CD;
  Y = U - V;
  A = -D * E;
  FF64 = F * F / 64.0;
  Distkm = AL * SD * (T -
		      F / 4.0 * (T * X - Y) +
		      FF64 * (X * (A + (T - (A + E) / 2.0) * X) +
			      Y * (E * Y - 2.0 * D) + D * X * Y)) / 1000.0;

  TDLPM = tan((DLR - (E * (4.0 - X) + 2.0 * Y) * (F / 2.0 * T +
		       FF64 * (32.0 * T + (A - 20.0 * T) * X -
			       2.0 * (D + 2.0) * Y)) / 4.0 * tan(DLR)) / 2.0);

  HAPBR = my_atan2(SDTM, CTM * TDLPM);
  HAMBR = my_atan2(CDTM, STM * TDLPM); 

  A1M2 = Pi2 + HAMBR - HAPBR;
  A2M1 = Pi2 - HAMBR - HAPBR;

  while(!((A1M2 >= 0.0) && (A1M2 < Pi2)))
    {
      if(A1M2 >= Pi2)
	{
	  A1M2 = A1M2 - Pi2;
	}
      else
	{
	  A1M2 = A1M2 + Pi2;
	}
    }

  while(!((A2M1 >= 0) && (A2M1 < Pi2)))
    {
      if(A2M1 >= Pi2)
	{
	  A2M1 = A2M1 - Pi2;
	}
      else
	{
	  A2M1 = A2M1 + Pi2;
	}
    }

  Az = A1M2 / D2R;

  Baz = A2M1 / D2R;

  return Az;
}

