#!/usr/bin/perl 

## --> Wireless Network Link Calculator, wireless.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2003 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

## Program Setup
#
select STDOUT;
$| = 1;
use Math::Trig;

## User Setup
#
$banner = "A service of Green Bay Professional Packet Radio - www.gbppr.org";
$ver = "v1.9";

($sec,$min,$hour,$mday,$mon,$year) = gmtime;
$hour = sprintf "%02.0f",$hour;
$min  = sprintf "%02.0f",$min;
$sec  = sprintf "%02.0f",$sec;
$mon  = sprintf "%02.0f",($mon+1);
$mday = sprintf "%02.0f",$mday;
$year = sprintf "%02.0f",$year;
$year = 1900 + $year;

## Subroutines
#
sub log10 {
  log($_[0]) * (1 / log(10));
}

## Print MIME
#
print "Content-type:text/html\n\n";

## Read Environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $frq = $FORM{'frq'};
my $frq_val = $FORM{'frq_val'};
my $pwr_out = $FORM{'pwr_out'};
my $pwr_out_val = $FORM{'pwr_out_val'};

my $tx_name = $FORM{'tx_name'};
my $tx_cab = $FORM{'tx_cab'};
my $tx_len = $FORM{'tx_len'};
my $tx_len_val = $FORM{'tx_len_val'};
my $tx_ant_gain = $FORM{'tx_ant_gain'};
my $tx_radome = $FORM{'tx_radome'};
my $tx_ant_val = $FORM{'tx_ant_val'};
my $tx_ant_ht = $FORM{'tx_ant_ht'};
my $tx_ant_ht_val = $FORM{'tx_ant_ht_val'};
my $tx_elv = $FORM{'tx_elv'};
my $tx_elv_val = $FORM{'tx_elv_val'};
my $con_tx = $FORM{'con_tx'};
my $tx_misc_loss = $FORM{'tx_misc_loss'};
my $tx_misc_cab_loss = $FORM{'tx_misc_cab_loss'};
my $tx_misc_gain = $FORM{'tx_misc_gain'};

my $rx_name = $FORM{'rx_name'};
my $rx_cab = $FORM{'rx_cab'};
my $rx_len = $FORM{'rx_len'};
my $rx_len_val = $FORM{'rx_len_val'};
my $rx_ant_gain = $FORM{'rx_ant_gain'};
my $rx_radome = $FORM{'rx_radome'};
my $rx_ant_val = $FORM{'rx_ant_val'};
my $rx_ant_ht = $FORM{'rx_ant_ht'};
my $rx_ant_ht_val = $FORM{'rx_ant_ht_val'};
my $rx_elv = $FORM{'rx_elv'};
my $rx_elv_val = $FORM{'rx_elv_val'};
my $con_rx = $FORM{'con_rx'};
my $rx_misc_cab_loss = $FORM{'rx_misc_cab_loss'};
my $rx_misc_gain = $FORM{'rx_misc_gain'};

my $rx_div_ant_ht = $FORM{'rx_div_ant_ht'};
my $rx_div_ant_ht_val = $FORM{'rx_div_ant_ht_val'};
my $rx_div_ant_gain = $FORM{'rx_div_ant_gain'};
my $rx_div_ant_val = $FORM{'rx_div_ant_val'};
my $rx_div_len = $FORM{'rx_div_len'};
my $rx_div_len_val = $FORM{'rx_div_len_val'};
my $rx_div_misc_cab_loss = $FORM{'rx_div_misc_cab_loss'};

my $BER = $FORM{'BER'};
my $BER_val = $FORM{'BER_val'};

my $dfm = $FORM{'dfm'};
my $eifm = $FORM{'eifm'};
my $aifm = $FORM{'aifm'};

my $nth = $FORM{'nth'};
my $k = $FORM{'k'};
my $climate = $FORM{'climate'};
my $temp = $FORM{'temp'};
my $temp_val = $FORM{'temp_val'};
my $dist = $FORM{'dist'};
my $dist_val = $FORM{'dist_val'};

my $chia = $FORM{'chia'};
my $chia1 = $FORM{'chia1'};
my $chia2 = $FORM{'chia2'};
my $chia3 = $FORM{'chia3'};
my $chia4 = $FORM{'chia4'};

my $rough = $FORM{'rough'};
my $rough_hum = $FORM{'rough_hum'};
my $rough_val = $FORM{'rough_val'};

my $LAT1_D = $FORM{'LAT1_D'};
my $LAT1_M = $FORM{'LAT1_M'};
my $LAT1_S = $FORM{'LAT1_S'};

my $LON1_D = $FORM{'LON1_D'};
my $LON1_M = $FORM{'LON1_M'};
my $LON1_S = $FORM{'LON1_S'};

my $LAT2_D = $FORM{'LAT2_D'};
my $LAT2_M = $FORM{'LAT2_M'};
my $LAT2_S = $FORM{'LAT2_S'};

my $LON2_D = $FORM{'LON2_D'};
my $LON2_M = $FORM{'LON2_M'};
my $LON2_S = $FORM{'LON2_S'};

my $tx_cab_other = $FORM{'tx_cab_other'};
my $rx_cab_other = $FORM{'rx_cab_other'};
my $rh = $FORM{'rh'};
my $baro = $FORM{'baro'};
my $rate = $FORM{'rate'};
my $envy = $FORM{'envy'};

my $EE1 = $FORM{'EE1'}; # 1
my $EE2 = $FORM{'EE2'};
my $EE3 = $FORM{'EE3'};

my $FF1 = $FORM{'FF1'}; # 2
my $FF2 = $FORM{'FF2'};
my $FF3 = $FORM{'FF3'};

my $GG1 = $FORM{'GG1'}; # 3
my $GG2 = $FORM{'GG2'};
my $GG3 = $FORM{'GG3'};

my $HH1 = $FORM{'HH1'}; # 4
my $HH2 = $FORM{'HH2'};
my $HH3 = $FORM{'HH3'};

my $II1 = $FORM{'II1'}; # 5
my $II2 = $FORM{'II2'};
my $II3 = $FORM{'II3'};

my $JJ1 = $FORM{'JJ1'}; # 6
my $JJ2 = $FORM{'JJ2'};
my $JJ3 = $FORM{'JJ3'};

my $KK1 = $FORM{'KK1'}; # 7
my $KK2 = $FORM{'KK2'};
my $KK3 = $FORM{'KK3'};

my $LL1 = $FORM{'LL1'}; # 8
my $LL2 = $FORM{'LL2'};
my $LL3 = $FORM{'LL3'};

my $MM1 = $FORM{'MM1'}; # 9
my $MM2 = $FORM{'MM2'};
my $MM3 = $FORM{'MM3'};

my $NN1 = $FORM{'NN1'}; # 10
my $NN2 = $FORM{'NN2'};
my $NN3 = $FORM{'NN3'};

my $skip = $FORM{'skip'};

## Frequency
#
$frq =~ tr/0-9.//csd;

if ($frq_val eq "GHz") {
  $frq_mhz = $frq * 1000; # convert to MHz
  $frq_ghz = $frq;
}
else {
  $frq_mhz = $frq;
  $frq_ghz = $frq / 1000;
}

if (!$frq_mhz || !$frq_ghz || $frq_mhz < 100) {
  print "<html><b>You need a enter a frequency above 100 MHz.</b></html>";
  exit;
}

## Transmitter
#
$tx_name =~ tr/A-Za-z0-9\.\-\ //csd;
$tx_len =~ tr/0-9.//csd;
$tx_ant_gain =~ tr/0-9.//csd;
$tx_radome =~ tr/0-9.//csd;
$tx_ant_ht =~ tr/0-9.//csd;
$tx_elv =~ tr/0-9.-//csd;
$con_tx =~ tr/0-9//csd;
$tx_misc_loss =~ tr/0-9.//csd;
$tx_misc_cab_loss =~ tr/0-9.//csd;
$tx_cab_other =~ tr/0-9.//csd;
$tx_misc_gain =~ tr/0-9.//csd;

if (!$tx_len) {
  print "<html><b>You need to enter the transmitter's total cable length.</b></html>";
  exit;
}

if (!$tx_ant_ht) {
  print "<html><b>You need to enter the transmitter's antenna height.</b></html>";
  exit;
}

if (!$tx_elv) {
  print "<html><b>You need to enter the transmitter's site elevation above sea level.</b></html>";
  exit;
}

## Receiver
#
$rx_name =~ tr/A-Za-z0-9\.\-\ //csd;
$rx_len =~ tr/0-9.//csd;
$rx_ant_gain =~ tr/0-9.//csd;
$rx_radome =~ tr/0-9.//csd;
$rx_ant_ht =~ tr/0-9.//csd;
$rx_elv =~ tr/0-9.-//csd;
$con_rx =~ tr/0-9//csd;
$rx_misc_cab_loss =~ tr/0-9.//csd;
$rx_cab_other =~ tr/0-9.//csd;
$rx_misc_gain =~ tr/0-9.//csd;
$rx_div_ant_ht =~ tr/0-9.//csd;
$rx_div_ant_gain =~ tr/0-9.//csd;
$rx_div_len =~ tr/0-9.//csd;
$rx_div_misc_cab_loss =~ tr/0-9.//csd;

if (!$rx_len) {
  print "<html><b>You need to enter the receiver's total cable length.</b></html>";
  exit 1;
}

if (!$rx_ant_ht) {
  print "<html><b>You need to enter the receiver's antenna height.</b></html>";
  exit 1;
}

if (!$rx_elv) {
  print "<html><b>You need to enter the receiver's site elevation above sea level.</b></html>";
  exit 1;
} 

## Distance
#
$dist =~ tr/0-9.//csd;

if ($chia eq "no") {
  if (!$dist) {
    print "<html><b>You need to enter the distance between the transmitter and receiver.</b></html>";
    exit 1;
  }
}

## Average Annual Temperature
#
$temp =~ tr/0-9.-//csd;

## F to Umm C & K
#
if ($temp_val eq "fahrenheit") {
  $temp_c = sprintf "%.2f", (5 / 9) * ($temp - 32);
  $temp_f = sprintf "%.2f", $temp;
  $temp_k = sprintf "%.2f", 273.15 + $temp_c;
}  
else { 
  $temp_c = sprintf "%.2f", $temp;
  $temp_f = sprintf "%.2f", ((9 / 5) * $temp) + 32;
  $temp_k = sprintf "%.2f", 273.15 + $temp_c; 
} 

## Climate & Terrain Factors
#
$rough =~ tr/0-9.-//csd;

if ($rough_val eq "meters") {
  $rough_m = sprintf "%.2f", $rough;
  $rough_ft = sprintf "%.2f", $rough / 0.3048;
} 
else {
  $rough_m = sprintf "%.2f", $rough * 0.3048;
  $rough_ft = sprintf "%.2f", $rough; 
} 

if ($chia4 eq "yes") {
  if ($rough_hum eq "Coastal, very humid areas") {
    $c = 2;
  } 
  elsif ($rough_hum eq "Non-coastal, humid areas") {
    $c = 1.4;
  } 
  elsif ($rough_hum eq "Average or temperate areas") {
    $c = 1;
  } 
  elsif ($rough_hum eq "Dry areas") {
    $c = 0.5;
  } 
  $cli = sprintf "%.2f", $c * (($rough_ft / 50) ** -1.3);
  $climate = "Calculated";
}
else {
  if ($climate eq "6 : Very smooth terrain, over water or flat desert, coastal") {
    $cli = sprintf "%.2f", 6;
    ($null, $climate) = split ':', $climate;
    $climate = substr ($climate, 1, ((length $climate) - 1));
  }
  elsif ($climate eq "4 : Very smooth terrain, over water or flat desert, non-coastal") {
    $cli = sprintf "%.2f", 4;
   ($null, $climate) = split ':', $climate;
   $climate = substr ($climate, 1, ((length $climate) - 1));
  }
  elsif ($climate eq "2 : Great lakes area") {
    $cli = sprintf "%.2f", 2;
   ($null, $climate) = split ':', $climate;
   $climate = substr ($climate, 1, ((length $climate) - 1));
  }
  elsif ($climate eq "1 : Average terrain, with some roughness") {
    $cli = sprintf "%.2f", 1;
    ($null, $climate) = split ':', $climate;
    $climate = substr ($climate, 1, ((length $climate) - 1));
  }
  elsif ($climate eq "0.5 : Dry desert climate") {
    $cli = sprintf "%.2f", 0.50;
    ($null, $climate) = split ':', $climate;
    $climate = substr ($climate, 1, ((length $climate) - 1));
  }
  elsif ($climate eq "0.25 : Mountainous, very rough, very dry but non-reflective") {
    $cli = sprintf "%.2f", 0.25;
    ($null, $climate) = split ':', $climate;
    $climate = substr ($climate, 1, ((length $climate) - 1));
  }
}

## Humidity & Pressure
#
$rh =~ tr/0-9.//csd;
$baro =~ tr/0-9.//csd;

if (!$rh) {
  $rh = 50; # 50% relative humidity
} 

if (!$baro) {
  $baro = 30; # 30 inches of mercury
}

## Coordinates
#
$LAT1_D =~ tr/0-9.-//csd;
$LAT1_M =~ tr/0-9.//csd;
$LAT1_S =~ tr/0-9.//csd;

$LON1_D =~ tr/0-9.-//csd;
$LON1_M =~ tr/0-9.//csd;
$LON1_S =~ tr/0-9.//csd;

$LAT2_D =~ tr/0-9.-//csd;
$LAT2_M =~ tr/0-9.//csd;
$LAT2_S =~ tr/0-9.//csd;

$LON2_D =~ tr/0-9.-//csd;
$LON2_M =~ tr/0-9.//csd;
$LON2_S =~ tr/0-9.//csd;

if ($LAT1_D > 90) {
  print "<b>BAD COORDINATES! - $LAT1_D &gt; 90</b>\n";
  exit 1;
}
if ($LAT1_M > 60) {
  print "<b>BAD COORDINATES! - $LAT1_M &gt; 60</b>\n";
  exit 1;
}
if ($LAT1_S > 60) {
  print "<b>BAD COORDINATES! - $LAT1_S &gt; 60</b>\n"; 
  exit 1;
}

if ($LON1_D > 180) {
  print "<b>BAD COORDINATES! - $LON1_D &gt; 180</b>\n";
  exit 1;
}
if ($LON1_M > 60) {
  print "<b>BAD COORDINATES! - $LON1_M &gt; 60</b>\n"; 
  exit 1;
}
if ($LON1_S > 60) {
  print "<b>BAD COORDINATES! - $LON1_S &gt; 60</b>\n"; 
  exit 1;
}

if ($LAT2_D > 90) {
  print "<b>BAD COORDINATES! - $LAT2_D &gt; 90</b>\n";
  exit 1;
}
if ($LAT2_M > 60) {
  print "<b>BAD COORDINATES! - $LAT2_M &gt; 60</b>\n";
  exit 1;
}
if ($LAT2_S > 60) {
  print "<b>BAD COORDINATES! - $LAT2_S &gt; 60</b>\n";
  exit 1;
}

if ($LON2_D > 180) {
  print "<b>BAD COORDINATES! - $LON2_D &gt; 180</b>\n";
  exit 1;
}
if ($LON2_M > 60) {
  print "<b>BAD COORDINATES! - $LON2_M &gt; 60</b>\n";    
  exit 1;
}
if ($LON2_S > 60) {
  print "<b>BAD COORDINATES! - $LON2_S &gt; 60</b>\n"; 
  exit 1;
}

if ($LAT1_D < 0) {
  $y1 = sprintf "%.6f", ($LAT1_D * -1) + ($LAT1_M / 60) + ($LAT1_S / 3600);
  $y1label = $y1 * -1;
}
else {
  $y1 = sprintf "%.6f", $LAT1_D + ($LAT1_M / 60) + ($LAT1_S / 3600);
  $y1label = $y1;
}
if ($LON1_D < 0) {
  $x1 = sprintf "%.6f", ($LON1_D * -1) + ($LON1_M / 60) + ($LON1_S / 3600);
  $x1label = $x1 * -1;
}
else {
  $x1 = sprintf "%.6f", $LON1_D + ($LON1_M / 60) + ($LON1_S / 3600);
  $x1label = $x1;
}
if ($LAT2_D < 0) {
  $y2 = sprintf "%.6f", ($LAT2_D * -1) + ($LAT2_M / 60) + ($LAT2_S / 3600);
  $y2label = $y2 * -1;
}
else {
  $y2 = sprintf "%.6f", $LAT2_D + ($LAT2_M / 60) + ($LAT2_S / 3600);
  $y2label = $y2;
}
if ($LON2_D < 0) {
  $x2 = sprintf "%.6f", ($LON2_D * -1) + ($LON2_M / 60) + ($LON2_S / 3600);
  $x2label = $x2 * -1;
}
else {
  $x2 = sprintf "%.6f", $LON2_D + ($LON2_M / 60) + ($LON2_S / 3600);
  $x2label = $x2;
}

$LAT1_D = sprintf "%02.0f", $LAT1_D;
$LAT1_M = sprintf "%02.0f", $LAT1_M;
$LAT1_S = sprintf "%02.2f", $LAT1_S;
$LON1_D = sprintf "%03.0f", $LON1_D;
$LON1_M = sprintf "%02.0f", $LON1_M;
$LON1_S = sprintf "%02.2f", $LON1_S;

$LAT2_D = sprintf "%02.0f", $LAT2_D;
$LAT2_M = sprintf "%02.0f", $LAT2_M;
$LAT2_S = sprintf "%02.2f", $LAT2_S;
$LON2_D = sprintf "%03.0f", $LON2_D;
$LON2_M = sprintf "%02.0f", $LON2_M;
$LON2_S = sprintf "%02.2f", $LON2_S;

## Transmitter RF Output Power
#
$pwr_out =~ tr/0-9\.\-//csd;

if ($pwr_out_val eq "milliWatts") {
  if ($pwr_out == 0) {
    print "<b>Bad Power Output - $pwr_out milliWatts</b>\n";
    exit 1;
  }
  else {
    $pwr_out = 10 * log10($pwr_out); # mW to dBm
  }
}
elsif ($pwr_out_val eq "Watts") {
  if ($pwr_out == 0) {
    print "<b>Bad Power Output - $pwr_out Watts</b>\n";
    exit 1;
  }
  else {
    $pwr_out = 10 * log10($pwr_out) + 30; # W to dBm
  }
}
elsif ($pwr_out_val eq "kiloWatts") {
  if ($pwr_out == 0) {
    print "<b>Bad Power Output - $pwr_out kiloWatts</b>\n";
    exit 1;
  }
  else {
    $pwr_out = 10 * log10($pwr_out) + 60; # kW to dBm
  }
}
elsif ($pwr_out_val eq "dBW") {
  $pwr_out = 10 * log10((10 ** (($pwr_out + 30) / 10))); # dBW to dBm
}
elsif ($pwr_out_val eq "dBk") {
  $pwr_out = 10 * log10((10 ** (($pwr_out + 60) / 10))); # dBk to dBm
} 

$pwr_out = sprintf "%.3f", $pwr_out;
$pwr_out_mw = sprintf "%.3f", 10 ** ($pwr_out / 10);
$pwr_out_w = sprintf "%.3f", 10 ** (($pwr_out - 30) / 10);
$pwr_out_kw = sprintf "%.5f", (10 ** (($pwr_out - 30) / 10)) / 1000;
$pwr_out_dbw = sprintf "%.3f", 10 * log10((10 ** (($pwr_out - 30) / 10)));
$pwr_out_dbk = sprintf "%.3f", (10 * log10((10 ** (($pwr_out - 30) / 10)))) - 30;

## Cable Loss per Meter
#
sub Cable {
  undef $loss_per_foot; undef $loss_per_meter;
  if ($val eq "Times Microwave LMR-400") {
    $loss_per_foot = ((0.12229 * sqrt $frq_mhz) + (0.00026 * $frq_mhz)) / 100;
    $loss_per_meter = $loss_per_foot * 3.2808399;
  }
  elsif ($val eq "Times Microwave LMR-400 UltraFlex") {
    $loss_per_foot = ((0.12229 * sqrt $frq_mhz) + (0.00026 * $frq_mhz)) / 100;
    $loss_per_foot = $loss_per_foot + ($loss_per_foot * 0.15);
    $loss_per_meter = $loss_per_foot * 3.2808399;
  }
  elsif ($val eq "Times Microwave LMR-500") {
    $loss_per_foot = ((0.09659 * sqrt $frq_mhz) + (0.00026 * $frq_mhz)) / 100;
    $loss_per_meter = $loss_per_foot * 3.2808399;
  }
  elsif ($val eq "Times Microwave LMR-600") {
    $loss_per_foot = ((0.0755 * sqrt $frq_mhz) + (0.00026 * $frq_mhz)) / 100;
    $loss_per_meter = $loss_per_foot * 3.2808399;
  }
  elsif ($val eq "Times Microwave LMR-900") {
    $loss_per_foot = ((0.05177 * sqrt $frq_mhz) + (0.00016 * $frq_mhz)) / 100;
    $loss_per_meter = $loss_per_foot * 3.2808399;
  } 
  elsif ($val eq "Times Microwave LMR-1200") {
    $loss_per_foot = ((0.03737 * sqrt $frq_mhz) + (0.00016 * $frq_mhz)) / 100;
    $loss_per_meter = $loss_per_foot * 3.2808399;
  }         
  elsif ($val eq "Times Microwave LMR-1700") {
    $loss_per_foot = ((0.02646 * sqrt $frq_mhz) + (0.00016 * $frq_mhz)) / 100;
    $loss_per_meter = $loss_per_foot * 3.2808399;
  }         
  elsif ($val eq "Andrew Heliax LDF4-50A") {
    $loss_per_foot = ((0.06432 * sqrt $frq_mhz) + (0.00019 * $frq_mhz)) / 100;
    $loss_per_meter = $loss_per_foot * 3.2808399;
  } 
  elsif ($val eq "Andrew Heliax LDF5-50A") {
    $loss_per_foot = ((0.03482 * sqrt $frq_mhz) + (0.00015 * $frq_mhz)) / 100;
    $loss_per_meter = $loss_per_foot * 3.2808399;
  }        
  elsif ($val eq "Andrew Heliax LDF6-50A") {
    $loss_per_foot = ((0.02397 * sqrt $frq_mhz) + (0.00014 * $frq_mhz)) / 100;
    $loss_per_meter = $loss_per_foot * 3.2808399;
  }        
  elsif ($val eq "Andrew Heliax LDF7-50A") {
    $loss_per_foot = ((0.01901 * sqrt $frq_mhz) + (0.00014 * $frq_mhz)) / 100;
    $loss_per_meter = $loss_per_foot * 3.2808399;
  }        
  elsif ($val eq "Belden 9913 (RG-8)") {
    $loss_per_foot = ((0.12050 * sqrt $frq_mhz) + (0.00066 * $frq_mhz)) / 100;
    $loss_per_meter = $loss_per_foot * 3.2808399;
  }
  elsif ($val eq "Belden 8267 (RG-213)") {
    $loss_per_foot = ((0.18993 * sqrt $frq_mhz) + (0.00216 * $frq_mhz)) / 100;
    $loss_per_meter = $loss_per_foot * 3.2808399;
  }
  elsif ($val eq "Belden 9258 (RG-8X)") {
    $loss_per_foot = ((0.26904 * sqrt $frq_mhz) + (0.00572 * $frq_mhz)) / 100;
    $loss_per_meter = $loss_per_foot * 3.2808399;
  } 
  elsif ($val eq "Belden 8240 (RG-58)") {
    $loss_per_foot = ((0.34190 * sqrt $frq_mhz) + (0.00377 * $frq_mhz)) / 100;
    $loss_per_meter = $loss_per_foot * 3.2808399;
  } 
  elsif ($val eq "Crap RG-8") {
    $loss_per_foot = ((0.21 * sqrt $frq_mhz) + (0.00026 * $frq_mhz)) / 100;
    $loss_per_meter = $loss_per_foot * 3.2808399;
  }
  elsif ($val eq "Other") {
    if ($val2 == 0) {
      $val2 = 7; $val1 = "feet";
    }
    if ($val1 eq "meters") {
      $loss_per_meter = $val2 / 100;
      $loss_per_foot = $loss_per_meter / 3.2808399;
    }  
    elsif ($val1 eq "feet") {
      $loss_per_foot =  $val2 / 100;
      $loss_per_meter = $loss_per_foot * 3.2808399;
    }
  }
}

## Transmitter Transmission Line
#
&Cable($val = $tx_cab, $val1 = $chia1, $val2 = $tx_cab_other);

if ($tx_len_val eq "meters") {
  $tx_cab_loss = $tx_len * $loss_per_meter;
  $tx_length = $tx_len;
  $tx_loss_per_meter = $loss_per_meter;
  $tx_loss_per_foot = $loss_per_foot;
  $tx_loss_per_100m = $loss_per_meter * 100;
  $tx_loss_per_100f = $loss_per_foot * 100;
}
else {
  $tx_cab_loss = $tx_len * $loss_per_foot;
  $tx_length = $tx_len * 0.3048; # ft to m
  $tx_loss_per_meter = $loss_per_meter;
  $tx_loss_per_foot = $loss_per_foot;
  $tx_loss_per_100m = $loss_per_meter * 100;
  $tx_loss_per_100f = $loss_per_foot * 100;
}

## Transmitter Transmission Line Efficiency
#
$tx_eff = sprintf "%.2f", 100 / (10 ** ($tx_cab_loss / 10)); # percent

if ($tx_eff < 50) {
  $tx_eff_message = "unacceptable line loss";
}
else {
  $tx_eff_message = "acceptable line loss";
}

## Transmitter Connector and/or Adapter Loss
#
$tx_con_loss = $con_tx * 0.025 * $frq_ghz;

## Total Transmitter Transmission Line Loss
#
$tx_total_cable_loss = $tx_cab_loss + $tx_con_loss + $tx_misc_cab_loss;

## Receiver Transmission Line
#
&Cable($val = $rx_cab, $val1 = $chia2, $val2 = $rx_cab_other);

if ($rx_len_val eq "meters") {
  $rx_cab_loss = $rx_len * $loss_per_meter;
  $rx_length = $rx_len;
  $rx_loss_per_meter = $loss_per_meter;
  $rx_loss_per_foot = $loss_per_foot;
  $rx_loss_per_100m = $loss_per_meter * 100;
  $rx_loss_per_100f = $loss_per_foot * 100;
}
else {
  $rx_cab_loss = $rx_len * $loss_per_foot;
  $rx_length = $rx_len * 0.3048; # ft to m
  $rx_loss_per_meter = $loss_per_meter;
  $rx_loss_per_foot = $loss_per_foot;
  $rx_loss_per_100m = $loss_per_meter * 100;
  $rx_loss_per_100f = $loss_per_foot * 100;
}

## Diversity Antenna Transmission Line Loss
#
if ($rx_div_ant_ht) {
  if ($rx_div_len_val eq "feet") {
    $rx_div_loss = sprintf "%.2f", ($rx_div_len * $rx_loss_per_foot) + $rx_div_misc_cab_loss;
  }
  elsif ($rx_div_len_val eq "meters") {
    $rx_div_loss = sprintf "%.2f", ($rx_div_len * $rx_loss_per_meter) + $rx_div_misc_cab_loss;
  }
}
else {
  $rx_div_loss = sprintf "%.2f", 0;
}

$rx_div_misc_cab_loss = sprintf "%.2f", $rx_div_misc_cab_loss;

## Receiver Transmission Line Efficiency
#
$rx_eff = sprintf "%.2f", 100 / (10 ** ($rx_cab_loss / 10)); # percent

if ($rx_eff < 50) {
  $rx_eff_message = "unacceptable line loss";
} 
else {
  $rx_eff_message = "acceptable line loss";
}

## Receiver Connector and/or Adapter Loss
#
$rx_con_loss = $con_rx * 0.025 * $frq_ghz;

## Total Receiver Transmission Line Loss
#
$rx_total_cable_loss = $rx_cab_loss + $rx_con_loss + $rx_misc_cab_loss;

## Antenna Gain
#
if ($tx_ant_val eq "dBd") {
  $tx_ant_gain = $tx_ant_gain + 2.15; # dBi
}

if ($rx_ant_val eq "dBd") {
  $rx_ant_gain = $rx_ant_gain + 2.15;
}

if ($rx_div_ant_val eq "dBd") {
  $rx_div_ant_gain = $rx_div_ant_gain + 2.15;
} 

$div_ant_dbi = sprintf "%.2f", $rx_div_ant_gain;
$div_ant_dbd = sprintf "%.2f", $rx_div_ant_gain - 2.15;

## 3 dB Beamwidth
#
$tx_ant_bw = sprintf "%.2f", 164 * sqrt(1 / (10 ** ($tx_ant_gain / 10)));
$rx_ant_bw = sprintf "%.2f", 164 * sqrt(1 / (10 ** ($rx_ant_gain / 10)));

## Site Elevation AMSL
#
if ($tx_elv_val eq "meters") {
  $tx_elv_m = sprintf "%.2f", $tx_elv;
  $tx_elv_ft = sprintf "%.2f", $tx_elv / 0.3048;
}
else {
  $tx_elv_m = sprintf "%.2f", $tx_elv * 0.3048;
  $tx_elv_ft = sprintf "%.2f", $tx_elv;
}

if ($rx_elv_val eq "meters") {
  $rx_elv_m = sprintf "%.2f", $rx_elv;
  $rx_elv_ft = sprintf "%.2f", $rx_elv / 0.3048;
} 
else {
  $rx_elv_m = sprintf "%.2f", $rx_elv * 0.3048;
  $rx_elv_ft = sprintf "%.2f", $rx_elv;
} 

## K Factor
#
if ($chia3 eq "yes") {
  # Atmospheric pressure from inches of mercury to millibars with sea level 
  # correction.
  $elv_ft = (sqrt($tx_elv_m * $tx_elv_m)) * 3.2808399; # m to ft
  $atmos_p = sprintf "%.2f", (33.86 * $baro) - ($elv_ft * 0.025);

  # Saturation vapor pressure, millibars
  $es = sprintf "%.2f", exp(1.805 + (0.0738 * $temp_c) - (0.000298 * ($temp_c ** 2)));

  # Partial vapor pressure, millibars
  $vapor_p = sprintf "%.2f", ($rh / 100) * $es;

  # Index of refraction
  $N = sprintf "%.2f", ((77.6 * $atmos_p) / $temp_k) + ((373000 * $vapor_p) / $temp_k ** 2);

  # Effective Earth radius, K factor
  $k = 1 / (1 - 0.04665 * exp(0.005577 * $N));
  $k_str = sprintf "%.2f", $k;

  if (!$k || $k > 10) {
    $k = "1.33";
    $k_str = "1.33";
  }
}
else {
  if ($k eq "5/12") {
    $k = 5 / 12;
    $k_str = "5/12";
  }
  elsif ($k eq "1/2") {
    $k = 1 / 2;
    $k_str = "1/2";
  }
  elsif ($k eq "2/3") {
    $k = 2 / 3;
    $k_str = "2/3";
  }
  elsif ($k eq "1.0") {
    $k = 1.0;
    $k_str = "1.0";
  }
  elsif ($k eq "7/6") {
    $k = 7 / 6;
    $k_str = "7/6";
  }
  elsif ($k eq "4/3") {
    $k = 4 / 3;
    $k_str = "4/3";
  }
  elsif ($k eq "5/3") {
    $k = 5 / 3;
    $k_str = "5/3";
  }
  elsif ($k eq "2.0") {
    $k = 2.0;
    $k_str = "2.0";
  }
  elsif ($k eq "4.0") {
    $k = 4.0;
    $k_str = "4.0";
  }
  elsif ($k eq "Infinity") {
    $k = "Infinity";
    $k_str = "Infinity";
  }
  $N = $vapor_p = $es = $atmos_p = $elv_ft = "Not Applicable";
}

## Radio Horizon
#
if ($tx_ant_ht_val eq "feet") {
  $tx_ant_ht_m = sprintf "%.2f", $tx_ant_ht * 0.3048; # feet to meters
  $tx_ant_ht_ft = sprintf "%.2f", $tx_ant_ht;
}
else {
  $tx_ant_ht_m = sprintf "%.2f", $tx_ant_ht;
  $tx_ant_ht_ft = sprintf "%.2f", $tx_ant_ht / 0.3048;
}

if ($rx_ant_ht_val eq "feet") {
  $rx_ant_ht_m = sprintf "%.2f", $rx_ant_ht * 0.3048; # feet to meters
  $rx_ant_ht_ft = sprintf "%.2f", $rx_ant_ht;
}
else {
  $rx_ant_ht_m = sprintf "%.2f", $rx_ant_ht;
  $rx_ant_ht_ft = sprintf "%.2f", $rx_ant_ht / 0.3048;
}

if ($k eq "Infinity") {
  $tx_rad_hor = sprintf "%.2f", sqrt (12.75 * $tx_ant_ht_m); # distance (km) to radio horizon
  $rx_rad_hor = sprintf "%.2f", sqrt (12.75 * $rx_ant_ht_m); # distance (km) to radio horizon
  $tx_rad_hor_mi = sprintf "%.2f", $tx_rad_hor * 0.62137119; # distance (mi) to radio horizon
  $rx_rad_hor_mi = sprintf "%.2f", $rx_rad_hor * 0.62137119; # distance (mi) to radio horizon
}
else {
  $tx_rad_hor = sprintf "%.2f", sqrt (12.75 * $tx_ant_ht_m * $k); # distance (km) to radio horizon
  $rx_rad_hor = sprintf "%.2f", sqrt (12.75 * $rx_ant_ht_m * $k); # distance (km) to radio horizon
  $tx_rad_hor_mi = sprintf "%.2f", $tx_rad_hor * 0.62137119; # distance (mi) to radio horizon
  $rx_rad_hor_mi = sprintf "%.2f", $rx_rad_hor * 0.62137119; # distance (mi) to radio horizon
}

$tx_ant_ht_ov_ft = sprintf "%.2f", $tx_ant_ht_ft + $tx_elv_ft;
$tx_ant_ht_ov_m = sprintf "%.2f", $tx_ant_ht_m + $tx_elv_m;
$rx_ant_ht_ov_ft = sprintf "%.2f", $rx_ant_ht_ft + $rx_elv_ft;
$rx_ant_ht_ov_m = sprintf "%.2f", $rx_ant_ht_m + $rx_elv_m;

## Maximum Communication Distance
#
$distance_max = sprintf "%.2f", $tx_rad_hor + $rx_rad_hor;
$distance_max_mi = sprintf "%.2f", ($tx_rad_hor + $rx_rad_hor) * 0.62137119;

## Coordinates to Distance
#
if ($chia eq "yes") {
  $YM = ($y1 + $y2) / 2;
  $H = (($x1 - $x2)) * (68.962 + 0.04525 * ($YM) - 0.01274 * ($YM ** 2) + 0.00004117 * ($YM ** 3));
  $V = (($y1 - $y2)) * (68.712 - 0.001184 * ($YM) + 0.0002928 * ($YM ** 2) - 0.000002162 * ($YM ** 3));
  $dist_mi = sprintf "%.2f", sqrt(($H ** 2) + ($V ** 2));
  $dist_km = sprintf "%.2f", $dist_mi * 1.609344;
}
else { 
  if ($dist_val eq "miles") {
    $dist_mi = sprintf "%.2f", $dist;
    $dist_km = sprintf "%.2f", $dist * 1.609344;
  }
  else {
    $dist_km = sprintf "%.2f", $dist;
    $dist_mi = sprintf "%.2f", $dist / 1.609344;
  }
  $x1 = $x2 = $y1 = $y2 = "Not Applicable";
}

## Divide by Zero Catches
#
if ($dist_mi == 0) {
  $dist_mi = sprintf "%.2f", 0.01;
  $dist_km = sprintf "%.2f", $dist_mi * 1.609344;
}

if ($dist_km == 0) {
  $dist_km = sprintf "%.2f", 0.01;
  $dist_mi = sprintf "%.2f", $dist_km / 1.609344;
}

## Azmiuth
#
if ($chia eq "yes") {

  if ($LAT1_D < 0) {
    $lat1_az = deg2rad $y1 * -1;
  }
  else {
    $lat1_az = deg2rad $y1;
  }

  if ($LON1_D < 0) {
    $lon1_az = deg2rad $x1 * -1;
  }
  else {
    $lon1_az = deg2rad $x1;
  }

  if ($LAT2_D < 0) {
    $lat2_az = deg2rad $y2 * -1; 
  }
  else {
    $lat2_az = deg2rad $y2;
  }

  if ($LON2_D < 0) {
    $lon2_az = deg2rad $x2 * -1;
  }
  else {
    $lon2_az = deg2rad $x2;
  }

  $cosd = sin($lat2_az) * sin($lat1_az) + cos($lat1_az) * cos($lat2_az) * cos($lon1_az - $lon2_az);
  $daz = rad2deg (acos $cosd);
  $cosb = (sin($lat2_az) - sin($lat1_az) * cos (deg2rad($daz))) / (cos($lat1_az) * sin (deg2rad($daz)));

  if ($cosb > 0.999999) {
    $AZ = 0;
  } 
  elsif ($cosb < -0.999999) {
    $AZ = 180; 
  } 
  else {
    $AZ = rad2deg (acos $cosb);
  } 
            
  if (sin ($lon2_az - $lon1_az) >= 0) {
    $AZSP = $AZ;
    $AZLP = 180 + $AZ;
  }  
  else {
    $AZSP = 360 - $AZ;
    $AZLP = 180 - $AZ;
  } 

  $AZSP = sprintf "%.2f", $AZSP;
  $AZLP = sprintf "%.2f", $AZLP;
}
else {
  $AZSP = $AZLP = "Not Applicable";
}

## Wavelength
#
$wav = (2.99792458E+12 / $frq_mhz) / 1E+10; # wavelength in meters
$wav_in = sprintf "%.4f", ($wav * 100) / 2.54; # inches
$wav_ft = sprintf "%.4f", $wav / 0.3048; # feet
$wav_cm = sprintf "%.4f", $wav * 100; # centimeters
$wav_m = sprintf "%.4f", $wav; # meters

## Atmospheric Attenuation (oxygen loss)
#
$oxy_att_km = sprintf "%.3f", ((6.6 / (($frq_ghz ** 2) + 0.33)) + (9 / ((($frq_ghz - 57) ** 2) + 1.96))) * ($frq_ghz ** 2) * (10 ** -3);
$oxy_att_mi = sprintf "%.3f", $oxy_att_km / 1.609344;
$oxy_att_total = sprintf "%.3f", $oxy_att_km * $dist_km;

## Water Vapor Attenuation
#
$wvd = 7.5; # water vapor density, gm/m3
$water_att_km = sprintf "%.3f", (0.067 + 2.4 / ((($frq_ghz - 22.3) ** 2) + 6.6)) * (($frq_ghz ** 2) * $wvd * (10 ** -4));
$water_att_mi = sprintf "%.3f", $water_att_km / 1.609344;
$water_att_total = sprintf "%.3f", $water_att_km * $dist_km;

## Rain Attenuation
#
if (!$rate) {
  $rain_att_km = sprintf "%.3f", 0;
  $rain_att_mi = sprintf "%.3f", 0;
  $rain_att_total = sprintf "%.3f", 0;
  $rate = sprintf "%.1f", 0;
}
else {
  $rate =~ tr/0-9.//csd;
  $rate = sprintf "%.1f", $rate;

  # Ryde & Ryde
  #
  if ($frq_ghz >= 2) {
    if ($frq_ghz >= 2 && $frq_ghz <= 54) {
      $af = 4.21 * (10 ** -5) * ($frq_ghz ** 2.42);
    }
    elsif ($frq_ghz >= 54 && $frq_ghz <= 180) {
      $af = 4.09 * (10 ** -2) * ($frq_ghz ** 0.699);
    } 
    if ($frq_ghz >= 2 && $frq_ghz <= 25) {
      $bf = 1.41 * ($frq_ghz ** -0.0779);
    }
    elsif ($frq_ghz >= 25 && $frq_ghz <= 180) {
      $bf = 2.63 * ($frq_ghz ** -0.272);
    } 
    $rain_att_km = sprintf "%.3f", $af * ($rate ** $bf); # dB/km
    $rain_att_mi = sprintf "%.3f", $rain_att_km / 1.609344;
    $rain_att_total = sprintf "%.3f", $rain_att_km * ($dist_km / (1 + (0.045 * $dist_km)));
  } 
  else {
    $rain_att_km = sprintf "%.3f", 0;
    $rain_att_mi = sprintf "%.3f", 0;
    $rain_att_total = sprintf "%.3f", 0;
  } 
}

## Free Space Path Loss
#
$fs = sprintf "%.2f", (20 * (log10 $frq_mhz)) + (20 * (log10 $dist_km)) + 32.447782;

## Urban Area Path Loss
#
if ($frq_mhz <= 1000) {
  if ($envy eq "Urban Indoor - Large City") {
    $K = 0;
    if ($frq_mhz <= 200) {
      $ah2 = 8.29 * log10(1.54 * $rx_ant_ht_m) ** 2 - 1.1 - 15.0;
    } 
    if ($frq_mhz >= 200.1) {
      $ah2 = 3.2 * log10(11.75 * $rx_ant_ht_m) ** 2 - 4.97 - 15.0;
    } 
  } 
  elsif ($envy eq "Urban - Large City") {
    $K = 0;
    if ($frq_mhz <= 200) {
      $ah2 = 8.29 * log10(1.54 * $rx_ant_ht_m) ** 2 - 1.1;
    } 
    if ($frq_mhz >= 200.1) {
      $ah2 = 3.2 * log10(11.75 * $rx_ant_ht_m) ** 2 - 4.97;
    } 
  } 
  elsif ($envy eq "Urban - Small City") {
    $K = 0;
    $ah2 = (((1.1 * log10($frq_mhz)) - 0.7) * $rx_ant_ht_m) - ((1.56 * log10($frq_mhz)) - 0.8);
  } 
  elsif ($envy eq "Suburban") {
    $K = (((log10($frq_mhz / 28)) ** 2) * 2) + 5.4;
    $ah2 = 0;
  } 
  elsif ($envy eq "Rural Indoor - Quasi Open") {
    $K = (4.78 * (log10($frq_mhz) ** 2)) - (18.33 * (log10($frq_mhz))) + 35.94 - 10;
    $ah2 = 0;
  } 
  elsif ($envy eq "Rural Country Side - Quasi Open") {
    $K = (4.78 * (log10($frq_mhz) ** 2)) - (18.33 * (log10($frq_mhz))) + 35.94;
    $ah2 = 0;
  } 
  elsif ($envy eq "Rural Desert - Open") {
    $K = (4.78 * (log10($frq_mhz) ** 2)) - (18.33 * (log10($frq_mhz))) + 40.94;
    $ah2 = 0;
  } 

  $ur = 69.55 + (26.16 * log10($frq_mhz)) - (13.82 * log10($tx_ant_ht_m)) - $ah2 + ((44.9 - (6.55 * log10($tx_ant_ht_m))) * log10($dist_km)) - $K; 
  $urban = sprintf "%.2f", $ur;
} 
else {
  if ($envy eq "Urban Indoor - Large City") {
    $K = -3;
    $ah2 = (((1.1 * log10($frq_mhz)) - 0.7) * $rx_ant_ht_m) - ((1.56 * log10($frq_mhz)) - 0.8) - 15;
  } 
  elsif ($envy eq "Urban - Large City") {
    $K = -3;
    $ah2 = (((1.1 * log10($frq_mhz)) - 0.7) * $rx_ant_ht_m) - ((1.56 * log10($frq_mhz)) - 0.8);
  }
  elsif ($envy eq "Urban - Small City") {
    $K = 0;
    $ah2 = (((1.1 * log10($frq_mhz)) - 0.7) * $rx_ant_ht_m) - ((1.56 * log10($frq_mhz)) - 0.8);
  }
  elsif ($envy eq "Suburban") {
    $K = 0;
    $ah2 = (((1.1 * log10($frq_mhz)) - 0.7) * $rx_ant_ht_m) - ((1.56 * log10($frq_mhz)) - 0.8);
  }
  elsif ($envy eq "Rural Indoor - Quasi Open") {
    $K = (4.78 * (log10($frq_mhz) ** 2)) - (18.33 * (log10($frq_mhz))) + 35.94 - 10;
    $ah2 = 0;
  }
  elsif ($envy eq "Rural Country Side - Quasi Open") {
    $K = (4.78 * (log10($frq_mhz) ** 2)) - (18.33 * (log10($frq_mhz))) + 35.94;
    $ah2 = 0;
  }
  elsif ($envy eq "Rural Desert - Open") {
    $K = (4.78 * (log10($frq_mhz) ** 2)) - (18.33 * (log10($frq_mhz))) + 40.94;
    $ah2 = 0;
  }
				     
  $ur = 46.3 + (33.9 * log10($frq_mhz)) - (13.82 * log10($tx_ant_ht_m)) - $ah2 + ((44.9 - (6.55 * log10($tx_ant_ht_m))) * log10($dist_km)) - $K; 

  if ($ur < 0) {
    $urban = sprintf "%.2f", $fs + 60;;
  }
  else {
    $urban = sprintf "%.2f", $ur;

  }

}

## Total Path Loss
#
if ($urban < $fs) {
  $urban = $fs;
}
$pl_fs = sprintf "%.2f", $fs + $rain_att_total + $water_att_total + $oxy_att_total;
$pl_ur = sprintf "%.2f", $urban + $rain_att_total + $water_att_total + $oxy_att_total;

## Effective Isotropic Radiated Power (EIRP)
#
$eirp = sprintf "%.3f", ($pwr_out - $tx_total_cable_loss) + $tx_misc_gain + ($tx_ant_gain - $tx_radome);
$eirp_mw = sprintf "%.3f", 10 ** ($eirp / 10);
$eirp_w = sprintf "%.3f", 10 ** (($eirp - 30) / 10);
$eirp_dbw = sprintf "%.3f", 10 * log10((10 ** (($eirp - 30) / 10)));
$eirp_kw = sprintf "%.5f", (10 ** (($eirp - 30) / 10)) / 1000;
$eirp_dbk = sprintf "%.3f", (10 * log10((10 ** (($eirp - 30) / 10)))) - 30;

## RF Input to the Antenna
#
$tx_ant_input_mw = sprintf "%.2f", 10 ** ((($pwr_out - $tx_total_cable_loss) + $tx_misc_gain) / 10);
$tx_ant_input = sprintf "%.2f", ($pwr_out - $tx_total_cable_loss) + $tx_misc_gain;

## RF Input Power, FCC Part 15.247
#
if (!$tx_ant_gain || $tx_ant_gain <= 6) {
  $max_ant_pwr = sprintf "%.2f", 30;
  $max_ant_pwr_mw = sprintf "%.2f", 10 ** (30 / 10);
}

if ($tx_ant_gain > 6) {
  $max_ant_pwr = sprintf "%.2f", 30 - (($tx_ant_gain - 6) / 3);
  $max_ant_pwr_mw = sprintf "%.2f", 10 ** ($max_ant_pwr / 10);
}

## Received Power Level - Free Space
#
$rx_pwr = sprintf "%.2f", ($eirp - ($pl_fs + $tx_misc_loss)) + ((($rx_ant_gain - $rx_radome) + $rx_misc_gain) - $rx_total_cable_loss);
$rx_div_pwr = sprintf "%.2f", ($eirp - ($pl_fs + $tx_misc_loss)) + ($rx_div_ant_gain - $rx_div_loss);
$rx_uvolt = sprintf "%.2f", (sqrt(( 10 ** ($rx_pwr / 10) / 1000) * 50)) * 1000000;

## Received Power Level - Urban Area
#
$rx_pwr_ur = sprintf "%.2f", ($eirp - ($pl_ur + $tx_misc_loss)) + ((($rx_ant_gain - $rx_radome) + $rx_misc_gain) - $rx_total_cable_loss);
$rx_div_pwr_ur = sprintf "%.2f", ($eirp - ($pl_ur + $tx_misc_loss)) + ($rx_div_ant_gain - $rx_div_loss);
$rx_uvolt_ur = sprintf "%.2f", (sqrt(( 10 ** ($rx_pwr_ur / 10) / 1000) * 50)) * 1000000;

## Receiver Threshold
#
$BER =~ tr/0-9.-//csd;

if ($BER_val eq "microVolts") {
  $BER_dbm = sprintf "%.2f", 10 * (log((($BER / 1000000) ** 2 / 50) * 1000) * 0.43429); # uV to dBm
  $BER_uvolt = sprintf "%.2f", $BER; # uV
}
else {
  $BER_dbm = sprintf "%.2f", $BER; # dBm
  $BER_uvolt = sprintf "%.2f", (sqrt((10 ** ($BER / 10) / 1000) * 50)) * 1000000; # dBm to uV
}

## Minimum Antenna Height
#
$min_ht_ft = sprintf "%.2f", 43.24 * sqrt($dist_mi / (4 * $frq_ghz)) +  (($dist_mi ** 2) / 8);
$min_ht_m = sprintf "%.2f", $min_ht_ft * 0.3048;

## Thermal Noise Fade Margin - Free Space
#
if ($rx_pwr >= $BER_dbm) {
  $tfm = sprintf "%.2f", abs ($BER_dbm - $rx_pwr);
}
else {
  $tfm = sprintf "%.2f", ($BER_dbm - $rx_pwr) * -1;
}

## Thermal Noise Fade Margin - Urban Area
#
if ($rx_pwr_ur >= $BER_dbm) {
  $tfm_ur = sprintf "%.2f", abs ($BER_dbm - $rx_pwr_ur);
}
else {
  $tfm_ur = sprintf "%.2f", ($BER_dbm - $rx_pwr_ur) * -1;
}

if ($rx_div_ant_ht) {
  if ($rx_div_pwr >= $BER_dbm) {
    $div_tfm = sprintf "%.2f", abs ($BER_dbm - $rx_div_pwr);
  } 
  else {
    $div_tfm = sprintf "%.2f", ($BER_dbm - $rx_div_pwr) * -1;
  } 
}
else {
  $div_tfm = $tfm;
}

if ($rx_div_ant_ht) {
  if ($rx_div_pwr_ur >= $BER_dbm) {
    $div_tfm_ur = sprintf "%.2f", abs ($BER_dbm - $rx_div_pwr_ur);
  }
  else {
    $div_tfm_ur = sprintf "%.2f", ($BER_dbm - $rx_div_pwr_ur) * -1;
  }
}
else {
  $div_tfm_ur = $tfm_ur;
}

## Composite, Dispersive, External Interference, Adjacent Channel Fade Margins 
## Free Space
#
$dfm =~ tr/0-9.//csd;
$eifm =~ tr/0-9.//csd;
$aifm =~ tr/0-9.//csd;

if (!$dfm) {
  $dfm_fs = $comp_fs = $eifm_fs = $aifm_fs = sprintf "%.2f", 0;
  $cmp_fs = sprintf "%.2f", $tfm;
}
elsif ($dfm && !$eifm && !$aifm) {
  $comp = -10 * log10(((10 ** (-$dfm / 10))) + ((10 ** (-$tfm / 10))));
  $cmp_fs = $comp_fs = sprintf "%.2f", $comp;
  $dfm_fs = sprintf "%.2f", $dfm;
  $eifm_fs = $aifm_fs = sprintf "%.2f", 0;
}
elsif ($dfm && $eifm && !$aifm) {
  $comp = -10 * log10(((10 ** (-$dfm / 10))) + ((10 ** (-$tfm / 10))) + ((10 ** (-$eifm / 10))));
  $cmp_fs = $comp_fs = sprintf "%.2f", $comp;
  $dfm_fs = sprintf "%.2f", $dfm;
  $eifm_fs = sprintf "%.2f", $eifm;
  $aifm_fs = sprintf "%.2f", 0;
}
elsif ($dfm && $aifm && !$eifm) {
  $comp = -10 * log10(((10 ** (-$dfm / 10))) + ((10 ** (-$tfm / 10))) + ((10 ** (-$aifm / 10))));
  $cmp_fs = $comp_fs = sprintf "%.2f", $comp;
  $dfm_fs = sprintf "%.2f", $dfm;
  $aifm_fs = sprintf "%.2f", $aifm;
  $eifm_fs = sprintf "%.2f", 0;
}
else {
  $comp = -10 * log10(((10 ** (-$dfm / 10))) + ((10 ** (-$tfm / 10))) + ((10 ** (-$eifm / 10))) + ((10 ** (-$aifm / 10))));
  $cmp_fs = $comp_fs = sprintf "%.2f", $comp;
  $dfm_fs = sprintf "%.2f", $dfm;
  $eifm_fs = sprintf "%.2f", $eifm;
  $aifm_fs = sprintf "%.2f", $aifm;
}

## Composite, Dispersive, External Interference, Adjacent Channel Fade Margins
## Urban Area
#
if (!$dfm) {
  $dfm_ur = $comp_ur = $eifm_ur = $aifm_ur = sprintf "%.2f", 0;
  $cmp_ur = sprintf "%.2f", $tfm_ur; 
}
elsif ($dfm && !$eifm && !$aifm) {
  $comp = -10 * log10(((10 ** (-$dfm / 10))) + ((10 ** (-$tfm_ur / 10))));
  $cmp_ur = $comp_ur = sprintf "%.2f", $comp;
  $dfm_ur = sprintf "%.2f", $dfm;
  $eifm_ur = $aifm_ur = sprintf "%.2f", 0;
}
elsif ($dfm && $eifm && !$aifm) {
  $comp = -10 * log10(((10 ** (-$dfm / 10))) + ((10 ** (-$tfm_ur / 10))) + ((10 ** (-$eifm / 10))));
  $cmp_ur = $comp_ur = sprintf "%.2f", $comp;
  $dfm_ur = sprintf "%.2f", $dfm;
  $eifm_ur = sprintf "%.2f", $eifm;
  $aifm_ur = sprintf "%.2f", 0;
}
elsif ($dfm && $aifm && !$eifm) {
  $comp = -10 * log10(((10 ** (-$dfm / 10))) + ((10 ** (-$tfm_ur / 10))) + ((10 ** (-$aifm / 10))));
  $cmp_ur = $comp_ur = sprintf "%.2f", $comp;
  $dfm_ur = sprintf "%.2f", $dfm;
  $aifm_ur = sprintf "%.2f", $aifm;
  $eifm_ur = sprintf "%.2f", 0;
}
else {
  $comp = -10 * log10(((10 ** (-$dfm / 10))) + ((10 ** (-$tfm_ur / 10))) + ((10 ** (-$eifm / 10))) + ((10 ** (-$aifm / 10))));
  $cmp_ur = $comp_ur = sprintf "%.2f", $comp;
  $dfm_ur = sprintf "%.2f", $dfm;
  $eifm_ur = sprintf "%.2f", $eifm;
  $aifm_ur = sprintf "%.2f", $aifm;
}

## North American Outage Calculations - Vigants
#

## Annual Multipath Outage Probability
## Non-diversity - Free Space
#
$Und_nodiv = $cli * ($frq_ghz / 4) * (10 ** -5) * ($dist_mi ** 3) * (10 ** (-$cmp_fs / 10));
$Und_nodiv_per = 100 * (1 - $Und_nodiv);
$Und_nodiv_out = 100 - $Und_nodiv - $Und_nodiv_per;
$SES_nodiv_mo = $Und_nodiv * 2600000; # SES per month (2600000 seconds)
$SES_nodiv_yr = $SES_nodiv_mo * 3 * ($temp_f / 50); # SES per year over a 3-month fade season

if ($SES_nodiv_mo >= 3600) {
  $worst_nodiv_mo = sprintf "%.2f", $SES_nodiv_mo / 3600;
  $worst_nodiv_mo_val = "hours";
}
elsif ($SES_nodiv_mo >= 60) {
  $worst_nodiv_mo = sprintf "%.2f", $SES_nodiv_mo / 60;
  $worst_nodiv_mo_val = "minutes";
}
else {
  $worst_nodiv_mo = sprintf "%.2f", $SES_nodiv_mo;
  $worst_nodiv_mo_val = "seconds";
}

if ($SES_nodiv_yr >= 3600) {
  $worst_nodiv_yr = sprintf "%.2f", $SES_nodiv_yr / 3600;
  $worst_nodiv_yr_val = "hours";
} 
elsif ($SES_nodiv_yr >= 60) {
  $worst_nodiv_yr = sprintf "%.2f", $SES_nodiv_yr / 60;
  $worst_nodiv_yr_val = "minutes"; 
} 
else {
  $worst_nodiv_yr = sprintf "%.2f", $SES_nodiv_yr;
  $worst_nodiv_yr_val = "seconds"; 
} 


if ($Und_nodiv_per < 0) {
  $Und_nodiv_per = sprintf "%.8f", 0;
}
if ($Und_nodiv_per > 100) {
  $Und_nodiv_per = sprintf "%.8f", 100;
}
if ($Und_nodiv_out < 0) {
  $Und_nodiv_out = sprintf "%.8f", 0;
}
if ($Und_nodiv_out > 100) {
  $Und_nodiv_out = sprintf "%.8f", 100;
} 

$Und_nodiv_per = sprintf "%.8f", abs $Und_nodiv_per;
$Und_nodiv_out = sprintf "%.8f", abs $Und_nodiv_out;
$SES_nodiv_mo = sprintf "%.2f", abs $SES_nodiv_mo;
$SES_nodiv_yr = sprintf "%.2f", abs $SES_nodiv_yr;

## Annual Multipath Outage Probability 
## Non-Diversity - Urban Area
#
$Und_nodiv_ur = $cli * ($frq_ghz / 4) * (10 ** -5) * ($dist_mi ** 3) * (10 ** (-$cmp_ur / 10));
$Und_nodiv_per_ur = 100 * (1 - $Und_nodiv_ur);
$Und_nodiv_out_ur = 100 - $Und_nodiv_ur - $Und_nodiv_per_ur;
$SES_nodiv_mo_ur = $Und_nodiv_ur * 2600000; # SES per month (2600000 seconds)
$SES_nodiv_yr_ur = $SES_nodiv_mo_ur * 3 * ($temp_f / 50); # SES per year over a 3-month fade season

if ($SES_nodiv_mo_ur >= 3600) {
  $worst_nodiv_mo_ur = sprintf "%.2f", $SES_nodiv_mo_ur / 3600;
  $worst_nodiv_mo_val_ur = "hours";
}
elsif ($SES_nodiv_mo_ur >= 60) {
  $worst_nodiv_mo_ur = sprintf "%.2f", $SES_nodiv_mo_ur / 60;
  $worst_nodiv_mo_val_ur = "minutes";
}
else {
  $worst_nodiv_mo_ur = sprintf "%.2f", $SES_nodiv_mo_ur;
  $worst_nodiv_mo_val_ur = "seconds";
}

if ($SES_nodiv_yr_ur >= 3600) {
  $worst_nodiv_yr_ur = sprintf "%.2f", $SES_nodiv_yr_ur / 3600;
  $worst_nodiv_yr_val_ur = "hours";
} 
elsif ($SES_nodiv_yr_ur >= 60) {
  $worst_nodiv_yr_ur = sprintf "%.2f", $SES_nodiv_yr_ur / 60;
  $worst_nodiv_yr_val_ur = "minutes";
} 
else {
  $worst_nodiv_yr_ur = sprintf "%.2f", $SES_nodiv_yr_ur;
  $worst_nodiv_yr_val_ur = "seconds";
} 

if ($Und_nodiv_per_ur < 0) {
  $Und_nodiv_per_ur = sprintf "%.8f", 0;
} 
if ($Und_nodiv_per_ur > 100) {
  $Und_nodiv_per_ur = sprintf "%.8f", 100;
} 
if ($Und_nodiv_out_ur < 0) {
  $Und_nodiv_out_ur = sprintf "%.8f", 0;
} 
if ($Und_nodiv_out_ur > 100) {
  $Und_nodiv_out_ur = sprintf "%.8f", 100;
} 

$Und_nodiv_per_ur = sprintf "%.8f", abs $Und_nodiv_per_ur;
$Und_nodiv_out_ur = sprintf "%.8f", abs $Und_nodiv_out_ur;
$SES_nodiv_mo_ur = sprintf "%.2f", abs $SES_nodiv_mo_ur;
$SES_nodiv_yr_ur = sprintf "%.2f", abs $SES_nodiv_yr_ur;

## Diversity Antenna Spacing
#
if (!$rx_div_ant_ht) {
  $div_m = sprintf "%.2f", $wav_m * ((3 * ($dist_km * 1000)) / (8 * $tx_ant_ht_m));
  $div_ft = sprintf "%.2f", $div_m / 0.3048;
  $div_message = "calculated";
  $div_ant_ht_ft = sprintf "%.2f", 0;
  $div_ant_ht_m = sprintf "%.2f", 0;
}
else {
  if ($rx_div_ant_ht_val eq "feet") {
    $div_ft = $rx_div_ant_ht;
    $div_m = $rx_div_ant_ht * 0.3048;
  }
  elsif ($rx_div_ant_ht_val eq "meters") {
    $div_m = $rx_div_ant_ht;
    $div_ft = $rx_div_ant_ht / 0.3048;
  }
  $div_ant_ht_ft = sprintf "%.2f", $div_ft;
  $div_ant_ht_m = sprintf "%.2f", $div_m;
  $div_ft = sprintf "%.2f", abs($div_ft - $rx_ant_ht_ft);
  $div_m = sprintf "%.2f", $div_ft * 0.3048;
  $div_message = "provided";
}

## Space Diversity Improvement Factor for Vertically Separated Receive Antennas
## Hosoya - Free Space
#
$div_factor = 7 * (10 ** -5) * $frq_ghz * ($div_ft ** 2) * (10 ** ($div_tfm / 10)) / $dist_mi;

if ($div_factor <= 1) {
  $div_fact_message = "will not improve link reliability";
  $div_factor = sprintf "%.2f", $div_factor;
  $do_div = "no";
} 
else {
  $div_fact_message = "will improve link reliability";
  $div_factor = sprintf "%.2f", $div_factor;
  $do_div = "yes";
} 

## Annual Multipath Outage Probability
## Diversity - Free Space
#
if ($do_div eq "yes") {
  $Und_div = $Und_nodiv / $div_factor;
} 
if ($do_div eq "no") { 
  $Und_div = $Und_nodiv;
} 

$Und_div_per = 100 * (1 - $Und_div);
$Und_div_out = 100 - $Und_div - $Und_div_per;
$SES_div_mo = $Und_div * 2600000; # SES per month (2600000 seconds)
$SES_div_yr = $SES_div_mo * 3 * ($temp_f / 50); # SES per year over a 3-month fade season

if ($SES_div_mo >= 3600) {
  $worst_div_mo = sprintf "%.2f", $SES_div_mo / 3600;
  $worst_div_mo_val = "hours";
}
elsif ($SES_div_mo >= 60) {
  $worst_div_mo = sprintf "%.2f", $SES_div_mo / 60;
  $worst_div_mo_val = "minutes";
}
else {
  $worst_div_mo = sprintf "%.2f", $SES_div_mo;
  $worst_div_mo_val = "seconds";
}

if ($SES_div_yr >= 3600) {
  $worst_div_yr = sprintf "%.2f", $SES_div_yr / 3600;
  $worst_div_yr_val = "hours";
}
elsif ($SES_div_yr >= 60) {
  $worst_div_yr = sprintf "%.2f", $SES_div_yr / 60;
  $worst_div_yr_val = "minutes";
}
else {
  $worst_div_yr = sprintf "%.2f", $SES_div_yr;
  $worst_div_yr_val = "seconds";
}

if ($Und_div_per < 0) {
  $Und_div_per = sprintf "%.8f", 0;
}
if ($Und_div_per > 100) {
  $Und_div_per = sprintf "%.8f", 100;
}
if ($Und_div_out < 0) {
  $Und_div_out = sprintf "%.8f", 0;
}
if ($Und_div_out > 100) {
  $Und_div_out = sprintf "%.8f", 100;
}

$Und_div_per = sprintf "%.8f", abs $Und_div_per;
$Und_div_out = sprintf "%.8f", abs $Und_div_out;
$SES_div_mo = sprintf "%.2f", abs $SES_div_mo;
$SES_div_yr = sprintf "%.2f", abs $SES_div_yr;

## Space Diversity Improvement Factor for Vertically Separated Receive Antennas
## Hosoya - Urban Area
#
$div_factor_ur = 7 * (10 ** -5) * $frq_ghz * ($div_ft ** 2) * (10 ** ($div_tfm_ur / 10)) / $dist_mi;

if ($div_factor_ur <= 1) {
  $div_fact_message_ur = "will not improve link reliability";
  $div_factor_ur = sprintf "%.2f", $div_factor_ur;
  $do_urdiv = "no";
}
else {
  $div_fact_message_ur = "will improve link reliability";
  $div_factor_ur = sprintf "%.2f", $div_factor_ur;
  $do_urdiv = "yes";
}

## Annual Multipath Outage Probability
## Diversity - Urban Area
#
if ($do_urdiv eq "yes") {
  $Und_div_ur = $Und_nodiv_ur / $div_factor_ur;
}
elsif ($do_urdiv eq "no") {
  $Und_div_ur = $Und_nodiv_ur;
}

$Und_div_per_ur = 100 * (1 - $Und_div_ur);
$Und_div_out_ur = 100 - $Und_div_ur - $Und_div_per_ur;
$SES_div_mo_ur = $Und_div_ur * 2600000; # SES per month (2600000 seconds)
$SES_div_yr_ur = $SES_div_mo_ur * 3 * ($temp_f / 50); # SES per year over a 3-month fade season

if ($SES_div_mo_ur >= 3600) {
  $worst_div_mo_ur = sprintf "%.2f", $SES_div_mo_ur / 3600;
  $worst_div_mo_val_ur = "hours";
} 
elsif ($SES_div_mo_ur >= 60) {
  $worst_div_mo_ur = sprintf "%.2f", $SES_div_mo_ur / 60;
  $worst_div_mo_val_ur = "minutes";
} 
else {
  $worst_div_mo_ur = sprintf "%.2f", $SES_div_mo_ur;
  $worst_div_mo_val_ur = "seconds";
} 

if ($SES_div_yr_ur >= 3600) {
  $worst_div_yr_ur = sprintf "%.2f", $SES_div_yr_ur / 3600;
  $worst_div_yr_val_ur = "hours";
}
elsif ($SES_div_yr_ur >= 60) {
  $worst_div_yr_ur = sprintf "%.2f", $SES_div_yr_ur / 60;
  $worst_div_yr_val_ur = "minutes";
}
else {
  $worst_div_yr_ur = sprintf "%.2f", $SES_div_yr_ur;
  $worst_div_yr_val_ur = "seconds";
}

if ($Und_div_per_ur < 0) {
  $Und_div_per_ur = sprintf "%.8f", 0;
} 
if ($Und_div_per_ur > 100) {
  $Und_div_per_ur = sprintf "%.8f", 100;
} 
if ($Und_div_out_ur < 0) {
  $Und_div_out_ur = sprintf "%.8f", 0;
} 
if ($Und_div_out_ur > 100) {
  $Und_div_out_ur = sprintf "%.8f", 100;
} 

$Und_div_per_ur = sprintf "%.8f", abs $Und_div_per_ur;
$Und_div_out_ur = sprintf "%.8f", abs $Und_div_out_ur;
$SES_div_mo_ur = sprintf "%.2f", abs $SES_div_mo_ur;
$SES_div_yr_ur = sprintf "%.2f", abs $SES_div_yr_ur;

## Ideal Fade Margin
#
$min_fade = log10(((0.9995 - 1) / (-2.5 * 2 * $cli * $frq_ghz * ($dist_mi ** 3) * (10 ** -6)))) * -10;
$min_fade = sprintf "%.2f", abs $min_fade;

## Impossible Link - Free Space
#
if ($tfm <= 0) {
  $Und_div_per = $Und_nodiv_per = sprintf "%.8f", 0;
  $Und_div_out = $Und_nodiv_out = sprintf "%.8f", 100;
  $worst_div_mo = $worst_nodiv_mo = 43333;
  $worst_div_mo_val = $worst_nodiv_mo_val = "minutes";
  $SES_div_yr = $SES_nodiv_yr = "31557600";
  $SES_div_mo = $SES_nodiv_mo = "2600000";
}

## Foliage Loss
#
if ($frq_ghz < 3) {
  $foli_m = sprintf "%.2f", 0.25 * ($frq_ghz ** 0.77);
  $foli_ft = sprintf "%.2f", $foli_m * 0.3048;
}
else {
  $foli_m = sprintf "%.2f", 1.102 + (1.44 * log10($frq_ghz));
  $foli_ft = sprintf "%.2f", $foli_m * 0.3048;
}

## Antenna Tilt
#
if ($k_str eq "Infinity" || $dist_km <= 7) {
  $tilt = sprintf "%.4f", rad2deg atan2(abs($tx_ant_ht_ov_ft - $rx_ant_ht_ov_ft), ($dist_mi * 5280));

  if ($tx_ant_ht_ov_ft > $rx_ant_ht_ov_ft) {
    $tilt_tr = sprintf "-%.4f", $tilt;
    $tilt_rt = sprintf "+%.4f", $tilt;
    $dir_tr = "DOWNWARD";
    $dir_rt = "UPWARD";
  }  
  elsif ($rx_ant_ht_ov_ft > $tx_ant_ht_ov_ft) {
    $tilt_tr = sprintf "+%.4f", $tilt;
    $tilt_rt = sprintf "-%.4f", $tilt;
    $dir_tr = "UPWARD";
    $dir_rt = "DOWNWARD";
  }  
  else {
    $tilt_tr = sprintf "%.4f", 0;
    $dir_tr = "LEVEL"; 
    $tilt_rt = sprintf "%.4f", 0;
    $dir_rt = "LEVEL";
  }
}
else {
  $TR = (180 / pi) * ((($rx_ant_ht_ov_ft - $tx_ant_ht_ov_ft) / (5280 * $dist_mi)) - ($dist_mi / (7920 * $k)));
  $TR = abs $TR;
  $RT = (180 / pi) * ((($tx_ant_ht_ov_ft - $rx_ant_ht_ov_ft) / (5280 * $dist_mi)) - ($dist_mi / (7920 * $k)));
  $RT = abs $RT;

  if ($tx_ant_ht_ov_ft > $rx_ant_ht_ov_ft) {
    $tilt_tr = sprintf "%.4f", $TR * -1;
    $dir_tr = "DOWNWARD";
    $tilt_rt = sprintf "+%.4f", $RT;
    $dir_rt = "UPWARD";
  } 
  elsif ($tx_ant_ht_ov_ft < $rx_ant_ht_ov_ft) {
    $tilt_tr = sprintf "+%.4f", $TR;
    $dir_tr = "UPWARD";
    $tilt_rt = sprintf "%.4f", $RT * -1;
    $dir_rt = "DOWNWARD";
  } 
  else {
    $tilt_tr = sprintf "%.4f", 0;
    $dir_tr = "LEVEL";
    $tilt_rt = sprintf "%.4f", 0; 
    $dir_rt = "LEVEL";
  }
}

## Grazing Angle
#
$graze = atan2(($tx_ant_ht_m - $rx_ant_ht_m), ($dist_km * 1000));
$graze_d = sprintf "%.2f", $graze * 57.29578;

## RF Safety
#
$rf_safe_eirp = $tx_ant_input_mw * (10 ** ($tx_ant_gain / 10));
$rf_safe_dx = $tx_ant_ht_ft * 30.48; # ft to cm 

if ($frq_mhz < 1.34) {
  $std1 = 100.0; 
  $std2 = 100.0;
} 
elsif ($frq_mhz < 3.0) {
  $std1 = 100.0;  
  $std2 = 180.0 / ($frq_mhz ** 2);
} 
elsif ($frq_mhz < 30.0) {
  $std1 = 900.0 / ($frq_mhz ** 2);
  $std2 = 180.0 / ($frq_mhz ** 2);
} 
elsif ($frq_mhz < 300.0) {
  $std1 = 1.0; 
  $std2 = 0.2;
} 
elsif ($frq_mhz < 1500.0) {
  $std1 = $frq_mhz / 300.0;
  $std2 = $frq_mhz / 1500.0;
}  
elsif ($frq_mhz < 100000.0) {
  $std1 = 5.0; 
  $std2 = 1.0;
}  
else {
  $std1 = 5.0;
  $std2 = 1.0;
}

$pwrdens = (0.64 * $rf_safe_eirp) / (pi * ($rf_safe_dx ** 2));
$rf_safe_pwrdens = (($pwrdens * 10000) + 0.5) / 10000;
$rf_safe_pwrdens = sprintf "%.3f", $rf_safe_pwrdens;

$dx2 = (sqrt((0.64 * $rf_safe_eirp) / ($std2 * pi))) / 30.48;
$dx2 = (($dx2 * 10) + 0.5) / 10;
$dx2_ft = sprintf "%.2f", $dx2;
$dx2_m = sprintf "%.2f", $dx2 * 0.3048;

$std2 = ((($std2 * 100) + 0.5) / 100);
$std2 = sprintf "%.2f", $std2;

## Misc Stuff I Forgot
#
if ($div_ant_ht_m == 0) {
  $div_rx_ant_ht_ov_ft = $rx_ant_ht_ov_ft;
  $div_rx_ant_ht_ov_m = $rx_ant_ht_ov_m;
}
else {
  $div_rx_ant_ht_ov_ft = sprintf "%.2f", $rx_elv_ft + $div_ant_ht_ft;
  $div_rx_ant_ht_ov_m = sprintf "%.2f", $rx_elv_m + $div_ant_ht_m;
}

## Make All Pretty
#
$frq_ghz = sprintf "%.6f", $frq_ghz;
$frq_mhz = sprintf "%.6f", $frq_mhz;

$tx_loss_per_foot = sprintf "%.2f", $tx_loss_per_foot;
$tx_loss_per_meter = sprintf "%.2f", $tx_loss_per_meter;
$tx_loss_per_100f = sprintf "%.2f", $tx_loss_per_100f;
$tx_loss_per_100m = sprintf "%.2f", $tx_loss_per_100m;
$rx_loss_per_foot = sprintf "%.2f", $rx_loss_per_foot;
$rx_loss_per_meter = sprintf "%.2f", $rx_loss_per_meter;
$rx_loss_per_100f = sprintf "%.2f", $rx_loss_per_100f;
$rx_loss_per_100m = sprintf "%.2f", $rx_loss_per_100m;

$con_tx = sprintf "%1.0f", $con_tx;
$tx_length_ft = sprintf "%.2f", $tx_length / 0.3048;
$tx_length = sprintf "%.2f", $tx_length;
$tx_con_loss = sprintf "%.2f", $tx_con_loss;
$tx_cab_loss = sprintf "%.2f", $tx_cab_loss;
$tx_ant_gain = sprintf "%.2f", $tx_ant_gain;
$tx_ant_gain_dbd = sprintf "%.2f", $tx_ant_gain - 2.15;
$tx_radome = sprintf "%.2f", $tx_radome;
$tx_misc_loss = sprintf "%.2f", $tx_misc_loss;
$tx_misc_cab_loss = sprintf "%.2f", $tx_misc_cab_loss;
$tx_total_cable_loss = sprintf "%.2f", $tx_total_cable_loss;
$tx_misc_gain = sprintf "%.2f", $tx_misc_gain;

$con_rx = sprintf "%1.0f", $con_rx;
$rx_length_ft = sprintf "%.2f", $rx_length / 0.3048;
$rx_length = sprintf "%.2f", $rx_length;
$rx_con_loss = sprintf "%.2f", $rx_con_loss;
$rx_cab_loss = sprintf "%.2f", $rx_cab_loss;
$rx_ant_gain = sprintf "%.2f", $rx_ant_gain;
$rx_ant_gain_dbd = sprintf "%.2f", $rx_ant_gain - 2.15;
$rx_radome = sprintf "%.2f", $rx_radome;
$rx_misc_cab_loss = sprintf "%.2f", $rx_misc_cab_loss;
$rx_total_cable_loss = sprintf "%.2f", $rx_total_cable_loss;
$rx_misc_gain = sprintf "%.2f", $rx_misc_gain;

## Draw Me a Web Page
#
print  "<html>\n";
print  "<head></head>\n";
print  "<body>\n";
print  "<center>\n";
print  "<hr noshade>\n";
print  "<h1><font face=Helvetica color=purple><i>Wireless Network Link Analysis</i></font></h1>\n";
print  "<p>$banner</p>\n";
print  "</center>\n";
print  "<hr noshade>\n";
print  "<pre>\n";
print  "<b>                    Highest Transmitted Frequency :</b> $frq_ghz <b>GHz  (</b>$frq_mhz <b>MHz)</b>\n";
print  "<b>                                       Wavelength :</b> $wav_m <b>meters  (</b>$wav_cm <b>centimeters)</b>\n";
print  "<b>                                                  :</b> $wav_ft <b>feet  (</b>$wav_in <b>inches)</b>\n";
print  "<b>                      Transmitter RF Power Output :</b> $pwr_out <b>dBm  (</b>$pwr_out_mw <b>milliWatts)</b>\n";
print  "<b>                                                  :</b> $pwr_out_dbw <b>dBW  (</b>$pwr_out_w <b>Watts)</b>\n";
print  "<b>                                                  :</b> $pwr_out_dbk <b>dBk  (</b>$pwr_out_kw <b>kiloWatts)</b>\n";
print  "<b>               Transmitter Transmission Line Type :</b> $tx_cab\n";
print  "<b>                          Transmitter Line Length :</b> $tx_length <b>meters  (</b>$tx_length_ft <b>feet)</b>\n";
print  "<b>              Transmitter Line Loss Specification :</b> $tx_loss_per_100m <b>dB/100-meters  (</b>$tx_loss_per_100f <b>dB/100-feet)</b>\n";
print  "<b>                 Calculated Transmitter Line Loss :</b> $tx_cab_loss <b>dB  (</b>$tx_loss_per_meter <b>dB/meter)  (</b>$tx_loss_per_foot <b>dB/foot)</b>\n";
print  "<b>                      Transmitter Line Efficiency :</b> $tx_eff <b>%  (</b>$tx_eff_message<b>)</b>\n";
print  "<b>                 Total Transmitter Connector Loss :</b> $tx_con_loss <b>dB through</b> $con_tx <b>connectors</b>\n";
print  "<b>              Transmitter Line Miscellaneous Loss :</b> $tx_misc_cab_loss <b>dB</b>\n";
print  "<b>                      Total Transmitter Line Loss :</b> $tx_total_cable_loss <b>dB</b>\n";
print  "<b>            Transmitter Path Miscellaneous Losses :</b> $tx_misc_loss <b>dB</b>\n";
print  "<b>                   Transmitter Miscellaneous Gain :</b> $tx_misc_gain <b>dB</b>\n";
print  "<b>                    Transmitter Antenna Peak Gain :</b> $tx_ant_gain <b>dBi  (</b>$tx_ant_gain_dbd <b>dBd)</b>\n";
print  "<b>                  Transmitter Antenna Radome Loss :</b> $tx_radome <b>dB</b>\n";
print  "<b>               Transmitter Antenna 3 dB Beamwidth :</b> $tx_ant_bw <b>&deg;</b>\n";
print  "<b>              Total RF Input Power to the Antenna :</b> $tx_ant_input <b>dBm  (</b>$tx_ant_input_mw <b>milliWatts)</b>\n";
print  "<b>FCC Part 15.247 Allowed RF Input Power to Antenna :</b> $max_ant_pwr <b>dBm  (</b>$max_ant_pwr_mw <b>milliWatts)</b>\n";
print  "<b>                       Transmitter Antenna Height :</b> $tx_ant_ht_m <b>meters  (</b>$tx_ant_ht_ft <b>feet) AGL</b>\n";
print  "<b>               Transmitter Antenna Site Elevation :</b> $tx_elv_m <b>meters  (</b>$tx_elv_ft <b>feet) AMSL</b>\n";
print  "<b>               Overall Transmitter Antenna Height :</b> $tx_ant_ht_ov_m <b>meters  (</b>$tx_ant_ht_ov_ft <b>feet) AMSL</b>\n";
print  "<b>        Transmitter Distance to the Radio Horizon :</b> $tx_rad_hor <b>kilometers  (</b>$tx_rad_hor_mi <b>miles)</b>\n";
print  "<b>  Transmitter to Receiver Antenna Mechanical Tilt :</b> $tilt_tr <b>&deg;  (</b>$dir_tr<b>)</b>\n";
print  "\n";
print  "<b>                  Receiver Transmission Line Type :</b> $rx_cab\n";
print  "<b>                             Receiver Line Length :</b> $rx_length <b>meters  (</b>$rx_length_ft <b>feet)</b>\n";
print  "<b>                 Receiver Line Loss Specification :</b> $rx_loss_per_100m <b>dB/100-meters  (</b>$rx_loss_per_100f <b>dB/100-feet)</b>\n";
print  "<b>                    Calculated Receiver Line Loss :</b> $rx_cab_loss <b>dB  (</b>$rx_loss_per_meter <b>dB/meter)  (</b>$rx_loss_per_foot <b>dB/foot)</b>\n";
print  "<b>                         Receiver Line Efficiency :</b> $rx_eff <b>%  (</b>$rx_eff_message<b>)</b>\n";
print  "<b>                    Total Receiver Connector Loss :</b> $rx_con_loss <b>dB through</b> $con_rx <b>connectors</b>\n";
print  "<b>                 Receiver Line Miscellaneous Loss :</b> $rx_misc_cab_loss <b>dB</b>\n";
print  "<b>                         Total Receiver Line Loss :</b> $rx_total_cable_loss <b>dB</b>\n";
print  "<b>                      Receiver Miscellaneous Gain :</b> $rx_misc_gain <b>dB</b>\n";
print  "<b>                       Receiver Antenna Peak Gain :</b> $rx_ant_gain <b>dBi  (</b>$rx_ant_gain_dbd <b>dBd)</b>\n";
print  "<b>                     Receiver Antenna Radome Loss :</b> $rx_radome <b>dB</b>\n";
print  "<b>                  Receiver Antenna 3 dB Beamwidth :</b> $rx_ant_bw <b>&deg;</b>\n";
print  "<b>                          Receiver Antenna Height :</b> $rx_ant_ht_m <b>meters  (</b>$rx_ant_ht_ft <b>feet) AGL</b>\n";
print  "<b>                  Receiver Antenna Site Elevation :</b> $rx_elv_m <b>meters  (</b>$rx_elv_ft <b>feet) AMSL</b>\n";
print  "<b>                  Overall Receiver Antenna Height :</b> $rx_ant_ht_ov_m <b>meters  (</b>$rx_ant_ht_ov_ft <b>feet) AMSL</b>\n";
print  "<b>           Receiver Distance to the Radio Horizon :</b> $rx_rad_hor <b>kilometers  (</b>$rx_rad_hor_mi <b>miles)</b>\n";
print  "<b>  Receiver to Transmitter Antenna Mechanical Tilt :</b> $tilt_rt <b>&deg;  (</b>$dir_rt<b>)</b>\n";
print  "\n\n";
print  "<b>          Vertical Space Diversity Antenna Height :</b> $div_ant_ht_m <b>meters  (</b>$div_ant_ht_ft <b>feet) AGL</b>\n";
print  "<b>                           Diversity Antenna Gain :</b> $div_ant_dbi <b>dBi  (</b>$div_ant_dbd <b>dBd)</b>\n";
print  "<b>           Calculated Diversity Antenna Line Loss :</b> $rx_div_loss <b>dB  (</b>$rx_loss_per_meter <b>dB/meter)  (</b>$rx_loss_per_foot <b>dB/foot)</b>\n";
print  "<b>                Diversity Line Miscellaneous Loss :</b> $rx_div_misc_cab_loss <b>dB</b>\n";
print  "<b>        Overall Diversity Receiver Antenna Height :</b> $div_rx_ant_ht_ov_m <b>meters  (</b>$div_rx_ant_ht_ov_ft <b>feet) AMSL</b>\n";
print  "\n";
print  "<b>                            Transmitter Site Name :</b> $tx_name\n";
print  "<b>                        Transmitter Site Latitude :</b> $y1label  <b>(</b>$LAT1_D<b>&deg;</b> $LAT1_M<b>'</b> $LAT1_S<b>&quot;)</b>\n";
print  "<b>                       Transmitter Site Longitude :</b> $x1label  <b>(</b>$LON1_D<b>&deg;</b> $LON1_M<b>'</b> $LON1_S<b>&quot;)</b>\n";
print  "<b>                               Receiver Site Name :</b> $rx_name\n";
print  "<b>                           Receiver Site Latitude :</b> $y2label  <b>(</b>$LAT2_D<b>&deg;</b> $LAT2_M<b>'</b> $LAT2_S<b>&quot;)</b>\n";
print  "<b>                          Receiver Site Longitude :</b> $x2label  <b>(</b>$LON2_D<b>&deg;</b> $LON2_M<b>'</b> $LON2_S<b>&quot;)</b>\n";
print  "<b>   Azimuth From Transmitter Site to Receiver Site :</b> $AZSP <b>&deg; East of true North</b>\n";
print  "<b>   Azimuth From Receiver Site to Transmitter Site :</b> $AZLP <b>&deg; East of true North</b>\n";
print  "<b>                              Total Path Distance :</b> $dist_km <b>kilometers  (</b>$dist_mi <b>miles)</b>\n";
print  "\n";
print  "<b>                             Free Space Path Loss :</b> $fs <b>dB</b>\n";
print  "<b>                   Estimated Urban Area Path Loss :</b> $urban <b>dB</b>\n";
print  "<b>              Total Worst Case Precipitation Loss :</b> $rain_att_total <b>dB</b>\n";
print  "<b>                           Total Water Vapor Loss :</b> $water_att_total <b>dB</b>\n";
print  "<b>                                Total Oxygen Loss :</b> $oxy_att_total <b>dB</b>\n";
print  "<b>                Total System Free Space Path Loss :</b> $pl_fs <b>dB</b>\n";
print  "<b>                Total System Urban Area Path loss :</b> $pl_ur <b>dB</b>\n";
print  "\n";
print  "<b>   Peak Effective Isotropic Radiated Power (EIRP) :</b> $eirp <b>dBm  (</b>$eirp_mw <b>milliWatts)</b>\n";
print  "<b>                                                  :</b> $eirp_dbw <b>dBW  (</b>$eirp_w <b>Watts)</b>\n";
print  "<b>                                                  :</b> $eirp_dbk <b>dBk  (</b>$eirp_kw <b>kiloWatts)</b>\n";
print  "<b>  Unfaded Free Space Received Carrier Power Level :</b> $rx_pwr <b>dBm  (</b>$rx_uvolt <b>&micro;V)</b>\n";
print  "<b>  Unfaded Urban Area Received Carrier Power Level :</b> $rx_pwr_ur <b>dBm  (</b>$rx_uvolt_ur <b>&micro;V)</b>\n";
print  "<b>                 Receiver Threshold (sensitivity) :</b> $BER_dbm <b>dBm  (</b>$BER_uvolt <b>&micro;V)</b>\n";
print  "\n";
print  "<b>             Thermal Noise Free Space Fade Margin :</b> $tfm <b>dB  (Urban : </b>$tfm_ur <b>dB)</b>\n";
print  "<b>   Diversity Thermal Noise Free Space Fade Margin :</b> $div_tfm <b>dB  (Urban : </b>$div_tfm_ur <b>dB)</b>\n";
print  "<b> Ideal Thermal Noise Fade Margin for This Climate :</b> $min_fade <b>dB</b>\n";
print  "<b>                Dispersive Free Space Fade Margin :</b> $dfm_fs <b>dB  (Urban : </b>$dfm_ur <b>dB)</b>\n";
print  "<b>     External Interference Free Space Fade Margin :</b> $eifm_fs <b>dB  (Urban : </b>$eifm_ur <b>dB)</b>\n";
print  "<b> Adj. Channel Interference Free Space Fade Margin :</b> $aifm_fs <b>dB  (Urban : </b>$aifm_ur <b>dB)</b>\n";
print  "<b>                 Composite Free Space Fade Margin :</b> $cmp_fs <b>dB  (Urban : </b>$cmp_ur <b>dB)</b>\n";
print  "\n";
print  "<b>Dense, Dry, In-Leaf Temperate Climate Foliage Loss :</b> $foli_m <b>dB/meter  (</b>$foli_ft <b>dB/foot) worst case</b>\n";
print  "<b>        Estimated Attenuation Due to Precipitation :</b> $rain_att_km <b>dB/km  (</b>$rain_att_mi <b>dB/mi) (</b>$rate <b>mm/hour)</b>\n";
print  "<b>          Estimated Attenuation Due to Water Vapor :</b> $water_att_km <b>dB/km  (</b>$water_att_mi <b>dB/mi)</b>  $wvd <b>gm/m3</b>\n";
print  "<b>          Estimated Attenuation Due to Oxygen Loss :</b> $oxy_att_km <b>dB/kilometer  (</b>$oxy_att_mi <b>dB/mile)</b>\n";
print  "<b>Absolute Minimum Antenna Height for Either Antenna :</b> $min_ht_m <b>meters  (</b>$min_ht_ft <b>feet)</b>\n\n";
print  "<font color=purple><b>One Way - No Spaced Vertical Antenna Diversity</b></font>\n";
print  "<b> Annual Free Space Multipath Reliability Estimate :</b> $Und_nodiv_per <b>%  (Urban : </b>$Und_nodiv_per_ur <b>%)</b>\n";
print  "<b>               Annual Free Space Multipath Outage :</b> $worst_nodiv_yr <b>$worst_nodiv_yr_val  (Urban : </b>$worst_nodiv_yr_ur <b>$worst_nodiv_yr_val_ur)</b>\n";
print  "<b>          Worst Month Free Space Multipath Outage :</b> $worst_nodiv_mo <b>$worst_nodiv_mo_val  (Urban : </b>$worst_nodiv_mo_ur <b>$worst_nodiv_mo_val_ur)</b>\n";
print  "<b>       Annual Free Space Severely Errored Seconds :</b> $SES_nodiv_yr  <b>(Urban : </b>$SES_nodiv_yr_ur<b>)</b>\n";
print  "<b>  Worst Month Free Space Severely Errored Seconds :</b> $SES_nodiv_mo  <b>(Urban : </b>$SES_nodiv_mo_ur<b>)</b>\n\n";
print  "<font color=purple><b>One Way - With Spaced Vertical Antenna Diversity</b></font>\n";
print  "<b>          Vertical Spacing for Diversity Antennas :</b> $div_m <b>meters  (</b>$div_ft <b>feet)  (</b>$div_message<b>)</b>\n";
print  "<b>          Free Space Diversity Improvement Factor :</b> $div_factor  <b>(</b>$div_fact_message<b>)</b>\n";
print  "<b>          Urban Area Diversity Improvement Factor :</b> $div_factor_ur  <b>(</b>$div_fact_message_ur<b>)</b>\n";
print  "<b> Annual Free Space Multipath Reliability Estimate :</b> $Und_div_per <b>%  (Urban : </b>$Und_div_per_ur <b>%)</b>\n";
print  "<b>               Annual Free Space Multipath Outage :</b> $worst_div_yr <b>$worst_div_yr_val  (Urban : </b>$worst_div_yr_ur <b>$worst_div_yr_val_ur)</b>\n";
print  "<b>          Worst Month Free Space Multipath Outage :</b> $worst_div_mo <b>$worst_div_mo_val  (Urban : </b>$worst_div_mo_ur <b>$worst_div_mo_val_ur)</b>\n";
print  "<b>       Annual Free Space Severely Errored Seconds :</b> $SES_div_yr  <b>(Urban : </b>$SES_div_yr_ur<b>)</b>\n";
print  "<b>  Worst Month Free Space Severely Errored Seconds :</b> $SES_div_mo  <b>(Urban : </b>$SES_div_mo_ur<b>)</b>\n";
print  "\n";
print  "<b>                Effective Earth Radius (K Factor) :</b> $k_str\n";
print  "<b>                                   Climate Factor :</b> $cli\n";
print  "<b>                         Urban Environment Factor :</b> $envy\n";
print  "<b>      Terrain Roughness (std. dev. of elevations) :</b> $rough_m <b>meters  (</b>$rough_ft <b>feet)</b>\n";
print  "<b>                       Average Annual Temperature :</b> $temp_c <b>&deg; C  (</b>$temp_f <b>&deg; F)</b>\n";
print  "<b>         Sea Level Corrected Atmospheric Pressure :</b> $atmos_p <b>millibars</b>\n";
print  "<b>                        Saturation Vapor Pressure :</b> $es <b>millibars</b>\n";
print  "<b>                           Partial Vapor Pressure :</b> $vapor_p <b>millibars</b>\n";
print  "<b>                              Index of Refraction :</b> $N <b>N units</b>\n";
print  "<b>  Maximum Free Space Wave Communications Distance :</b> $distance_max <b>kilometers  (</b>$distance_max_mi <b>miles)</b>\n";
print  "<b>                      Receiver Site Grazing Angle :</b> $graze_d <b>&deg;</b>\n";
print  "\n";
print  "<b>Estimated RF Power Density Below the Radiating Antenna :</b> $rf_safe_pwrdens <b>mW/cm2</b>\n";
print  "<b>     FCC OET Bulletin #65 Maximum Permissible Exposure :</b> $std2 <b>mW/cm2</b>\n";
print  "<b>Distance to RF Safety Compliance From Transmit Antenna :</b> $dx2_m <b>meters  (</b>$dx2_ft <b>feet)</b>\n";
print  "</pre>\n";
print  "<hr noshade size=5>\n";
print  "<p><b><u>Notes</u></b></p>\n";
print  "<blockquote>\n";
print  "<ul type=circle>\n";
print  "<li>Annual outage time due to multipath fade activity in a microwave link is computed over a one-year period.&nbsp;&nbsp;Actual outage is defined as that occuring over a 3-month 'fade season'.</li>\n";
print  "<p></p>\n";
print  "<li>Horizontal polarization will generally provide less multipath in urban areas and may provide lower path loss in non line-of-sight situations.&nbsp;&nbsp;It is also better in reducing foliage attenuation.</li>\n";
print  "<p></p>\n";
print  "<li>Neither space diversity nor in-band frequency diversity provides any improvement against rain attenuation.</li>\n";
print  "<p></p>\n";
print  "<li>Space diversity is needed when crossing flat, wet surfaces.</li>\n";
print  "<p></p>\n";
print  "<li>Vertically polarized high-frequency link rain outage is 40-60% less than those links horizontally polarized.</li>\n";
print  "<p></p>\n";
print  "<li>Principal atmospheric absorption is by oxygen and water vapor.&nbsp;&nbsp;The attenuation due to oxygen is relatively linear in the 2 to 14 GHz frequency range.&nbsp;&nbsp;Water vapor absorption is highly dependent on the frequency, as well as to the density of the water vapor (absolute humidity).</li>\n";
print  "<p></p>\n";
print  "<li>Attenuation from trees is approximately 0.35 dB/meter at 2.4 GHz.&nbsp;&nbsp;At lower frequencies, the attenuation is somewhat lower for horizontal polarization than for vertical, but the difference disappears above about 1 GHz.</li>\n";
print  "<p></p>\n";
print  "<li>Urban path loss is only somewhat accurate for frequencies between 0.1-3.0 GHz, transmit antenna height of 30-200 meters, receive antenna height of 1-10 meters and path distances of 1-20 kilometers.</li>\n";
print  "<p></p>\n";
print  "<li>Maximum space wave communications distance is the longest distance possible using the choosen antenna heights.&nbsp;&nbsp;It <b>does not</b> mean a link that long is possible.</li>\n";
print  "<p></p>\n";
print  "<li>Improved script available at <a href=\"http://gbppr.dyndns.org:8080/wireless.super.main.cgi\">Wireless Network Link Analysis - Super Edition</a></li>\n";
print  "</ul>\n";
print  "<pre>\n";
print  "\n<b>Calculated on $mon/$mday/$year  $ver</b>\n";
print  "</pre>\n";
print  "</blockquote>\n";
print  "</body>\n";
print  "</html>\n";

exit 0;
