#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Parabolic Reflector Analysis, parabolic.main.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
select STDOUT;
$| = 1;

# User stuff
#
my $form = "./parabolic.cgi";
my $freq = 2450; # 2450 MHz
my $ill = 0.60; # 0.6 illumination factor

# Print MIME
#
print "Content-type:text/html\n\n";

# Draw me a web page
#
print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Parabolic Reflector Analysis</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<font face="Verdana, Arial, Helvetica">
<h2>Parabolic Reflector Analysis</h2>

<p><font size="-1">A service of <a href="http://www.gbppr.org">Green Bay Professional Packet Radio</a>&nbsp;&reg;</font></p>
</center>

<hr noshade>
<form action="$form" method="post">
<table border="0">
<tr>
<td align="left"><b>Enter the illumination factor (0.??)</b></td>
<td align="right"><input type="text" name="ill" size="5" value="$ill"></td>
</tr>

<tr>
<td align="left"><b>Enter the reflector's diameter</b></td>
<td align="right"><input type="text" name="ref_dia" size="5" value=""></td>
<td align="right"><select name="ref_dia_val">
<option selected>centimeters</option>
<option>inches</option>
</select></td>
</tr>

<tr>
<td align="left"><b>Enter the reflector's depth</b></td>
<td align="right"><input type="text" name="ref_dep" size="5" value=""></td>
<td align="right"><select name="ref_dep_val">
<option selected>centimeters</option>
<option>inches</option>
</select></td>
</tr>

<tr>
<td align="left"><b>Enter the operating frequency</b></td>
<td align="right"><input type="text" name="frq" size="5" value="$freq"></td>
<td align="right"><select name="frq_val">
<option selected>MHz</option>
<option>GHz</option>
</select></td>
</tr>
</table>

<hr noshade>
<center>
<table>
<tr>
<td><input type="submit" value="Submit"></td>
<td><input type="reset" value="Clear"></td>
</tr>
</table>
</center>
</form>

<hr noshade size="5">
</font>

</body>
</html>
EOF
