#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Omnidirectional Antenna Beamwidth Analysis, omni.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
use Math::Trig;
select STDOUT;
$| = 1;

my $pic = "pics/omni.png";

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $vb = $FORM{'vb'};

my $dt = $FORM{'dt'};

my $ht = $FORM{'ht'};
my $ht_val = $FORM{'ht_val'};

my $k = $FORM{'k'};

# Clean up user input data
#
$vb =~ tr/0-9.//csd;

if (!$vb || $vb > 120) {
  $vb = 3.5; # 3.5 degrees vertical beamwidth
}

$dt =~ tr/0-9.-//csd;

if (!$dt || $dt >= 90) {
  $dt = 0; # 0 degrees downtilt
} 

$k =~ tr/0-9.//csd;

if (!$k) {
  $k = 1.33; # K factor (effective Earth radius)
}

$ht =~ tr/0-9.//csd;
$ht_val =~ tr/a-z//csd;

if (!$ht) {
  $ht = 50; $ht_val = "meters"; # 50 meters antenna height
}

# Start calculations
#

# Distance to radio horizon
#
if ($ht_val eq "feet") {
  $height = $ht * 0.3048 ; # ft to m
}
else {
  $height = $ht;
}

$hor_km = sqrt(12.75 * $height * $k); # distance (km) to radio horizon
$hor_mi = $hor_km / 1.609344;

# Distance to 3 dB intersections
#
if ($ht_val eq "meters") {
  $height = $ht / 0.3048; # m to ft
}
else {
  $height = $ht;
}

if (!$dt) {
  $main_lobe = $hor_mi;
  $lower = (($height / (tan(deg2rad (($vb / 2) + $dt)))) / 5280) * 1;
  $upper = (($height / (tan(deg2rad ($dt - ($vb / 2))))) / 5280) * 1;
}
else {
  $main_lobe = (($height / (tan(deg2rad $dt))) / 5280) * 1;
  $lower = (($height / (tan(deg2rad (($vb / 2) + $dt)))) / 5280) * 1;
  $upper = (($height / (tan(deg2rad ($dt - ($vb / 2))))) / 5280) * 1;
}

# Make all pretty
#
$vb = sprintf "%.3f", $vb;

$k = sprintf "%.3f", $k;

$ht_m = sprintf "%.3f", $ht / 3.2808399;
$ht = sprintf "%.3f", $ht;

$main_lobe_km = sprintf "%.3f", $main_lobe * 1.609344;
$main_lobe = sprintf "%.3f", $main_lobe;

$upper_km = sprintf "%.3f", $upper * 1.609344;
$upper = sprintf "%.3f", $upper;

$lower_km = sprintf "%.3f", $lower * 1.609344;
$lower = sprintf "%.3f", $lower;

if ($upper < 0) {
  $upper = "Over Horizon";
  $upper_km = "Over Horizon";
}

$hor_mi = sprintf "%.3f", $hor_mi;
$hor_km = sprintf "%.3f", $hor_km;

$date = scalar gmtime;

# Draw me a web page
#
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Omnidirectional Antenna Beamwidth Analysis</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>Omnidirectional Antenna Beamwidth Analysis</h2>
</center>

<hr noshade>
<center><img src="$pic" alt="[omni]"></center>

<hr noshade>
<pre>
   $b Vertical 3 dB beamwidth : $e$vb$b degrees $e
          $b Antenna downtilt : $e$dt$b degrees $e
            $b Antenna height : $e$ht_m$b meters ($e$ht$b feet) $e
$b Effective Earth radius (K) : $e$k
 $b Distance to radio horizon : $e$hor_km$b kilometers ($e$hor_mi$b miles) $e
<br>
      $p Main lobe intersection : $e$main_lobe_km$p kilometers ($e$main_lobe$p miles) $e
$p Lower 3 dB lobe intersection : $e$lower_km$p kilometers ($e$lower$p miles) $e
$p Upper 3 dB lobe intersection : $e$upper_km$p kilometers ($e$upper$p miles) $e
</pre>

<hr noshade size="5">

<p><font size="-1">Calculated on $date GMT</font></p>
</body>
</html>
EOF
