#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Terrestrial Distance and Bearing Calculator, distance.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
use Math::Trig;
select STDOUT;
$| = 1;

my $pic = "pics/distance.png";

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $lat1 = $FORM{'lat1'};
my $lon1 = $FORM{'lon1'};

my $lat2 = $FORM{'lat2'};
my $lon2 = $FORM{'lon2'};

# Clean up user input data
#
$lat1 =~ tr/0-9.-//csd;
$lon1 =~ tr/0-9.-//csd;
$lat2 =~ tr/0-9.-//csd;
$lon2 =~ tr/0-9.-//csd;

if (!$lat1 || $lat1 > 90 || $lat1 < -90) {
  $lat1 = 44.51800;
}

if (!$lon1 || $lon1 > 180 || $lon1 < -180) {
  $lon1 = -87.96850;
}

if (!$lat2 || $lat2 > 90 || $lat2 < -90) {
  $lat2 = 44.51620;
}

if (!$lon2 || $lon2 > 180 || $lon2 < -180) {
  $lon2 = -88.02279;
}

# Start calculations
#

# The Haversine Formula can be expressed in terms of a two-argument
# inverse tangent function, atan2(y,x), instead of an inverse sine
# as follows (no bulletproofing is needed for an inverse tangent):
#
# dlon = lon2 - lon1
# dlat = lat2 - lat1
# a = (sin(dlat/2))^2 + cos(lat1) * cos(lat2) * (sin(dlon/2))^2
# c = 2 * atan2( sqrt(a), sqrt(1-a) )
# d = R * c
#

# Distance
#
$dlon = $lon2 - $lon1;
$dlat = $lat2 - $lat1;

$a = ((sin (deg2rad $dlat / 2)) ** 2) + ((cos (deg2rad $lat1) * cos (deg2rad $lat2)) * ((sin (deg2rad $dlon / 2)) ** 2));

# Radius of the earth based on latitude
#
$radius = (6378 - (21 * sin((deg2rad($lat1) + deg2rad($lat2)) / 2)));

$distance = (2 * atan2(sqrt $a, sqrt(1 - $a))) * $radius;

# Bearing
#
$LAT1 = deg2rad $lat1;
$LNG1 = deg2rad $lon1;
$LAT2 = deg2rad $lat2;
$LNG2 = deg2rad $lon2;
$DIFF = $LNG2 - $LNG1;

$CBETA = (sin($LAT1) * sin($LAT2)) + (cos($LAT1) * cos($LAT2) * cos($DIFF));

$BETA = acos($CBETA);

$DISTSP = $BETA * $radius;

$COSAZ = (sin($LAT2) - (sin($LAT1) * cos($BETA))) / (cos($LAT1) * sin($BETA));

if ($COSAZ > 0.999999) {
  $AZ = 0;
}
elsif ($COSAZ < -0.999999) {
  $AZ = 180;
}
else {
  $AZ = rad2deg (acos $COSAZ);
}

if (sin $DIFF >= 0) {
  $AZSP = $AZ;
  $AZLP = 180 + $AZ;
}
else {
  $AZSP = 360 - $AZ;
  $AZLP = 180 - $AZ;
}

# Make all pretty
#
$distance_mi = sprintf "%.3f", $distance / 1.609344;
$distance = sprintf "%.3f", $distance;

$radius_mi = sprintf "%.3f", $radius / 1.609344;
$radius = sprintf "%.3f", $radius;

$lat1 = sprintf "%.5f", $lat1;
$lon1 = sprintf "%.5f", $lon1;
$lat2 = sprintf "%.5f", $lat2;
$lon2 = sprintf "%.5f", $lon2;

$AZSP = sprintf "%.3f", $AZSP;
$AZLP = sprintf "%.3f", $AZLP;

$date = scalar gmtime;

# Draw me a web page
#
$b = "<font color=\"blue\">";
$r = "<font color=\"red\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Distance &amp; Bearing Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>Distance &amp; Bearing Results</h2>

<hr noshade>
<img src="$pic" alt="[distance]">
</center>

<hr noshade>
<pre>
    $b Latitude of site A : $e$lat1$b degrees $e
   $b Longitude of site A : $e$lon1$b degrees $e
<br>
    $b Latitude of site B : $e$lat2$b degrees $e
   $b Longitude of site B : $e$lon2$b degrees $e
<br>
$r Distance between sites : $e$distance$r kilometers ($e$distance_mi$r statute miles) $e
  $r Radius of Earth used : $e$radius$r kilometers ($e$radius_mi$r statute miles) $e
<br>
   $p Azimuth from A to B : $e$AZSP$p degrees East of North $e
   $p Azimuth from B to A : $e$AZLP$p degrees East of North $e
</pre>

<hr noshade size="5">

<blockquote>
<ul>
<li>Calculated distances are great circle routes, and are not very accurate for long paths.</li>

<li>Azimuth (bearing) is referenced from true North.</li>

<li>The Earth is flat.</li>
</ul>
</blockquote>

<p><font size="-1">Calculated on $date GMT</font></p>
</body>
</html>
EOF
