' *************************************************************
' *               Liberty Basic Spell-Checker                 *
' *                                                           *
' *   Portions of this code come from Brosco, Carl Gundel's   *
' *   tutorials and Ian Campell. I may have cut and pasted    *
' *   a line or two from someone else, if I did then give     *
' *   them credit also. The algorithm for the suggested       *
' *   words is called "Soundex" and was written in 1918 by    *
' *   M.K. Odell and R.C. Russell. Special thanks to Brosco   *
' *   for his continued encouragment, many ideas and          *
' *   suggestions.                                            *
' *                                                           *
' *************************************************************

' The following variables set the letter values for the Soundex codes
    soundex0$ = "hwaeiouy"
    soundex1$ = "bfpv"
    soundex2$ = "cgjkqsxz"
    soundex3$ = "dt"
    soundex4$ = "l"
    soundex5$ = "mn"
    soundex6$ = "r"

    numA = 14794    'This tells us how many words in the dictionary
    dim list$(10)
    dim sort.list$(10,2)
    dim custom$(100)

' Opens the random access file that contains the dictionary words
    open "alphadat.001" for random as #alphadict len = 20
    field #alphadict, 20 as word1$

' Opens the random access file that contains the Soundex codes
    open "codedata.001" for random as #codedict len = 24   ' open as random access
    field #codedict, 20 as word1$, 4 as soundexcode$

' Opens a custom dictionary or create one if it doesn't exist
    open "custom.dct" for input as #custom
    if eof(#custom) = 0 then [custom.loop]
    close #custom
    goto [make.window]

' Creates an array from the custom dictionary for fast searching
[custom.loop]
    input #custom, text$
    cl=cl+1
    custom$(cl) = text$
    if eof(#custom) = 0 then [custom.loop]
    close #custom

[make.window]
    open "user" for dll as #user    ' used by Timer Ticks routine
    UpperLeftX = INT((DisplayWidth-550)/2)
    UpperLeftY = INT((DisplayHeight-410)/2)
    WindowWidth = 550
    WindowHeight = 410

   nomainwin
    textbox #w.whatWord, 130, 73, 150, 25
    button #w.replace, "Replace", [replace], UL, 290, 73, 120, 25
    button #w.replaceall, "Replace All", [replace.all], UL, 420, 73, 120, 25
    button #w.ignore, "Ignore", [ignore], UL, 290, 128, 120, 25
    button #w.ignoreall, "Ignore All", [ignore.all], UL, 420, 128, 120, 25
    button #w.add, "Add", [add], UL, 290, 183, 120, 25
    button #w.done, "Cancel", [closeWindow], UL, 420, 183, 120, 25
    button #w.findNow, "Suggest", [findNow], UL, 290, 238, 120, 25
    button #w.help, "Help", [help], UL, 420, 238, 120, 25
    listbox #w.suggest, list$(, [selection], 130, 101, 150, 245
    open "Liberty Basic Spell Checker" for graphics_nsb_nf as #w
    print #w, "fill lightgray ; down ; color black ; backcolor lightgray"
    print #w, "font Times_New_Roman_Bold 7 18; place 10 20"
    print #w, "flush"
    print #w, "trapclose [closeWindow]"
    print #w.suggest, "singleclickselect"
    print #w.whatWord,""
    print #w.whatWord,"!setfocus"

    print #w, "down";
    Print #w, "color darkgray ; line 128 71 280 71 ; line 128 71 128 98";
    Print #w, "color white ; line 128 97 280 97 ; line 279 97 279 71";
    Print #w, "color darkgray ; line 128 99 280 99 ; line 128 99 128 346";
    Print #w, "color white ; line 128 345 280 345 ; line 279 345 279 99";
    print #w, "color black; font Times_New_Roman_Bold 12; place  10, 53"
    Print #w, "\Not in Dictionary:"
    Print #w, "place  10, 87": Print #w, "\Replace With:"
    Print #w, "place  10, 120": Print #w, "\Suggestions:"

    print #w, "flush";

' This checks to see if the Enter key was pressed. If it was it will start
' spell checking
[wait.loop]
    OPEN "user"for DLL AS #CatchEnter
    CallDLL #CatchEnter, "GetAsyncKeyState",_
    _VK_RETURN AS short,_
    RESULT AS short
    CLOSE #CatchEnter
    If RESULT<0 Then [findNow]
    Scan
     goto [wait.loop]

[selection]
    print #w.suggest, "selection?"
    input #w.suggest, selected$
    print #w.whatWord, selected$
      goto [wait.loop]

[replace]
      notice "Sorry this feature does not work"
      goto [wait.loop]

[replace.all]
    notice "Sorry this feature does not work"
      goto [wait.loop]

[ignore]
    notice "Sorry this feature does not work"
      goto [wait.loop]

[ignore.all]
    notice "Sorry this feature does not work"
      goto [wait.loop]

' Adds a word to the custom dictionary
[add]
    if chkword$ = "" then [wait.loop]
    if cl < 1 then pad = 1
    if cl = 1 then
     temp.word$ = custom$(1)
      redim custom$(100)
     custom$(1) = temp.word$
    end if
    cl=cl+1
    custom$(cl) = chkword$
    if cl > 1 then sort custom$(,1,cl
    open "custom.dct" for output as #custom
    for cd = 1 to cl
    print #custom, custom$(cd)
    next cd

' search doesn't see last word in array so this is padding
' the 4 z's will make sure it's the last word in the sorted array
    print #custom, "zzzz"

' if this is the first time adding to the custom.dct need to add this padding
    if cl = 1 or pad = 1 then custom$(cl+1) = "zzzz"
    if cl = 1 then sort custom$(,1,2 _
        else sort custom$(,1,cl
    close #custom
    goto [wait.loop]

[help]
    UpperLeftX = INT((DisplayWidth-350)/2)
    UpperLeftY = INT((DisplayHeight-180)/2)
    WindowWidth = 350
    WindowHeight = 180

    open "Liberty Basic Spell Checker Help" for graphics_nsb as #help
    print #help, "trapclose [closeHelp]"
    print #help, "color black; font Times_New_Roman_Bold 12; place  5, 20"
    Print #help, "\Enter the word you want to check in the " + chr$(13) + _
    "Replace With: box and click on [Suggest]" + chr$(13) + _
    " or press [Enter]"
    Print #help, "place  5, 100"
    Print #help, "\If a word is not in the dictionary " + chr$(13) + _
    "you can click on [Add] to add it."

[Help.Loop]
    input waithelp$
    goto [Help.Loop]

[closeHelp]
    close #help
      goto [wait.loop]



[findNow]
    print #w.whatWord, "!contents?"
    input #w.whatWord, chkword$
    if chkword$ = "" then
      print #w.whatWord, "!setfocus"
      goto [wait.loop]
    end if
    print #w.whatWord, ""

' The Binary Search for speed freaks!

    gosub [ticks]
    StartTime = ticks.result     'record start time

    numFound = 0
    StartTime$ = time$()     'record start time
        search.a$ = chkword$    'create a search string
        gosub [checkword]
        if search.fnd = 0 then gosub [noneFound]

    gosub [ticks]               ' record the finish time
    EndTime = ticks.result
    elapsedTime = (EndTime - StartTime) / 1000    'convert ticks to seconds
    print #w, "color black; place 50 20"
    print #w, "\Time taken for Search = "; elapsedTime; space$(100)

    goto [wait.loop]

[closeWindow]       'close everything and quit
    close #user
    close #w
    close #alphadict
    close #codedict
    end

[ticks]         'Returns the number of milliseconds that the search
                'has been running
    calldll #user, "GetTickCount",_
           ticks.result as long
    return

[checkword]

    search.top = numA                    ' Set the top of the array
    search.bot = 1                       ' set the bottom of the array
    search.mp = int(numA / 2)            ' set the midpoint of the array

    search.fnd = 0
    search.done = 0

' Remember that "word$" is a resevered variable in Liberty Basic
    while search.done = 0                ' search until done = -1
     gettrim #alphadict, search.mp          ' Gets word1$ from alphadat.001
        if search.a$ > word1$ then          ' calc new midpoint
           search.bot = search.mp
            search.mp = int((search.mp+search.top) / 2)
        else
            if search.a$ < word1$ then      ' calc new midpoint
                search.top = search.mp
                search.mp = int((search.mp+search.bot) / 2)
            else                                       ' Aha! we found it
                search.done = -1
                search.fnd = search.mp
                end if
             end if
        if search.mp = search.bot then search.done = -1  ' Doesnt exist!
        wend
        if search.mp = search.bot then [custom.search]

    redim list$(10)
    list$(0) = "Valid Spelling"
    print #w.whatWord, word1$
    print #w.suggest, "reload"
    print #w, "color black; font MS_Sans_Serif 20; place  153, 53"
    Print #w, "|";space$(25)
    print #w, "flush"
    return

' If word was not in dictionary checks the custom dictionary
[custom.search]
    if cl = 1 then search.top = 2 _
        else search.top = cl                    ' Set the top of the array
    search.bot = 1                       ' set the bottom of the array
    search.mp = int(cl / 2)            ' set the midpoint of the array

    search.fnd = 0
    search.done = 0

    while search.done = 0                ' search until done = -1
        if search.a$ > custom$(search.mp) then          ' calc new midpoint
           search.bot = search.mp
            search.mp = int((search.mp+search.top) / 2)
        else
            if search.a$ < custom$(search.mp) then      ' calc new midpoint
                search.top = search.mp
                search.mp = int((search.mp+search.bot) / 2)
            else                                       ' Aha! we found it
                search.done = -1
                search.fnd = search.mp
                end if
             end if
        if search.mp = search.bot then search.done = -1  ' Doesnt exist!
        wend
    if search.a$ = custom$(search.top) then search.fnd = search.top
    if search.a$ = custom$(search.mp) then search.fnd = search.mp
        if search.fnd < 1 then [suggest]

    redim list$(10)
    list$(0) = "Valid Spelling"
    print #w.whatWord, chkword$
    print #w.suggest, "reload"
    print #w, "color black; font MS_Sans_Serif 20; place  153, 53"
    Print #w, "|";space$(25)
    print #w, "flush"
    return

' Converts word not found in the dictionary to a Soundex code
' Read the Soundex.txt file to see how a word is converted
[suggest]
    suspect1$ = chkword$
    suspect1$ = lower$(suspect1$)
    word.len  = len(suspect1$)
    first.let$ = left$(suspect1$, 1)    'keeps first letter intact
    after1$ = mid$(suspect1$, 2)

[remove.hw&nonalpha]    ' Remove h's, w's and non-alpha characters
    hw$ = "hw"
    newchar$ = ""
    for trim = 1 to len(after1$)
    char$ = mid$(after1$, trim, 1)
    if (asc(char$)<97 or asc(char$) > 122) then char$ = ""
    if instr(hw$, char$) then char$ = ""
    newchar$ = newchar$ + char$
    next trim
    suspect$ = first.let$ + newchar$

' Convert the word to a Soundex code
    soundexcode$ = ""
    lastCodeLttr$ = ""
    for get.code = 1 to word.len
    newCodeLttr$ = ""
    letter$ = mid$(suspect1$, get.code, 1)
    if instr(soundex0$, letter$) then newCodeLttr$ = newCodeLttr$ + "0"
    if instr(soundex1$, letter$) then newCodeLttr$ = newCodeLttr$ + "1"
    if instr(soundex2$, letter$) then newCodeLttr$ = newCodeLttr$ + "2"
    if instr(soundex3$, letter$) then newCodeLttr$ = newCodeLttr$ + "3"
    if instr(soundex4$, letter$) then newCodeLttr$ = newCodeLttr$ + "4"
    if instr(soundex5$, letter$) then newCodeLttr$ = newCodeLttr$ + "5"
    if instr(soundex6$, letter$) then newCodeLttr$ = newCodeLttr$ + "6"
    if newCodeLttr$ = lastCodeLttr$ then [set.last.code] 'combine any
    soundexcode$ = soundexcode$ + newCodeLttr$

[set.last.code]
    lastCodeLttr$ = newCodeLttr$
    next get.code

[remove.0s]
    newnum$ = ""
    first.num$ = left$(soundexcode$, 1)
    after1num$ = mid$(soundexcode$, 2)
    zero$ = "0"
    for trim0 = 1 to len(after1num$)
    num$ = mid$(after1num$, trim0, 1)
    if instr(zero$, num$) then num$ = ""
    newnum$ = newnum$ + num$
    next trim0
    soundexcode$ = first.num$ + newnum$
    if len(soundexcode$) > 4 then soundexcode$ = left$(soundexcode$, 4) _
    else [add0s]
    search.b$ = soundexcode$
    goto [suggest.search]

' Make sure the code is 4 characters long
[add0s]
    code.len = 4 - len(soundexcode$)
    for addOn = 1 to code.len
    soundexcode$ = soundexcode$ + "0"
    next addon
    search.b$ = soundexcode$
    goto [suggest.search]

' Finds similar words
[suggest.search]

    search.top = numA                    ' Set the top of the array
    search.bot = 1                       ' set the bottom of the array
    search.mp = int(numA / 2)            ' set the midpoint of the array

    search.fnd = 0
    search.done = 0

    while search.done = 0                ' search until done = -1
 gettrim #codedict, search.mp
        if search.b$ > soundexcode$ then          ' calc new midpoint
           search.bot = search.mp
            search.mp = int((search.mp+search.top) / 2)
        else
            if search.b$ < soundexcode$ then      ' calc new midpoint
                search.top = search.mp
                search.mp = int((search.mp+search.bot) / 2)
            else                                       ' Aha! we found it
                search.done = -1
                search.fnd = search.mp
                end if
             end if
        if search.mp = search.bot then search.done = -1  ' Doesnt exist!
        wend
       if search.mp <> search.bot then [get.suggestions]

    redim list$(10)
    list$(0) = "No Suggestions"
    print #w.suggest, "reload"
    return

[get.suggestions]
    redim list$(200)
    xss = 0
    search.sug = search.mp

' Gets all the words with the same Soundex code
[suggest.downloop]
    gettrim #codedict, search.sug
    if search.b$ <> soundexcode$ then [suggest.uploop]
    list$(xss) = word1$
    xss = xss + 1
    search.sug = search.sug + 1
    goto [suggest.downloop]

[suggest.uploop]
    search.sugb = search.mp - 1

[suggest.uploopSub]
    gettrim #codedict, search.sugb
    if search.b$ <> soundexcode$ then [uploop.done]
    list$(xss) = word1$
    xss = xss + 1
    search.sugb = search.sugb - 1
    goto [suggest.uploopSub]

[uploop.done]
    fn = 0
    nf = 0
    cw.len = len(chkword$)
    loop = cw.len - 1
    redim sort.list$(xss,2)

' Assign priorty based on how close the words match the mis-spelled word
[sort.sugg]
    found$ = list$(fn)
    if len(found$) < 1 then [sort.sugg.done]
    f.len = len(found$)
    for pri = 0 to loop
    firstCW$ = mid$(chkword$,pri + 1,1)
    lastCW$ = mid$(chkword$,cw.len - pri,1)
    firstF$ = mid$(found$,pri + 1,1)
    lastF$ = mid$(found$,f.len - pri,1)
    if (firstCW$ = firstF$ or lastCW$ = lastF$) then priority = priority + 1
    if (firstCW$ = firstF$ and lastCW$ = lastF$) then priority = priority + 1
    if pri = f.len then pri = loop
  next pri

[set.priority]
    if priority <= 0 then
    fn = fn + 1
  else
    if len(str$(priority)) < 2 then pri$ = "0" + str$(priority)_
    else pri$ = str$(priority)
    nf = nf + 1
    sort.list$(nf,1) = list$(fn)
    sort.list$(nf,2) = pri$
    fn = fn + 1
    priority = 0
    end if
        goto [sort.sugg]

' Take the words found in the dictionary and offer them as suggestions
[sort.sugg.done]
    if nf = 0 then [noneFound]
    if nf > 1 then sort sort.list$(, 1, nf, 2
    redim list$(nf)
    ssl = 0
    for lss = nf to 0 step -1
    list$(ssl) = sort.list$(lss,1)
    ssl = ssl + 1
    next lss
      print #w.suggest, "reload"

' Put the closes match in the Replace with box
[done.select]
    index1$ = str$(1)
    index2$ = "selectindex "
    index3$ = index2$ + index1$
    print #w.suggest, index3$
    print #w.suggest, "selection?"
    input #w.suggest, selected$
    print #w.whatWord, selected$
    print #w, "color black; font MS_Sans_Serif 20; place  153, 53"
    Print #w, "|";chkword$; space$(25)
    print #w, "flush"
    print #w.suggest, "setfocus"
    return

[none.Found]
    redim list$(10)
    list$(0) = "No Suggestions"
    print #w.suggest, "reload"
    print #w, "color black; font MS_Sans_Serif 20; place  153, 53"
    Print #w, "|";chkword$; space$(25)
    print #w, "flush"
    print #w.whatWord, "!setfocus"
    return

