DEFDBL A-Z: pi = 4 * ATN(1)
menu: CLS
PRINT "FILXTAL.BAS Jul/2004"
PRINT "Pulse 1 para calcular el modelo de un cristal a partir de mediciones"
PRINT "      2 para dise#ar un filtro segun articulo de QST Noviembre 1980"
resp$ = INPUT$(1)
SELECT CASE resp$
  CASE IS = "1": GOSUB ConvertirMedicionesAModelo
  CASE IS = "2": GOSUB CalculoFiltro
  CASE ELSE: GOTO menu
END SELECT
END

ConvertirMedicionesAModelo:
PRINT "Convertir mediciones sobre un cristal o resonador ceramico a su modelo"
PRINT
PRINT "+--Rg--+-----+   1) Arme este circuito, comience con Rg = unos 100ohm  "
PRINT "|      |     |   2) Busque la f que da salida minima, llamela fser     "
PRINT "|    +-+-+   |   3) Calcule Atx=Vg/Vsal (da >1) o bien AtDB=20*log(Atx)"
PRINT "|    |   L   |   4) Si Atx es muy grande o chica, repita con otra Rg   "
PRINT "Vg   Cp  C  Vsal 5) Calcule BW=distancia entre puntos en que sube 3dB  "
PRINT "|    |   R   |   6) Permute xtal y Rg, busque la f que da salida minima"
PRINT "|    +-+-+   |   7) Calcule su distancia con resp. a fser, llamela dist"
PRINT "|      |     |   8) Ingrese estos datos en el programa editando el .BAS"
PRINT "+------+-----+   9) Se obtendran las incognitas del modelo L, C, R y Cp"
pi = 4 * ATN(1): mega = 1000000
'COLOCAR AQUI LOS DATOS:
 AtDB = 20     'Si sabe la at. en dB, ponerla; si no, ingresar un 0 aqui
  Atx = 10     'Si sabe la at. en veces, ponerla; si no, poner cualquier cosa
   Rg = 118    'ohm   OJO: debe incluir la del generador y considerar el detector
 fser = .434   'MHz
   BW = 480    'Hz
 dist = 20000  'Hz
'Calculos previos: todo se pasa a:  ohm  Mrad/s  uH  uF  veces
IF AtDB <> 0 THEN Atx = 10 ^ (AtDB / 20)
   wB = 2 * pi * BW / mega
wdist = 2 * pi * dist / mega
 wser = 2 * pi * fser
    R = Rg / (Atx - 1)
    L = SQR(2 * (Rg ^ 2 + 2 * Rg * R) / (Atx ^ 2 - 1) - R ^ 2) / wser / (1 - (1 - wB / 2 / wser) ^ 2)
    C = 1 / L / wser ^ 2
   Cp = C / ((1 + (wdist / wser)) ^ 2 - 1)
PRINT
PRINT "DATOS:      At ="; Atx; "veces = "; 20 * LOG(Atx) / LOG(10); "dB"
PRINT "    fser [MHz] ="; fser
PRINT "     dist [Hz] ="; dist
PRINT "BW @ +3dB [Hz] ="; BW
PRINT "      Rg [ohm] ="; Rg; "(paralelo de la R generador y R medidor)"
PRINT : PRINT "VALORES DEL MODELO:"
PRINT "       R [ohm] ="; R
PRINT "        L [uH] ="; L
PRINT "        C [pF] ="; C * mega
PRINT "       Cp [pF] ="; Cp * mega; "(vale para fpar-fser >> BW)"

'Ejemplo para verificar el programa:
' At [veces] = 10          fser [MHz] = .45500
'  dist [Hz] = 15000   BW @ +3dB [Hz] = 1000
'   Rg [ohm] = 100    
'    R [ohm] = 11.111          L [uH] = 1769.3
'     C [pF] = 69.151         Cp [pF] = 1031.7
RETURN

CalculoFiltro:
'****** Editar la siguiente linea para ingresar los valores de f, n y Cii **********
proto: f = 8.867: n = 6: Cii = 33   'filtro xtales PAL B, comienzo del dise#o
'Para la 1a vez se sugiere usar tres capacitores de 33pF
R = 613000 / 2 / pi / f / Cii
CLS
PRINT USING "Datos que necesita saber el      frecuencia de los cristales = ##.####MHz"; f
PRINT USING "programa (editar linea 'proto'             cantidad de polos =  #"; n
PRINT USING "en el .BAS para cambiarlos):      capacitores para la prueba = ###.##pF"; Cii
PRINT STRING$(79, "*")
PRINT USING "Arme este     +--###.##pF--X--+--X--###.##pF--+   (cada X es un cristal)"; Cii; Cii
      PRINT " circuito     |               |               |           "
PRINT USING "de prueba  ###.##ohm      ###.##pF         ###.##ohm      "; R; Cii; R
      PRINT "y mida el     |               |               |           "
PRINT USING "BW @ 3dB:     +---------------+---------------+   f=##.###MHz"; f
PRINT
PRINT "Si el circuito de prueba da el BW @ 3dB deseado, este sera el final:"
PRINT
C = Cii / .613
ON n GOSUB 0, 0, 3, 4, 0, 6, 0, 8
PRINT "Si no:"
PRINT "- Calcular Cnuevos = Canteriores * (BW3dBmedido / BW3dBdeseado)."
PRINT "- Colocar el valor de Cnuevos en la linea 'proto'. Volver a correr el programa."
PRINT "- Observar el nuevo valor de resistencias que de. "
PRINT "- Rehacer el circuito de prueba con las nuevas R y C, medir BW, etc."
0 : RETURN

3 : Cs1 = .701 * C: C1 = .701 * C
PRINT USING "  +----###.#-----X---+------X-------+---X---###.#------+ "; Cs1; Cs1
      PRINT "  |      pF          |              |         pF       | "
PRINT USING "###.#              ###.#          ###.#             ###.#"; R; C1; C1; R
      PRINT " ohm                pF             pF                 ohm"
      PRINT "  |                  |              |                  | "
      PRINT "  +------------------+--------------+------------------+ "
RETURN

4 : Cs1 = .827 * C: C1 = .712 * C: C2 = .827 * C
PRINT USING "  +---###.# --X--+-----X-----+-----X-----+--X--###.# ---+ "; Cs1; Cs1
      PRINT "  |     pF       |           |           |       pF     | "
PRINT USING "###.#          ###.#       ###.#       ###.#         ###.#"; R; C1; C2; C1; R
      PRINT " ohm            pF          pF          pF             ohm"
      PRINT "  |              |           |           |              | "
      PRINT "  +--------------+-----------+-----------+--------------+ "
RETURN

6 : Cs1 = .854 * C: C1 = .716 * C: C2 = .854 * C: Cs3 = 4 * C: C3 = .872 * C
PRINT USING "  +--###.# --X--+---X--+--X--####.# --+--####.# --X--+---X--+--X--###.# --+ "; Cs1; Cs3; Cs3; Cs1
      PRINT "  |    pF       |      |      pF      |    pF        |      |       pF    | "
PRINT USING "###.#        ###.#    ###.#         ###.#         ###.#    ###.#       ###.#"; R; C1; C2; C3; C2; C1; R
      PRINT " ohm           pF     pF             pF             pF     pF            ohm"
      PRINT "  |             |      |              |              |      |             | "
      PRINT "  +-------------+------+--------------+--------------+------+-------------+ "
RETURN

8 : Cs1 = .857 * C: C1 = .716 * C: C2 = .857 * C: Cs3 = 3.79 * C: C3 = .883 * C: Cs4 = 3.28 * C: C4 = .888 * C
PRINT USING " +-###.#--X-+-X-+-X-###.# -+-X-###.#--+-###.# -X-+-###.#--X-+-X-+-X-###.#--+ "; Cs1; Cs3; Cs4; Cs4; Cs3; Cs1
      PRINT " |    pF    |   |     pF   |    pF    |    pF    |    pF    |   |    pF    | "
PRINT USING "###.#    ###.# ###.#     ###.#      ###.#      ###.#     ###.# ###.#    ###.#"; R; C1; C2; C3; C4; C3; C2; C1; R
      PRINT "ohm        pF  pF         pF         pF         pF         pF   pF        ohm"
      PRINT " |          |   |          |          |          |          |   |          | "
      PRINT " +----------+---+----------+----------+----------+----------+---+----------+ "
RETURN

