{$M $1000,0,0} { limit stack and heap sizes }
{$N+,F+}
{*-------------------------------------------------------------------------*}
{* PktRoute                               by P.E.Colla -1994-              *}
{* Packet Mail Route Analyzer for AX.25 Network                            *}
{*-------------------------------------------------------------------------*}
{$M $8000,$1000,$1000}
{$V-}
Program PktRoute;

Uses Crt,Dos;

  Type
     Str1           =   String[001];
     Str2           =   String[002];
     Str3           =   String[003];
     Str4           =   String[004];
     Str6           =   String[006];
     Str8           =   String[008];
     Str16          =   String[016];
     Str32          =   String[032];
     Str64          =   String[064];
     Str80          =   String[080];
     Str128         =   String[128];
     Str255         =   String[255];

  Const
     DOSIdle        =   $28;
     DOSApi         =   $21;
     NUL            =   $00;
     CR             =   $0D;
     LF             =   $0A;
     CTLC           =   $03;
     CTLZ           =   $1A;
     EXIT_OK        =   $00;
     EXIT_DISC      =   $01;
     EXIT_NOACK     =   $02;
     EXIT_NOC       =   $00;
     EXIT_ABEND     =   $08;
     EXIT_TNCHANG   =   $10;
     ARRAYMAX       =   128;
     TIMER_ANSWER   =   $01;
     TIMER_SLEEP    =   $02;
     TIMER_WAIT     =   $03;
     TIMER_WASTE    =   $04;
     TIMER_GETCHAR  =   $05;
     BUFFER_LIMIT   =   128;
     TNCTIMEOUT     =   720;
     CONNTIMEOUT    =   720;
     GETCHARTIMEOUT =  1800;
     REPLYTIMEOUT   =  3600;
     FBBTIMEOUT     =  3600;
     MAXTRIES       =    04;
     TNCSAMPLE      =   360;
     RETRYCNTMAX    =    03;
     EOT            =   $04;
     STX            =   $02;
     SOH            =   $01;
     STDIN          =   $00;
     STDOUT         =   $01;

  Var

     MailGroup      :   Str255;
     MailDir        :   Str255;
{*   DirInfo        :   SearchRec;  *}
     BinFile        :   File;
     BinRPtr        :   Word;
     BinWPtr        :   Word;
     BinBuffer      :   Array [1..2048] of Char;

     Origin         :   Array [1..600] of Str6;
     MailVolume     :   Array [1..600] of LongInt;

     GroupId        :   Array [1..50] of Str8;
     GroupFiles     :   Array [1..50] of LongInt;
     GroupSize      :   Array [1..50] of LongInt;
     Group7P        :   Array [1..50] of Word;
     Group7PS       :   Array [1..50] of LongInt;


     QNet           :   LongInt;
     QFiles         :   LongInt;
     Index          :   Word;

     PathCall       :   Array [1..600] of Str6;
     PathDate       :   Array [1..600] of Str8;
     PathTime       :   Array [1..600] of Str8;

     OrigId         :   Array [1..600] of Str6;
     OrigSize       :   Array [1..600] of LongInt;
     OrigHops       :   Array [1..600] of LongInt;
     OrigTime       :   Array [1..600] of LongInt;
     OrigFiles      :   Array [1..600] of LongInt;
     Orig7PFiles    :   Array [1..600] of Word;
     Orig7PSize     :   Array [1..600] of LongInt;
     OrigCVFiles    :   Array [1..600] of Word;
     OrigCVSize     :   Array [1..600] of LongInt;

     NetFrom        :   Array [1..600] of Str6;
     NetTo          :   Array [1..600] of Str6;
     NetSize        :   Array [1..600] of LongInt;
     NetFiles       :   Array [1..600] of LongInt;
     NetTime        :   Array [1..600] of LongInt;

     MailFile       :   Text;
     MailStr        :   Str255;

     Is7Plus        :   Boolean;
     IsCV           :   Boolean;
     HCNStr         :   Str255;

{*-------------------------------------------------------------------------*}
{*                       SECONDARY ROUTINES                                *}
{*-------------------------------------------------------------------------*}
{*-------------------------------------------------------------------------*}
{* UpCaseStr                                                               *}
{* This routine forces uppercase on a string                               *}
{*-------------------------------------------------------------------------*}
Function UpCaseStr (Token : Str255 ) : Str255;
  var
    MyIndex     :    word;
    FakeStr     :    Str128;

begin { UpCaseStr }
      UpCaseStr := '';
      FakeStr   := '';
      MyIndex   := 1;
      Repeat
         FakeStr   := FakeStr   + UpCase(Token[MyIndex]);
         MyIndex   := MyIndex + 1;
      until MyIndex >  Length(Token) ; {endrepeat}
      UpCaseStr := FakeStr ;
end; { UpCaseStr }
{*-------------------------------------------------------------------------*}
{* ReadBinStr                                                              *}
{* This function reads a binary file into a CR/LF String                   *}
{*-------------------------------------------------------------------------*}
Function ReadBinStr (Var FileStr : Str255) : Boolean;

  Label
    GetBinChar;

  Var
    AuxStr      :       Str255;
    BinChar     :       Char;
    ReadIn      :       Word;
    FakeFlag    :       Boolean;

begin { ReadBinStr }
    AuxStr := '';
    FakeFlag := FALSE;

    While FakeFlag = FALSE do begin

       If BinRPtr < BinWPtr then begin
GetBinChar:
          BinChar := BinBuffer[BinRPtr];
          BinRPtr := BinRPtr + 1;

          If BinChar = Chr(LF) then begin
             FileStr    := AuxStr;
             ReadBinStr := TRUE;
             Exit;
          end; {endif}

          If BinChar <> Chr(CR) then begin
             AuxStr := AuxStr + BinChar;
          end; {endif}

          If BinRPtr = BinWPtr then begin
             Goto GetBinChar
          end; {endif}

       end else begin

          If EOF(BinFile) then begin
             FileStr    := AuxStr;
             ReadBinStr := FALSE;
             Exit;
          end; {endif}

          BlockRead (BinFile,BinBuffer,1024,ReadIn);
          BinWPtr := ReadIn;
          BinRPtr := 1;

          If BinWPtr = 1 then begin
             Goto GetBinChar;
          end; {endif}

       end; {endif}

    end; {endwhile}


end; { ReadBinStr }
{*-------------------------------------------------------------------------*}
{* PadStr                                                                  *}
{* This function pads a string adding blanks to the right                  *}
{*-------------------------------------------------------------------------*}
Function PadStr( OrigStr : Str255; Num : Word) : Str255;
  Var
    Index       :       Word;
    AuxStr      :       Str255;
    EndFlag     :       Boolean;

begin { PadStr }

  AuxStr := OrigStr;
  EndFlag := FALSE;
  While EndFlag  = FALSE do begin
    If Length(AuxStr) >=  Num then begin
       PadStr := AuxStr;
       Exit;
    end else begin
       AuxStr := AuxStr + ' ';
    end; {endif}
  end; {endwhile}

end; { PadStr }
{*-------------------------------------------------------------------------*}
{* PutStdOut                                                               *}
{* This routine writes a String thru the Standard Output                   *}
{*-------------------------------------------------------------------------*}
Procedure PutStdOut (StdStr : Str255 ) ;

  Var
    regs        :       Registers;
    OutBuffer   :       Str255;

begin { PutStdOut }
  OutBuffer:= StdStr+Chr(CR)+Chr(LF);

  Regs.DS  := seg(OutBuffer);
  Regs.DX  := ofs(OutBuffer)+1;
  Regs.BX  := STDOUT;
  Regs.CX  := Length(OutBuffer);
  Regs.AH  := $40;
  Regs.AL  := $00;
  MSDOS(Regs);

end; { PutStdOut }
{*-------------------------------------------------------------------------*}
{* PopBang                                                                 *}
{* Extract an address stacked with the 'Bang' criteria                     *}
{*-------------------------------------------------------------------------*}
Function PopBang (Var FullAddr : Str255 ; Delimiter : Char) : Str255;
  Var
    Index       :       Word;
    AuxStr      :       Str255;

begin { PopBang }

    AuxStr := '';
    For Index := 1  to Length(FullAddr)  do begin
       If FullAddr[Index] = Delimiter then begin
          If Length(Copy(FullAddr,Index+1,Length(FullAddr))) > 1 then begin
             FullAddr := Copy(FullAddr,Index+1,Length(FullAddr));
          end else begin
             FullAddr := '';
          end; {endif}
          PopBang  := AuxStr;
          Exit;
       end else begin
          AuxStr := AuxStr + FullAddr[Index];
       end; {endif}
    end; {endfor}
    FullAddr := '';
    PopBang  := AuxStr;

end; { PopBang }
{*-------------------------------------------------------------------------*}
{* Parse                                                                   *}
{* This routine parses a string of character returning the first           *}
{*-------------------------------------------------------------------------*}
Function Parse (Var ParseStr : Str255) : Str255;
  Var
    Index       :       Word;
    AuxParse    :       Str255;
    AuxArgs     :       Str255;
    AuxCmmd     :       Str255;
    AuxFlag     :       Boolean;

begin { Parse }

    If Length(ParseStr) = 0 then begin
       Parse := '';
       Exit;
    end; {endif}
    AuxParse := ParseStr;
    AuxCmmd  := '';
    AuxArgs  := '';

    If AuxParse[Length(ParseStr)] = Chr(CR) then begin
       AuxParse := Copy(AuxParse,1,Length(AuxParse)-1);
    end; {endif}

    Index := 1;
    AuxFlag := FALSE;

    While AuxFlag = FALSE do begin
      If AuxParse[Index] <> ' ' then begin
         AuxFlag := TRUE;
      end else begin
         Index := Index + 1;
      end; {endif}
      If Index > Length(AuxParse) then begin
         ParseStr := '';
         Parse    := '';
         Exit;
      end; {endif}
    end; {endwhile}

    AuxFlag := FALSE;

    While AuxFlag = FALSE do begin
      If AuxParse[Index] = ' ' then begin
         AuxFlag := TRUE;
      end else begin
        AuxArgs := AuxArgs + AuxParse[Index];
        Index := Index + 1;
      end; {endif}
      If Index > Length(AuxParse) then begin
         ParseStr := '';
         Parse    := AuxArgs;
         Exit;
      end; {endif}
    end; {endwhile}

    AuxFlag := FALSE;

    While AuxFlag = FALSE do begin
      If AuxParse[Index] <> ' ' then begin
         AuxFlag := TRUE;
      end else begin
         Index := Index + 1;
      end; {endif}
      If Index > Length(AuxParse) then begin
         ParseStr := '';
         Parse    := AuxArgs;
         Exit;
      end; {endif}
    end; {endwhile}

    ParseStr := Copy(AuxParse,Index,Length(AuxParse));
    Parse    := AuxArgs;

end; { Parse }
{*-------------------------------------------------------------------------*}
{* ExtractR                                                                *}
{* Procedure to extract relevant data on the R: record                     *}
{*-------------------------------------------------------------------------*}
Procedure ExtractR(RStr : Str255; Var CallId : Str255; Var DateStr : Str8 ; Var TimeStr : Str8);
  Var
    AuxStr      :       Str255;
    AuxStr2     :       Str255;
    AuxStr3     :       Str255;

begin { ExtractR }

    AuxStr2     := RStr;
    If AuxStr2[3] = ' ' then begin
       AuxStr2 := AuxStr2[1]+AuxStr2[2]+Copy(AuxStr2,4,Length(AuxStr2)-3);
    end; {endif}
    AuxStr      := Parse(AuxStr2);
    AuxStr3     := PopBang(AuxStr,':');
    DateStr     := PopBang(AuxStr,'/');
    TimeStr     := AuxStr;
    AuxStr3     := PopBang(AuxStr2,'@');
    CallId      := PopBang(AuxStr2,'.');
    If CallId[1] = ':' then begin
       CallId := Copy(CallId,2,Length(CallId)-1);
    end; {endif}

end; { ExtractR }
{*-------------------------------------------------------------------------*}
{* StorePath                                                               *}
{* Procedure to store the path  of a given mail/bulletin                   *}
{*-------------------------------------------------------------------------*}
Procedure StorePath (PathStr : Str255);
  Var
    Index       :       Word;
    CallId      :       Str6;
    DateMail    :       Str8;
    TimeMail    :       Str8;

begin { StorePath }
    ExtractR(PathStr,CallId,DateMail,TimeMail);
    For Index := 1  to 600  do begin
        If PathCall[Index] = '' then begin
           PathCall [Index] := CallId;
           PathDate [Index] := DateMail;
           PathTime [Index] := Timemail;
           Exit;
        end; {endif}
    end; {endfor}
    WriteLn('*** ERROR *** Temporary table Path full, Aborting.');
    Halt(16);

end; { StorePath }
{*-------------------------------------------------------------------------*}
{* SearchStart                                                             *}
{* Function to extract the starting point                                  *}
{*-------------------------------------------------------------------------*}
Function SearchStart : Str6;
  Var
    Index       :       Word;

begin { SearchStart }

    For Index := 1  to 600  do begin
       If PathCall[Index] = '' then begin
          SearchStart := PathCall[Index-1];
          Exit;
       end; {endif}
    end; {endfor}
    SearchStart := '';

end; { SearchStart }
{*-------------------------------------------------------------------------*}
{* SearchHops                                                              *}
{* Function to extract the number of hops of a path                        *}
{*-------------------------------------------------------------------------*}
Function SearchHops : LongInt;
  Var
    Index       :       Word;
    QHops       :       Word;

begin { SearchHops }

    QHops := 0;
    For Index := 1  to 600  do begin
       If PathCall[Index] = '' then begin
          SearchHops := QHops;
          Exit;
       end; {endif}
       QHops := QHops + 1;
    end; {endfor}
    SearchHops := 600;

end; { SearchHops }
{*-------------------------------------------------------------------------*}
{* AddTime                                                                 *}
{* Function to compute the addition of time in  hours                      *}
{*-------------------------------------------------------------------------*}
Procedure AddTime (Var Year: Word;Var Month : Word; Var Day: Word; Var Hour: Word;
                   Var Min: Word; Delta : Integer);
  Var
    AuxHour     :       Integer;

begin { AddTime }

    If Delta  = 0 then begin
       Exit;
    end; {endif}

    If Delta  > 0  then begin
       Hour := Hour  +  Delta;
       If Hour > 24 then begin
          Hour  := Hour  - 24;
          Day   := Day  +  1;
          If Day  > 30 then begin
             Day := 1;
             Month :=  Month + 1;
             If Month >  12 then begin
                Month := 1;
                Year  := Year +  1;
             end; {endif}
          end; {endif}
          Exit;
       end; {endif}
    end; {endif}

    AuxHour := Hour;

    AuxHour := AuxHour + Delta;
    If AuxHour < 0 then begin
       AuxHour := AuxHour + 24;
       If Day = 1 then begin
          Day := 30;
          If  Month = 1 then begin
              Month := 12;
              Year  := Year - 1;
              Exit;
          end else begin
              Month := Month - 1 ;
              Exit;
          end; {endif}
       end else begin
          Day := Day - 1;
          Exit;
       end; {endif}
    end; {endif}

end; { AddTime }
{*-------------------------------------------------------------------------*}
{* ComputeLap                                                              *}
{* Function to compute the difference between two dates/times              *}
{*-------------------------------------------------------------------------*}
Function ComputeLap (FromDate:  Str8;FromTime: Str8;ToDate: Str8;ToTime: Str8) : LongInt;
  Var
    YrFrom      :       Word;
    MoFrom      :       Word;
    DyFrom      :       Word;
    HrFrom      :       Word;
    MnFrom      :       Word;
    YrTo        :       Word;
    MoTo        :       Word;
    DyTo        :       Word;
    HrTo        :       Word;
    MnTo        :       Word;
    EC          :       Word;
    LongFrom    :       LongInt;
    LongTo      :       LongInt;
    AuxLong     :       LongInt;
begin { ComputeLap }

    Val(Copy(FromDate,1,2),YrFrom,EC);
    Val(Copy(FromDate,3,2),MoFrom,EC);
    Val(Copy(FromDate,5,2),DyFrom,EC);
    Val(Copy(FromTime,1,2),HrFrom,EC);
    Val(Copy(FromTime,3,2),MnFrom,EC);

    If UpCaseStr(Copy(FromTime,5,1)) = 'Z' then begin
       AddTime(YrFrom,MoFrom,DyFrom,HrFrom,MnFrom,-3);
    end; {endif}


    Val(Copy(ToDate,1,2),YrTo,EC);
    Val(Copy(ToDate,3,2),MoTo,EC);
    Val(Copy(ToDate,5,2),DyTo,EC);
    Val(Copy(ToTime,1,2),HrTo,EC);
    Val(Copy(ToTime,3,2),MnTo,EC);

    If UpCaseStr(Copy(ToTime,5,1)) = 'Z' then begin
       AddTime(YrTo,MoTo,DyTo,HrTo,MnTo,-3);
    end; {endif}

    LongFrom  := (MoFrom - 1) * 30 * 24;
    LongFrom  := (DyFrom - 1) * 24 + LongFrom;
    LongFrom  := (HrFrom) + LongFrom;
    LongFrom  := (YrFrom  - 80 - 1) * 365 * 24 + LongFrom;

    LongTo    := (MoTo   - 1) * 30 * 24;
    LongTo    := (DyTo   - 1) * 24 + LongTo  ;
    LongTo    := (HrTo  ) + LongTo  ;
    LongTo    := (YrTo    - 80 - 1) * 365 * 24 + LongTo  ;

    AuxLong := LongTo - LongFrom;

    If AuxLong < 0 then begin
       AuxLong := 0;
    end; {endif}

    If AuxLong > 1000 then begin
       ComputeLap := 0;
    end else begin
       ComputeLap := AuxLong;
    end; {endif}

end; { ComputeLap }
{*-------------------------------------------------------------------------*}
{* SearchTime                                                              *}
{* Function to extract the average time  to travel  -NOT IMPLEMENTED-      *}
{*-------------------------------------------------------------------------*}
Function SearchTime : LongInt;
  Var
    Index       :       Word;
    FromDate    :       Str8;
    FromTime    :       Str8;
    ToDate      :       Str8;
    ToTime      :       Str8;
    AuxIdx      :       Word;
    AuxLap      :       Longint;

begin { SearchTime }

    ToDate := PathDate[2];
    ToTime := PathTime[2];

    For Index := 2  to 600  do begin
       If PathCall[Index] = '' then begin
          AuxIdx := Index;
          AuxIdx := AuxIdx - 1;
          If AuxIdx > 2 then begin
              FromDate := PathDate[AuxIdx];
              FromTime := PathTime[AuxIdx];
              AuxLap     := ComputeLap(FromDate,FromTime,ToDate,ToTime);
              SearchTime := AuxLap;
              Exit;
          end else  begin
             SearchTime := 1;
             Exit;
          end; {endif}
       end; {endif}
    end; {endfor}

    SearchTime := 0;

end; { SearchTime }
{*-------------------------------------------------------------------------*}
{* StoreOrig                                                               *}
{* Procedure to Store the Origin of a given mail                           *}
{*-------------------------------------------------------------------------*}
Procedure StoreOrig (CallId : Str6; SizeMail : LongInt; Hops : LongInt  ; AvgTime : LongInt);
  Var
    Index       :       Word;

begin { StoreOrig }
    For Index := 1  to 600  do begin
        If OrigId[Index] = '' then begin
           OrigId[Index] := CallId;
           OrigSize[Index] := SizeMail;
           OrigHops[Index] := Hops-1;
           OrigTime[Index] := AvgTime*SizeMail;
           OrigFiles[Index]:= 1;
           If Is7Plus = TRUE then begin
              Orig7PFiles[Index] := Orig7PFiles[Index] + 1;
              Orig7PSize[Index]  := Orig7PSize[Index] + SizeMail;
           end; {endif}
           If IsCV = TRUE then begin
              OrigCVFiles[Index] := OrigCVFiles[Index] + 1;
              OrigCVSize[Index]  := OrigCVSize[Index] + SizeMail;
           end; {endif}
           Exit;
        end else begin
           If UpCaseStr(OrigId[Index]) = UpCaseStr(CallId) then begin
              OrigSize[Index] := OrigSize[Index] + SizeMail;
              OrigHops[Index] := OrigHops[Index] + Hops - 1;
              OrigTime[Index] := OrigTime[Index] + (AvgTime*SizeMail);
              OrigFiles[Index]:= OrigFiles[Index] + 1;
              If Is7Plus = TRUE then begin
                 Orig7PFiles[Index] := Orig7PFiles[Index] + 1;
                 Orig7PSize[Index]  := Orig7PSize[Index] + SizeMail;
              end; {endif}
              If IsCV = TRUE then begin
                 OrigCVFiles[Index] := OrigCVFiles[Index] + 1;
                 OrigCVSize[Index]  := OrigCVSize[Index] + SizeMail;
              end; {endif}
              Exit;
           end; {endif}
        end; {endif}
    end; {endfor}

end; { StoreOrig }
{*-------------------------------------------------------------------------*}
{* StoreNet                                                                *}
{* Procedure to store path pairs on table                                  *}
{*-------------------------------------------------------------------------*}
Procedure StoreNet (FromId:  Str6; ToId  : Str6; MailSize  : LongInt; MailTime : LongInt);

  Var
    Index       :       Word;

begin { StoreNet }

  For Index := 1  to 600  do begin
    If NetFrom[Index] = '' then begin
       NetFrom[Index] := UpCaseStr(FromId);
       NetTo[Index]   := UpCaseStr(ToId);
       NetSize[Index] := MailSize;
       NetTime[Index] := MailSize  * MailTime;
       NetFiles[Index] := 1;
       Exit;
    end else begin
       If UpCaseStr(NetFrom[Index]) = UpCaseStr(FromId) then begin
          If UpCaseStr(NetTo[Index]) = UpCaseStr(ToId) then begin
             NetSize[Index] := NetSize[Index] + MailSize;
             NetTime[Index] := NetTime[Index] + (MailSize  * MailTime);
             NetFiles[Index] := NetFiles[Index] + 1;
             Exit;
          end; {endif}
       end else begin
       end; {endif}
    end; {endif}
  end; {endfor}
end; { StoreNet }
{*-------------------------------------------------------------------------*}
{* ExtractPaths                                                            *}
{* Procedure to extract paths pairs from a given note path                 *}
{*-------------------------------------------------------------------------*}
Procedure ExtractPaths(FileSize : LongInt);
  Var
    Index       :       Word;
    LastIndex   :       Word;
    MailTime    :       LongInt;
    FromDate    :       Str8;
    FromTime    :       Str8;

    ToDate      :       Str8;
    ToTime      :       Str8;
    AuxStr      :       Str1;

begin { ExtractPaths }

    Index := 1;
    While  Index < 600 do begin
      If PathCall[Index] = '' then begin
         LastIndex := Index - 1;
         Index := 999;
      end; {endif}
      Index  := Index + 1;
    end; {endwhile}

    Index  := LastIndex;
    While Index > 0 do begin
      If (Index-1) > 0 then begin
         FromDate := '';
         FromTime := '';
         ToDate   := '';
         ToTime   := '';
         MailTime := 0;
         If (Index+1) <= LastIndex then begin
            FromDate := PathDate[Index+1];
            FromTime := PathTime[Index+1];
            ToDate   := PathDate[Index];
            ToTime   := PathTime[Index];
            MailTime := ComputeLap(FromDate,FromTime,ToDate,ToTime);
            If MailTime < 0 then begin
               MailTime := 0;
            end; {endif}
         end else begin
            MailTime := 0;
         end; {endif}

         StoreNet(PathCall[Index],PathCall[Index-1],FileSize,MailTime);
   {*    WriteLn('Stored Path  ',PathCall[Index],'->',PathCall[Index-1],'  ',
                 ToDate,'/',ToTime,' ',FromDate,'/',FromTime,' = ',MailTime); *}


      end; {endif}
      Index := Index - 1;
    end; {endwhile}

end; { ExtractPaths }
{*-------------------------------------------------------------------------*}
{* ExtractMetrics                                                          *}
{* Procedure to extract metrics from a given path                          *}
{*-------------------------------------------------------------------------*}
Procedure ExtractMetrics (FileSize : LongInt);
  Var
    Index       :       Word;
    StartId     :       Str6;
    NHops       :       LongInt;
    AvgTime     :       LongInt;


begin { ExtractMetrics }

    StartId := SearchStart;
    NHops   := SearchHops;
    AvgTime := SearchTime;
    StoreOrig(StartId,FileSize,NHops,AvgTime);

end; { ExtractMetrics }
{*-------------------------------------------------------------------------*}
{* AnalyzeMail                                                             *}
{* Procedure to Analyze a particular piece of mail                         *}
{*-------------------------------------------------------------------------*}
Procedure AnalyzeMail(FileNameStr : Str255);
  Var
   EOFBin       :       Boolean;
   FileStr      :       Str255;
   FlagFirst    :       Boolean;
   ToDay        :       Str8;
   FromDay      :       Str8;
   ToTime       :       Str8;
   FromTime     :       Str8;
   FromCall     :       Str8;
   ToCall       :       Str8;
   PrevR        :       Str255;

begin { AnalyzeMail }

   BinRPtr := 1;
   BinWPtr := 1;
   Assign(BinFile,FileNameStr);
   Reset(BinFile,1);
   EOFBin  := TRUE;
   FlagFirst := TRUE;
   PrevR   := '';
   FromCall := '';

   While EOFBin = TRUE do begin
      EOFBin := ReadBinStr(FileStr);
      If EOFBin = FALSE then begin

         If FlagFirst = TRUE then begin
            PrevR := 'R:990101/0000Z @:'+HCNStr;
            StorePath(PrevR);
            PrevR := 'R:990101/0000Z @:'+HCNStr;
            StorePath(PrevR);
         end; {endif}

         Close(BinFile);
         Exit;
      end; {endif}

      If Copy(FileStr,1,2) = 'R:' then begin
         If FlagFirst = TRUE then begin
            FlagFirst := FALSE;
            PrevR := 'R:990101/0000Z @:'+HCNStr;
            StorePath(PrevR);
         end; {endif}
         StorePath(FileStr);
      end; {endif}

      If UpCaseStr(Copy(FileStr,1,6)) = ' GO_7+' then begin
         Is7PLUS := TRUE;
      end; {endif}

   end; {endwhile}

   If FlagFirst = TRUE then begin
      PrevR := 'R:990101/0000Z @:'+HCNStr;
      StorePath(PrevR);
      PrevR := 'R:990101/0000Z @:'+HCNStr;
      StorePath(PrevR);
   end; {endif}

   Close(BinFile);

end; { AnalyzeMail }
{*-------------------------------------------------------------------------*}
{* ClearPath                                                               *}
{* Procedure to clear the Path temporary vector                            *}
{*-------------------------------------------------------------------------*}
Procedure ClearPath;
  Var
    Index       :       Word;
begin { ClearPath }

    For Index := 1  to 600  do begin
        PathCall [Index] := '';
        PathDate [Index] := '';
        PathTime [Index] := '';
    end; {endfor}

end; { ClearPath }
{*-------------------------------------------------------------------------*}
{* ClearOrig                                                               *}
{* Procedure to clear the Orig vector                                      *}
{*-------------------------------------------------------------------------*}
Procedure ClearOrig;
  Var
    Index       :       Word;
begin { ClearOrig }

    For Index := 1  to 600 do begin
        OrigId[Index]   := '';
        OrigSize[Index] := 0;
        OrigHops[Index] := 0;
        OrigTime[Index] := 0;
        OrigFiles[Index]:= 0;
        Orig7PFiles[Index] := 0;
        Orig7PSize[Index] := 0;
        OrigCVFiles[Index] := 0;
        OrigCVSize[Index] := 0;
    end; {endfor}

end; { ClearOrig }
{*-------------------------------------------------------------------------*}
{* ClearNet                                                                *}
{* Procedure to clear the Net  vector                                      *}
{*-------------------------------------------------------------------------*}
Procedure ClearNet;
  Var
    Index       :       Word;
begin { ClearNet }

    For Index := 1  to 600 do begin
        NetFrom[Index]   := '';
        NetTo[Index]     := '';
        NetSize[Index]   := 0;
        NetTime[Index]   := 0;
        NetFiles[Index]  := 0;
    end; {endfor}

end; { ClearNet }
{*-------------------------------------------------------------------------*}
{* PrintGroup                                                              *}
{* Procedure to Print the Results of the Scan                              *}
{*-------------------------------------------------------------------------*}
Procedure PrintGroup;
  Var
    Index       :       Word;
    AuxStr      :       Str1;

    FilesStr    :       Str128;
    SizeStr     :       Str128;
    CallStr     :       Str128;
    HopsStr     :       Str128;
    TimeStr     :       Str128;
    FHops       :       Real;
    FFiles      :       Real;
    FileStr     :       Str255;
    FNet        :       Real;
    FAux        :       Real;
    FTime       :       Real;
    PVol        :       Str8;
    PFiles      :       Str8;
    AvgSizeStr  :       Str255;
    AvgTimeHop  :       Str255;
    FAvgHops    :       Real;
    FAvgTime    :       Real;
    Tot7Plus    :       Word;
    P7Plus      :       Real;
    Files7PStr  :       Str255;
    Porc7PStr   :       Str255;
    AuxInt      :       LongInt;

begin { PrintGroup }

    FAvgHops:= 0.0;
    FAvgTime:= 0.0;
    Tot7Plus := 0;

    For Index := 1  to 600  do begin
        Tot7Plus := Tot7Plus + Orig7PFiles[Index];
    end; {endfor}

    FileStr := 'Analisis de Red AX.25 X Muestra    Grupo: @'+MailGroup;
    PutStdOut(FileStr);
    PutStdOut('--------------------------------------------------------------------------------');
    PutStdOut('Estacion  *- Archivos -* *--- Volumen ---* Volum*Metric*Tiempo Transp*  7Plus  *');
    PutStdOut('Origen       #   %Tot       Bytes   %Tot   Medio Forwrd  Medio  X Fwd   #     % ');
    PutStdOut('--------------------------------------------------------------------------------');
    For Index := 1  to 600  do begin
        If OrigId[Index] = '' then begin
           Str(QNet:8,SizeStr);
           Str(QFiles:5,FilesStr);
           Faux := (QNet * 1.0) / (QFiles * 1.0);
           Str(FAux:6:0,AvgSizeStr);
           Faux := (QNet * 1.0);
           If FAux = 0.0 then begin
              FAux := 1.0;
           end; {endif}
           FAvgHops := FAvgHops / FAux;
           FAvgTime := FAvgTime / FAux;
           If FAvgHops = 0.0 then begin
              FAvgHops := 1.0;
           end; {endif}
           FAux     := FAvgTime / FAvgHops;
           Str(FAvgHops:3:0,HopsStr);
           Str(FAvgTime:6:2,TimeStr);
           Str(FAux:5:1,AvgTimeHop);
           Str(Tot7Plus:5,Files7PStr);
           FileStr := CallStr+'    '+FilesStr+' '+PadStr(PFiles,5)+'%    '+SizeStr+' '+PadStr(PVol,5)+'% '+AvgSizeStr+
                      '   '+HopsStr+'   '+
                      TimeStr+'  '+AvgTimeHop+Files7PStr;
           PutStdOut('--------------------------------------------------------------------------------');
           PutStdOut(FileStr);
           PutStdOut('--------------------------------------------------------------------------------');

           Exit;
        end; {endif}

        CallStr := PadStr(OrigId[Index],6);
        Str(OrigFiles[Index]:5,FilesStr);
        Str(OrigSize[Index]:8,SizeStr);
        FHops := OrigHops[Index] * 1.0;
        FFiles:= OrigFiles[Index] * 1.0;
        FHops := FHops / FFiles;
        FAvgHops := (Fhops * (OrigSize[Index] * 1.0)) + FAvgHops;
        OrigHops[Index] :=  Trunc(FHops);
        Str(OrigHops[Index]:3,HopsStr);
        Str(OrigTime[Index]:5,TimeStr);
        FAux := OrigSize[Index] * 1.0;
        FNet := QNet * 1.0;
        FAux := (FAux / FNet) * 100.0;
        Str(FAux:4:1,PVol);
        FAux := OrigFiles[Index] * 1.0;
        FFiles := QFiles * 1.0;
        FAux := (FAux/FFiles)  * 100.0;
        Str(FAux:4:1,PFiles);
        FTime := OrigTime[Index] * 1.0;
        FAux  := OrigSize[Index] * 1.0;
        FAux  := FTime / FAux;
        If FAux = 0.0 then begin
           TimeStr  := '--**--';
        end else begin
           Str(FAux:6:2,TimeStr);
        end; {endif}
        FAvgTime := (FAux * (OrigSize[Index] * 1.0)) + FAvgTime;

        FAux  := FAux / (OrigHops[Index] * 1.0);
        Str(FAux:5:1,AvgTimeHop);
        FAux  := OrigSize[Index] * 1.0;
        FAux  := FAux / (OrigFiles[Index] * 1.0);
        Str(FAux:6:0,AvgSizeStr);

        If Tot7Plus > 0 then begin
           Faux := (Orig7PFiles[Index] * 1.0) / (Tot7Plus * 1.0);
        end else begin
           Faux := 0.0;
        end; {endif}
        Faux := Faux * 100.0;
        AuxInt := Round(FAux);
        Str(AuxInt:3,Porc7PStr);
        Str(Orig7PFiles[Index]:5,Files7PStr);

        FileStr := CallStr+'    '+FilesStr+' '+PadStr(PFiles,5)+'%    '+SizeStr+' '+PadStr(PVol,5)+'% '+AvgSizeStr+
                   '   '+HopsStr+'   '+
                   TimeStr+'  '+AvgTimeHop+Files7PStr+' '+Porc7PStr+'%';
        PutStdOut(FileStr);

    end; {endfor}

    Str(QNet:8,SizeStr);
    Str(QFiles:6,FilesStr);
    Faux := (QNet * 1.0) / (QFiles * 1.0);
    Str(FAux:6:0,AvgSizeStr);
    Faux := (QNet * 1.0);
    FAvgHops := FAvgHops / FAux;
    FAvgTime := FAvgTime / FAux;
    Str(FAvgHops:3:0,HopsStr);
    Str(FAvgTime:6:2,TimeStr);
    Str(Tot7Plus:5,Files7PStr);
    PutStdOut('--------------------------------------------------------------------------------');
    FileStr := '*TOTAL*   '+FilesStr+'           '+SizeStr+'        '+AvgSizeStr+'   '+HopsStr+
               '   '+TimeStr+
               '  '+AvgTimeHop+Files7PStr;
    PutStdOut(FileStr);
    PutStdOut('--------------------------------------------------------------------------------');

end; { PrintGroup }
{*-------------------------------------------------------------------------*}
{* PrintList                                                               *}
{* Procedure to Print the Totals X Group                                   *}
{*-------------------------------------------------------------------------*}
Procedure PrintList;
  Var
    Index       :       Word;
    AuxStr      :       Str1;

    FilesStr    :       Str128;
    SizeStr     :       Str128;
    CallStr     :       Str128;
    HopsStr     :       Str128;
    TimeStr     :       Str128;
    FHops       :       Real;
    FFiles      :       Real;
    FileStr     :       Str255;
    FNet        :       Real;
    FAux        :       Real;
    FTime       :       Real;
    PVol        :       Str8;
    PFiles      :       Str8;
    AvgSizeStr  :       Str255;
    AvgTimeHop  :       Str255;
    FAvgHops    :       Real;
    FAvgTime    :       Real;
    F7PFStr     :       Str255;
    F7PFSStr    :       Str255;
    F7PGrp      :       Real;
    F7PSize     :       Real;
    F7PGrpStr   :       Str255;
    F7PSizeStr  :       Str255;
    Tot7P       :       Real;
    Tot7PS      :       Real;
    AuxInt      :       LongInt;

begin { PrintList }

    FAvgHops:= 0.0;
    FAvgTime:= 0.0;
    Tot7P   := 0.0;
    Tot7PS  := 0.0;
    PutStdOut(' ');
    PutStdOut(' ');
    FileStr := 'Totales por Grupo de Boletines    Grupo: @'+MailGroup;
    PutStdOut(FileStr);
    PutStdOut('-----------------------------------------------------------------------------');
    PutStdOut('Grupo      *- Archivos -*  *----- Volumen -----**------- 7+ Files ----------*');
    PutStdOut('Origen       #   %Tot       Bytes   %Tot    Prom    #   %Grp   Bytes  %Grp');
    PutStdOut('-----------------------------------------------------------------------------');
    For Index := 1  to 50  do begin
        If GroupId[Index] = '' then begin
           Str(QNet:8,SizeStr);
           Str(QFiles:5,FilesStr);
           Faux := (QNet * 1.0) / (QFiles * 1.0);
           Str(FAux:6:0,AvgSizeStr);
           Faux := (QNet * 1.0);
           If QNet > 0 then begin
              Faux := (Tot7PS) / (QNet * 1.0);
           end else begin
              Faux := 0.0;
           end; {endif}
           Faux := Faux * 100.0;
           Str(Faux:5:1,F7PSizeStr);
           If QFiles > 0 then begin
              Faux := Tot7P / (QFiles * 1.0);
           end else begin
              Faux := 0.0;
           end; {endif}
           Faux := Faux * 100.0;
           Str(Faux:5:1,F7PGrpStr);
           AuxInt := Trunc(Tot7P);
           Str(AuxInt:5,F7PFStr);
           AuxInt := Trunc(Tot7PS);
           Str(AuxInt:8,F7PFSStr);
           PutStdOut('-----------------------------------------------------------------------------');
           FileStr := '*TOTAL*   '+FilesStr+'           '+SizeStr+'        '+AvgSizeStr+' '+F7PFStr+
                      ' '+F7PGrpStr+'% '+F7PFSStr+' '+F7PSizeStr+'%';
           PutStdOut(FileStr);
           PutStdOut('-----------------------------------------------------------------------------');
           Exit;
        end; {endif}

        CallStr := PadStr(GroupId[Index],6);
        Str(GroupFiles[Index]:5,FilesStr);
        Str(GroupSize[Index]:8,SizeStr);
        FAux := GroupFiles[Index] * 1.0;
        FFiles := QFiles * 1.0;
        FAux := (FAux/FFiles)  * 100.0;
        Str(FAux:4:1,PFiles);
        FAux  := GroupSize[Index] * 1.0;
        FAux  := FAux / (GroupFiles[Index] * 1.0);
        Str(FAux:6:0,AvgSizeStr);
        FAux := GroupSize[Index] * 1.0;
        FNet := QNet * 1.0;
        FAux := (FAux / FNet) * 100.0;
        Str(FAux:4:1,PVol);
        Str(Group7P[Index]:5,F7PFStr);
        Str(Group7PS[Index]:8,F7PFSStr);
        If GroupFiles[Index] > 0 then begin
           F7PGrp := Group7P[Index] * 1.0;
           F7PGrp := F7PGrp / (GroupFiles[Index] * 1.0);
        end else begin
           F7PGrp := 0.0;
        end; {endif}
        If GroupSize[Index] > 0 then begin
           F7PSize := Group7PS[Index] * 1.0;
           F7PSize := F7PSize / (GroupSize[Index] * 1.0);
        end else begin
           F7PSize := 0.0;
        end; {endif}
        F7PGrp := F7PGrp * 100.0;
        F7PSize:= F7PSize * 100.0;
        Str(F7PGrp:5:1,F7PGrpStr);
        Str(F7PSize:5:1,F7PSizeStr);
        Tot7P := Tot7P + (Group7P[Index] * 1.0);
        Tot7PS:= Tot7PS+ (Group7PS[Index] * 1.0);

        FileStr := CallStr+'    '+FilesStr+' '+PadStr(PFiles,5)+'%    '+SizeStr+' '+PadStr(PVol,5)+'% '+
                   AvgSizeStr+' '+F7PFStr+' '+F7PGrpStr+'% '+F7PFSStr+' '+F7PSizeStr+'%';

        PutStdOut(FileStr);
    end; {endfor}


        Str(QNet:8,SizeStr);
        Str(QFiles:5,FilesStr);
        Faux := (QNet * 1.0) / (QFiles * 1.0);
        Str(FAux:6:0,AvgSizeStr);
        Faux := (QNet * 1.0);
        If QNet > 0 then begin
           Faux := (Tot7PS) / (QNet * 1.0);
        end else begin
           Faux := 0.0;
        end; {endif}
        Faux := Faux * 100.0;
        Str(Faux:5:1,F7PSizeStr);
        If QFiles > 0 then begin
           Faux := Tot7P / (QFiles * 1.0);
        end else begin
           Faux := 0.0;
        end; {endif}
        Faux := Faux * 100.0;
        Str(Faux:5:1,F7PGrpStr);
        AuxInt := Trunc(Tot7P);
        Str(AuxInt:5,F7PFStr);
        AuxInt := Trunc(Tot7PS);
        Str(AuxInt:8,F7PFSStr);
        PutStdOut('-----------------------------------------------------------------------------');
        FileStr := '*TOTAL*   '+FilesStr+'           '+SizeStr+'        '+AvgSizeStr+' '+
                   F7PFStr+' '+F7PGrpStr+'% '+F7PFSStr+' '+F7PSizeStr+'%';
        PutStdOut(FileStr);
        PutStdOut('-----------------------------------------------------------------------------');
        Exit;


end; { PrintList }
{*-------------------------------------------------------------------------*}
{* PrintPaths                                                              *}
{* Procedure to Print the Results of the Paths                             *}
{*-------------------------------------------------------------------------*}
Procedure PrintPaths;
  Var
    Index       :       Word;
    AuxStr      :       Str1;

    FilesStr    :       Str128;
    SizeStr     :       Str128;
    CallStr     :       Str128;
    HopsStr     :       Str128;
    TimeStr     :       Str128;
    FHops       :       Real;
    FFiles      :       Real;
    FileStr     :       Str255;
    FNet        :       Real;
    FAux        :       Real;
    PVol        :       Str8;
    PFiles      :       Str8;
    FTime       :       Real;

begin { PrintPaths }

    PutStdOut(' ');
    PutStdOut(' ');
    PutStdOut(' ');
    FileStr := 'Rutas de Forward    Grupo: @'+MailGroup;
    PutStdOut(FileStr);
    PutStdOut('-----------------------------------------------------------');
    PutStdOut(' Ruta Forward        Archivos          Volumen      T.Trans');
    PutStdOut('                     #   %Tot        Bytes  %Tot     (Hrs) ');
    PutStdOut('-----------------------------------------------------------');
    For Index := 1  to 600  do begin
        If NetFrom[Index] = '' then begin
           Str(QNet:8,SizeStr);
           Str(QFiles:5,FilesStr);
           PutStdOut('-----------------------------------------------------------');
           FileStr := '*TOTAL*           '+FilesStr+'           '+SizeStr;
           PutStdOut(FileStr);
           PutStdOut('-----------------------------------------------------------');
           Exit;
        end; {endif}

        CallStr := PadStr(NetFrom[Index],6)+'->'+PadStr(NetTo[Index],6);
        Str(NetFiles[Index]:5,FilesStr);
        Str(NetSize[Index]:8,SizeStr);
        Str(NetTime[Index]:5,TimeStr);
        FAux := NetSize[Index] * 1.0;
        FNet := QNet * 1.0;
        FAux := (FAux / FNet) * 100.0;
        Str(FAux:4:1,PVol);
        FAux := NetFiles[Index] * 1.0;
        FFiles := QFiles * 1.0;
        FAux := (FAux/FFiles)  * 100.0;
        Str(FAux:4:1,PFiles);
        FTime := NetTime[Index] * 1.0;
        FAux  := NetSize[Index] * 1.0;
        FAux  := FTime / FAux;
        Str(FAux:6:2,TimeStr);

        FileStr := CallStr+'    '+FilesStr+' '+PadStr(PFiles,5)+'%    '+
                   SizeStr+' '+PadStr(PVol,5)+'%    '+TimeStr;
        PutStdOut(FileStr);

    end; {endfor}

    Str(QNet:8,SizeStr);
    Str(QFiles:5,FilesStr);
    PutStdOut('-----------------------------------------------------------');
    FileStr := '*TOTAL*           '+FilesStr+'           '+SizeStr;
    PutStdOut(FileStr);
    PutStdOut('-----------------------------------------------------------');

end; { PrintPaths }
{*-------------------------------------------------------------------------*}
{* SortGroup                                                               *}
{* Procedure to Sort the files in the area                                 *}
{*-------------------------------------------------------------------------*}
Procedure SortGroup;
  Var
    Index       :       Word;
    Jndex       :       Word;
    TempOrig    :       Str6;
    TempSize    :       LongInt;
    TempHops    :       LongInt;
    TempFiles   :       LongInt;
    TempTime    :       LongInt;
    Temp7PFiles :       Word;
    Temp7PSize  :       LongInt;
    TempCVFiles :       Word;
    TempCVSize  :       LongInt;

begin { SortGroup }

    WriteLn('Sorting Origin Records');
    WriteLn;
    For Index := 1  to 999  do begin
      Write('.');
      If OrigId[Index] = '' then begin
         WriteLn;
         Exit;
      end; {endif}
      For Jndex := Index + 1  to 600  do begin
          If OrigSize[Jndex] > OrigSize[Index] then begin
             TempOrig := OrigId[Index];
             TempSize := OrigSize[Index];
             TempHops := OrigHops[Index];
             TempFiles:= OrigFiles[Index];
             TempTime := OrigTime[Index];
             Temp7PFiles := Orig7PFiles[Index];
             Temp7PSize  := Orig7PSize[Index];
             TempCVFiles := OrigCVFiles[Index];
             TempCVSize  := OrigCVSize[Index];

             OrigId[Index]   := OrigId[Jndex];
             OrigSize[Index] := OrigSize[Jndex];
             OrigHops[Index] := OrigHops[Jndex];
             OrigFiles[Index] := OrigFiles[Jndex];
             OrigTime[Index] := OrigTime[Jndex];
             Orig7PFiles[Index] := Orig7PFiles[Jndex];
             Orig7PSize[Index] := Orig7PSize[Jndex];
             OrigCVFiles[Index] := OrigCVFiles[Jndex];
             OrigCVSize[Index] := OrigCVSize[Jndex];

             OrigId   [Jndex] := TempOrig ;
             OrigSize [Jndex] := TempSize ;
             OrigHops [Jndex] := TempHops ;
             OrigFiles[Jndex] := TempFiles;
             OrigTime [Jndex] := TempTime ;
             Orig7PFiles[Jndex] := Temp7PFiles;
             Orig7PSize[Jndex] := Temp7PSize;
             OrigCVFiles[Jndex] := TempCVFiles;
             OrigCVSize[Jndex] := TempCVSize;

          end; {endif}
      end; {endfor}
    end; {endfor}
    WriteLn;

end; { SortGroup }
{*-------------------------------------------------------------------------*}
{* SortList                                                                *}
{* Procedure to Sort the totals of the groups                              *}
{*-------------------------------------------------------------------------*}
Procedure SortList;
  Var
    Index       :       Word;
    Jndex       :       Word;
    TempGroup   :       Str6;
    TempSize    :       LongInt;
    TempFiles   :       LongInt;
    TempG7P     :       Word;
    TempG7PS    :       LongInt;

begin { SortList }

    WriteLn('Sorting Group Totals');
    WriteLn;
    For Index := 1  to 49  do begin
      Write('.');
      If GroupId[Index] = '' then begin
         WriteLn;
         Exit;
      end; {endif}
      For Jndex := Index + 1  to 50  do begin
          If GroupSize[Jndex] > GroupSize[Index] then begin
             TempGroup:= GroupId[Index];
             TempSize := GroupSize[Index];
             TempFiles:= GroupFiles[Index];
             TempG7P  := Group7P[Index];
             TempG7PS := Group7PS[Index];

             GroupId[Index] := GroupId[Jndex];
             GroupSize[Index] := GroupSize[Jndex];
             GroupFiles[Index] := GroupFiles[Jndex];
             Group7P[Index] := Group7P[Jndex];
             Group7PS[Index]:= Group7PS[Jndex];

             GroupId[Jndex] := TempGroup;
             GroupSize[Jndex] := TempSize;
             GroupFiles[Jndex] := TempFiles;
             Group7P[Jndex] := TempG7P;
             Group7PS[Jndex] := TempG7PS;

          end; {endif}
      end; {endfor}
    end; {endfor}
    WriteLn;

end; { SortList }
{*-------------------------------------------------------------------------*}
{* SortPaths                                                               *}
{* Procedure to Sort the files in the area                                 *}
{*-------------------------------------------------------------------------*}
Procedure SortPaths;
  Var
    Index       :       Word;
    Jndex       :       Word;
    TempFrom    :       Str6;
    TempTo      :       Str6;
    TempSize    :       LongInt;
    TempHops    :       LongInt;
    TempFiles   :       LongInt;
    TempTime    :       LongInt;

begin { SortPaths }

    WriteLn('Sorting Paths Records');
    WriteLn;
    For Index := 1  to 499  do begin
      Write('.');
      If NetFrom[Index] = '' then begin
         WriteLn;
         Exit;
      end; {endif}
      For Jndex := Index + 1  to 600  do begin
          If NetSize[Jndex] > NetSize[Index] then begin
             TempFrom := NetFrom[Index];
             TempTo   := NetTo[Index];
             TempSize := NetSize[Index];
             TempFiles:= NetFiles[Index];
             TempTime := NetTime[Index];

             NetFrom[Index]   := NetFrom[Jndex];
             NetTo[Index]     := NetTo[Jndex];
             NetSize[Index]   := NetSize[Jndex];
             NetFiles[Index]  := NetFiles[Jndex];
             NetTime[Index]   := NetTime[Jndex];

             NetFrom [Jndex] := TempFrom ;
             NetTo   [Jndex] := TempTo;
             NetSize [Jndex] := TempSize ;
             NetFiles[Jndex] := TempFiles;
             NetTime [Jndex] := TempTime ;

          end; {endif}
      end; {endfor}
    end; {endfor}
    WriteLn;

end; { SortPaths }
{*-------------------------------------------------------------------------*}
{* StoreGroup                                                              *}
{* Procedure to Store the totals of the groups                             *}
{*-------------------------------------------------------------------------*}
Procedure StoreGroup(MailDir : Str255; FileSize : Word);
  Var
    Index       :       Word;
    Auxstr      :       Str255;
    GroupStr    :       Str255;

begin { StoreGroup }

    AuxStr := MailDir;
    While AuxStr <> '' do begin
       GroupStr := PopBang(AuxStr,'\');
    end; {endwhile}

    For Index := 1  to 50  do begin
      If GroupId[Index] = '' then begin
         GroupId[Index]    := UpCaseStr(GroupStr);
         GroupFiles[Index] := GroupFiles[Index] + 1;
         GroupSize[Index]  := GroupSize[Index] + FileSize;
         If Is7Plus = TRUE then begin
            Group7P[Index] := Group7P[Index] + 1;
            Group7PS[Index] := Group7PS[Index] + FileSize;
         end; {endif}
         Exit;
      end else begin
         If UpCaseStr(GroupStr) = UpCaseStr(GroupId[Index]) then begin
            GroupFiles[Index] := GroupFiles[Index] + 1;
            GroupSize[Index]  := GroupSize[Index] + FileSize;
            If Is7Plus = TRUE then begin
               Group7P[Index] := Group7P[Index] + 1;
               Group7PS[Index] := Group7PS[Index] + FileSize;
            end; {endif}
            Exit;
         end; {endif}
      end; {endif}
    end; {endfor}

    WriteLn('*** ERROR *** Group Table exhausted');

end; { StoreGroup }
{*-------------------------------------------------------------------------*}
{* ScanGroup                                                               *}
{* Procedure to Scan the files in the area                                 *}
{*-------------------------------------------------------------------------*}
Procedure ScanGroup(MailDir : Str255);

  Var
    DirInfo     :       SearchRec;
    Pointer     :       Word;
    ExtLen      :       Word;
    ExtFile     :       Str8;

begin { ScanGroup }

    FindFirst(MailDir+'*.*',AnyFile,DirInfo);
    WriteLn('Processing ',MailDir+'*.*');
    WriteLn;
    While DosError = 0 do begin
      WriteLn('Processing file '+DirInfo.Name);
      If DirInfo.Attr = $10 then begin
         If DirInfo.Name = '..' then begin
         end else begin
            If DirInfo.Name = '.' then begin
            end else begin
               WriteLn;
               ScanGroup(MailDir+DirInfo.Name+'\');
            end; {endif}
         end; {endif}
      end else begin

         If Pos('.',DirInfo.Name) <> 0 then begin
            Pointer := Pos('.',DirInfo.Name);
            ExtLen  := Length(DirInfo.Name) - Pointer;
            If ExtLen > 0 then begin
               ExtFile := Copy (DirInfo.Name,Pointer+1,Extlen);
            end else begin
               ExtFile := '';
            end; {endif}
         end else begin
            ExtFile := '';
         end; {endif}

         If ExtFile = '' then begin
         end else begin
            ClearPath;
            Is7Plus := FALSE;
            IsCV    := FALSE;
            AnalyzeMail(MailDir+DirInfo.Name);
            StoreGroup(MailDir,DirInfo.Size);
            ExtractMetrics(DirInfo.Size);
            ExtractPaths(DirInfo.Size);
            QNet := QNet + DirInfo.Size;
            QFiles := QFiles + 1;
            If Is7Plus = TRUE then begin
               Write('+');
            end else begin
               Write('.');
            end; {endif}
         end; {endif}

      end; {endif}

      FindNext(DirInfo);

    end; {endwhile}
    WriteLn;

end; { ScanGroup }
{*-------------------------------------------------------------------------*}
{* InitProgram                                                             *}
{* Initializes all program variables and areas                             *}
{*-------------------------------------------------------------------------*}
Procedure InitProgram;


  Var
    ParmFlag    :       Boolean;
    ParmStr     :       Str255;
    ParmIndex   :       Word;
    EC          :       Word;
    Index       :       Word;

begin { InitProgram }

     ClrScr;
     WriteLn;
     WriteLn('PktRoute Version 1.0 - by Pedro E. Colla (LU7DID) - 1994,1998');
     WriteLn;

     ParmFlag       :=  TRUE;
     ParmIndex      :=  1;
     MailDir        :=  '';
     HCNStr         :=  '';
     MailGroup      :=  '';

     While ParmFlag = TRUE do begin
       ParmStr := UpCaseStr(ParamStr(ParmIndex));
       WriteLn('Parameter processed '+ParmStr);
       If ParmStr = '-D' then begin
          ParmIndex  := ParmIndex + 1;
          MailDir := UpCaseStr(ParamStr(ParmIndex));
          WriteLn('Directory to Scan ',MailDir);
          If MailDir[Length(MailDir)] <> '\' then begin
             MailDir := MailDir + '\';
          end; {endif}
       end else begin
          If ParmStr = '-G' then begin
             ParmIndex   := ParmIndex + 1;
             MailGroup   := UpCaseStr(ParamStr(ParmIndex));
             WriteLn('Bulletin Group ',MailGroup);
          end else begin
             If (ParmStr = '-?') or (ParmStr = '?') then begin
                WriteLn;
                WriteLn(' Format:                                                  ');
                WriteLn('    PktRoute -d {Directory} -g {MailGroup} -h {HCN}       ');
                WriteLn('                                                          ');
                WriteLn(' -d Physical DOS directory to scan ({d:}\{Path}\)         ');
                WriteLn(' -g Group Name (i.e. LUNET,LATNET,WW,etc)                 ');
                WriteLn(' -h HCN        (i.e. LU1BUV.#ADR.BA.ARG.SOAM)             ');
                WriteLn;
                WriteLn(' If -d switch is omitted a directory list is seek on        ');
                WriteLn(' the file PKTNET.LST on the same directory this program   ');
                WriteLn(' is being run from.                                         ');
                WriteLn;
                WriteLn;
                WriteLn('           --- THIS IS A BETA TEST VERSION ---            ');
                Halt(NUL);
             end else begin
                If ParmStr = '-H' then begin
                   ParmIndex   := ParmIndex + 1;
                   HCNStr      := UpCaseStr(ParamStr(ParmIndex));
                   WriteLn('HCN Informed is ',HCNStr);
                end else begin
                   {                                                  }
                   {                                                  }
                   {     SPACE FOR FUTURE PARAMETER DEFINITION        }
                   {                                                  }
                   {                                                  }
                end; {endif}
             end; {endif}
          end; {endif}
       end; {endif}
       ParmIndex := ParmIndex + 1;
       If ParmIndex > ParamCount then begin
          ParmFlag := FALSE;
       end; {endif}
     end; {endwhile}

     ClearOrig;
     ClearNet;
     QNet   := 0;
     QFiles := 0;

     For Index := 1  to 50  do begin
       GroupId[Index]    := '';
       GroupFiles[Index] := 0;
       GroupSize[Index]  := 0;
       Group7P[Index]    := 0;
       Group7PS[Index]   := 0;
     end; {endfor}

     If HCNStr = '' then begin
        WriteLn('HCN Not informed, LU7DID.#ADR.BA.ARG.SOAM assumed!');
        HCNStr := 'LU7DID.#ADR.BA.ARG.SOAM';
     end; {endif}

     If MailGroup = '' then begin
        WriteLn('Mail Group not specified, ALL assumed');
        MailGroup := 'ALL';
     end; {endif}

end; { InitProgram }
{*-------------------------------------------------------------------------*}
{*                           MAIN PROGRAM LOGIC                            *}
{*-------------------------------------------------------------------------*}
begin { PktRoute }

        InitProgram;
        If MailDir <> '' then begin

           PutStdOut('Searching '+MailDir+' alone.');
           ScanGroup(MailDir);
           SortGroup;
           PrintGroup;
           SortList;
           PrintList;
           SortPaths;
           PrintPaths;

           Halt(00);
        end; {endif}

{I$-}
        Assign(MailFile,'PKTNET.LST');
        If IOResult <> 0 then begin
{I$+}
           PutStdOut('*** ERROR *** Problems allocating PKTNET.LST file');
           Halt(16);
        end; {endif}
{I$-}
        Reset(MailFile);
        If IOResult <> 0 then begin
{I$+}
           PutStdOut('*** ERROR *** Problems opening PKTNET.LST file');
           Halt(16);
        end; {endif}

        While not EOF(MailFile) do begin
          ReadLn(MailFile,MailStr);
          If MailStr[1] <> '#' then begin
             MailDir := Parse(MailStr);
             ScanGroup(MailDir);
          end; {endif}
        end; {endwhile}

        SortGroup;
        PrintGroup;
        SortList;
        PrintList;
        SortPaths;
        PrintPaths;

end. { PktRoute }
