#include <stdlib.h>
#include <stdio.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <linux/ax25.h>
#include "aprs_config.h"

int verbose;
char login[10];
int halter,dx_counter;


void watch_wolf_reset( int signal_number)
{
	if ( 0==dx_counter) {
		printf( "!%d!\n",dx_counter);
		// halter=0;
		}
	dx_counter=0;
}

void nothing( int cosi)
{
}

int send_packet( char *message, char *destination, char *port, char *scall ) {
	struct full_sockaddr_ax25 dest;
	struct full_sockaddr_ax25 src;
	char addr[20];
	char *portcall;
	int slen,dlen;
	int s;
		
	
	if ( (dlen = ax25_aton(destination, &dest) ) == -1 ) {
		fprintf( stderr, "Destination call conversion error\n");
		return 1;
	}
	if ( (portcall = ax25_config_get_addr( port)) == NULL ) {
		fprintf( stderr, "Unable to find specified port\n" );
		return 1;
	}
	
	if ( (NULL != scall ) && ( strcmp( portcall, scall ) != 0 ) ) 
		sprintf( addr, "%s %s", scall, portcall );
	else
		sprintf( addr, "%s", portcall );
	
	if ( ( slen = ax25_aton(addr, &src) ) == -1 ) {
		printf(  "Source callsign conversion error\n");
		return 1;
	}
	if ( (s = socket(AF_AX25, SOCK_DGRAM, 0)) == -1 ) {
		printf( "Unable to create socket\n" );
		return 1;
	}
	if ( bind( s, (struct sockaddr *)&src, slen) == -1 ) {
		printf( "Unable to bind socket\n" );
		return 1;
	}
	sendto( s, message, strlen( message), 0, (struct sockaddr *)&dest, dlen);
	close( s);
	return 0;
}

int send_ui( struct aprs_config conf, char *message )
{
	return ( send_packet( message, conf.destination, conf.port, conf.csgn ) );
}


int runloop( char *host, int port, struct aprs_config conf)
{
	int socket_fd,i,j;
	struct sockaddr_in name;
	struct hostent* hostinfo;
	struct sigaction sa;
	char buffer[10000];
	char str[256];
	ssize_t characters_read;
	

	memset( &sa, 0, sizeof(sa));
	sa.sa_handler=&nothing;
	sigaction( SIGALRM, &sa, NULL);
	
	socket_fd = socket( PF_INET, SOCK_STREAM, 0);
	
	name.sin_family = AF_INET;
	hostinfo = gethostbyname( host);
	if ( NULL == hostinfo) return 1;
	else
	name.sin_addr = *((struct in_addr *) hostinfo->h_addr);
	name.sin_port = htons( port);
	if ( connect( socket_fd, &name, sizeof( struct sockaddr_in)) == -1)
	{
		fprintf( stderr, "Unable to connect.\n");
		return 1;
	}
	
	sprintf( buffer, "%s\n", login);
	write( socket_fd, buffer, strlen( buffer));
	halter=1;
	while(1==halter) {
		characters_read = recv( socket_fd, buffer, 9995, 0 );
		if ( 0 >= characters_read ) return;
		buffer[characters_read]=0;
		j=0;
		for (i=0; i<characters_read; i++) {
			
			if (( 0 < j ) && (13 != buffer[i]) && (10 != buffer[i]) && (07 != buffer[i]))
			{
				str[j]=buffer[i];
				j++;
			}
			
			if ((0 < j ) && (10 == buffer[i]))
			{
				dx_counter++;
				str[j]=0;
				if ( 0<verbose) printf( "Dx(%d): %s |\n",dx_counter, str);
				send_ui( conf, str);
				j=0;
				str[j]=0;
			}
			
			if (( 0==j ) && ('D' == buffer[i]) && ('X' == buffer[i+1]))
			{
				str[j]=buffer[i];
				j++;
			}
		}
		if (1<verbose) fprintf( stderr, "Rx: %s |\n", buffer);
		buffer[0]=0;
		}
		close( socket_fd);
}
	

int main( int argc, char *argv[])
{
	struct	aprs_config myconf;
	int	g;
	char	host[100];
	int	port;

	dx_counter=0;
	strcpy( myconf.port, "ham");
	strcpy( myconf.csgn, "NOCALL");
	strcpy( myconf.destination, "DX");
	strcpy( host, "eadx.net");
	verbose = 0;
	strcpy( login, "nocall");
	port = 23;

	if ( 1 == argc ) 
	{
		printf( "Use -h for help! \n");
		return 1;
	}
	
	while( -1 != ( g=getopt( argc, argv, "hp:l:s:v:c:t:") ) )
	{
		switch(g)
		{
			case 'h' : printf( "\
   dxget - connects to telnet DX Cluster and sends received \n\
           dx data in unprotocolled ax.25 frames readable by \n\
	   TH-D7 handheld radio (and maybe by some other). \n\
	   \n\
	   License: GPL, Author: benghi/Karel OK2SKY\n\n\
   Usage:\n\
   ------\n\
     -p <port> ............ specifies ax.25 port (see /etc/ax25/axports)\n\
     -s <call> ............ source callsign with ssid (use your own)\n\
     -l <call> ............ DXCluster login callsign\n\
     -c <IP address|name> . DXCluster IP address or domain name\n\
     -t <port> ............ TCP port for DXCluster (typically 23 - telnet)\n\
     -v <0|1|2> ........... Verbosity level 0=only errors are displayed\n\
                                            1=errors + sent data\n\
					    2=errors + sent data + cluster\n");
			return 1;
		 	break;

			case 'p' : strncpy( myconf.port, optarg, 20);
			break;
			
			case 's' : strncpy( myconf.csgn, optarg, 20);
			break;
			
			case 'v' : verbose=atoi( optarg);
			break;
			
			case 'l' : strncpy( login, optarg, 10);
			break;
			
			case 'c' : strncpy( host, optarg, 100);
			break;
			
			case 't' : port = atoi( optarg);
			break;
			
			default: fprintf( stderr, "Unrecognized option! Use -h for help\n");
				return 1;
			break;
		}
	}
			
			
	if ( ax25_config_load_ports() == 0 ) {
		fprintf( stderr, "Unable to load axports.\n" );
		return 1;
	}

	halter=1;
	while (2>halter) runloop( host, port, myconf);
}
