.include "TN12DEF.INC"		
;
; THis code generates DTMF dial with one pin (for PWM at 15.625Khz) and
;	it also uses two pins for the 8Mhz xtal (no external capacitors)
; so set the fuses to 01011010 (or $5A)
;
; includes a twist
;
.equ T697 =2923
.equ T770 =3230
.equ T852 =3574
.equ T941 =3947
.equ T1209 =5071
.equ T1336 =5604
.equ T1477 =6195
;
.def t1lpt =r5
.def t1hpt =r6
.def t2lpt =r7
.def t2hpt =r8
;
.def t1low  =r9
.def t1high =r10
.def t2low =r11
.def t2high =r12
.def ntindex =r14
.def zreg =r15
.def Temp  =r16	
.def stat =r17
.equ PAUSE =7
.def pwtime =r18
.def tacc =r19
.def timerh =r20
.def timerl =r21
.def acca =r22
;
.CSEG
.org $0000
	rjmp start
	rjmp intext
	rjmp intpc
	rjmp inttov
	rjmp intee
	rjmp intac
;
inttov: sbrc stat,PAUSE ;cbco              these two lines are a different
	rjmp hdone	;cbco		   approach to solving the zc problem
	mov pwtime,tacc
	cpi pwtime,0
	breq ldone

	cbi PORTB,PB1	; level=0
	sbi DDRB,PB1	; output
ltloop:	dec pwtime
	brne ltloop	; loop if zero not reached
	cbi DDRB,PB1	; make the pin an input
	cbi PORTB,PB1	; pullup off
ldone:	mov pwtime,tacc
	cpi pwtime,128
	brcc hdone

	sbi PORTB,PB1	; level=1
	sbi DDRB,PB1	; output
htloop: inc pwtime
	brpl htloop	; loop if msb is clear, loop exit when 128 reached
hdone:	cbi DDRB,PB1	; make the pin an input
	cbi PORTB,PB1	; pullup off
	wdr
	ret

start:	cli
	clr stat
	clr zreg
	ldi acca,1
	out TCCR0,acca	; select clock as clock for timer0
	out GIMSK,zreg
;
	ldi acca,0x0f
	out WDTCR,acca
;
	cbr stat,1<<PAUSE	; start
	clr ntindex
; point to number to dial useing ntindex
nextdig:  mov t1lpt,zreg
	mov t1hpt,zreg
	mov t2lpt,zreg
	mov t2hpt,zreg
;
	mov timerl,zreg	; length of digit tone
	mov timerh,zreg
;
	ldi ZH,HIGH(ntdial*2)	; point to number to dial
	ldi ZL,LOW(ntdial*2)
	add ZL,ntindex		; use nt index
	adc ZH,zreg
	lpm
	mov Temp,r0
	cpi Temp,0x0C	; ff marks end of number list
	brcs ntimore
	rjmp ntidone
; now set up t1 and t2
ntimore: ldi ZH,HIGH(dtab*2)
	ldi ZL,LOW(dtab*2)
	add ZL,r0
	add ZL,r0
	add ZL,r0
	add ZL,r0
	lpm
	mov t1low,r0	; lsb first
	inc ZL
	lpm
	mov t1high,r0
	inc ZL
	lpm
	mov t2low,r0	; lsb first
	inc ZL
	lpm
	mov t2high,r0
	rjmp fentry
;
dcnt:	add t1lpt,t1low
	adc t1hpt,t1high
;
	add t2lpt,t2low
	adc t2hpt,t2high
;
fentry:	ldi ZH,HIGH(stab*2)
	ldi ZL,LOW(stab*2)
	add ZL,t1hpt
	adc ZH,zreg
	lpm		; low tone
	mov tacc,r0	; 0..128		these four lines implement
	lsr tacc	; 0..64 cbco		a twist by halving
	ldi acca,32	; cbco		 the amplitude of the 
	add tacc,acca	; cbco 32..96 this is the twist    low tone group
	ldi ZH,HIGH(stab*2)
	ldi ZL,LOW(stab*2)
	add ZL,t2hpt
	adc ZH,zreg
	lpm	; high tone
	add tacc,r0	; max 255+255
	ror tacc	; now max 255
	lsr tacc	; now max 128
	cbr stat,1<<PAUSE	; ensure tone
;
pauseing: cli 		; ensure int disabled
	ldi acca,2
	out TIFR,acca 	; clear pending
	out TIMSK,acca	; enable TOV0
; go into idle mode
	ldi acca,0x60
	out MCUCR,acca
	sei ;ensure ints enabled
	sleep	; do pwm
	out TIMSK,zreg
;
	inc timerl
	brne ntinc
	adc timerh,zreg
ntinc:	cpi timerh,7	; 7*256*64uS = 110uS
	brcc timeup	;	(or 55uS for the pause)
	sbrc stat,PAUSE	; if lsbit if stat is set, do pause
	rjmp pauseing
	rjmp  dcnt
;
;pause / digit complete
timeup: mov timerl,zreg	; length of digit tone
	mov timerh,zreg
	ldi tacc,0x40
	ldi acca,1<<PAUSE
	eor stat,acca	; change from tone/pause
	ldi tacc,0x40
	sbrc stat,PAUSE	; if lsbit if stat is set, do pause
	rjmp pauseing
	inc ntindex
	rjmp nextdig
;
intext:
intpc:
intee:
intac:
ntidone: cli 
hfin:	sleep
	rjmp hfin

.org $0100
; number to dial
ntdial:	.db 0,8
	.db 2,7
	.db 2,7
	.db 7,2
	.db 4,5
	.db 0xff,0xff
.org $0120
; digit table
dtab:	.dw T941	;0
	.dw T1336
	.dw T697	;1
	.dw T1209
	.dw T697	;2
	.dw T1336
	.dw T697	;3
	.dw T1477
	.dw T770	;4
	.dw T1209
	.dw T770	;5
	.dw T1336
	.dw T770	;6
	.dw T1477
	.dw T852	;7
	.dw T1209
	.dw T852	;8
	.dw T1336
	.dw T852	;9
	.dw T1477
	.dw T941	;A *
	.dw T1209
	.dw T941	;B #
	.dw T1477

.org $0180
; SCALE  255  , OFFSET  0 
stab:    .db 0x80, 0x83 ; 1 
    .db 0x86, 0x89 ; 3 
    .db 0x8C, 0x8F ; 5 
    .db 0x92, 0x95 ; 7 
    .db 0x98, 0x9B ; 9 
    .db 0x9E, 0xA2 ; 11 
    .db 0xA5, 0xA7 ; 13 
    .db 0xAA, 0xAD ; 15 
    .db 0xB0, 0xB3 ; 17 
    .db 0xB6, 0xB9 ; 19 
    .db 0xBC, 0xBE ; 21 
    .db 0xC1, 0xC4 ; 23 
    .db 0xC6, 0xC9 ; 25 
    .db 0xCB, 0xCE ; 27 
    .db 0xD0, 0xD3 ; 29 
    .db 0xD5, 0xD7 ; 31 
    .db 0xDA, 0xDC ; 33 
    .db 0xDE, 0xE0 ; 35 
    .db 0xE2, 0xE4 ; 37 
    .db 0xE6, 0xE8 ; 39 
    .db 0xEA, 0xEB ; 41 
    .db 0xED, 0xEE ; 43 
    .db 0xF0, 0xF1 ; 45 
    .db 0xF3, 0xF4 ; 47 
    .db 0xF5, 0xF6 ; 49 
    .db 0xF8, 0xF9 ; 51 
    .db 0xFA, 0xFA ; 53 
    .db 0xFB, 0xFC ; 55 
    .db 0xFD, 0xFD ; 57 
    .db 0xFE, 0xFE ; 59 
    .db 0xFE, 0xFF ; 61 
    .db 0xFF, 0xFF ; 63 
    .db 0xFF, 0xFF ; 65 
    .db 0xFF, 0xFF ; 67 
    .db 0xFE, 0xFE ; 69 
    .db 0xFE, 0xFD ; 71 
    .db 0xFD, 0xFC ; 73 
    .db 0xFB, 0xFA ; 75 
    .db 0xFA, 0xF9 ; 77 
    .db 0xF8, 0xF6 ; 79 
    .db 0xF5, 0xF4 ; 81 
    .db 0xF3, 0xF1 ; 83 
    .db 0xF0, 0xEE ; 85 
    .db 0xED, 0xEB ; 87 
    .db 0xEA, 0xE8 ; 89 
    .db 0xE6, 0xE4 ; 91 
    .db 0xE2, 0xE0 ; 93 
    .db 0xDE, 0xDC ; 95 
    .db 0xDA, 0xD7 ; 97 
    .db 0xD5, 0xD3 ; 99 
    .db 0xD0, 0xCE ; 101 
    .db 0xCB, 0xC9 ; 103 
    .db 0xC6, 0xC4 ; 105 
    .db 0xC1, 0xBE ; 107 
    .db 0xBC, 0xB9 ; 109 
    .db 0xB6, 0xB3 ; 111 
    .db 0xB0, 0xAD ; 113 
    .db 0xAA, 0xA7 ; 115 
    .db 0xA5, 0xA2 ; 117 
    .db 0x9E, 0x9B ; 119 
    .db 0x98, 0x95 ; 121 
    .db 0x92, 0x8F ; 123 
    .db 0x8C, 0x89 ; 125 
    .db 0x86, 0x83 ; 127 
    .db 0x80, 0x7C ; 129 
    .db 0x79, 0x76 ; 131 
    .db 0x73, 0x70 ; 133 
    .db 0x6D, 0x6A ; 135 
    .db 0x67, 0x64 ; 137 
    .db 0x61, 0x5D ; 139 
    .db 0x5A, 0x58 ; 141 
    .db 0x55, 0x52 ; 143 
    .db 0x4F, 0x4C ; 145 
    .db 0x49, 0x46 ; 147 
    .db 0x43, 0x41 ; 149 
    .db 0x3E, 0x3B ; 151 
    .db 0x39, 0x36 ; 153 
    .db 0x34, 0x31 ; 155 
    .db 0x2F, 0x2C ; 157 
    .db 0x2A, 0x28 ; 159 
    .db 0x25, 0x23 ; 161 
    .db 0x21, 0x1F ; 163 
    .db 0x1D, 0x1B ; 165 
    .db 0x19, 0x17 ; 167 
    .db 0x15, 0x14 ; 169 
    .db 0x12, 0x11 ; 171 
    .db 0xF, 0xE ; 173 
    .db 0xC, 0xB ; 175 
    .db 0xA, 0x9 ; 177 
    .db 0x7, 0x6 ; 179 
    .db 0x5, 0x5 ; 181 
    .db 0x4, 0x3 ; 183 
    .db 0x2, 0x2 ; 185 
    .db 0x1, 0x1 ; 187 
    .db 0x1, 0x0 ; 189 
    .db 0x0, 0x0 ; 191 
    .db 0x0, 0x0 ; 193 
    .db 0x0, 0x0 ; 195 
    .db 0x1, 0x1 ; 197 
    .db 0x1, 0x2 ; 199 
    .db 0x2, 0x3 ; 201 
    .db 0x4, 0x5 ; 203 
    .db 0x5, 0x6 ; 205 
    .db 0x7, 0x9 ; 207 
    .db 0xA, 0xB ; 209 
    .db 0xC, 0xE ; 211 
    .db 0xF, 0x11 ; 213 
    .db 0x12, 0x14 ; 215 
    .db 0x15, 0x17 ; 217 
    .db 0x19, 0x1B ; 219 
    .db 0x1D, 0x1F ; 221 
    .db 0x21, 0x23 ; 223 
    .db 0x25, 0x28 ; 225 
    .db 0x2A, 0x2C ; 227 
    .db 0x2F, 0x31 ; 229 
    .db 0x34, 0x36 ; 231 
    .db 0x39, 0x3B ; 233 
    .db 0x3E, 0x41 ; 235 
    .db 0x43, 0x46 ; 237 
    .db 0x49, 0x4C ; 239 
    .db 0x4F, 0x52 ; 241 
    .db 0x55, 0x58 ; 243 
    .db 0x5A, 0x5D ; 245 
    .db 0x61, 0x64 ; 247 
    .db 0x67, 0x6A ; 249 
    .db 0x6D, 0x70 ; 251 
    .db 0x73, 0x76 ; 253 
    .db 0x79, 0x7C ; 255 
;

