;*************************************************************************************
;  Send a CW id every three minutes (audio), without using a lookup table... AVR Tiny12
; uses internal 1Mhz oscillator -don't set fuse bits (internal oscillator is default!)
;
;*************************************************************************************
.include "TN12DEF.INC"
.def zreg =r1
.def rcount =r16		; this times the interval between sending the ID
.def ccnt=r17		; index into the . and - message
.def acca =r19		
.def stat =r20		; status byte, contains MAKTONE bit only
.equ MAKTONE =7
.def timer =r21		; these two timer bytes time dots and dashes
.def timerl =r22

.CSEG
.org $0000
	rjmp start
	rjmp intext
	rjmp intpc
	rjmp zinttov
	rjmp intee
	rjmp intac
;
; if the MAKTONE bit is set in the stat register, then toggle the PB1 pin
zinttov: sbrs stat,MAKTONE
	rjmp jwait
	sbrs timerl,1
	sbi PORTB,PB1	; level=1
	sbrc timerl,1
	cbi PORTB,PB1	; level=0
	sbi DDRB,PB1	; output
	rjmp intout
jwait: 	cbi PORTB,PB1	; level=0
	sbi DDRB,PB1	; output
intout:	wdr
	andi timerl,15
	brne into
	dec timer
into:	dec timerl
	ret
;
fault: clr rcount
intext:
intpc:
intee:
intac:
ntidone:
; power down, set wdog for 1.9 seconds
hfin:	cli 
	ldi acca,0x0f
	out WDTCR,acca
	cbi DDRB,PB1	; make the pin an input
	cbi PORTB,PB1	; pullup off
	ldi acca,0x70
	out MCUCR,acca	; power down, watchdog only
	sleep
	rjmp hfin

start:	cli
	clr zreg
	inc rcount		; 16 gives 35 sec (30 +5)
	andi rcount,63	; count the number of wdog resets
; uncomment the line below to speed up to 20seconds (instead of three minutes)
;;	andi rcount,7	; 7 gives 20sec
	brne hfin		; loop back if not time yet
;
runit:	
; the programmer allows reading the calibration byte for 1Mhz, can write it back here
;	ldi acca,0x2d
;	out OSCCAL,acca
;
	ldi acca,1
	out TCCR0,acca	; select clock as clock for timer0 @ 1Mhz
	out GIMSK,zreg
;
	ldi acca,0x0f
	out WDTCR,acca	; wdog timer
;
	clr timer
	clr timerl
	clr stat
	clr ccnt
;
nextchr: ldi ZH,HIGH(2*MESS)		; point to the "." or "-" to send
	mov ZL,ccnt
	lpm
	inc ccnt			; move to next element
	tst r0
	breq hfin			; 0 marks the end of the message
	mov acca,r0
	cpi acca,'-'			; is it a dah?
	breq dodash
	cpi acca,'.'			; is it a dit?
	breq dodot
	cpi acca,' '			; is is a space?
	brne fault
.equ U1 = 17
.equ U2 = 34
.equ U3 = 51
dospace: ldi timer,U2		; 300mS (there is a hidden U1 between)
	clr timerl
	cbr stat,1<<MAKTONE
	rjmp sendit
;
dodash:	ldi timer,U3		; 300mS
	clr timerl
	sbr stat,1<<MAKTONE
	rjmp sendit
;
dodot:	ldi timer,U1		;100mS
	clr timerl
	sbr stat,1<<MAKTONE
;
sendit:	 cli 		; ensure int disabled
	ldi acca,2
	out TIFR,acca 	; clear pending
	out TIMSK,acca	; enable TOV0
; go into idle mode
	ldi acca,0x60
	out MCUCR,acca
	sei		 ;ensure ints enabled
	sleep		; do beep
	out TIMSK,zreg
;
	tst timer
	brne sendit
	tst timerl
	brne sendit
; timer is 0000 : now do the dummy
dummy: 	ldi timer,U1		; 100mS
	clr timerl
waitit:	cbr stat,1<<MAKTONE
	cli 		; ensure int disabled
	ldi acca,2
	out TIFR,acca 	; clear pending
	out TIMSK,acca	; enable TOV0
; go into idle mode
	ldi acca,0x60
	out MCUCR,acca
	sei 		;ensure ints enabled
	sleep		; do beep, wakes every 256uS to toggle the PB1 (1953.1 Hz)
	out TIMSK,zreg
;
	tst timer
	brne waitit
	tst timerl
	brne waitit
	rjmp nextchr


; change to the message you want here; the .db 0,0 marks the end of the message
.org $180
MESS: .db "--.. ... .---- .- --. -..-"
	.db 0,0