/* Definitions for transmission of POCSAG codes *
 * (C) Stefan Petersen 1995                     *
 */

#ifndef POCSAG_H
#define POCSAG_H

#define UNIX

#ifdef UNIX
typedef unsigned int CodeWord;
#endif

#ifdef MSDOS
typedef unsigned long CodeWord;
#endif

typedef struct Batch {
  CodeWord sc;
  CodeWord frame[8][2];
  struct Batch *next;
} Batch;

typedef enum MsgType {Tone, Numerical, Alpha} MsgType;

/* Standard CodeWord's */
#define SYNCH 0x7CD215D8;
#define IDLE  0x7A89C197;

Batch *make_fill_batch(CodeWord RIC,
		       char *data, int size_of_data,
		       MsgType type);

void kill_batch(Batch *batch);

#endif /* POCSAG_H */
