
  'Data Transfer Utility--VIA to PC

    nomainwin
    UpperLeftX = 50
    UpperLeftY = 100
    WindowWidth = 500
    WindowHeight = 350

    global port$
    global commopen
    commopen = 0
    global displayopen
    displayopen = 0
    global dirselected
    dirselected = 0
    button #1, "Set CommPort", [commport], UL, 5, 5, 150, 25
    button #1, "Apply", [apply], UL, 230, 5, 50, 25
    textbox #1.port, 170, 5, 25, 25
    textbox #1.com, 300, 5, 170, 25
    button #1, "Get Setup Data", [setupdata], UL, 5, 145, 150, 25
    textbox #1.setup, 170, 145, 150, 25
    button #1, "Get Calibrated Data", [caldata], UL, 5, 175, 150, 25
    textbox #1.caldat, 170, 175, 150, 25
    button #1, "Get Raw Data", [rawdata], UL, 5, 205, 150, 25
    textbox #1.rawdat, 170, 205, 150, 25
    button #1, "Get EEProm Image", [eeprombackup], UL, 5, 235, 150, 25
    textbox #1.eeprom, 170, 235, 150, 25
    button #1, "Restore EEProm", [eepromrestore], UL, 5, 265, 150, 25
    textbox #1.restore, 170, 265, 150, 25
    button #1, "Exit", [quit], UL, 400, 265, 50, 25
    button #1 "OK", [OK], UL, 205, 85, 30, 25
    textbox #1.defdir, 5, 85, 150, 25
    statictext #1, "\Data", 160, 90, 45, 15
    statictext #1, "ACTION", 60, 130, 75, 15
    statictext #1, "Default Filename", 205, 130, 125, 15
    statictext #1, "Default Directory", 35, 70, 125, 15

    graphicbox #1.bx 1,50,480,6

    open "VIA Data Transfer Utility" for window as #1
    print #1.bx, "down"
    print #1.bx, "fill cyan"

    UpperLeftX = 550
    UpperLeftY = 100
    WindowWidth = 400
    WindowHeight = 500

    open "Monitor" for text as #display
    #1.port, "4"
    #1, "trapclose [quit]"
    ' File name initialization
    #1.setup, "VIA_SetupData.txt"
    #1.caldat, "VIA_Cal_dat.txt"
    #1.rawdat, "VIA_Raw_dat.txt"
    #1.eeprom, "VIA_EEPROM_Image.dat"
    #1.restore, "VIA_EEPROM_Image.dat"
    #1.defdir, DefaultDir$

    'wait here for user interaction
    wait

[OK]
    #1.defdir "!contents? tmpdir$"
    result = mkdir (tmpdir$ + "\Data")
    datadir$ = tmpdir$ + "\Data\"
    dirselected = 1
    print #display, datadir$

    'wait here for user interaction
    wait

[commport]
    #1.port, "!contents? tmp$"
    n = VAL(tmp$)
    n = n mod 16 +1
    #1.port, STR$(n)

    'wait here for user interaction
    wait

[apply]
    'apply port selection and open selected port
    dat$ = ":115200,n,8,1,ds0,cs0,rs"
    #1.port "!contents? port$"
    com$ = "COM" + port$ + dat$
    #1.com, com$

    commopen = 1
    'wait here for user interaction

    wait

[errorhandler]
    ' called if error opening port
    oncomerror

    noerror = 0
    error$ = "Comm Error"
    'clear display
    print #display, "!cls"
    print #display, error$
    print #display, "Port";port$; " not available"
    t = time$("seconds")
    do
    tstop = time$("seconds")
    loop while ((tstop - t) < 3)
    goto [quit]


[setupdata]
    ' Called if "Get Setup Data" button is tapped
    ' Send CTRL-P to port and await receipt of parameters
    #1.setup "!contents? file1$"
    if dirselected = 0 then
        print #display, "Please select a directory"
        wait
    end if
    open datadir$ + file1$ for binary as #file1
    oncomerror [errorhandler]
    open com$ for random as #commport
    print #display, "!cls"
    print #commport, chr$(16);
    ts = time$("seconds")
do
    n = lof(#commport)
    if n > 0 then
        ts = time$("seconds")
         txt$ = input$(#commport, n)
         print #display, txt$;
         print #file1, txt$;
    end if
    tf = time$("seconds")
loop while (tf-ts < 2)
    close #file1
    close #commport
    'wait here for user interaction

    wait


[caldata]
    ' Called if "Get Calibrated Data" button is tapped
    ' Send CTRL-C to port and await receipt of calibrated data.
    #1.caldat "!contents? file2$"
    if dirselected = 0 then
        print #display, "Please select a directory"
        wait
    end if
    open datadir$ + file2$ for binary as #file2
    oncomerror [errorhandler]
    open com$ for random as #commport
    print #display, "!cls"
    print #commport, chr$(3);
    ts = time$("seconds")
do
    n = lof(#commport)
    if n > 0 then
        ts = time$("seconds")
        txt$ = input$(#commport, n)
        print #display, txt$;
        print #file2, txt$;
    end if
    tf = time$("seconds")
loop while (tf-ts < 2)
    close #file2
    close #commport
    'wait here for user interaction
    wait

[rawdata]
    ' Called if "Get Raw Data" button is tapped
    ' Send CTRL-Q to port and await receipt of calibrated data.
    #1.rawdat "!contents? file3$"
    if dirselected = 0 then
        print #display, "Please select a directory"
        wait
    end if
    open datadir$ + file3$ for binary as #file3
    oncomerror [errorhandler]
    open com$ for random as #commport
    print #display, "!cls"
    print #commport, chr$(17);
    ts = time$("seconds")
do
    n = lof(#commport)
    if n > 0 then
        ts = time$("seconds")
        txt$ = input$(#commport, n)
        print #display, txt$;
        print #file3, txt$;
    end if
    tf = time$("seconds")
loop while (tf-ts < 2)
    close #file3
    close #commport
    'wait here for user interaction
    wait

[eeprombackup]
    ' Called if "Get EEProm Image" button is tapped
    #1.eeprom "!contents? file4$"
    page = 0
    if dirselected = 0 then
        print #display, "Please select a directory"
        wait
    end if
    open datadir$ + file4$ for binary as #file4
    oncomerror [errorhandler]
    open com$ for random as #commport
    seek #file4, 0
    print #display, "!cls"
    print #display, file4$
    numsamps = 0
    total = 0

for page = 0 to 511
        print #commport, chr$(5); 'send ctrl-E
        n = lof(#commport)
        do
        loop until lof(#commport)>= 128
        n = lof(#commport)
        txt$ = input$(#commport,n)
        print #display, n
        print #file4, txt$;
next page
        print #display, n
        print #display, lof(#commport)
    close #file4
    close #commport
    'wait here for user interaction
    wait


[eepromrestore]
    ' Called if "Restore EEProm" button is tapped
    #1.restore "!contents? file5$"
    page = 0
    if dirselected = 0 then
        print #display, "Please select a directory"
        wait
    end if
    open datadir$ + file5$ for binary as #file5
    oncomerror [errorhandler]
    open com$ for random as #commport
    print #display, "!cls"
    print #display, file5$
' enter code here to transmit eeprom image to VIA
' start transfer by sending ctrl-r to VIA
    print #commport, chr$(18);
for page = 0 to 511
' wait for acknowledgement from VIA (ctrl-n)
    do
    loop until lof(#commport)>= 1
    r$ = input$(#commport,1)
    if r$ = chr$(14) then
    ' send 128 bytes --1 eeprom page-- to VIA
        seek #file5, page*128
        data$ = input$(#file5,128)
        print #commport, data$;
    else
        print #display, "Error"
        close #file5
        close #commport
        goto [quit]
    end if
    print #display, page

next page
    close #file5
    close #commport
    'wait here for user interaction
    wait

[quit]
    ' Called if "X" is tapped
    confirm "EXIT program?"; quit$
    if quit$ = "no" then wait
    close #display
    close #1
    end


sub Pause mil
    t = time$("milliseconds")
    while time$("milliseconds") < t + mil
    wend
    end sub
