VERSION 5.00
Begin VB.Form frmDebugData 
   Caption         =   "Debug Data"
   ClientHeight    =   3528
   ClientLeft      =   48
   ClientTop       =   336
   ClientWidth     =   3744
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3528
   ScaleWidth      =   3744
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame frDebugData 
      Caption         =   "DataType"
      Height          =   2652
      Left            =   2040
      TabIndex        =   5
      Top             =   120
      Width           =   1452
      Begin VB.OptionButton obDebugData 
         Caption         =   "ASCII"
         Height          =   252
         Index           =   3
         Left            =   120
         TabIndex        =   10
         Top             =   1680
         Width           =   1092
      End
      Begin VB.OptionButton obDebugData 
         Caption         =   "Zero"
         Height          =   252
         Index           =   4
         Left            =   120
         TabIndex        =   9
         Top             =   2160
         Width           =   1212
      End
      Begin VB.OptionButton obDebugData 
         Caption         =   "Sine Wave"
         Height          =   252
         Index           =   2
         Left            =   120
         TabIndex        =   8
         Top             =   1200
         Width           =   1212
      End
      Begin VB.OptionButton obDebugData 
         Caption         =   "Random"
         Height          =   252
         Index           =   1
         Left            =   120
         TabIndex        =   7
         Top             =   720
         Width           =   1212
      End
      Begin VB.OptionButton obDebugData 
         Caption         =   "Binary"
         Height          =   252
         Index           =   0
         Left            =   120
         TabIndex        =   6
         Top             =   240
         Width           =   1212
      End
   End
   Begin VB.TextBox tbDebugBoardType 
      Height          =   372
      Left            =   1080
      Locked          =   -1  'True
      TabIndex        =   3
      Top             =   360
      Width           =   492
   End
   Begin VB.VScrollBar vsDebugDataBoard 
      Height          =   492
      Left            =   600
      Max             =   1
      Min             =   6
      TabIndex        =   2
      Top             =   360
      Value           =   1
      Width           =   252
   End
   Begin VB.TextBox tbDebugDataBoard 
      Height          =   372
      Left            =   120
      TabIndex        =   1
      Top             =   360
      Width           =   372
   End
   Begin VB.Label Label1 
      Caption         =   "Board Type"
      Height          =   252
      Left            =   960
      TabIndex        =   4
      Top             =   120
      Width           =   972
   End
   Begin VB.Label lblDebugDataBoard 
      Caption         =   "Board Nbr"
      Height          =   252
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   852
   End
End
Attribute VB_Name = "frmDebugData"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim iBoard As Integer
Dim K0 As Integer
Dim K1 As Integer
Dim L0 As Long
Dim L1 As Long
Dim fval As Double
Dim TotalBits As Integer

Private Sub Form_Load()
   vsDebugDataBoard.Value = 1
   vsDebugDataBoard_Change
End Sub

Private Sub obDebugData_Click(Index As Integer)
   Dim fval As Double
   Dim ParityBit As Integer
   Dim OnesCount As Integer
   Dim Logic_1(0 To 1) As Integer
   Dim Logic_0(0 To 1) As Integer

   Select Case Index

   Case 0:  ' Binary
      For L0 = 0 To MAX_SAMPLES - 1
         bDataArray(iBoard, L0) = (L0) Mod 256
      Next L0

   Case 1:  ' Random
      For L0 = 0 To MAX_SAMPLES - 1
         K0 = Rnd * 256
         If K0 < 256 Then
            bDataArray(iBoard, L0) = K0
         Else
            L0 = L0 - 1
         End If
      Next L0

   Case 2:  ' Sine wave
      For L0 = 0 To MAX_SAMPLES - 1
         fval = (L0 Mod 360) * 3.14159265358979 / 180 ' convert to radians
         fval = Sin(fval)
         fval = (fval + 1#) * 128#     ' normalize to 0..256
         K0 = fval                      ' convert to int
         If K0 = 256 Then K0 = 255
         bDataArray(iBoard, L0) = K0
      Next L0

   Case 3:  ' ASCII
      SamplesPerBit = 3
      iMeasBaud = 1# / (3# * rSamplePeriod(iTimeBaseIndex))

      TotalBits = 1 + iMeasDataBits + (iMeasParity <> MEAS_PARITY_NONE) + iMeasStopBits
      L0 = 0            ' index into data array

      Logic_1(0) = 2                      ' data on channel 1, clock = channel 0
      Logic_0(0) = 2 - Logic_1(0)

      Logic_1(1) = 4                      ' data on channel 2
      Logic_0(1) = 4 - Logic_1(1)

      For L0 = 0 To 5
         If iMeasType = MEAS_ASYNCH Then
            bDataArray(iBoard, L0) = Logic_1(0) + Logic_1(1)     ' dummy bit time
         Else
            bDataArray(iBoard, L0) = Logic_0(0) + Logic_0(1)     ' dummy bit time
         End If
      Next L0

      K0 = 0          ' initial data value
      Do                ' for all possible samples
         If iMeasType = MEAS_ASYNCH Then
            bDataArray(iBoard, L0) = Logic_0(0)       ' start bit
            bDataArray(iBoard, L0 + 1) = Logic_0(0)
            bDataArray(iBoard, L0 + 2) = Logic_0(0)
            L0 = L0 + 3
         End If

         OnesCount = 0
         For K1 = 0 To iMeasDataBits - 1        ' do a byte
   ' channel 1
            If K0 And (2 ^ K1) Then
               bDataArray(iBoard, L0) = Logic_1(0)
               bDataArray(iBoard, L0 + 1) = Logic_1(0) + 1     ' synch clock
               bDataArray(iBoard, L0 + 2) = Logic_1(0)
               OnesCount = OnesCount + 1
            Else
               bDataArray(iBoard, L0) = Logic_0(0)
               bDataArray(iBoard, L0 + 1) = Logic_0(0) + 1     ' synch clock
               bDataArray(iBoard, L0 + 2) = Logic_0(0)
            End If
   ' channel 2 - no parity calculation or clock bit
            If (K0 + 1) And (2 ^ K1) Then
               bDataArray(iBoard, L0) = bDataArray(iBoard, L0) + Logic_1(1)
               bDataArray(iBoard, L0 + 1) = bDataArray(iBoard, L0 + 1) + Logic_1(1)
               bDataArray(iBoard, L0 + 2) = bDataArray(iBoard, L0 + 2) + Logic_1(1)
            Else
               bDataArray(iBoard, L0) = bDataArray(iBoard, L0) + Logic_0(1)
               bDataArray(iBoard, L0 + 1) = bDataArray(iBoard, L0 + 1) + Logic_0(1)
               bDataArray(iBoard, L0 + 2) = bDataArray(iBoard, L0 + 2) + Logic_0(1)
            End If

            L0 = L0 + 3
         Next K1
         K0 = K0 + 2                      ' next data value

         Select Case iMeasParity
         Case MEAS_PARITY_EVEN
            If OnesCount Mod 2 = 0 Then
               ParityBit = Logic_0(0)
            Else
               ParityBit = Logic_1(0)
            End If
         Case MEAS_PARITY_ODD
            If OnesCount Mod 2 = 0 Then
               ParityBit = Logic_1(0)
            Else
               ParityBit = Logic_0(0)
            End If
         Case MEAS_PARITY_0
            ParityBit = Logic_0(0)
         Case MEAS_PARITY_1
            ParityBit = Logic_1(0)
         Case MEAS_PARITY_NONE
         End Select

         If (iMeasParity <> MEAS_PARITY_NONE) And (iMeasType = MEAS_ASYNCH) Then
            bDataArray(iBoard, L0) = ParityBit
            bDataArray(iBoard, L0 + 1) = ParityBit
            bDataArray(iBoard, L0 + 2) = ParityBit
            L0 = L0 + 3
         End If

         bDataArray(iBoard, L0) = Logic_1(0)       ' stop bit
         bDataArray(iBoard, L0 + 1) = Logic_1(0)   ' NO CLOCK!
         bDataArray(iBoard, L0 + 2) = Logic_1(0)
         L0 = L0 + 3

      Loop While L0 < MAX_SAMPLES - (4 * TotalBits)

   Case 4:  ' zero
      For L0 = 0 To MAX_SAMPLES - 1
         bDataArray(iBoard, L0) = 0
      Next L0
   End Select
End Sub

Private Sub vsDebugDataBoard_Change()
   For K0 = 0 To 2
      obDebugData(K0).Value = False
   Next K0
   iBoard = vsDebugDataBoard.Value
   tbDebugDataBoard.Text = iBoard
   If iBoardType(iBoard) = LA_BOARD Then
      tbDebugBoardType.Text = "LA"
   End If
   If iBoardType(iBoard) = AD_BOARD Then
      tbDebugBoardType.Text = "A/D"
   End If
   If iBoardType(iBoard) = 0 Then
      tbDebugBoardType.Text = "  "
   End If
End Sub
