VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmDataWrite 
   Caption         =   "Data Save"
   ClientHeight    =   3960
   ClientLeft      =   48
   ClientTop       =   336
   ClientWidth     =   4992
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   10.2
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   ScaleHeight     =   3960
   ScaleWidth      =   4992
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame fraLAdata 
      Caption         =   "LA Data Format"
      Height          =   1092
      Left            =   120
      TabIndex        =   11
      Top             =   1320
      Width           =   1692
      Begin VB.OptionButton obLAdataFormat 
         Caption         =   "Bits"
         Height          =   252
         Index           =   1
         Left            =   240
         TabIndex        =   13
         Top             =   720
         Width           =   852
      End
      Begin VB.OptionButton obLAdataFormat 
         Caption         =   "Bytes"
         Height          =   252
         Index           =   0
         Left            =   240
         TabIndex        =   12
         Top             =   360
         Width           =   852
      End
   End
   Begin VB.CommandButton cmdDataSave 
      Caption         =   "Save"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   492
      Left            =   1680
      Style           =   1  'Graphical
      TabIndex        =   9
      Top             =   2640
      Width           =   972
   End
   Begin MSComDlg.CommonDialog cdlgSaveData 
      Left            =   360
      Top             =   2640
      _ExtentX        =   677
      _ExtentY        =   677
      _Version        =   393216
   End
   Begin VB.TextBox tbSaveSample 
      Height          =   492
      Index           =   1
      Left            =   3480
      TabIndex        =   8
      Text            =   "End Sample"
      Top             =   1920
      Width           =   1332
   End
   Begin VB.TextBox tbSaveSample 
      Height          =   492
      Index           =   0
      Left            =   2040
      TabIndex        =   7
      Text            =   "Start Sample"
      Top             =   1920
      Width           =   1332
   End
   Begin VB.Frame fraSize 
      Caption         =   "Sample Count"
      Height          =   1572
      Left            =   2040
      TabIndex        =   3
      Top             =   240
      Width           =   2292
      Begin VB.OptionButton obSampleCnt 
         Caption         =   "User Define"
         Height          =   252
         Index           =   2
         Left            =   120
         TabIndex        =   6
         Top             =   1080
         Width           =   1332
      End
      Begin VB.OptionButton obSampleCnt 
         Caption         =   "Samples On Screen"
         Height          =   252
         Index           =   1
         Left            =   120
         TabIndex        =   5
         Top             =   720
         Width           =   2052
      End
      Begin VB.OptionButton obSampleCnt 
         Caption         =   "Entire Sample Set"
         Height          =   252
         Index           =   0
         Left            =   120
         TabIndex        =   4
         Top             =   360
         Width           =   1932
      End
   End
   Begin VB.Frame fraDataType 
      Caption         =   "File Type"
      Height          =   852
      Left            =   120
      TabIndex        =   0
      Top             =   240
      Width           =   1092
      Begin VB.OptionButton obDataType 
         Caption         =   "CSV"
         Height          =   252
         Index           =   1
         Left            =   120
         TabIndex        =   2
         Top             =   480
         Width           =   852
      End
      Begin VB.OptionButton obDataType 
         Caption         =   "BIN"
         Height          =   252
         Index           =   0
         Left            =   120
         TabIndex        =   1
         Top             =   240
         Width           =   852
      End
   End
   Begin VB.Label lblDataSave 
      Caption         =   "This will save both a Data file and the current INI file."
      Height          =   612
      Left            =   960
      TabIndex        =   10
      Top             =   3240
      Width           =   2772
   End
End
Attribute VB_Name = "frmDataWrite"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Const DATA_TYPE_BIN = 0
Const DATA_TYPE_ASC = 1
Const DATA_SIZE_ALL = 0
Const DATA_SIZE_SCREEN = 1
Const DATA_SIZE_SELECT = 2
Const LA_DATA_BYTES = 0
Const LA_DATA_BITS = 1
Const DATA_FILE = 2

Private Sub Form_Load()
   obDataType(DATA_TYPE_BIN) = True
   obSampleCnt(DATA_SIZE_SCREEN) = True
   obLAdataFormat(LA_DATA_BYTES).Value = True
End Sub ' Form_Load

Private Sub obSampleCnt_Click(Index As Integer)
   Select Case Index
   Case DATA_SIZE_ALL
      tbSaveSample(0).Locked = True
      tbSaveSample(1).Locked = True
      tbSaveSample(0).BackColor = BKG_WHITE
      tbSaveSample(1).BackColor = BKG_WHITE
      tbSaveSample(0).Text = 0
      tbSaveSample(1).Text = iMax_Samples
      lStartSample(CurrentScreen) = tbSaveSample(0).Text
      lEndSample(CurrentScreen) = tbSaveSample(1).Text
   Case DATA_SIZE_SCREEN
      tbSaveSample(0).Locked = True
      tbSaveSample(1).Locked = True
      tbSaveSample(0).BackColor = BKG_WHITE
      tbSaveSample(1).BackColor = BKG_WHITE
      tbSaveSample(0).Text = lStartSample(CurrentScreen)
      tbSaveSample(1).Text = lEndSample(CurrentScreen)
      lStartSample(CurrentScreen) = tbSaveSample(0).Text
      lEndSample(CurrentScreen) = tbSaveSample(1).Text
   Case DATA_SIZE_SELECT
      tbSaveSample(0).BackColor = BKG_RED
      tbSaveSample(1).BackColor = BKG_RED
      tbSaveSample(0).Locked = False
      tbSaveSample(1).Locked = False
   End Select
End Sub ' obSampleCnt_Click

Private Sub tbSaveSample_KeyUp(Index As Integer, KeyCode As Integer, Shift As Integer)
   Dim I As Integer
   Dim lval As Long
   
   If KeyCode = 13 Then         ' if Enter key
      If tbSaveSample(Index).Text <> "" Then
         tbSaveSample(Index).BackColor = BKG_WHITE
         If Index = 0 Then
            lStartSample(CurrentScreen) = tbSaveSample(Index).Text
         Else
            lEndSample(CurrentScreen) = tbSaveSample(Index).Text
         End If
      End If
   Else
      tbSaveSample(Index).BackColor = BKG_RED
   End If
End Sub ' tbSaveSample_KeyUp
Private Sub cmdDataSave_Click()
   Dim SampleNbr As Long
   Dim BrdNbr As Integer
   Dim I As Integer
   Dim J As Integer
   Dim K As Integer
   Dim L As Byte
   Dim OutputLine As String * 150
   Dim TrimString

   On Error GoTo cmdDataSaveExit
   If obDataType(DATA_TYPE_BIN).Value = True Then
      cdlgSaveData.Flags = cdlOFNOverwritePrompt + cdlOFNPathMustExist
      cdlgSaveData.Filter = " DSO Binary Files(*.BIN)|*.BIN"
      cdlgSaveData.InitDir = szIniFolder
      cdlgSaveData.FilterIndex = 1
      cdlgSaveData.FileName = "*.BIN"
      cdlgSaveData.ShowSave
      If Mid$(cdlgSaveData.FileName, 1, 1) <= " " Then Exit Sub
      Open cdlgSaveData.FileName For Binary Access Write As #DATA_FILE
      
      cmdDataSave.Caption = "Writing"
      cmdDataSave.BackColor = BKG_RED
      DoEvents
      
      For BrdNbr = 1 To MAX_BOARDS
         If iBoardType(BrdNbr) <> 0 Then
            For SampleNbr = lStartSample(CurrentScreen) To lEndSample(CurrentScreen)
               Put DATA_FILE, , bDataArray(BrdNbr, SampleNbr)
            Next SampleNbr
         End If
      Next BrdNbr
   End If ' DATA_TYPE_BIN

   If obDataType(DATA_TYPE_ASC).Value = True Then
      cdlgSaveData.Flags = cdlOFNOverwritePrompt + cdlOFNPathMustExist
      cdlgSaveData.Filter = " DSO Binary Files(*.CSV)|*.CSV"
      cdlgSaveData.InitDir = szIniFolder
      cdlgSaveData.FilterIndex = 1
      cdlgSaveData.FileName = "*.CSV"
      cdlgSaveData.ShowSave
      If Mid$(cdlgSaveData.FileName, 1, 1) <= " " Then Exit Sub
      Open cdlgSaveData.FileName For Output Access Write As #DATA_FILE
      
      cmdDataSave.Caption = "Writing"
      cmdDataSave.BackColor = BKG_RED
      DoEvents
      
      If obLAdataFormat(LA_DATA_BYTES).Value = True Then
         For SampleNbr = lStartSample(CurrentScreen) To lEndSample(CurrentScreen)
            OutputLine = Space(128)
            I = 1
            For BrdNbr = 1 To MAX_BOARDS
               If iBoardType(BrdNbr) <> 0 Then
                  Mid(OutputLine, I) = bDataArray(BrdNbr, SampleNbr) & ", "
                  I = I + 5
               End If
            Next BrdNbr
            TrimString = RTrim(OutputLine)
            Print #DATA_FILE, TrimString
         Next SampleNbr
      End If ' LA_DATA_BYTES
      
      If obLAdataFormat(LA_DATA_BITS).Value = True Then
         For SampleNbr = lStartSample(CurrentScreen) To lEndSample(CurrentScreen)
            OutputLine = Space(128)
            I = 1
            For BrdNbr = 1 To MAX_BOARDS
               If iBoardType(BrdNbr) = AD_BOARD Then
                  Mid(OutputLine, I) = bDataArray(BrdNbr, SampleNbr) & ", "
                  I = I + 5
               End If
               If iBoardType(BrdNbr) = LA_BOARD Then
                  J = 1                   ' bit position value
                  For K = 0 To 7          ' for each channel
                     If bLA_Use(BrdNbr, K) Then
                        L = (bDataArray(BrdNbr, SampleNbr) And J) \ J
                        Mid(OutputLine, I) = L & ", "
                        I = I + 3
                     End If
                     J = J + J
                  Next K
               End If
            Next BrdNbr
            TrimString = RTrim(OutputLine)
            Print #DATA_FILE, TrimString
         Next SampleNbr
      End If ' LA_DATA_BITS
   
   End If ' DATA_TYPE_ASC

' now save the INI file using the same name and path
   szIniFileName = cdlgSaveData.FileName
   I = InStr(szIniFileName, ".")       ' find extension
   If I = 0 Then I = Len(szIniFileName)
   Mid(szIniFileName, I) = ".INI"
   fnIniWrite

cmdDataSaveExit:
   On Error GoTo 0
   Close #DATA_FILE
   cmdDataSave.Caption = "Save"
   cmdDataSave.BackColor = BKG_GREY
   Unload frmDataWrite
End Sub ' cmdDataSave_Click

Private Sub Form_KeyUp(KeyCode As Integer, Shift As Integer)
   If KeyCode = 27 Then
      Unload frmDataWrite
   End If
End Sub

