Attribute VB_Name = "DSO_Data"
'Control signal descriptions for programming the DSO/LA
'    L = level,        P = pulse
'Data Port:
   '#Const doDebug = 1
   Global Const VERSION = 1.2
   
   Global Const DEBUG_TRIGADDR = 1
   Global Const DEBUG_DISP_LA = 2
   Global Const DEBUG_ADDR = 4
   Global Const DEBUG_ADDR_MOD = 2048
'   Global Const DEBUG_VALUE = DEBUG_TRIGADDR + DEBUG_ADDR
   Global Const DEBUG_VALUE = 0

'Global Constants
   Global Const INI_FILE = 1           ' channel for INI file
   Global Const DATA_FILE = 2          ' channel for Data file
   Global Const DEF_INI_FILE = "dso.ini"
   Global Const BKG_RED = &H8080FF
   Global Const BKG_WHITE = &HFFFFFF
   Global Const BKG_GREY = &H8000000F
   Global Const BKG_DARKGREEN = &H8000&
   Global Const COLOR_BLACK = &H0&
   Global Const COLOR_BROWN = &H4080&
   Global Const COLOR_RED = &HFF&
   Global Const COLOR_ORANGE = &H80C0FF0
   Global Const COLOR_YELLOW = &HFFFF&
   Global Const COLOR_GREEN = &HFF00&
   Global Const COLOR_BLUE = &HFF0000
   Global Const COLOR_VIOLET = &HFFC0C0
   Global Const COLOR_GRAY = &HC0C0C0
   Global Const COLOR_WHITE = &HFFFFFF
   
'Printer Port Control Register Definitions
   Global Const DATA_OFFSET = 0        ' parallel port registers
   Global Const STATUS_OFFSET = 1
   Global Const CONTROL_OFFSET = 2
   Global Const ECR_OFFSET = &H402
   Global Const ECR_MASK = &H1F        ' remove bits 7..5
   Global Const ECR_MODE_EPP = &H80

   Global Const CONTROL_PORT_MASK = 3  ' invert bits 0 & 1
   Global Const CONTROL_STROBE = 8     ' bit 3 is strobe
   Global Const READ_ENABLE_MASK = 32  ' bit 5: 0=Write, 1=Read
   Global Const SYSRESET = 1
   Global Const SYSENABLE = 2
   Global Const SUBSELECT = 3
   Global Const READSUB = 4
   Global Const WRITESUB = 5
' write sub functions
   Global Const SUB_TRIG_CMP_LATCH_0 = 0
   Global Const SUB_TRIG_CMP_LATCH_1 = 1
   Global Const SUB_TRIG_CMP_LATCH_2 = 2
   Global Const SUB_TRIG_CMP_LATCH_3 = 3
   Global Const SUB_TRIG_CH_ENA = 6
   Global Const SUB_TRIG_CH_STATE = 7
   
   Global Const SBLA_RESET = 1
   Global Const SBLA_TRIG = 2
   Global Const SBLA_ENA = 3
' read sub function
   Global Const SUB_READ_0 = 0 + 8
   Global Const SUB_READ_1 = 1 + 8
   Global Const SUB_READ_2 = 2 + 8
   Global Const SUB_READ_3 = 3 + 8
   Global Const SUB_READ_4 = 4 + 8
   Global Const SUB_READ_5 = 5 + 8
   Global Const SUB_READ_LOW_TRIG_ADR = 6 + 8
   Global Const SUB_READ_HIGH_TRIG_ADR = 7 + 8

   Global Const SBLA_READ = 4
   Global Const SBLA_READ_TRIG_ADDR_LOW = 4
   Global Const SBLA_READ_TRIG_ADDR_HIGH = 5
   Global Const SBLA_READ_RAM_0 = 6
   Global Const SBLA_READ_RAM_1 = 7
'Printer Port Values
   Global iControlPort As Integer      ' control port value
   Global iOutputPort As Integer       ' data port value
   Global iTrigLatch As Integer
   Global iSampleClkEna As Integer
   Global iPreTrigDone As Integer
   Global iStatusBit7 As Integer
   Global SBLA As Integer

' ************* INI file constants and globals **************

'Section Name values
   Global Const GENERAL = 1
   Global Const BOARD_TYPES = 2
   Global Const LA_CHANNELS = 3
   Global Const AD_CHANNELS = 4
   Global Const TRIGGER = 5
   Global Const TIMEBASE = 6
   Global Const DISPLAY = 7
   Global Const MARKERS = 8
   Global Const MEASUREMENT = 9
   Global Const MENU_POSITIONS = 10

'Values for reading DSO.ini
   Global szString As String * 255     ' general string variable
   Global szParameter As String * 15   ' parameter value
   Global szIniFileName As String * 50
   Global szIniFolder As String * 50
   Global szIniDrive As String * 2

'[General]
   Global PortAddr As Integer          ' address of parallel port
   Global szRegName As String * 30

'[Board Types]
   Global Const MAX_BOARDS = 6
   Global Const LA_BOARD = 1
   Global Const AD_BOARD = 2
   Global Const NO_BOARD = 3
   Global Const AD_DELAY = 7     ' output delay due to A/D pipeline
   Global iBoardType(1 To MAX_BOARDS) As Integer
   Global Const MAX_TRACE_THICKNESS = 10
   Global Thickness(1 To MAX_BOARDS) As Long
   Global Invert(1 To MAX_BOARDS) As Byte
   
'[LA_CHANNELS]
   Global szChannelName(1 To MAX_BOARDS, 0 To 7) As String * 20
   Global bLA_Use(1 To MAX_BOARDS, 0 To 7) As Byte
   
'[AD_CHANNELS]
   Global Const AD_RANGE_MAX = 7       ' nbr of A/D ranges
   Global Const AD_SCALE_MAX = 7
   Global Const AD_SCALE_1 = 4               ' default scale factor index: value = 1.0
   Global Const ADTRIGGERMAX = 15      ' max value for trigger
   Global ADScaleFactors(1 To 7) As Single      ' constants: .1, .2, .5, 1, 2, 5, 10
   Global AD_RangeIndex(1 To MAX_BOARDS) As Integer
   Global bADTrig(1 To MAX_BOARDS) As Byte
   Global ADTrig(1 To MAX_BOARDS) As Single
   Global AD_Color(1 To MAX_BOARDS) As Long

   Global szAD_Range(0 To AD_RANGE_MAX) As String * 10
   Global AD_Range(0 To 7, 0 To 1) As Single ' 1 = upper voltage limit
   Global AD_YscaleIndex(1 To MAX_BOARDS) As Integer
   Global AD_Yoffset(1 To MAX_BOARDS) As Single
   Global VoltsPerBit(1 To MAX_BOARDS) As Single

   Global VGridLines As Integer        ' number of voltage grid lines
   Global Const MAXVGRIDLINES = 7
   Global GridLineVolts(0 To MAXVGRIDLINES + 1)
   Global curADbd As Integer

'[Trigger]
   Global Const TRIG_MAX = 15
   Global Const PRE_TRIG_MAX = 14
   Global Const NO_TRIG = 255
   Global Const TRIG_WINDOW = 2 ^ 13
   Global iPreTrig As Integer
   Global iPostTrig As Integer
   Global bTrig(0 To 7) As Byte
   Global iCursor2Trigger As Integer   ' 1=cursor to trigger on Draw

'[TimeBase]
   Global Const TIME_BASE_VALS = 15
   Global iTimeBaseIndex As Integer
   Global szSamplePeriodName(0 To TIME_BASE_VALS) As String * 10
   Global rSamplePeriod(0 To TIME_BASE_VALS) As Single

'[DISPLAY]
   Global Const MAX_SAMPLES = 2 ^ 17   ' determined by RAM
   Global Const MAX_SCREENS = 5
   Global ScreensFlag(0 To 5) As Boolean
   Global fZoom1 As Single
   Global fZoom2 As Single
   Global fSlide1 As Single
   Global fSlide2 As Single
   Global AD_Size As Single
   Global LA_Size As Single
   Global lStartSample(0 To MAX_SCREENS) As Long
   Global lEndSample(0 To MAX_SCREENS) As Long
   Global lTotalSamples As Long
   Global iMax_Samples As Long      ' determined by Pre & Post Trig values
   Global CurrentScreen As Integer  ' current screen 0..MAX_SCREENS
   Global AutoUpdate As Integer

'[MARKERS]
   Global Const NBR_CURSORS = 4     ' number of "other" cursors
   Global Const MAXVCURSORS = 2
   Global Const TPD_MIN = 0.0000001    ' 100 ns
   Global Const TPD_MAX = 0.1          ' 100 ms
   Global lCursorSample(0 To NBR_CURSORS) As Long
   Global iCursorFlag(0 To NBR_CURSORS) As Integer
   Global CursorsColor As Long
   Global CursorsWidth As Integer
   Global TGridLinesOn As Integer
   Global TGridLinesColor As Long
   Global TGridLinesWidth As Integer
   Global VCursorValue(0 To MAXVCURSORS - 1) As Integer
   Global CursorDataTop2Bot As Boolean

'MENU_POSITIONS]
   Global PChannelParamsTop As Integer
   Global PChannelParamsLeft As Integer
   Global PBoardsTop As Integer
   Global PBoardsLeft As Integer
   Global PTriggerTop As Integer
   Global PTriggerLeft As Integer
   Global PDisplayTop As Integer
   Global PDisplayLeft As Integer
   Global PMarkersTop As Integer
   Global PMarkersLeft As Integer
   Global PMeasureTop As Integer
   Global PMeasureLeft As Integer

   
'************* end INI file constants and globals *************

   Global ParamChannel As Integer

   Global sLA_Use As String * 8
   Global iLAchannels As Integer
   Global iADchannels As Integer
   Global ChannelsChanged As Integer

   Global DataFilename As String * 80
   
   Global AD_RangeMax As Integer

   Global TPDvalues(1 To 27) As Single
   Global iTPD As Integer              ' index into TPDvalues
   Global iTPDchange As Integer
   Global TPDtext As String * 10       ' text for current TPD value


' Drawing values
   Global Const X_INITIAL = 10
   Global Const Y_INITIAL = 120
   Global Const Y_INCREMENT = 10
   Global Const Y_SPACE = 40
   Global Const X_SPACE = 80
   Global Const STARTS = 0
   Global Const ENDS = 1
   Global Const WINDOW_HSX_SCALE = 4
   Global Const MIN_WINDOW = WINDOW_HSX_SCALE * 5

' Time Cursor stuff
   Global iCursorDispType As Boolean   ' TRUE = samples, FALSE = time

   Global bDataArray(0 To MAX_BOARDS, 0 To MAX_SAMPLES - 1) As Byte
   Global iSampleNr As Long

   Global iCursorDisplay As Integer ' 0=off,  1=Ch1 is MSB,   2=Ch8 is MSB
   Global iCursorBase As Integer    ' 0 = Decimal,  1 = Hex,  2 = Octal,  3 = Binary

'Measurement values             these ALL must be synchronized with the option indices
   Global iMeasType As Integer
   Global Const MEAS_ASYNCH = 0
   Global Const MEAS_SYNCH = 1
   Global Const MEAS_NONE = 2
   
   Global Const CH1OFFSET = 1000

   Global iMeasMSBFirst As Integer
   Global Const MEAS_MSB_FIRST = 0
   Global Const MEAS_MSB_LAST = 1

   Global iMeasParity As Integer
   Global Const MEAS_PARITY_EVEN = 0
   Global Const MEAS_PARITY_ODD = 1
   Global Const MEAS_PARITY_0 = 2
   Global Const MEAS_PARITY_1 = 3
   Global Const MEAS_PARITY_NONE = 4

   Global iMeasClkEdge As Integer
   Global Const MEAS_FALLING = 0
   Global Const MEAS_RISING = 1

   Global iMeasDisplayMode As Integer
   Global Const MEAS_DISPLAY_MODE_ASCII = 0
   Global Const MEAS_DISPLAY_MODE_HEX = 1

   Global iMeasDataBits As Integer
   Global iMeasStopBits As Integer
   Global iMeasBaud As Long
   Global iMeasCursor As Integer
   Global iMeasBoard As Integer
   Global iMeasChannel(0 To 1) As Integer
   Global iMeasClkCh As Integer
   Global iMeasCount As Long
   Global TimePerBit As Double
   Global SamplesPerBit As Double
   Global MeasLeft As Single
   Global MeasTop As Single
   Global DisplayHeight As Integer

'Other files required by the program
#If doDebug Then
        ' Parallel Port
   Declare Function Inp Lib "c:\jlc\dso\vb\inpout32.Dll" Alias "Inp32" (ByVal PortAddress As Integer) As Integer
   Declare Sub Out Lib "c:\jlc\dso\vb\inpout32.Dll" Alias "Out32" (ByVal PortAddress As Integer, ByVal Value As Integer)
#Else
        ' Parallel Port
   Declare Function Inp Lib "inpout32.Dll" Alias "Inp32" (ByVal PortAddress As Integer) As Integer
   Declare Sub Out Lib "inpout32.Dll" Alias "Out32" (ByVal PortAddress As Integer, ByVal Value As Integer)
#End If

