Attribute VB_Name = "DSO_Subs"

Public Sub SetChPos()
   Dim I As Integer
   Dim J As Integer
   iLAchannels = 0                  ' init channel position
   iADchannels = 0
   For I = 1 To MAX_BOARDS
      If iBoardType(I) = AD_BOARD Then
         iADchannels = iADchannels + 1
      Else
         For J = 0 To 7             ' for each of 8 possible channels
            If bLA_Use(I, J) Then
               iLAchannels = iLAchannels + 1 ' update channel position
               bLA_Use(I, J) = iLAchannels ' save channel position
            End If
         Next J
      End If
   Next I
End Sub

Public Function CursorDataValue(CursorNbr)
   Dim CursorString As Variant
   Dim bCursorValue As Byte
   Dim Mask As Integer
   Dim bValue As Byte
   Dim I As Integer
   Dim Brd As Integer

   CursorString = ""
   For Brd = 1 To MAX_BOARDS        ' for each board
      bValue = bDataArray(Brd, lCursorSample(CursorNbr)) ' get sample value
      If iBoardType(Brd) = AD_BOARD Then
         CursorString = CursorString & Hex(bValue) & " "
      ElseIf iBoardType(Brd) = LA_BOARD Then
         bCursorValue = 0
         If CursorDataTop2Bot Then  ' Bit 0 = MSB
            Mask = 1                ' mask for bit 0
            For Ch = 0 To 7
               If bLA_Use(Brd, Ch) Then
                  If bValue And 2 ^ Ch Then bCursorValue = bCursorValue Or (128 \ Mask)
                  Mask = Mask * 2
               End If
            Next Ch
         Else                       ' Bit 7 = MSB
            Mask = 128              ' mask for bit 7
            For Ch = 7 To 0 Step -1
               If bLA_Use(Brd, Ch) Then
                  If bValue And 2 ^ Ch Then bCursorValue = bCursorValue Or Mask
                  Mask = Mask / 2
               End If
            Next Ch
         End If
         CursorString = CursorString & Hex(bCursorValue) & " "
      End If
   Next Brd ' next board
   CursorDataValue = CursorString
End Function ' CursorDataValue
