Attribute VB_Name = "DSO_IO"
  'This module contains all the functions which use the printer port
'Printer Port control bit descriptions
' C0, C1 and C3 are low true;  C2 is high true
' C0..C2 select the basic function
' C3 is the  "clock" or strobe
'
' The following are for the DSO_LA only - not the SBLA!
' Main Functions
'  0 = not used
'  1 = SysReset-PL
'  2 = SysEnable-PL
'  3 = subFunction Select
'  4 = ReadClock-PL
'  5 = subFunction 0..7 strobe
'  6 = not used
'  7 = not used
'
' subFunctions
'  bits 0..3
'     0 = CmpLatch-Ch0-PL
'     1 = CmpLatch-Ch1-PL
'     2 = CmpLatch-Ch2-PL
'     3 = CmpLatch-Ch3-PL
'     4 = not used
'     5 = not used
'     6 = TrigChEna-PL
'     7 = TrigChState-PL
'     8 = Read-Ch0-L
'     9 = Read-Ch1-L
'    10 = Read-Ch2-L
'    11 = Read-Ch3-L
'    12 = Read-Ch4-L
'    13 = Read-Ch5-L
'    14 = ReadLowTrigAddr-L
'    15 = ReadHighTrigAddr-L
'  bits 4..6
'     Time Base Select
'     0 = ReadClock-PL
'     1..7 = Sample Clock
'  bit 7 = not used

Public Sub CtrlBit(BitNbr, State)
Dim Mask As Integer
' set/clear a control bit
   I = 2 ^ BitNbr             ' create mask for bit
   If SBLA > 0 And I = SBLA_READ Then
      Mask = SBLA_READ Or READ_ENABLE_MASK
      iControlPort = iControlPort And Not Mask
      If State = 1 Then iControlPort = iControlPort Or Mask
   End If

   If State = 0 Then
      iControlPort = iControlPort And Not I
   Else
      iControlPort = iControlPort Or I
   End If
   WrControl (iControlPort)
End Sub ' CtrlBit

Public Sub ReadCh(Channel As Integer)
' read the channel - put the data in bDataArray(0,0...)
   Dim Addr As Long
   Dim I As Integer
   Dim J As Integer
   Dim K As Integer
   Dim TimeBaseIndexSave As Integer
   
' reset the system - including the address generator - also clears pre/post trigger values
' NOTE: same for SBLA
   WrControl SYSRESET
   WrControl SYSRESET + CONTROL_STROBE
   WrControl SYSRESET
   
   If SBLA = 0 Then
      TimeBaseIndexSave = iTimeBaseIndex  ' save value
      iTimeBaseIndex = 0         ' set for ReadClock
      SubFunction Channel        ' select the channel
' read each byte
      J = Channel - SUB_READ_0 + 1
      If iBoardType(J) = AD_BOARD Then
         K = Invert(J)
         For Addr = 1 To MAX_SAMPLES - 1
            WrControl READSUB Or READ_ENABLE_MASK ' set control port to read
            WrControl READSUB Or READ_ENABLE_MASK Or CONTROL_STROBE  ' advances address counter
            J = Inp(PortAddr)
            If K Then J = 255 - J
            bDataArray(0, Addr) = J
         Next Addr
      Else
         For Addr = 1 To MAX_SAMPLES - 1
            WrControl READSUB Or READ_ENABLE_MASK ' set control port to read
            WrControl READSUB Or READ_ENABLE_MASK Or CONTROL_STROBE  ' advances address counter
            J = Inp(PortAddr)
            bDataArray(0, Addr) = J
         Next Addr
      End If
      WrControl READSUB Or READ_ENABLE_MASK ' set control port to read
      WrControl READSUB Or READ_ENABLE_MASK Or CONTROL_STROBE  ' advances address counter
      bDataArray(0, 0) = Inp(PortAddr)
      WrControl READSUB          ' disable read
      iTimeBaseIndex = TimeBaseIndexSave  ' restore
   Else ' if SBLA
' read each byte
      I = READ_ENABLE_MASK Or (Channel - 1 + SBLA_READ_RAM_0)
      WrControl (I)                                      ' enable read
      For Addr = 0 To MAX_SAMPLES - 1
         If Addr = 69630 Then                      ' for debugging
            J = 0
         End If
         J = Inp(PortAddr)
         bDataArray(0, Addr) = J Xor Invert(Channel)
         WrControl I Or CONTROL_STROBE  ' advances address counter
         WrControl I
      Next Addr
      WrControl (0)                                      ' remove read enable
   End If
End Sub ' ReadCh

Public Function ReadData()
' read data from the Data port
   If SBLA = 0 Then
      WrControl (READ_ENABLE_MASK Or READSUB) ' enable read
' now put the data on the bus
      WrControl (READ_ENABLE_MASK Or READSUB Or CONTROL_STROBE)
   Else
      WrControl (READ_ENABLE_MASK Or iControlPort) ' enable read
   End If
   ReadData = Inp(PortAddr)
'   WrControl (READSUB)   ' remove read enable
End Function ' ReadData

Public Sub ReadStatus()
' read from the status port
   I = Inp(PortAddr + STATUS_OFFSET)
   iTrigLatch = (I And 16) \ 16
   iSampleClkEna = (I And 32) \ 32
   iPreTrigDone = (I And 64) \ 64
   iStatusBit7 = (I And 128) \ 128
End Sub ' ReadStatus

Public Function ReadTrigAddr()
' read the trigger address
   Dim LowAddr As Long
   Dim HighAddr As Long

   If SBLA = 0 Then
      SubFunction SUB_READ_LOW_TRIG_ADR
      LowAddr = ReadData And &HFF           ' make sure upper bits are 0
      SubFunction SUB_READ_HIGH_TRIG_ADR
      HighAddr = ReadData
   Else
      WrControl (SBLA_READ_TRIG_ADDR_HIGH)  ' enable read
      HighAddr = Inp(PortAddr) And &HFF   ' make sure upper bits are 0
      TimeDelay (100)
      HighAddr = Inp(PortAddr) And &HFF   ' make sure upper bits are 0
      HighAddr = Inp(PortAddr) And &HFF   ' make sure upper bits are 0

      WrControl (SBLA_READ_TRIG_ADDR_LOW)  ' enable read
      LowAddr = Inp(PortAddr) And &HFF   ' make sure upper bits are 0
      TimeDelay (100)
      LowAddr = Inp(PortAddr) And &HFF   ' make sure upper bits are 0
      LowAddr = Inp(PortAddr) And &HFF   ' make sure upper bits are 0

      WrControl (0)   ' remove read enable
   End If

   ReadTrigAddr = LowAddr + (HighAddr * 256)
   ReadTrigAddr = ReadTrigAddr * 2          ' adjust for no address bit 0
End Function ' ReadTrigAddr

Public Sub SubFunction(iSub As Integer)
   WrData (iTimeBaseIndex * 16) Or iSub ' put subfunction on data bus
   WrControl SUBSELECT     ' select sub function
   WrControl SUBSELECT + CONTROL_STROBE ' latch it
   WrControl SUBSELECT     ' remove latch
End Sub ' SubFunction

Public Sub WrControl(Value As Integer)
' write a value to the Control port
Dim LoopCount As Long
   If SBLA > 0 Then
      I = (Value And (SBLA_READ Or READ_ENABLE_MASK))
      If (I = 0) Then
         Value = Value And Not (SBLA_READ Or READ_ENABLE_MASK)
      Else
         Value = Value Or SBLA_READ Or READ_ENABLE_MASK
      End If
   End If

   iControlPort = Value          ' save the value
   I = iControlPort Xor CONTROL_PORT_MASK
   If SBLA > 0 Then I = I Xor CONTROL_STROBE        ' adjust for high true strobe
   Out PortAddr + CONTROL_OFFSET, I
   If I And CONTROL_STROBE Then
      I = 1
   Else
      I = 0
   End If
   LoopCount = 0
   Do
      ReadStatus
      LoopCount = LoopCount + 1
   Loop Until (iStatusBit7 = I) Or (LoopCount > 100000#)
End Sub ' WrControl

Public Sub WrData(Value As Integer)
' write a value to the Data port
   I = iControlPort And Not READ_ENABLE_MASK ' printer port to write
   If SBLA > 0 Then
      I = I And Not SBLA_READ              ' SBLA logic to read from printer port
   End If
   WrControl (I)          ' set control port to write
   iDataPort = Value
   Out PortAddr, iDataPort
End Sub ' WrData

Public Sub WrSub(ByVal iSub As Integer, Value As Byte)
   SubFunction iSub
   WrData (Value)
   WrControl WRITESUB
   WrControl WRITESUB + CONTROL_STROBE
   WrControl WRITESUB
End Sub ' WrSub

Public Sub Sys_SetTrigger(TrigEna As Byte, TrigState As Byte)
   If SBLA = 0 Then
      WrSub SUB_TRIG_CH_ENA, TrigEna
      WrSub SUB_TRIG_CH_STATE, TrigState
   Else
      I = TrigState And &HF      ' keep lower 4 bits
      J = TrigEna And &HF        ' keep lower 4 bits
      WrData (I + (J * 16))
      WrControl SBLA_TRIG
      TimeDelay (1000)
      WrControl SBLA_TRIG + CONTROL_STROBE
      TimeDelay (1000)
      WrControl SBLA_TRIG
'      WrControl SBLA_TRIG + READ_ENABLE_MASK
   End If
End Sub ' Sys_SetTrigger

Public Sub Sys_Reset()
' System Reset - includes setting the Pre and Post trigger values
' NOTE: this is the same for the SBLA
   WrData (iPreTrig + (iPostTrig * 16))
   WrControl SYSRESET
'      TimeDelay (1000)
   WrControl SYSRESET + CONTROL_STROBE
'      TimeDelay (1000)
   WrControl SYSRESET
   If SBLA > 0 Then
'      WrControl SYSRESET + READ_ENABLE_MASK
   End If
End Sub ' Sys_Reset

Public Sub Sys_Enable()
   If SBLA = 0 Then
      WrControl SYSENABLE
      WrControl SYSENABLE + CONTROL_STROBE
      WrControl SYSENABLE
   Else
      WrData (iTimeBaseIndex)
      WrControl SBLA_ENA
      TimeDelay (1000)
      WrControl SBLA_ENA + CONTROL_STROBE
      TimeDelay (1000)
      WrControl SBLA_ENA
'      WrControl SBLA_ENA + READ_ENABLE_MASK
   End If
End Sub ' Sys_Enable

Public Sub TimeDelay(Counts As Long)
      For I = 1 To Counts
         DoEvents
      Next I
End Sub

Public Sub SetEPPmode()
   I = Inp(PortAddr + ECR_OFFSET)   ' read ECR register - if it exists
   I = I And ECR_MASK               ' remove mode bits
   I = I + ECR_MODE_EPP             ' put into ECP mode
   Out PortAddr + ECR_OFFSET, I     ' set mode to EPP
   I = Inp(PortAddr + ECR_OFFSET)   ' read ECR register - if it exists
End Sub
