Attribute VB_Name = "DSO_INI_File"
Public Function fnIniRead()
' open and read the INI file
' return values
'  1 = success
'  0 = failure

   Dim I As Integer
   Dim J As Integer
   Dim K As Integer
   Dim LineType As Integer
   Dim Section As Integer
   Dim rMult As Single
   Dim sVal As Single
   Dim cChar As String * 1
   Dim BrdNbr As Integer
   Dim Volts As Single
   Dim Offset As Single

' Initialize parameters
   PortAddr = 0
'[Boards] & [LA_CHANNELS] & [AD_CHANNELS]
   SBLA = 0
   For BrdNbr = 1 To MAX_BOARDS
      iBoardType(BrdNbr) = 0
      Invert(BrdNbr) = 0
      For J = 0 To 7
         szChannelName(BrdNbr, J) = " "
         bLA_Use(BrdNbr, J) = 0
      Next J

      AD_RangeIndex(BrdNbr) = 0
      bADTrig(BrdNbr) = 7              ' middle of the range
      ADTrig(BrdNbr) = 0#
      Invert(BrdNbr) = 0
      AD_Color(BrdNbr) = vbBlack
      Thickness(BrdNbr) = 1
      AD_YscaleIndex(BrdNbr) = AD_SCALE_1
      AD_Yoffset(BrdNbr) = 0
   Next BrdNbr
   AD_RangeMax = 0

'[AD_CHANNELS]
   For J = 0 To AD_RANGE_MAX     ' A/D parameters
      AD_Range(J, 0) = 0         ' lower voltage limit
      AD_Range(J, 1) = 0         ' upper voltage limit
      szAD_Range(J) = J & ": NoDef"
   Next J
   curADbd = 0

'[Trigger]
   For I = 0 To 7
      bTrig(I) = NO_TRIG
   Next I
   iPreTrig = 1
   iCursor2Trigger = 0

'[TimeBase]
   For I = 0 To TIME_BASE_VALS
      rSamplePeriod(I) = 0#
      szSamplePeriodName(I) = ""
   Next I
   szSamplePeriodName(0) = "RdClk"
   iTimeBaseIndex = 7
   
'[DISPLAY]
   For I = 0 To MAX_SCREENS
      lStartSample(I) = 0
      lEndSample(I) = 0
      ScreensFlag(I) = False
   Next I
   lEndSample(0) = 260
   lCursorSample(0) = (lEndSample(0) - lStartSample(0)) / 2
   ScreensFlag(0) = True

   fZoom1 = 2#
   fZoom2 = 4#
   fSlide1 = 0.5
   fSlide2 = 0.1
   LA_Size = 80
   AD_Size = 100 - LA_Size
   TGridLinesOn = 0
   TGridLinesColor = COLOR_VIOLET
   TGridLinesWidth = 1
   iTPD = 0             ' force AUTO for Time per Division
   VGridLines = 0
   AutoUpdate = 0
   
'[MARKERS]
   For I = 1 To NBR_CURSORS
      iCursorFlag(I) = 0
   Next I
   CursorsColor = COLOR_BLACK
   CursorsWidth = 1
   CursorDataTop2Bot = True
   iCursorDispType = True    ' samples
   
'[MEASUREMENT]
   iMeasType = MEAS_NONE
   iMeasDataBits = 8
   iMeasStopBits = 1
   iMeasParity = MEAS_PARITY_NONE
   iMeasBaud = 9600
   iMeasCursor = 1
   iMeasBoard = 1
   iMeasChannel(0) = 1
   iMeasChannel(1) = -1
   iMeasClkCh = 0
   iMeasClkEdge = MEAS_RISING
   iMeasMSBFirst = MEAS_MSB_FIRST
   DisplayHeight = 1
   
'[MENU_POSITIONS]
   PChannelParamsTop = 0
   PChannelParamsLeft = 0
   PBoardsTop = 0
   PBoardsLeft = 0
   PTriggerTop = 0
   PTriggerLeft = 0
   PDisplayTop = 0
   PDisplayLeft = 0
   PMarkersTop = 0
   PMarkersLeft = 0
   PMeasureTop = 0
   PMeasureLeft = 0


' PROCESS THE FILE
   On Error GoTo Error_fnIniRead
   Close                         ' just in case
   Open szIniFileName For Input Access Read As #INI_FILE
   On Error GoTo 0
   Section = 0                   ' init to no section yet
   Do
      LineType = fnIniLine       ' read a line
      Select Case LineType
      Case 0
         Exit Do
      Case 1
         If InStr(szString, "[GENERAL]") = 1 Then Section = GENERAL
         If InStr(szString, "[BOARD_TYPES]") = 1 Then Section = BOARD_TYPES
         If InStr(szString, "[LA_CHANNELS]") = 1 Then Section = LA_CHANNELS
         If InStr(szString, "[A/D_CHANNELS]") = 1 Then Section = AD_CHANNELS
         If InStr(szString, "[TRIGGER]") = 1 Then Section = TRIGGER
         If InStr(szString, "[TIMEBASE]") = 1 Then Section = TIMEBASE
         If InStr(szString, "[DISPLAY]") = 1 Then Section = DISPLAY
         If InStr(szString, "[MARKERS]") = 1 Then Section = MARKERS
         If InStr(szString, "[MEASUREMENT]") = 1 Then Section = MEASUREMENT
         If InStr(szString, "[MENU_POSITIONS]") = 1 Then Section = MENU_POSITIONS
         If InStr(szString, "[END]") = 1 Then Exit Do
      Case 2
         Select Case Section
         
         Case GENERAL
            If InStr(1, szString, "ADDRESS") = 1 Then PortAddr = szParameter
            If InStr(1, szString, "REG.NAME") = 1 Then
               szRegName = szParameter
            End If
            If InStr(1, szString, "SBLA") = 1 Then SBLA = szParameter
         'GENERAL

         Case BOARD_TYPES
            If InStr(1, szString, "BOARD_") = 1 Then
               BrdNbr = Val(Mid$(szString, 7, 1))   ' get board number
               If BrdNbr < 1 Or BrdNbr > MAX_BOARDS Then
                  I = MsgBox(szLine, vbOKOnly, "Invalid Board number")
               Else
                  If InStr(1, szParameter, "AD") Then iBoardType(BrdNbr) = AD_BOARD
                  If InStr(1, szParameter, "LA") Then iBoardType(BrdNbr) = LA_BOARD
               End If
            End If
            If InStr(1, szString, "THICKNESS_") = 1 Then
               BrdNbr = Val(Mid$(szString, 11, 1))   ' get board number
               I = szParameter
               If I > MAX_TRACE_THICKNESS Then I = MAX_TRACE_THICKNESS
               If I < 1 Then I = 1
               Thickness(BrdNbr) = I
            End If
         'BOARD_TYPES
         
         Case LA_CHANNELS
            I = InStr(1, szString, "_")   ' find board number
            BrdNbr = Val(Mid$(szString, I + 1, 1)) ' get the board number
            If BrdNbr < 1 Or BrdNbr > MAX_BOARDS Or iBoardType(BrdNbr) <> LA_BOARD Then
               I = MsgBox(szLine, vbOKOnly, "Not an LA Board")
               Exit Function
            End If
            
            If InStr(1, szString, "NAME_") = 1 Then
               J = Val(Mid$(szString, 8, 1)) ' get the ch nbr
               szChannelName(BrdNbr, J) = szParameter
            End If
            
            If InStr(1, szString, "USE_") = 1 Then
               For J = 0 To 7          ' for each of 8 possible channels
                  cChar = Mid$(szParameter, 9 - J, 1) ' get channel nbr
                  If cChar >= "0" And cChar <= "7" Then
                     bLA_Use(BrdNbr, Val(cChar)) = 1
                  End If
               Next J
            End If
         
            If InStr(1, szString, "INVERT_") = 1 Then
               For J = 0 To 7          ' for each of 8 possible channels
                  If Mid$(szParameter, J + 1, 1) = 1 Then
                     Invert(BrdNbr) = Invert(BrdNbr) + (2 ^ (7 - J))
                  End If
               Next J
            End If
         'LA_CHANNELS

         Case AD_CHANNELS
            I = InStr(1, szString, "_")   ' find board number
            If I > 0 Then
               BrdNbr = Val(Mid$(szString, I + 1, 1)) ' get the board number
               If BrdNbr > MAX_BOARDS Or iBoardType(BrdNbr) <> AD_BOARD Then
                  I = MsgBox(szString, vbOKOnly, "Not an AD Board")
                  Exit Function
               End If
               If curADbd = 0 Then curADbd = BrdNbr
            End If
            If InStr(1, szString, "CH.NAME_") = 1 Then szChannelName(BrdNbr, 0) = szParameter
            If InStr(1, szString, "CH.RANGE_") = 1 Then AD_RangeIndex(BrdNbr) = szParameter
            If InStr(1, szString, "CH.TRIG_") = 1 Then ADTrig(BrdNbr) = Val(szParameter) ' get trigger value
            If InStr(1, szString, "CH.COLOR_") = 1 Then AD_Color(BrdNbr) = szParameter
            If InStr(1, szString, "CH.INVERT_") = 1 Then Invert(BrdNbr) = szParameter
            If InStr(1, szString, "CH.YOFFSET_") = 1 Then AD_Yoffset(BrdNbr) = szParameter
            If InStr(1, szString, "CH.YSCALE_") = 1 Then
               sVal = szParameter                                 ' get scale factor
               If sVal > ADScaleFactors(AD_SCALE_MAX) Then sVal = ADScaleFactors(AD_SCALE_MAX)
               For I = 1 To AD_SCALE_MAX
                  If sVal < 1.1 * ADScaleFactors(I) Then
                     AD_YscaleIndex(BrdNbr) = I
                     Exit For
                  End If
               Next I
            End If ' CH.YSCALE_

         ' common for all boards
            If InStr(1, szString, "RANGE.") = 1 Then
               I = Val(Mid$(szString, 7, 1))                         ' get index number
               If I >= 0 And I <= AD_RANGE_MAX Then
                  szAD_Range(I) = szParameter                  ' store the string
                  AD_Range(I, 0) = Val(szParameter)          ' store lower value
                  J = InStr(1, szParameter, ",")
                  AD_Range(I, 1) = Val(Mid$(szParameter, J + 1)) ' store upper value
                  If I > AD_RangeMax Then AD_RangeMax = I
               End If
            End If
         'AD_CHANNELS

         Case TRIGGER
            If InStr(1, szString, "PRE.TRIG") = 1 Then
               iPreTrig = Val(szParameter)
               If iPreTrig > PRE_TRIG_MAX Then iPreTrig = PRE_TRIG_MAX
            End If
            If InStr(1, szString, "TRIG.") = 1 Then
               J = Val(Mid$(szString, 6, 1))  ' get trigger channel number
               If Mid$(szParameter, 1, 1) = "X" Then
                  bTrig(J) = NO_TRIG          ' show no trigger state
               Else
                  bTrig(J) = Val(szParameter) ' get trigger state
               End If
            End If
         'TRIGGER

         Case TIMEBASE
            If InStr(1, szString, "SELECT") = 1 Then iTimeBaseIndex = Val(szParameter)
            If InStr(1, szString, "PERIOD.") = 1 Then
               I = Val(Mid$(szString, 8, 2))   ' get index number
               If I > 0 And I <= TIME_BASE_VALS Then
                  szSamplePeriodName(I) = szParameter ' store the string
                  If InStr(1, szParameter, "ns") Then rMult = 0.000000001
                  If InStr(1, szParameter, "us") Then rMult = 0.000001
                  If InStr(1, szParameter, "ms") Then rMult = 0.001
                  rSamplePeriod(I) = Val(szParameter) * rMult
               End If
            End If
         'TIMEBASE

         Case DISPLAY
            If InStr(1, szString, "ZOOM1") = 1 Then fZoom1 = szParameter
            If InStr(1, szString, "ZOOM2") = 1 Then fZoom2 = szParameter
            If fZoom1 > 5 Then fZoom1 = 5
            If fZoom1 < 1 Then fZoom1 = 1
            If fZoom2 > 5 Then fZoom2 = 5
            If fZoom2 < 1 Then fZoom2 = 1
            If InStr(1, szString, "SLIDE1") = 1 Then fSlide1 = szParameter
            If InStr(1, szString, "SLIDE2") = 1 Then fSlide2 = szParameter
            If fSlide1 < 0.1 Then fSlide1 = 0.1
            If fSlide1 > 1# Then fSlide1 = 1#
            If fSlide2 < 0.1 Then fSlide2 = 0.1
            If fSlide2 > 1# Then fSlide2 = 1#
            If InStr(1, szString, "START.SAMPLE") = 1 Then
               I = Val(Mid$(szString, 14, 1))   ' get screen number
               If I < 0 Or I > MAX_SCREENS Then I = 0
               lStartSample(I) = szParameter
               ScreensFlag(I) = True
               If lEndSample(I) = 0 Then lEndSample(I) = MAX_SAMPLES - 1
            End If
            If InStr(1, szString, "END.SAMPLE") = 1 Then
               I = Val(Mid$(szString, 12, 1))   ' get screen number
               If I < 0 Or I > MAX_SCREENS Then I = 0
               lEndSample(I) = szParameter
            End If
            If InStr(1, szString, "LA.SIZE") = 1 Then LA_Size = szParameter
            If InStr(1, szString, "AD.SIZE") = 1 Then AD_Size = szParameter
            If InStr(1, szString, "CURSOR.TO.TRIGGER") = 1 Then
               iCursor2Trigger = Val(szParameter)
            End If
            If InStr(1, szString, "AUTOUPDATE") = 1 Then AutoUpdate = szParameter
            If InStr(1, szString, "TGRIDLINES.ON") = 1 Then TGridLinesOn = szParameter
            If InStr(1, szString, "TGRIDLINES.COLOR") = 1 Then TGridLinesColor = szParameter
            If InStr(1, szString, "TGRIDLINES.THICKNESS") = 1 Then TGridLinesWidth = szParameter
            If InStr(1, szString, "VGRIDLINES.ON") = 1 Then VGridLines = szParameter
         'DISPLAY

         Case MARKERS
            If InStr(1, szString, "MARKER_NBR.") = 1 Then
               I = Val(Mid$(szString, 12, 1))   ' get cursor number
               If I >= 0 And I <= NBR_CURSORS Then
                  lCursorSample(I) = szParameter
                  iCursorFlag(I) = 1
               End If
            End If
            If InStr(1, szString, "MARKER.COLOR") = 1 Then CursorsColor = szParameter
            If InStr(1, szString, "MARKER.THICKNESS") = 1 Then CursorsWidth = szParameter
            If CursorsWidth < 1 Or CursorsWidth > 10 Then CursorsWidth = 1
            If InStr(1, szString, "MARKER_DISPLAY") = 1 Then
               If InStr(1, szParameter, "TIME") = 1 Then iCursorDispType = False
            End If
         'MARKERS
         
         Case MEASUREMENT
            If InStr(1, szString, "TYPE") = 1 Then
               If InStr(1, szParameter, "NONE") = 1 Then iMeasType = MEAS_NONE
               If InStr(1, szParameter, "SYNCH") = 1 Then iMeasType = MEAS_SYNCH
               If InStr(1, szParameter, "ASYNCH") = 1 Then iMeasType = MEAS_ASYNCH
            End If
            
            If InStr(1, szString, "DISPLAY_MODE") = 1 Then
               If InStr(1, szParameter, "ASCII") = 1 Then iMeasDisplayMode = MEAS_DISPLAY_MODE_ASCII
               If InStr(1, szParameter, "HEX") = 1 Then iMeasDisplayMode = MEAS_DISPLAY_MODE_HEX
            End If
            
            If InStr(1, szString, "BAUD") = 1 Then iMeasBaud = szParameter
            If InStr(1, szString, "PARITY") = 1 Then
               If InStr(1, szParameter, "NONE") = 1 Then iMeasParity = MEAS_PARITY_NONE
               If InStr(1, szParameter, "EVEN") = 1 Then iMeasParity = MEAS_PARITY_EVEN
               If InStr(1, szParameter, "ODD") = 1 Then iMeasParity = MEAS_PARITY_ODD
               If InStr(1, szParameter, "0") = 1 Then iMeasParity = MEAS_PARITY_0
               If InStr(1, szParameter, "1") = 1 Then iMeasParity = MEAS_PARITY_1
            End If
            If InStr(1, szString, "DATA_BITS") = 1 Then iMeasDataBits = szParameter
            If InStr(1, szString, "STOP_BITS") = 1 Then iMeasStopBits = szParameter
            If InStr(1, szString, "MARKER") = 1 Then iMeasCursor = szParameter
            If InStr(1, szString, "BOARD") = 1 Then iMeasBoard = szParameter
            If InStr(1, szString, "CHANNEL_0") = 1 Then iMeasChannel(0) = szParameter
            If InStr(1, szString, "CHANNEL_1") = 1 Then iMeasChannel(1) = szParameter
            If InStr(1, szString, "CLOCK_CHANNEL") = 1 Then iMeasClkCh = szParameter
            If InStr(1, szString, "CLOCK_EDGE") = 1 Then
               If InStr(1, szParameter, "RISING") = 1 Then iMeasClkEdge = MEAS_RISING
               If InStr(1, szParameter, "FALLING") = 1 Then iMeasClkEdge = MEAS_FALLING
            End If
            If InStr(1, szString, "MSB") = 1 Then
               If InStr(1, szParameter, "FIRST_BIT") = 1 Then iMeasMSBFirst = MEAS_MSB_FIRST
               If InStr(1, szParameter, "LAST_BIT") = 1 Then iMeasMSBFirst = MEAS_MSB_LAST
            End If
            If InStr(1, szString, "DISPLAY_HEIGHT") = 1 Then DisplayHeight = szParameter
         'MEASUREMENT

         Case MENU_POSITIONS
            If InStr(1, szString, "ChannelParamsTop") = 1 Then PChannelParamsTop = szParameter
            If InStr(1, szString, "ChannelParamsLeft") = 1 Then PChannelParamsLeft = szParameter
            If InStr(1, szString, "BoardsTop") = 1 Then PBoardsTop = szParameter
            If InStr(1, szString, "BoardsLeft") = 1 Then PBoardsLeft = szParameter
            If InStr(1, szString, "TriggerTop") = 1 Then PTriggerTop = szParameter
            If InStr(1, szString, "TriggerLeft") = 1 Then PTriggerLeft = szParameter
            If InStr(1, szString, "DisplayTop") = 1 Then PDisplayTop = szParameter
            If InStr(1, szString, "DisplayLeft") = 1 Then PDisplayLeft = szParameter
            If InStr(1, szString, "MarkersTop") = 1 Then PMarkersTop = szParameter
            If InStr(1, szString, "MarkersLeft") = 1 Then PMarkersLeft = szParameter
            If InStr(1, szString, "MeasureTop") = 1 Then PMeasureTop = szParameter
            If InStr(1, szString, "MeasureLeft") = 1 Then PMeasureLeft = szParameter
         'MENU_POSITIONS
         
         End Select ' section
      End Select ' LineType
   Loop
   Close #INI_FILE

' post file processing
   iPostTrig = TRIG_MAX - iPreTrig
   iMax_Samples = ((iPreTrig + iPostTrig) * TRIG_WINDOW) + TRIG_WINDOW / 2
   lTotalSamples = lEndSample(0) - lStartSample(0) - 1
   If (lEndSample(0) - lStartSample(0) < MIN_WINDOW) Or (lTotalSamples > iMax_Samples) Then
      lStartSample(0) = (iPreTrig * TRIG_WINDOW) - (TRIG_WINDOW / 2)
      lEndSample(0) = lStartSample(0) + TRIG_WINDOW
   End If
   
   If SBLA = 0 Then
      frmDSO.Caption = "DSO & Logic Analyzer: Version " & VERSION & ", " & Trim$(szRegName) & "  " & Trim$(szIniFileName)
   Else
      frmDSO.Caption = "Logic Analyzer: Version " & VERSION & ", " & Trim$(szRegName) & "  " & Trim$(szIniFileName)
      For BrdNbr = 1 To MAX_BOARDS
         If iBoardType(BrdNbr) = AD_BOARD Then iBoardType(BrdNbr) = NO_BOARD
      Next BrdNbr
   End If

' calculate A/D trigger value from voltage and range
   For BrdNbr = 1 To MAX_BOARDS
      If iBoardType(BrdNbr) = AD_BOARD Then
         Volts = AD_Range(AD_RangeIndex(BrdNbr), 1) - AD_Range(AD_RangeIndex(BrdNbr), 0) ' voltage span
         Volts = Volts / (ADTRIGGERMAX + 1)  ' trigger resolution
         Offset = ADTrig(BrdNbr) - AD_Range(AD_RangeIndex(BrdNbr), 0) ' trigger offset to lowest value
         Offset = Offset / Volts                       ' value to program
         bADTrig(BrdNbr) = Offset                  ' offset to trigger value
      End If '  AD_BOARD
   Next BrdNbr

   If LA_Size + AD_Size > 100 Then
      I = MsgBox("LA area overlaps AD area", vbOKOnly + vbExclamation, szIniFileName)
   End If
   If lCursorSample(0) = 0 Then lCursorSample(0) = iPreTrig * TRIG_WINDOW
   iCursorFlag(0) = 1
   SetChPos

   fnIniRead = 1                 ' show success
   Exit Function

Error_fnIniRead:
   On Error GoTo 0
   Close #INI_FILE
   I = MsgBox(szIniFileName, vbOKOnly, "Error Opening File")
   fnIniRead = 0                 ' show failure
End Function ' fnIniRead


Public Function fnIniWrite()
' open and write the INI file
' return values
'  1 = success
'  0 = failure

   Dim I As Integer
   Dim Section As Integer

   On Error GoTo Error_fnIniWrite
   Close                         ' just in case
   Open szIniFileName For Output Access Write As #INI_FILE
   If SBLA > 0 Then
      Print #INI_FILE, "; DSO & Logic Analyzer: Version " & VERSION & ",   " & Trim$(szIniFileName) & "  " & Now
   Else
      Print #INI_FILE, "; SBLA: Version " & SBLA_VERSION & ",   " & Trim$(szIniFileName) & "  " & Now
   End If
   Print #INI_FILE, ""

'GENERAL
   Print #INI_FILE, "[GENERAL] ******************************"
   Print #INI_FILE, "ADDRESS = &H" & Trim(Hex$(PortAddr))
   Print #INI_FILE, "REG.NAME = " & Trim(szRegName)
   If SBLA > 0 Then Print #INI_FILE, "SBLA = " & SBLA
   Print #INI_FILE, ""

'BOARD_TYPES
   Print #INI_FILE, "[BOARD_TYPES] **************************"
   For I = 1 To MAX_BOARDS
      If iBoardType(I) = AD_BOARD Then Print #INI_FILE, "BOARD_" & I & " = AD"
      If iBoardType(I) = LA_BOARD Then Print #INI_FILE, "BOARD_" & I & " = LA"
      If iBoardType(I) <> 0 Then Print #INI_FILE, "THICKNESS_" & I & " = " & Thickness(I)
   Next I
   Print #INI_FILE, ""
   'BOARD_TYPES

'LA_CHANNELS
   Print #INI_FILE, "[LA_CHANNELS] *****************************"
   For BrdNbr = 1 To MAX_BOARDS
      If iBoardType(BrdNbr) = LA_BOARD Then
         For J = 0 To 7
            If Mid$(szChannelName(BrdNbr, J), 1, 1) <> " " Then
               Print #INI_FILE, "NAME_" & BrdNbr & "." & J & " = " & szChannelName(BrdNbr, J)
            End If
         Next J
         sLA_Use = "xxxxxxxx"
         szParameter = "00000000"
         For J = 7 To 0 Step -1
            If bLA_Use(BrdNbr, J) Then
               Mid$(sLA_Use, 8 - J, 1) = J
            End If
            If (Invert(BrdNbr) And (2 ^ J)) <> 0 Then
               Mid$(szParameter, 8 - J, 1) = 1
            End If
         Next J
         Print #INI_FILE, "USE_" & BrdNbr & " = " & sLA_Use
         Print #INI_FILE, "INVERT_" & BrdNbr & " = " & Trim$(szParameter)
      End If
   Next BrdNbr
   Print #INI_FILE, ""
   'LA_CHANNELS

'AD_CHANNELS
   If SBLA = 0 Then
   
   Print #INI_FILE, "[A/D_CHANNELS] ****************************"
   
   Print #INI_FILE, ";   A/D Ranges - same for all boards"
   For I = 0 To AD_RANGE_MAX
      Print #INI_FILE, "RANGE." & I & " = " & szAD_Range(I)
   Next I

   Print #INI_FILE, ";   Board Specific Values"
   For BrdNbr = 1 To MAX_BOARDS
      If iBoardType(BrdNbr) = AD_BOARD Then
         Print #INI_FILE, "CH.NAME_" & BrdNbr & " = " & Trim$(szChannelName(BrdNbr, 0))
         Print #INI_FILE, "CH.RANGE_" & BrdNbr & " = " & AD_RangeIndex(BrdNbr)
         Print #INI_FILE, "CH.TRIG_" & BrdNbr & " = " & ADTrig(BrdNbr)
         Print #INI_FILE, "CH.COLOR_" & BrdNbr & " = " & AD_Color(BrdNbr)
         Print #INI_FILE, "CH.INVERT_" & BrdNbr & " = " & Invert(BrdNbr)
         Print #INI_FILE, "CH.YSCALE_" & BrdNbr & " = " & ADScaleFactors(AD_YscaleIndex(BrdNbr))
         Print #INI_FILE, "CH.YOFFSET_" & BrdNbr & " = " & AD_Yoffset(BrdNbr)
      End If
   Next BrdNbr
   Print #INI_FILE, ""
   
   End If
   'AD_CHANNELS

'TRIGGER
   Print #INI_FILE, "[TRIGGER] ******************************"
   Print #INI_FILE, "PRE.TRIG = " & iPreTrig
   MaxChannel = 7               ' assume DSO/LA
   If SBLA > 0 Then MaxChannel = 3
   For J = 0 To MaxChannel
      cChar = "X"                   ' default to no trigger
      If bTrig(J) <> NO_TRIG Then   ' if trigger
         cChar = "0"                ' assume 0 state
         If bTrig(J) = 1 Then cChar = "1"
      End If
      Print #INI_FILE, "TRIG." & J & " = " & cChar
   Next J
   Print #INI_FILE, ""
   'TRIGGER

'TIMEBASE
   Print #INI_FILE, "[TIMEBASE] *****************************"
   Print #INI_FILE, "PERIOD.0 = read"
   For I = 1 To TIME_BASE_VALS
      If rSamplePeriod(I) > 0 Then
         Print #INI_FILE, "PERIOD." & I & " = " & Trim$(szSamplePeriodName(I))
      End If
   Next I
   Print #INI_FILE, "SELECT = " & iTimeBaseIndex
   Print #INI_FILE, ""
   'TIMEBASE

'DISPLAY
   Print #INI_FILE, "[DISPLAY] ******************************"
   Print #INI_FILE, "ZOOM1 = " & fZoom1
   Print #INI_FILE, "ZOOM2 = " & fZoom2
   Print #INI_FILE, "SLIDE1 = " & fSlide1
   Print #INI_FILE, "SLIDE2 = " & fSlide2
   For I = 0 To MAX_SCREENS
      If ScreensFlag(I) Then
         Print #INI_FILE, "START.SAMPLE_" & I & " = " & lStartSample(I)
         Print #INI_FILE, "END.SAMPLE_" & I & " = " & lEndSample(I)
      End If
   Next I
   Print #INI_FILE, "LA.SIZE = " & LA_Size
   If SBLA = 0 Then Print #INI_FILE, "AD.SIZE = " & AD_Size
   Print #INI_FILE, "CURSOR.TO.TRIGGER = " & iCursor2Trigger
   Print #INI_FILE, "AUTOUPDATE = " & AutoUpdate
   Print #INI_FILE, "TGRIDLINES.ON = " & TGridLinesOn
   Print #INI_FILE, "TGRIDLINES.COLOR = " & TGridLinesColor
   Print #INI_FILE, "TGRIDLINES.THICKNESS = " & TGridLinesWidth
   Print #INI_FILE, "VGRIDLINES.ON = " & VGridLines
   Print #INI_FILE, ""
   'DISPLAY

'MARKERS
   Print #INI_FILE, "[MARKERS] ******************************"
   For I = 0 To NBR_CURSORS
      If iCursorFlag(I) = 1 Then Print #INI_FILE, "MARKER_NBR." & I & " = " & lCursorSample(I)
   Next I
   Print #INI_FILE, "MARKER.COLOR = " & CursorsColor
   Print #INI_FILE, "MARKER.THICKNESS = " & CursorsWidth
   If iCursorDispType Then
      Print #INI_FILE, "MARKER_DISPLAY = SAMPLES"
   Else
      Print #INI_FILE, "MARKER_DISPLAY = TIME"
   End If
   Print #INI_FILE, ""
   'MARKERS

'MEASUREMENT
   Print #INI_FILE, "[MEASUREMENT] *************************"
   Select Case iMeasType
      Case MEAS_NONE
         Print #INI_FILE, "TYPE = NONE"

      Case MEAS_SYNCH
         Print #INI_FILE, "TYPE = SYNCH"
         Print #INI_FILE, "CLOCK_CHANNEL = " & iMeasClkCh
         Select Case iMeasClkEdge
            Case MEAS_RISING
               Print #INI_FILE, "CLOCK_EDGE = RISING"
            Case MEAS_FALLING
               Print #INI_FILE, "CLOCK_EDGE = FALLING"
         End Select ' iMeasClkEdge

      Case MEAS_ASYNCH
         Print #INI_FILE, "TYPE = ASYNC"
         Print #INI_FILE, "BAUD = " & iMeasBaud
         Print #INI_FILE, "DATA_BITS = " & iMeasDataBits
         Print #INI_FILE, "STOP_BITS = " & iMeasStopBits
         Select Case iMeasParity
            Case MEAS_PARITY_NONE
               Print #INI_FILE, "PARITY = NONE"
            Case MEAS_PARITY_EVEN
               Print #INI_FILE, "PARITY = EVEN"
            Case MEAS_PARITY_ODD
               Print #INI_FILE, "PARITY = ODD"
            Case MEAS_PARITY_0
               Print #INI_FILE, "PARITY = 0"
            Case MEAS_PARITY_1
               Print #INI_FILE, "PARITY = 1"
         End Select ' iMeasParity
   End Select ' iMeasType
   
' the following are for SYNCH only

' the following are for both ASYNCH and SYNCH
   Print #INI_FILE, "BOARD = " & iMeasBoard
   Print #INI_FILE, "CHANNEL_0 = " & iMeasChannel(0)
   Print #INI_FILE, "CHANNEL_1 = " & iMeasChannel(1)
   
   Select Case iMeasMSBFirst
      Case MEAS_MSB_FIRST
         Print #INI_FILE, "MSB = FIRST_BIT"
      Case MEAS_MSB_LAST
         Print #INI_FILE, "MSB = LAST_BIT"
   End Select ' iMeasMSBFirst
   
   Select Case iMeasDisplayMode
      Case MEAS_DISPLAY_MODE_ASCII
         Print #INI_FILE, "DISPLAY_MODE = ASCII"
      Case MEAS_DISPLAY_MODE_HEX
         Print #INI_FILE, "DISPLAY_MODE = HEX"
   End Select ' iMeasDisplayMode

   Print #INI_FILE, "MARKER = " & iMeasCursor
   Print #INI_FILE, "DISPLAY_HEIGHT = " & DisplayHeight
   
   Print #INI_FILE, ""
   'MEASUREMENT
   
'MENU_POSITIONS
   Print #INI_FILE, "[MENU_POSITIONS] *************************"
   Print #INI_FILE, "ChannelParamsTop = " & PChannelParamsTop
   Print #INI_FILE, "ChannelParamsLeft = " & PChannelParamsLeft
'   Print #INI_FILE, "BoardsTop = " & PBoardsTop
'   Print #INI_FILE, "BoardsLeft = " & PBoardsLeft
'   Print #INI_FILE, "TriggerTop = " & PTriggerTop
'   Print #INI_FILE, "TriggerLeft = " & PTriggerLeft
'   Print #INI_FILE, "DisplayTop = " & PDisplayTop
'   Print #INI_FILE, "DisplayLeft = " & PDisplayLeft
'   Print #INI_FILE, "MarkersTop = " & PMarkersTop
'   Print #INI_FILE, "MarkersLeft = " & PMarkersLeft
'   Print #INI_FILE, "MeasureTop = " & PMeasureTop
'   Print #INI_FILE, "MeasureLeft = " & PMeasureLeft

   Print #INI_FILE, ""
   'MENU_POSITIONS
   
   Print #INI_FILE, "[End] ***********************************"
   Print #INI_FILE, ""

   On Error GoTo 0
   Close #INI_FILE
   frmDSO.Caption = "DSO & Logic Analyzer: Version " & VERSION & ", " & Trim$(szRegName) & "  " & Trim$(szIniFileName)
   fnIniWrite = 1                 ' show success
   Exit Function

Error_fnIniWrite:
   On Error GoTo 0
   Close #INI_FILE
   I = MsgBox(szIniFileName, vbOKOnly, "Error Writing File")
   fnIniWrite = 0                 ' show failure
End Function ' fnIniWrite

Public Function fnIniLine()
    Dim iRetVal As Integer, I As Integer, J As Integer, K As Integer
    Dim cFirst As String * 1

' read a line from an ini file
' exit with
'  the line - made upper case - in szString
'  the parameter value - if there is one - in szParameter
'  return value:
'     0 = End of File
'     1 = section name
'     2 = parameter line

   iRetVal = 0                      ' defaul to EOF
   Do
      Line Input #INI_FILE, szString ' read a line
      szString = Trim(szString)     ' remove leading and trailing spaces
      cFirst = Mid$(szString, 1, 1) ' get first character
      If cFirst <> ";" And cFirst <> " " Then ' if not a comment line
   
   ' replace tabs with spaces
         J = InStr(1, szString, Chr$(9))
         While J
            Mid$(szString, J, 1) = Chr$(32)
            J = InStr(1, szString, Chr$(9))
         Wend
   
   ' remove embedded comment
         K = InStr(1, szString, ";")   ' check for comment
         If K <> 0 Then                ' if comment at end of line
            szString = Trim(Left$(szString, K - 1)) ' remove comment
         End If
   
   ' test for section name
         If InStr(1, szString, "[") = 1 Then
            szString = UCase(szString)    ' make upper case
            iRetVal = 1 ' show section
         End If
   
   ' get the parameter - if there is one
         K = InStr(1, szString, "=")
         If K <> 0 Then
            Mid$(szString, 1, K) = UCase(Mid$(szString, 1, K))    ' make upper case
            szParameter = Mid$(szString, K + 1, 15) ' copy the parameter value
            iRetVal = 2                ' show parameter present
            szParameter = Trim$(szParameter)
         End If
        
         Exit Do
      End If ' if not a comment
   Loop While Not EOF(INI_FILE)
   fnIniLine = iRetVal

End Function  'fnIniLine

Public Function fnReadDataFile()
   Dim SampleNbr As Long
   Dim BrdNbr As Integer
   Dim I As Integer

   frmDSO.tbStatus.Text = "Reading"
   DoEvents
' read the INI file first
   szIniFileName = DataFilename
   I = InStr(szIniFileName, ".")       ' find extension
   If I = 0 Then I = Len(szIniFileName)
   Mid(szIniFileName, I) = ".INI"
   I = fnIniRead
   
   On Error GoTo ReadDataFileExit
   Open DataFilename For Binary Access Read As #DATA_FILE
   For BrdNbr = 1 To MAX_BOARDS
      If iBoardType(BrdNbr) <> 0 Then
         For SampleNbr = lStartSample(0) To lEndSample(0)
            Get DATA_FILE, , bDataArray(BrdNbr, SampleNbr)
         Next SampleNbr
      End If
   Next BrdNbr

ReadDataFileExit:
   Close #DATA_FILE
   frmDSO.tbStatus.Text = "Done"
   frmDSO.cmdDraw.BackColor = BKG_RED
   On Error GoTo 0
End Function ' fnReadDataFile

