Attribute VB_Name = "DSO_File_IO"

Public Function fnIniRead()
' open and read the INI file
' return values
'  1 = success
'  0 = failure

   Dim I As Integer
   Dim J As Integer
   Dim K As Integer
   Dim LineType As Integer
   Dim Section As Integer
   Dim rMult As Single
   Dim cChar As String * 1
   Dim BrdNbr As Integer
   
' Initialize parameters
   PortAddr = 0
'[Boards] & [LA_CHANNELS] & [AD_CHANNELS]
   For BrdNbr = 1 To MAX_BOARDS
      iBoardType(BrdNbr) = 0
      bADTrig(BrdNbr) = NO_TRIG
      For J = 0 To 7
         szChannelName(BrdNbr, J) = " "
         bLA_Use(BrdNbr, J) = 0
      Next J

      AD_RangeIndex(BrdNbr) = 0
      bADTrig(BrdNbr) = 0
      Invert(BrdNbr) = 0
      AD_Color(BrdNbr) = vbBlack
      AD_Width(BrdNbr) = 1
      AD_Yscale(BrdNbr) = AD_SCALE_1
      AD_Yoffset(BrdNbr) = 0
   Next BrdNbr
   AD_RangeMax = 0

'[AD_CHANNELS]
   For J = 0 To AD_RANGE_MAX     ' A/D parameters
      AD_Range(J, 0) = 0         ' lower voltage limit
      AD_Range(J, 1) = 0         ' upper voltage limit
      szAD_Range(J) = J & ": NoDef"
   Next J

'[Trigger]
   For I = 0 To 7
      bTrig(I) = NO_TRIG
   Next I
   iPreTrig = 1
   iCursor2Trigger = 0

'[TimeBase]
   For I = 0 To TIME_BASE_VALS
      rSamplePeriod(I) = 0#
      szSamplePeriodName(I) = ""
   Next I
   szSamplePeriodName(0) = "RdClk"
   iTimeBaseIndex = 7
   
'[DISPLAY]
   fZoom = 2#
   fSlide = 0.5
   LA_Size = 80
   AD_Size = 100 - LA_Size
   
'[CURSORS]
   For I = 1 To NBR_CURSORS
      iCursorFlag(I) = 0
   Next I
   CursorsColor = COLOR_BLACK
   CursorsWidth = 1
   TGridLinesOn = 0
   TGridLinesColor = COLOR_VIOLET
   TGridLinesWidth = 1
   iTPD = 0             ' force AUTO for Time per Division
   VGridLines = 0

' PROCESS THE FILE
   On Error GoTo Error_fnIniRead
   Close                         ' just in case
   Open szIniFileName For Input Access Read As #INI_FILE
   On Error GoTo 0
   Section = 0                   ' init to no section yet
   Do
      LineType = fnIniLine       ' read a line
      Select Case LineType
      Case 0
         Exit Do
      Case 1
         If InStr(szString, "[GENERAL]") = 1 Then Section = GENERAL
         If InStr(szString, "[BOARD_TYPES]") = 1 Then Section = BOARD_TYPES
         If InStr(szString, "[LA_CHANNELS]") = 1 Then Section = LA_CHANNELS
         If InStr(szString, "[A/D_CHANNELS]") = 1 Then Section = AD_CHANNELS
         If InStr(szString, "[TRIGGER]") = 1 Then Section = TRIGGER
         If InStr(szString, "[TIMEBASE]") = 1 Then Section = TIMEBASE
         If InStr(szString, "[DISPLAY]") = 1 Then Section = DISPLAY
         If InStr(szString, "[CURSORS]") = 1 Then Section = CURSORS
         If InStr(szString, "[END]") = 1 Then Exit Do
      Case 2
         Select Case Section
         
         Case GENERAL
            If InStr(1, szString, "ADDRESS") = 1 Then PortAddr = szParameter
            If InStr(1, szString, "REG.NAME") = 1 Then
               szRegName = szParameter
               frmDSO.Caption = "DSO & Logic Analyzer: Version " & VERSION & ", " & Trim$(szRegName) & "  " & Trim$(szIniFileName)
            End If
         'GENERAL
         
         Case BOARD_TYPES
            If InStr(1, szString, "BOARD_") = 1 Then
               BrdNbr = Val(Mid$(szString, 7, 2))   ' get board number
               If BrdNbr < 1 Or BrdNbr > MAX_BOARDS Then
                  I = MsgBox(szLine, vbOKOnly, "Invalid Board number")
               Else
                  If InStr(1, szParameter, "AD") Then iBoardType(BrdNbr) = AD_BOARD
                  If InStr(1, szParameter, "LA") Then iBoardType(BrdNbr) = LA_BOARD
               End If
            End If
         'BOARD_TYPES
         
         Case LA_CHANNELS
            I = InStr(1, szString, "_")   ' find board number
            BrdNbr = Val(Mid$(szString, I + 1, 1)) ' get the board number
            If BrdNbr < 1 Or BrdNbr > MAX_BOARDS Or iBoardType(BrdNbr) <> LA_BOARD Then
               I = MsgBox(szLine, vbOKOnly, "Not an LA Board")
               Exit Function
            End If
            
            If InStr(1, szString, "NAME_") = 1 Then
               J = Val(Mid$(szString, 8, 1)) ' get the ch nbr
               szChannelName(BrdNbr, J) = szParameter
            End If
            If InStr(1, szString, "USE_") = 1 Then
               For J = 0 To 7          ' for each of 8 possible channels
                  cChar = Mid$(szParameter, 9 - J, 1) ' get channel nbr
                  If cChar >= "0" And cChar <= "7" Then
                     bLA_Use(BrdNbr, Val(cChar)) = 1
                  End If
               Next J
            End If
         'LA_CHANNELS

         Case AD_CHANNELS
            I = InStr(1, szString, "_")   ' find board number
            If I > 0 Then
               BrdNbr = Val(Mid$(szString, I + 1, 1)) ' get the board number
               If BrdNbr > MAX_BOARDS Or iBoardType(BrdNbr) <> AD_BOARD Then
                  I = MsgBox(szLine, vbOKOnly, "Not an AD Board")
                  Exit Function
               End If
            End If
            If InStr(1, szString, "CH.NAME_") = 1 Then szChannelName(BrdNbr, 0) = szParameter
            If InStr(1, szString, "CH.RANGE_") = 1 Then AD_RangeIndex(BrdNbr) = szParameter
            If InStr(1, szString, "CH.TRIG_") = 1 Then bADTrig(BrdNbr) = Val(szParameter) ' get trigger value
            If InStr(1, szString, "CH.COLOR_") = 1 Then AD_Color(BrdNbr) = szParameter
            If InStr(1, szString, "CH.THICKNESS_") = 1 Then AD_Width(BrdNbr) = szParameter
            If InStr(1, szString, "CH.INVERT_") = 1 Then Invert(BrdNbr) = szParameter
            If InStr(1, szString, "CH.YSCALE_") = 1 Then AD_Yscale(BrdNbr) = szParameter
            If InStr(1, szString, "CH.YOFFSET_") = 1 Then AD_Yoffset(BrdNbr) = szParameter

         ' non-board nbr values
            If InStr(1, szString, "RANGE_") = 1 Then
               I = Val(Mid$(szString, 7, 1))   ' get index number
               If I >= 0 And I <= AD_RANGE_MAX Then
                  szAD_Range(I) = szParameter ' store the string
                  AD_Range(I, 0) = Val(szParameter) ' store lower value
                  J = InStr(1, szParameter, ",")
                  AD_Range(I, 1) = Val(Mid$(szParameter, J + 1)) ' store upper value
                  If I > AD_RangeMax Then AD_RangeMax = I
               End If
            End If
         'AD_CHANNELS

         Case TRIGGER
            If InStr(1, szString, "PRE.TRIG") = 1 Then
               iPreTrig = Val(szParameter)
               If iPreTrig > PRE_TRIG_MAX Then iPreTrig = PRE_TRIG_MAX
            End If
            If InStr(1, szString, "TRIG_") = 1 Then
               J = Val(Mid$(szString, 6, 1))  ' get trigger channel number
               If Mid$(szParameter, 1, 1) = "X" Then
                  bTrig(J) = NO_TRIG          ' show no trigger state
               Else
                  bTrig(J) = Val(szParameter) ' get trigger state
               End If
            End If
            If InStr(1, szString, "CURSOR.TO.TRIGGER") = 1 Then
               iCursor2Trigger = Val(szParameter)
            End If
         'TRIGGER

         Case TIMEBASE
            If InStr(1, szString, "SELECT") = 1 Then iTimeBaseIndex = Val(szParameter)
            If InStr(1, szString, "PERIOD_") = 1 Then
               I = Val(Mid$(szString, 8, 2))   ' get index number
               If I > 0 And I <= TIME_BASE_VALS Then
                  szSamplePeriodName(I) = szParameter ' store the string
                  If InStr(1, szParameter, "ns") Then rMult = 0.000000001
                  If InStr(1, szParameter, "us") Then rMult = 0.000001
                  If InStr(1, szParameter, "ms") Then rMult = 0.001
                  rSamplePeriod(I) = Val(szParameter) * rMult
               End If
            End If
         'TIMEBASE

         Case DISPLAY
            If InStr(1, szString, "ZOOM") = 1 Then fZoom = szParameter
            If fZoom > 5 Then fZoom = 5
            If fZoom < 1 Then fZoom = 1
            If InStr(1, szString, "SLIDE") = 1 Then fSlide = szParameter
            If fSlide < 0.1 Then fSlide = 0.1
            If fSlide > 1# Then fSlide = 1#
            If InStr(1, szString, "START.SAMPLE") = 1 Then lStartSample = szParameter
            If InStr(1, szString, "END.SAMPLE") = 1 Then lEndSample = szParameter
            If InStr(1, szString, "LA.SIZE") = 1 Then LA_Size = szParameter
            If InStr(1, szString, "AD.SIZE") = 1 Then AD_Size = szParameter
         'DISPLAY

         Case CURSORS
            If InStr(1, szString, "CURSOR_") = 1 Then
               I = Val(Mid$(szString, 8, 1))   ' get cursor number
               If I >= 0 And I <= NBR_CURSORS Then
                  lCursorSample(I) = szParameter
                  iCursorFlag(I) = 1
               End If
            End If
            If InStr(1, szString, "CURSORS.COLOR") = 1 Then CursorsColor = szParameter
            If InStr(1, szString, "CURSORS.THICKNESS") = 1 Then CursorsWidth = szParameter
            If InStr(1, szString, "TGRIDLINES.ON") = 1 Then TGridLinesOn = szParameter
            If InStr(1, szString, "TGRIDLINES.COLOR") = 1 Then TGridLinesColor = szParameter
            If InStr(1, szString, "TGRIDLINES.THICKNESS") = 1 Then TGridLinesWidth = szParameter
            If InStr(1, szString, "VGRIDLINES.ON") = 1 Then VGridLines = szParameter
         'CURSORS

         End Select ' section
      End Select ' LineType
   Loop
   Close #INI_FILE

' post file processing
   iPostTrig = TRIG_MAX - iPreTrig
   iMax_Samples = ((iPreTrig + iPostTrig) * TRIG_WINDOW) + TRIG_WINDOW / 2
   lTotalSamples = lEndSample - lStartSample - 1
   If (lEndSample - lStartSample < MIN_WINDOW) Or (lTotalSamples > iMax_Samples) Then
      lStartSample = (iPreTrig * TRIG_WINDOW) - (TRIG_WINDOW / 2)
      lEndSample = lStartSample + TRIG_WINDOW
   End If

   If LA_Size + AD_Size > 100 Then
      I = MsgBox("LA area overlaps AD area", vbOKOnly + vbExclamation, szIniFileName)
   End If
   If lCursorSample(0) = 0 Then lCursorSample(0) = iPreTrig * TRIG_WINDOW
   iCursorFlag(0) = 1
   SetChPos

   fnIniRead = 1                 ' show success
   Exit Function

Error_fnIniRead:
   On Error GoTo 0
   Close #INI_FILE
   I = MsgBox(szIniFileName, vbOKOnly, "Error Opening File")
   fnIniRead = 0                 ' show failure
End Function ' fnIniRead


Public Function fnIniWrite()
' open and write the INI file
' return values
'  1 = success
'  0 = failure

   Dim I As Integer
   Dim Section As Integer

   On Error GoTo Error_fnIniWrite
   Close                         ' just in case
   Open szIniFileName For Output Access Write As #INI_FILE
   Print #INI_FILE, ";DSO & Logic Analyzer: Version " & VERSION & ", " & Trim$(szIniFileName)
   Print #INI_FILE, ""

'GENERAL
   Print #INI_FILE, "[GENERAL] ******************************"
   Print #INI_FILE, "ADDRESS = &H" & Trim(Hex$(PortAddr))
   Print #INI_FILE, "REG.NAME = " & Trim(szRegName)
   Print #INI_FILE, ""

'BOARD_TYPES
   Print #INI_FILE, "[BOARD_TYPES] **************************"
   For I = 1 To MAX_BOARDS
      If iBoardType(I) = AD_BOARD Then Print #INI_FILE, "BOARD_" & I & " = AD"
      If iBoardType(I) = LA_BOARD Then Print #INI_FILE, "BOARD_" & I & " = LA"
   Next I
   Print #INI_FILE, ""
   'BOARD_TYPES

'LA_CHANNELS
   Print #INI_FILE, "[LA_CHANNELS] *****************************"
   For BrdNbr = 1 To MAX_BOARDS
      If iBoardType(BrdNbr) = LA_BOARD Then
         For J = 0 To 7
            If Mid$(szChannelName(BrdNbr, J), 1, 1) <> " " Then
               Print #INI_FILE, "NAME_" & BrdNbr & "." & J & " = " & szChannelName(BrdNbr, J)
            End If
         Next J
         sLA_Use = "xxxxxxxx"
         For J = 7 To 0 Step -1
            If bLA_Use(BrdNbr, J) Then
               Mid$(sLA_Use, 8 - J, 1) = J
            End If
         Next J
         Print #INI_FILE, "USE_" & BrdNbr & " = " & sLA_Use
      End If
   Next BrdNbr
   Print #INI_FILE, ""
   'LA_CHANNELS

'AD_CHANNELS
   Print #INI_FILE, "[A/D_CHANNELS] ****************************"
   For BrdNbr = 1 To MAX_BOARDS
      If iBoardType(BrdNbr) = AD_BOARD Then
         Print #INI_FILE, "CH.NAME_" & BrdNbr & " = " & Trim$(szChannelName(BrdNbr, 0))
         Print #INI_FILE, "CH.RANGE_" & I & " = " & AD_RangeIndex(I)
         If bADTrig(BrdNbr) <> NO_TRIG Then
            Print #INI_FILE, "CH.TRIG_" & BrdNbr & " = " & bADTrig(BrdNbr)
         End If
         Print #INI_FILE, "CH.COLOR_" & BrdNbr & " = " & AD_Color(BrdNbr)
         Print #INI_FILE, "CH.THICKNESS_" & BrdNbr & " = " & AD_Width(BrdNbr)
         Print #INI_FILE, "CH.INVERT_" & BrdNbr & " = " & Invert(BrdNbr)
         Print #INI_FILE, "CH.YSCALE_" & BrdNbr & " = " & AD_Yscale(BrdNbr)
         Print #INI_FILE, "CH.YOFFSET_" & BrdNbr & " = " & AD_Yoffset(BrdNbr)
      End If
   Next BrdNbr

   For I = 0 To AD_RANGE_MAX
      Print #INI_FILE, "RANGE_" & I & " = " & szAD_Range(I)
   Next I

   Print #INI_FILE, ""
   'AD_CHANNELS

'TRIGGER
   Print #INI_FILE, "[TRIGGER] ******************************"
   Print #INI_FILE, "PRE.TRIG = " & iPreTrig
   For J = 0 To 7
      cChar = "X"                   ' default to no trigger
      If bTrig(J) <> NO_TRIG Then   ' if trigger
         cChar = "0"                ' assume 0 state
         If bTrig(J) = 1 Then cChar = "1"
      End If
      Print #INI_FILE, "TRIG_" & J & " = " & cChar
   Next J
   Print #INI_FILE, "CURSOR.TO.TRIGGER = " & iCursor2Trigger
   Print #INI_FILE, ""
   'TRIGGER

'TIMEBASE
   Print #INI_FILE, "[TIMEBASE] *****************************"
   Print #INI_FILE, "TIME_BASE_PERIOD_0 = read"
   For I = 1 To TIME_BASE_VALS
      If rSamplePeriod(I) > 0 Then
         Print #INI_FILE, "PERIOD_" & I & " = " & Trim$(szSamplePeriodName(I))
      End If
   Next I
   Print #INI_FILE, "SELECT = " & iTimeBaseIndex
   Print #INI_FILE, ""
   'TIMEBASE

'DISPLAY
   Print #INI_FILE, "[DISPLAY] ******************************"
   Print #INI_FILE, "ZOOM = " & fZoom
   Print #INI_FILE, "SLIDE = " & fSlide
   Print #INI_FILE, "START.SAMPLE = " & lStartSample
   Print #INI_FILE, "END.SAMPLE = " & lEndSample
   Print #INI_FILE, "LA.SIZE = " & LA_Size
   Print #INI_FILE, "AD.SIZE = " & AD_Size
   Print #INI_FILE, ""
   'DISPLAY

'CURSORS
   Print #INI_FILE, "[CURSORS] ******************************"
   For I = 0 To NBR_CURSORS
      If iCursorFlag(I) = 1 Then Print #INI_FILE, "CURSOR_" & I & " = " & lCursorSample(I)
   Next I
   Print #INI_FILE, "CURSORS.COLOR = " & CursorsColor
   Print #INI_FILE, "CURSORS.THICKNESS = " & CursorsWidth
   Print #INI_FILE, "TGRIDLINES.ON = " & TGridLinesOn
   Print #INI_FILE, "TGRIDLINES.COLOR = " & TGridLinesColor
   Print #INI_FILE, "TGRIDLINES.THICKNESS = " & TGridLinesWidth
   Print #INI_FILE, "VGRIDLINES.ON = " & VGridLines
   Print #INI_FILE, ""
   'CURSORS

   Print #INI_FILE, "[End] **********************************"
   Print #INI_FILE, ""

   On Error GoTo 0
   Close #INI_FILE
   frmDSO.Caption = "DSO & Logic Analyzer: Version " & VERSION & ", " & Trim$(szRegName) & "  " & Trim$(szIniFileName)
   fnIniWrite = 1                 ' show success
   Exit Function

Error_fnIniWrite:
   On Error GoTo 0
   Close #INI_FILE
   I = MsgBox(szIniFileName, vbOKOnly, "Error Writing File")
   fnIniWrite = 0                 ' show failure
End Function ' fnIniWrite

Public Function fnIniLine()
    Dim iRetVal As Integer, I As Integer, J As Integer, K As Integer
    Dim cFirst As String * 1

' read a line from an ini file
' exit with
'  the line - made upper case - in szString
'  the parameter value - if there is one - in szParameter
'  return value:
'     0 = End of File
'     1 = section name
'     2 = parameter line

   iRetVal = 0                      ' defaul to EOF
   Do
      Line Input #INI_FILE, szString ' read a line
      szString = Trim(szString)     ' remove leading and trailing spaces
      cFirst = Mid$(szString, 1, 1) ' get first character
      If cFirst <> ";" And cFirst <> " " Then ' if not a comment line
   
   ' replace tabs with spaces
         J = InStr(1, szString, Chr$(9))
         While J
            Mid$(szString, J, 1) = Chr$(32)
            J = InStr(1, szString, Chr$(9))
         Wend
   
   ' remove embedded comment
         K = InStr(1, szString, ";")   ' check for comment
         If K <> 0 Then                ' if comment at end of line
            szString = Trim(Left$(szString, K - 1)) ' remove comment
         End If
   
   ' test for section name
         If InStr(1, szString, "[") = 1 Then
            szString = UCase(szString)    ' make upper case
            iRetVal = 1 ' show section
         End If
   
   ' get the parameter - if there is one
         K = InStr(1, szString, "=")
         If K <> 0 Then
            Mid$(szString, 1, K) = UCase(Mid$(szString, 1, K))    ' make upper case
            szParameter = Mid$(szString, K + 1, 15) ' copy the parameter value
            iRetVal = 2                ' show parameter present
            szParameter = Trim$(szParameter)
         End If
        
         Exit Do
      End If ' if not a comment
   Loop While Not EOF(INI_FILE)
   fnIniLine = iRetVal

End Function  'fnIniLine

