Attribute VB_Name = "DSO_Draw"

Public Function Draw_LA(Bd As Integer, Ch As Integer)
' draw an LA channel
' Enter with:
'     iLAchannels = total number of LA channels to draw
'     lStartSample = starting index into bDataArray
'     lEndSample = ending index into bDataArray
'     bLA_Use(Bd, Ch) = relative channel position from top
'
   Dim I As Integer
   Dim J As Integer
   Dim K As Integer
   Dim Units As Integer
   Dim UnitHt As Single
   Dim Y0 As Integer       ' Y coordinate for logic 0
   Dim Y1 As Integer       ' Y coordinate for logic 1
   Dim Mask As Integer
   Dim Index As Long
   Dim PreValue As Integer
   Dim Xstep As Single
   Dim Xpos As Single

   I = bLA_Use(Bd, Ch)     ' get relative veritcal position
   If I = 0 Then Exit Function ' exit if channel not enabled

   picDSO.AutoRedraw = True
   Xstep = picDSO.ScaleWidth / (lEndSample - lStartSample + 1)
   
' calculate Y position for logic 0 and 1 levels
'     each trace is 2 units high + 1 unit space with 1 unit at bottom
   Units = iLAchannels * 3 + 1      ' total vertical units
   UnitHt = picDSO.ScaleHeight / Units   ' unit height
   Y0 = 3 * I * UnitHt              ' 0 level
   Y1 = Y0 - (2 * UnitHt)           ' 1 level

   Mask = 2 ^ Ch                    ' channel mask
   I = bDataArray(Bd, lStartSample)  ' get 1st value
   picDSO.CurrentX = 0              ' Set X starting point.
   If I And Mask Then
      picDSO.CurrentY = Y1          ' Set Y starting point.
      PreValue = Mask
   Else
      picDSO.CurrentY = Y0          ' Set Y starting point.
      PreValue = 0
   End If
   Xpos = 0#                        ' init position value
   For Index = lStartSample To lEndSample
      Xpos = Xpos + Xstep           ' new X position
      J = Xpos                      ' convert to integer
      I = bDataArray(Bd, Index) And Mask ' get bit value
      If I <> PreValue Then         ' draw veritcal line
         If I Then                  ' new value is 1
            picDSO.Line -Step(picDSO.CurrentX, Y1)
         Else                       ' new value is 0
            picDSO.Line -Step(picDSO.CurrentX, Y0)
         End If
      End If
      picDSO.Line -Step(J, picDSO.CurrentY)  ' Draw the line
   Next Index

   Draw_LA = 1
End Function ' Draw_LA
