VERSION 5.00
Begin VB.Form frmDSOFunctions 
   Caption         =   "DSO Functions"
   ClientHeight    =   3216
   ClientLeft      =   48
   ClientTop       =   336
   ClientWidth     =   5400
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3216
   ScaleWidth      =   5400
   StartUpPosition =   2  'CenterScreen
   Begin VB.TextBox tbDataBus 
      Height          =   372
      Left            =   4200
      TabIndex        =   13
      Top             =   2520
      Width           =   972
   End
   Begin VB.TextBox tbPulses 
      Height          =   288
      Left            =   3360
      TabIndex        =   11
      Top             =   1920
      Visible         =   0   'False
      Width           =   1212
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Left            =   120
      Top             =   1920
   End
   Begin VB.CheckBox cbSlow 
      Caption         =   "Slow"
      Height          =   192
      Left            =   1680
      TabIndex        =   10
      Top             =   2040
      Width           =   732
   End
   Begin VB.TextBox tbPrePostTrig 
      BackColor       =   &H00FFFFFF&
      Height          =   372
      Left            =   1320
      TabIndex        =   8
      Text            =   "&H88"
      Top             =   2520
      Width           =   972
   End
   Begin VB.CommandButton cmdMainGo 
      Caption         =   "GO"
      Height          =   372
      Left            =   600
      TabIndex        =   7
      Top             =   1920
      Width           =   972
   End
   Begin VB.TextBox tbTimeBase 
      Height          =   372
      Left            =   2760
      Locked          =   -1  'True
      TabIndex        =   5
      Text            =   "Time Base"
      Top             =   2520
      Width           =   972
   End
   Begin VB.VScrollBar vsTimeBase 
      Height          =   612
      Left            =   3840
      Max             =   7
      TabIndex        =   4
      Top             =   2400
      Value           =   7
      Width           =   252
   End
   Begin VB.ListBox lbxSubFunction 
      Height          =   1584
      ItemData        =   "DSOFunctions.frx":0000
      Left            =   2640
      List            =   "DSOFunctions.frx":0002
      TabIndex        =   2
      Top             =   240
      Width           =   2292
   End
   Begin VB.ListBox lbxMainFunction 
      Height          =   1584
      ItemData        =   "DSOFunctions.frx":0004
      Left            =   360
      List            =   "DSOFunctions.frx":0006
      TabIndex        =   0
      Top             =   240
      Width           =   1932
   End
   Begin VB.Label Label1 
      Caption         =   "Data Bus"
      Height          =   252
      Left            =   4320
      TabIndex        =   14
      Top             =   2280
      Width           =   732
   End
   Begin VB.Label lblPulses 
      Caption         =   "Pulses"
      Height          =   252
      Left            =   2760
      TabIndex        =   12
      Top             =   1920
      Visible         =   0   'False
      Width           =   492
   End
   Begin VB.Label lblPrePostTrig 
      Caption         =   "PrePostTrig"
      Height          =   252
      Left            =   240
      TabIndex        =   9
      Top             =   2520
      Width           =   972
   End
   Begin VB.Label lblTimeBase 
      Caption         =   "Time Base"
      Height          =   252
      Left            =   2760
      TabIndex        =   6
      Top             =   2280
      Width           =   972
   End
   Begin VB.Label lblSubFunction 
      Caption         =   "Sub Function"
      Height          =   252
      Left            =   3240
      TabIndex        =   3
      Top             =   0
      Width           =   972
   End
   Begin VB.Label lblMainFunction 
      Caption         =   "Main Function"
      Height          =   252
      Left            =   840
      TabIndex        =   1
      Top             =   0
      Width           =   1092
   End
End
Attribute VB_Name = "frmDSOFunctions"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim PulseCount As Long
Dim I As Integer
Dim iLong As Long
Dim iTriggerValue As Integer
Dim iDataValue As Integer
Dim iMainFunction As Integer
Dim iSubFunction As Integer
Dim iPrePostColor As Long
Dim GoSlow As Integer
Dim TimeBaseSave As Integer


Private Sub cbSlow_Click()
   GoSlow = cbSlow.Value
End Sub

Private Sub cmdMainGo_Click()
   Select Case iMainFunction
   Case 0   'not used
   Case SYSRESET
      WrData iTriggerValue    ' pre and post trigger values
      WrControl SYSRESET
      WrControl SYSRESET + CONTROL_STROBE
      CheckSlow
      WrControl SYSRESET
   Case SYSENABLE
      WrControl SYSENABLE
      WrControl SYSENABLE + CONTROL_STROBE
      CheckSlow
      WrControl SYSENABLE
   Case SUBSELECT
      I = (iTimeBaseIndex * 16) + iSubFunction
      tbDataBus.Text = I
      WrData I
      WrControl SUBSELECT
      WrControl SUBSELECT + CONTROL_STROBE
      CheckSlow
      WrControl SUBSELECT
   Case READSUB
      If PulseCount > 1 Then
         tbPulses.BackColor = BKG_RED
         DoEvents
         For iLong = 1 To PulseCount
            WrControl READSUB
            WrControl READSUB + CONTROL_STROBE
            CheckSlow
            RdData = Inp(PortAddr)
            WrControl (READSUB)   ' remove read enable
            tbDataBus.Text = I
            DoEvents
         Next iLong
         tbPulses.BackColor = BKG_WHITE
      Else
         WrControl READSUB
         WrControl READSUB + CONTROL_STROBE
         If GoSlow = 1 Then
            tbDataBus.BackColor = BKG_RED
            CheckSlow
            I = ReadData
            tbDataBus.Text = I
            tbDataBus.BackColor = BKG_WHITE
         Else
            I = ReadData
            tbDataBus.Text = I
         End If
      End If
   Case WRITESUB
      I = tbDataBus.Text
      WrData I
      WrControl WRITESUB
      WrControl WRITESUB + CONTROL_STROBE
      CheckSlow
      WrControl WRITESUB
   Case 6   'not used
   Case 7   'not used
   End Select
End Sub

Private Sub Form_Load()

   TimeBaseSave = iTimeBaseIndex  ' save for exit
   WrControl 0          ' init the control port
' set main functions
   lbxMainFunction.AddItem "0 not used", 0
   lbxMainFunction.AddItem "1 SysReset", 1
   lbxMainFunction.AddItem "2 SysEnable", 2
   lbxMainFunction.AddItem "3 Sub Function Select", 3
   lbxMainFunction.AddItem "4 Read Clock", 4
   lbxMainFunction.AddItem "5 Sub Function Strobe", 5
   lbxMainFunction.AddItem "6 not used", 6
   lbxMainFunction.AddItem "7 not used", 7
' set sub functions
   lbxSubFunction.AddItem " 0 CmpLatch-Ch0"
   lbxSubFunction.AddItem " 1 CmpLatch-Ch1"
   lbxSubFunction.AddItem " 2 CmpLatch-Ch2"
   lbxSubFunction.AddItem " 3 CmpLatch-Ch3"
   lbxSubFunction.AddItem " 4 not used"
   lbxSubFunction.AddItem " 5 not used"
   lbxSubFunction.AddItem " 6 TrigChEna"
   lbxSubFunction.AddItem " 7 TrigChState"
   lbxSubFunction.AddItem " 8 Read-Ch0"
   lbxSubFunction.AddItem " 9 Read-Ch1"
   lbxSubFunction.AddItem "10 Read-Ch2"
   lbxSubFunction.AddItem "11 Read-Ch3"
   lbxSubFunction.AddItem "12 Read-Ch4"
   lbxSubFunction.AddItem "13 Read-Ch5"
   lbxSubFunction.AddItem "14 ReadLowTrigAddr"
   lbxSubFunction.AddItem "15 ReadHighTrigAddr"
   
   vsTimeBase.Value = iTimeBaseIndex
   tbTimeBase.Text = szSamplePeriodName(iTimeBaseIndex)
   
   tbPrePostTrig.Text = "&H88"
   iTriggerValue = tbPrePostTrig.Text
   iPrePostColor = BKG_WHITE
   tbPrePostTrig.BackColor = BKG_WHITE
   
   tbPulses.BackColor = BKG_WHITE
   tbPulses.Text = 1
   PulseCount = 1

   tbDataBus.Text = "0"
   GoSlow = 0
   
End Sub

Private Sub Form_Unload(Cancel As Integer)
   iTimeBaseIndex = TimeBaseSave  ' restore
End Sub

Private Sub lbxMainFunction_Click()
   iMainFunction = lbxMainFunction.ListIndex
   If iMainFunction = SYSRESET Then
      iPrePostColor = BKG_RED
   Else
      iPrePostColor = BKG_WHITE
   End If
   tbPrePostTrig.BackColor = iPrePostColor
   
   If iMainFunction = SUBSELECT Then
      tbTimeBase.BackColor = BKG_RED
   Else
      tbTimeBase.BackColor = BKG_WHITE
   End If
   
   If iMainFunction = READSUB Then
      lblPulses.Visible = True
      tbPulses.Visible = True
   Else
      lblPulses.Visible = False
      tbPulses.Visible = False
   End If
End Sub

Private Sub lbxSubFunction_Click()
   iSubFunction = lbxSubFunction.ListIndex
End Sub

Private Sub tbCompLatch_Change()
    If KeyCode = 13 Then         ' if Enter key
        tbCompLatch.BackColor = BKG_WHITE
        If tbCompLatch.Text <> "" Then
            iCompLatch = tbCompLatch.Text
        Else
            tbCompLatch.Text = "0"
            iCompLatch = 0
        End If
    Else
        tbCompLatch.BackColor = BKG_RED
    End If
End Sub

Private Sub tbDataBus_KeyUp(KeyCode As Integer, Shift As Integer)
    If KeyCode = 13 Then         ' if Enter key
        tbDataBus.BackColor = BKG_WHITE
        If tbDataBus.Text <> "" Then
            iDataValue = tbDataBus.Text
        Else
            tbDataBus.Text = "&H00"
            iDataValue = 0
        End If
    Else
        tbDataBus.BackColor = BKG_RED
    End If

End Sub

Private Sub tbPrePostTrig_KeyUp(KeyCode As Integer, Shift As Integer)
   If tbPrePostTrig.Text = "&H" Then Exit Sub
   On Error GoTo tbPrePostTrig_error
   iTriggerValue = tbPrePostTrig.Text
   Exit Sub
   
tbPrePostTrig_error:
   On Error GoTo 0
   I = MsgBox(tbPrePostTrig.Text, vbOKOnly, "Illegal Value")
   tbPrePostTrig.Text = "&HF1"
End Sub

Private Sub tbPulses_KeyUp(KeyCode As Integer, Shift As Integer)
   On Error GoTo tbPulses_error
   PulseCount = tbPulses.Text
   Exit Sub
   
tbPulses_error:
   On Error GoTo 0
   I = MsgBox(tbPulses.Text, vbOKOnly, "Illegal Value")
   tbPulses.Text = 1
End Sub

Private Sub Timer1_Timer()
   GoSlow = 2
   Timer1.Enabled = False
End Sub

Private Sub vsTimeBase_Change()
   iTimeBaseIndex = vsTimeBase.Value
   tbTimeBase.Text = szSamplePeriodName(iTimeBaseIndex)
End Sub

Public Sub CheckSlow()
   If GoSlow = 1 Then
      cbSlow.BackColor = BKG_RED
      Timer1.Interval = 500
      Timer1.Enabled = True
      Do
         DoEvents
      Loop While GoSlow = 1
      cbSlow.BackColor = BKG_GREY
      GoSlow = 1
   End If
End Sub
