; InstructionTest.asm

#print PR_ALL & ~PR_PROC_DEFS
; memory definitions
#address NEXT_PC        0x1000
#address NEXT_ROM       0x400
#address NEXT_RAM       0X100000
Loc1:    #alloc.4
#address NEXT_PC

#vector  VECTOR_RTC        ; keep the assembler happy
   reti

#vector  VECTOR_START
#def_data_size  4

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

_Labela:
   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi

   dbne     r2, _Labelb
   dbge     r1, _Labela
   
_Labelb:

   br       _Labela
   bcs      _Labelb
   bcc      Label_.c
   beq      _Labela
   bne      _Labelb
   bmi      Label_.c
   bpl      _Labela
   bvs      _Labelb
   bvc      Label_.c
   bgtu     _Labela
   bleu     _Labelb
   bge      Label_.c
   blt      _Labela
   bgt      _Labelb
   ble      Label_.c

Label_.c:

;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
;=========================================

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi
