; Test_IS1.asm
#nprint PR_PROC_DEFS    ; do not print the standard processor definitions

#address    NEXT_ROM    0x400
._TextLabel:	#alloc.s	"\t\\this is a test of storing a longer string that should take more than one line\n\r\0"

#radix      10                ; set the default radix
#address    NEXT_ROM    0x400				; start storing constants at 0x400
#address    NEXT_PC     NEXT_ROM+0x1000	; allow an area of 0x1000 bytes for constants
#address    NEXT_RAM    0x30000			; RAM starting address - sets the Address Pointer
Value_1:		#alloc.1								; create a 1-byte variable with the name Value_1
Value_2:		#alloc.4								; create a 4-byte variable with the name Value_2
Loc1:       #alloc.4
;  NEXT_RAM now is 0x30006 due to the #alloc.4 being forced to start on an even address

#address NEXT_ROM               ; set the Address Pointer to NEXT_ROM (0x400)
Const_1:       #alloc.2    0x1234 ; create a 2byte constant
Const_Values:  #alloc.1    1,2,3,4,5 ; create a table of 5 constant bytes
FPvalues:      #alloc.4    0f3.14159, 0f1.0, 0f1.5
               #alloc.8    0f3.14159, 0f1.0, 0f1.5
; NEXT_ROM now is ???

#address NEXT_PC              ; set the Address Pointer to NEXT_PC (0x1400)
#vector  VECTOR_START         ; set startup vector to the value of  NEXT_PC
Program_Start:                ; label of the start of the program
#allocb.1   0x1234	            ; dummy directive to simulate block of code
; NEXT_PC is now ???

; set up some variables for Function_1
#address NEXT_RAM             ; set the Address Pointer to NEXT_RAM (0x30005)
Block_1: #allocb.1   10       ; allocate 10 elements of 1 byte each
Block_2: #allocb.8   32       ; allocate 32 elements of 8 bytes each
; NEXT_RAM now is 0x30006 + 10. + (32*8) = 0x30006 + 0x000A + 0x0100 = ???

#address NEXT_PC              ; set the Address Pointer to NEXT_PC (0x2634)
Func1_Consts:  #alloc.4 54321, 12345, 98765, 56789 ; some constants for Function_1
; NEXT_PC is now 0x2634 + 16. = ???
Function_1:
#allocb.1   0x234             ; dummy directive to simulate block of code
; NEXT_PC is now 0x2644 + 0x234. = ???


#vector VECTOR_ERROR       ; to keep the assembler happy
#vector VECTOR_RTC
   reti

#vector VECTOR_START
	copy.4	#0x30000, SP

; 1 byte copy
; DESTINATION: REGISTER MODE
	copy.1	R0, R1
	copy.1	(R0), R1
	copy.1	-12345(R0), R1
	copy.1	54321, R1
	copy.1	#123, R1
	
; DESTINATION: REGISTER INDIRECT MODE
	copy.1	R0, (R1)
	copy.1	(R0), (R1)
	copy.1	12345(R0),( R1)
	copy.1	54321, (R1)
	copy.1	#123, (R1)
	
; DESTINATION: REGISTER OFFSET MODE
	copy.1	R0, 123(R1)
	copy.1	(R0), 123(R1)
	copy.1	12345(R0),123( R1)
	copy.1	54321, 123(R1)
	copy.1	#123, 123(R1)
	
; DESTINATION: ADDRESS MODE
	copy.1	R0, 0x654321
	copy.1	(R0), 0x654321
	copy.1	12345(R0), 0x654321
	copy.1	54321, 0x654321
	copy.1	#123, 0x654321

; 2 byte copy
; DESTINATION: REGISTER MODE
	copy.2	R0, R1
	copy.2	(R0), R1
	copy.2	-12345(R0), R1
	copy.2	54321, R1
	copy.2	#123, R1
	
; DESTINATION: REGISTER INDIRECT MODE
	copy.2	R0, (R1)
	copy.2	(R0), (R1)
	copy.2	12345(R0),( R1)
	copy.2	54321, (R1)
	copy.2	#123, (R1)
	
; DESTINATION: REGISTER OFFSET MODE
	copy.2	R0, 123(R1)
	copy.2	(R0), 123(R1)
	copy.2	12345(R0),123( R1)
	copy.2	54321, 123(R1)
	copy.2	#123, 123(R1)
	
; DESTINATION: ADDRESS MODE
	copy.2	R0, 0x654321
	copy.2	(R0), 0x654321
	copy.2	12345(R0), 0x654321
	copy.2	54321, 0x654321
	copy.2	#123, 0x654321

; 4 byte copy
; DESTINATION: REGISTER MODE
	copy.4	R0, R1
	copy.4	(R0), R1
	copy.4	-12345(R0), R1
	copy.4	54321, R1
	copy.4	#123, R1
	
; DESTINATION: REGISTER INDIRECT MODE
	copy.4	R0, (R1)
	copy.4	(R0), (R1)
	copy.4	12345(R0),( R1)
	copy.4	54321, (R1)
	copy.4	#123, (R1)
	
; DESTINATION: REGISTER OFFSET MODE
	copy.4	R0, 123(R1)
	copy.4	(R0), 123(R1)
	copy.4	12345(R0),123( R1)
	copy.4	54321, 123(R1)
	copy.4	#123, 123(R1)
	
; DESTINATION: ADDRESS MODE
	copy.4	R0, 0x654321
	copy.4	(R0), 0x654321
	copy.4	12345(R0), 0x654321
	copy.4	54321, 0x654321
	copy.4	#123, 0x654321

; 8 byte copy
; DESTINATION: REGISTER MODE
	copy.8	R0, R1
	copy.8	(R0), R1
	copy.8	-12345(R0), R1
	copy.8	54321, R1
	copy.8	#123, R1
	
; DESTINATION: REGISTER INDIRECT MODE
	copy.8	R0, (R1)
	copy.8	(R0), (R1)
	copy.8	12345(R0),( R1)
	copy.8	54321, (R1)
	copy.8	#123, (R1)
	
; DESTINATION: REGISTER OFFSET MODE
	copy.8	R0, 123(R1)
	copy.8	(R0), 123(R1)
	copy.8	12345(R0),123( R1)
	copy.8	54321, 123(R1)
	copy.8	#123, 123(R1)
	
; DESTINATION: ADDRESS MODE
	copy.8	R0, 0x654321
	copy.8	(R0), 0x654321
	copy.8	12345(R0), 0x654321
	copy.8	54321, 0x654321
	copy.8	#123, 0x654321

; SP operations
	copy.4	#0x30000, SP

#def_data_size  4

; double operand integer
   add      r0, (r1)
   add.4    #10, SP
   and      5(r2), Loc1
   ashift   #12, r3
   bitest   (r0), 10(r1)
   comp     Loc1, r2
   copy.1   #200, (r3)
   copy     (sp), NEXT_RAM
   divu     #20, 456(r1)
   div      10(r0), Loc1
   mulu     r2, r3
   mul      r0, r1
   or       r0, r1
   sub      r2, r3
   xor      r0, r1

; single operand integer

   addc     r0
   clr      (r1)
   com      123(r2)
   decp     r3
   dec      Loc1
   incp     123(r1)
   inc      (r0)
   inv      Loc1
   pop      r2
   subc     321(r0)
   swap     Loc1
   sxt      r1
   test     (r2)
   psrcopy  r2       ; here because of its opcode format
   push     (r3)

; shift and rotate

   rl       r0
   rlc      (r1)
   rr       12(r2)
   rrc      Loc1
   rlb      r3
   rrb      (r0)
   sla      22(r1)
   sll      Loc1
   sllc     r2
   sra      (r3)
   srl      100(r0)
   srlc     Loc1

; single precision floating point

   fpsi     (r1)
   fpis     r0
   fpsadd   (r1)
   fpssub   345(r2)
   fpsmul   #0f123.4
   fpsdiv   Loc1
   fpsdp    r0
   fpscomp  789(r2)

; double precision floating point

   fpdi     (r1)
   fpid     r0
   fpdadd   (r1)
   fpdsub   345(r2)
   fpdmul   #0f123.4
   fpddiv   Loc1
   fpdsp    r0
   fpdcomp  789(r2)

; register set

   rsdef    15
   rscopy   12
   rsexch   14
   pushr    0x5         ; push r0 and r2
   popr     0xF         ; pop r0, r1, r2, r3
   setipl   2           ; here because of its opcode format
   rexch    1, 6        ; exchange r1 in the current set with r1 in rs6
   rcopy    2, 8        ; copy r2 in the current set to r2 in rs8

; short I/O

   iocopy   r0, PP1DATA
   iocopy   PP1DATA, (r2)
   ioor     (r1), PP2DATA
   ioand    #15, PP0DATA
   iotst    #4, PP3DATA

; block copy and misc

   bc
   bcis
   bcid

   ccc      NBIT
   ccs      CBIT

   nop

; program counter

_Labela:
   jmp      0x10000
   call     0x10000

   jmps     0x10000
   calls    0x10000

   jmpr     0x10000
   callr    0x10000

   jmp      r1
   call     r3

   jmpr     r2
   callr    r0
   
   rets
   reti
   wfi

   dbne     r2, _Labelb
   dbge     r1, _Labela
   
_Labelb:

   br       _Labela
   bcs      _Labelb
   bcc      Label_.c
   beq      _Labela
   bne      _Labelb
   bmi      Label_.c
   bpl      _Labela
   bvs      _Labelb
   bvc      Label_.c
   bgtu      _Labela
   bleu     _Labelb
   bge      Label_.c
   blt      _Labela
   bgt      _Labelb
   ble      Label_.c

Label_.c:

#define SYMBOL_1  1
#define SYMBOL_2  1

#if	SYMBOL_1 = 1
	#if	SYMBOL_2 = 1
		; here if SYMBOL_1 = 1 and SYMBOL_2 = 1
		; some code and/or directives
	#else
		; here if SYMBOL_1 = 1 and SYMBOL_2 != 1
		; some code and/or directives
	#endif	; SYMBOL_2 = 1
#else ; ( SYMBOL_1 != 1)
	#if	SYMBOL_2 = 1
		; here if SYMBOL_1 != 1 and SYMBOL_2 = 1
		; some code and/or directives
	#else
		; here if SYMBOL_1 != 1 and SYMBOL_2 != 1
		; some code and/or directives
	#endif	; SYMBOL_2 = 1
#endif ; SYMBOL_1 = 1

#nprint  PR_UN_IF
; Here is the same sample without using indenting or the additional comments:
#if	SYMBOL_1 = 1
#if	SYMBOL_2 = 1
		; some code and/or directives
#else
		; some code and/or directives
#endif
#else
#if	SYMBOL_2 = 1
		; some code and/or directives
#else
		; some code and/or directives
#endif
#endif
