; Sample_Alloc.asm
#nprint	PR_PROC_DEFS         ; do not print the processor definitions
; define the starting addresses for each of the known areas of memory:
; remember that the first 0x400 bytes are for the interrupt vectors.

#radix		10										; set the default radix
#address		NEXT_ROM		0x400					; start storing constants at 0x400
#address		NEXT_PC		NEXT_ROM+0x1000	; allow an area of 0x1000 bytes for constants
#address		NEXT_RAM		0x30000				; RAM starting address  sets the Address Pointer
Value_1:		#alloc.1								; create a 1-byte variable with the name Value_1
Value_2:		#alloc.4								; create a 4-byte variable with the name Value_2
;  NEXT_RAM now is 0x30006 due to the #alloc.4 being forced to start on an even address

#address	NEXT_ROM									; set the Address Pointer to NEXT_ROM (0x400)
Const_1:       #alloc.2		0x1234			; create a 2byte constant
Const_Values:  #alloc.1		1,2,3,4,5		; create a table of constants with 5 bytes
; NEXT_ROM now is 0x407

#address		NEXT_PC								; set the Address Pointer to NEXT_PC (0x1400)
#vector		VECTOR_START						; set startup vector to the value of  NEXT_PC
Program_Start:										; label of the start of the program
#allocb.1 	0x1234								; dummy directive to simulate block of code
; NEXT_PC is now 0x2634

; set up some variables for Function_1
#address		NEXT_RAM								; set the Address Pointer to NEXT_RAM (0x30006)
Block_1:		#allocb.1		10					; allocate 10 elements of 1 byte each
Block_2:		#allocb.8		32					; allocate 32 elements of 8 bytes each
; NEXT_RAM now is 0x30006 + 10. + (32*8) = 0x30006 + 0x000A + 0x0100 = 0x30110

#address	NEXT_PC									; set the Address Pointer to NEXT_PC (0x2634)
Function1_Consts:	#alloc.4	54321, 0x12345, 98765, 56789	; some constants for Function_1
; NEXT_PC is now 0x2634 + 16. = 0x2644
Function_1:
#allocb.1 		0x234								; dummy directive to simulate block of code
; NEXT_PC is now 0x2644 + 0x234. = 0x2878

; ISR for serial port 1 transmitter
#vector	VECTOR_SP1TX							; use NEXT_PC as the value for <address of ISR>
SP1TxISR:
; code for the transmit ISR

#vector VECTOR_ERROR       ; to keep the assembler happy
#vector VECTOR_RTC
   reti
