#print	0			; disable all printing
/* Processor_Definitions.h
This file contains memory and I/O definitions for the processor
*/
// define interrupt vectors *****************************************************************
#define		VECTOR_START	0x0000
#define		VECTOR_RTC		0x0004
#define		VECTOR_ERROR	0x0008
;leave a "hole" here (0x000C) in order to start the next group on a "nice" boundary
#define		VECTOR_SP0TX	0x0010
#define		VECTOR_SP0RX	0x0014
#define		VECTOR_SP1TX	0x0018
#define		VECTOR_SP1RX	0x001C
#define		VECTOR_SP2TX	0x0020
#define		VECTOR_SP2RX	0x0024
#define		VECTOR_SP3TX	0x0028
#define		VECTOR_SP3RX	0x002C
#define		VECTOR_SP4TX	0x0030
#define		VECTOR_SP4RX	0x0034
#define		VECTOR_SP5TX	0x0038
#define		VECTOR_SP5RX	0x003C
#define		VECTOR_SP6TX	0x0040
#define		VECTOR_SP6RX	0x0044
#define		VECTOR_SP7TX	0x0048
#define		VECTOR_SP7RX	0x004C

#define		VECTOR_TMR0		0x0050
#define		VECTOR_TMR1		0x0054
#define		VECTOR_TMR2		0x0058
#define		VECTOR_TMR3		0x005C
#define		VECTOR_TMR4		0x0060
#define		VECTOR_TMR5		0x0064
#define		VECTOR_TMR6		0x0068
#define		VECTOR_TMR7		0x006C
#define		VECTOR_TMR8		0x0070
#define		VECTOR_TMR9		0x0074
#define		VECTOR_TMRA		0x0078
#define		VECTOR_TMRB		0x007C
#define		VECTOR_TMRC		0x0080
#define		VECTOR_TMRD		0x0084
#define		VECTOR_TMRE		0x0088
#define		VECTOR_TMRF		0x008C

#define		VECTOR_PM0		0x0090
#define		VECTOR_PM1		0x0094
#define		VECTOR_PM2		0x0098
#define		VECTOR_PM3		0x009C
#define		VECTOR_PM4		0x0090
#define		VECTOR_PM5		0x0094
#define		VECTOR_PM6		0x0098
#define		VECTOR_PM7		0x009C

// Note that each group of registers starts at a "nice" address.  This is not necessary but does make it
// easier to recognize the address once you are familiar with them.
// define parallel Port Registers *************************************************************
#define		PP0.0CFG		0xFFFF0000
#define		PP0.1CFG		0xFFFF0001
#define		PP0.2CFG		0xFFFF0002
#define		PP0.3CFG		0xFFFF0003
#define		PP0.4CFG		0xFFFF0004
#define		PP0.5CFG		0xFFFF0005
#define		PP0.6CFG		0xFFFF0006
#define		PP0.7CFG		0xFFFF0007
#define		PP0DATA		0xFFFF0008
#define		PP0CFG			0xFFFF0009

#define		PP1.0CFG		0xFFFF0010
#define		PP1.1CFG		0xFFFF0011
#define		PP1.2CFG		0xFFFF0012
#define		PP1.3CFG		0xFFFF0013
#define		PP1.4CFG		0xFFFF0014
#define		PP1.5CFG		0xFFFF0015
#define		PP1.6CFG		0xFFFF0016
#define		PP1.7CFG		0xFFFF0017
#define		PP1DATA		0xFFFF0018
#define		PP1CFG			0xFFFF0019

#define		PP2.0CFG		0xFFFF0020
#define		PP2.1CFG		0xFFFF0021
#define		PP2.2CFG		0xFFFF0022
#define		PP2.3CFG		0xFFFF0023
#define		PP2.4CFG		0xFFFF0024
#define		PP2.5CFG		0xFFFF0025
#define		PP2.6CFG		0xFFFF0026
#define		PP2.7CFG		0xFFFF0027
#define		PP2DATA		0xFFFF0028
#define		PP2CFG			0xFFFF0029

#define		PP3.0CFG		0xFFFF0030
#define		PP3.1CFG		0xFFFF0031
#define		PP3.2CFG		0xFFFF0032
#define		PP3.3CFG		0xFFFF0033
#define		PP3.4CFG		0xFFFF0034
#define		PP3.5CFG		0xFFFF0035
#define		PP3.6CFG		0xFFFF0036
#define		PP3.7CFG		0xFFFF0037
#define		PP3DATA		0xFFFF0038
#define		PP3CFG			0xFFFF0039

#define		PP4.0CFG		0xFFFF0040
#define		PP4.1CFG		0xFFFF0041
#define		PP4.2CFG		0xFFFF0042
#define		PP4.3CFG		0xFFFF0043
#define		PP4.4CFG		0xFFFF0044
#define		PP4.5CFG		0xFFFF0045
#define		PP4.6CFG		0xFFFF0046
#define		PP4.7CFG		0xFFFF0047
#define		PP4DATA		0xFFFF0048
#define		PP4CFG			0xFFFF0049

#define		PP5.0CFG		0xFFFF0050
#define		PP5.1CFG		0xFFFF0051
#define		PP5.2CFG		0xFFFF0052
#define		PP5.3CFG		0xFFFF0053
#define		PP5.4CFG		0xFFFF0054
#define		PP5.5CFG		0xFFFF0055
#define		PP5.6CFG		0xFFFF0056
#define		PP5.7CFG		0xFFFF0057
#define		PP5DATA		0xFFFF0058
#define		PP5CFG			0xFFFF0059

#define		PP6.0CFG		0xFFFF0060
#define		PP6.1CFG		0xFFFF0061
#define		PP6.2CFG		0xFFFF0062
#define		PP6.3CFG		0xFFFF0063
#define		PP6.4CFG		0xFFFF0064
#define		PP6.5CFG		0xFFFF0065
#define		PP6.6CFG		0xFFFF0066
#define		PP6.7CFG		0xFFFF0067
#define		PP6DATA		0xFFFF0068
#define		PP6CFG			0xFFFF0069

#define		PP7.0CFG		0xFFFF0070
#define		PP7.1CFG		0xFFFF0071
#define		PP7.2CFG		0xFFFF0072
#define		PP7.3CFG		0xFFFF0073
#define		PP7.4CFG		0xFFFF0074
#define		PP7.5CFG		0xFFFF0075
#define		PP7.6CFG		0xFFFF0076
#define		PP7.7CFG		0xFFFF0077
#define		PP7DATA		0xFFFF0078
#define		PP7CFG 		0xFFFF0079

// define serial port registers ***************************************************************
#define		SP0DATA		0xFFFF0100
#define		SP0DIV			0xFFFF0102
#define		SP0RPORT	0xFFFF0104
#define		SP0CFG			0xFFFF0105
#define		SP0CLK			0xFFFF0106
#define		SP0INT			0xFFFF0107
#define		SP0STAT		0xFFFF0108

#define		SP1DATA		0xFFFF0110
#define		SP1DIV			0xFFFF0112
#define		SP1RPORT	0xFFFF0114
#define		SP1CFG			0xFFFF0115
#define		SP1CLK			0xFFFF0116
#define		SP1INT			0xFFFF0117
#define		SP1STAT		0xFFFF0118

#define		SP2DATA		0xFFFF0120
#define		SP2DIV			0xFFFF0122
#define		SP2RPORT	0xFFFF0124
#define		SP2CFG			0xFFFF0125
#define		SP2CLK			0xFFFF0126
#define		SP2INT			0xFFFF0127
#define		SP2STAT		0xFFFF0128

#define		SP3DATA		0xFFFF0130
#define		SP3DIV			0xFFFF0132
#define		SP3RPORT	0xFFFF0134
#define		SP3CFG			0xFFFF0135
#define		SP3CLK			0xFFFF0136
#define		SP3INT			0xFFFF0137
#define		SP3STAT		0xFFFF0138

#define		SP4DATA		0xFFFF0140
#define		SP4DIV			0xFFFF0142
#define		SP4RPORT	0xFFFF0144
#define		SP4CFG			0xFFFF0145
#define		SP4CLK			0xFFFF0146
#define		SP4INT			0xFFFF0147
#define		SP4STAT		0xFFFF0148

#define		SP5DATA		0xFFFF0150
#define		SP5DIV			0xFFFF0152
#define		SP5RPORT	0xFFFF0154
#define		SP5CFG			0xFFFF0155
#define		SP5CLK			0xFFFF0156
#define		SP5INT			0xFFFF0157
#define		SP5STAT		0xFFFF0158

#define		SP6DATA		0xFFFF0160
#define		SP6DIV			0xFFFF0162
#define		SP6RPORT	0xFFFF0164
#define		SP6CFG			0xFFFF0165
#define		SP6CLK			0xFFFF0166
#define		SP6INT			0xFFFF0167
#define		SP6STAT		0xFFFF0168

#define		SP7DATA		0xFFFF0170
#define		SP7DIV			0xFFFF0172
#define		SP7RPORT	0xFFFF0174
#define		SP7CFG			0xFFFF0175
#define		SP7CLK			0xFFFF0176
#define		SP7INT			0xFFFF0177
#define		SP7STAT		0xFFFF0178

// define Timer registers **********************************************************************
#define		T0DATA		0xFFFF0200
#define		T0CLK			0xFFFF0204
#define		T0CFG			0xFFFF0205
#define		T0START		0xFFFF0206
#define		T0STOP		0xFFFF0207
#define		T0INT			0xFFFF0208
#define		T0STAT		0xFFFF0209

#define		T1DATA		0xFFFF0210
#define		T1CLK			0xFFFF0214
#define		T1CFG			0xFFFF0215
#define		T1START		0xFFFF0216
#define		T1STOP		0xFFFF0217
#define		T1INT			0xFFFF0218
#define		T1STAT		0xFFFF0219

#define		T2DATA		0xFFFF0220
#define		T2CLK			0xFFFF0224
#define		T2CFG			0xFFFF0225
#define		T2START		0xFFFF0226
#define		T2STOP		0xFFFF0227
#define		T2INT			0xFFFF0228
#define		T2STAT		0xFFFF0229

#define		T3DATA		0xFFFF0230
#define		T3CLK			0xFFFF0234
#define		T3CFG			0xFFFF0235
#define		T3START		0xFFFF0236
#define		T3STOP		0xFFFF0237
#define		T3INT			0xFFFF0238
#define		T3STAT		0xFFFF0239

#define		T4DATA		0xFFFF0240
#define		T4CLK			0xFFFF0244
#define		T4CFG			0xFFFF0245
#define		T4START		0xFFFF0246
#define		T4STOP		0xFFFF0247
#define		T4INT			0xFFFF0248
#define		T4STAT		0xFFFF0249

#define		T5DATA		0xFFFF0250
#define		T5CLK			0xFFFF0254
#define		T5CFG			0xFFFF0255
#define		T5START		0xFFFF0256
#define		T5STOP		0xFFFF0257
#define		T5INT			0xFFFF0258
#define		T5STAT		0xFFFF0259

#define		T6DATA		0xFFFF0260
#define		T6CLK			0xFFFF0264
#define		T6CFG			0xFFFF0265
#define		T6START		0xFFFF0266
#define		T6STOP		0xFFFF0267
#define		T6INT			0xFFFF0268
#define		T6STAT		0xFFFF0269

#define		T7DATA		0xFFFF0270
#define		T7CLK			0xFFFF0274
#define		T7CFG			0xFFFF0275
#define		T7START		0xFFFF0276
#define		T7STOP		0xFFFF0277
#define		T7INT			0xFFFF0278
#define		T7STAT		0xFFFF0279

#define		T8DATA		0xFFFF0280
#define		T8CLK			0xFFFF0284
#define		T8CFG			0xFFFF0285
#define		T8START		0xFFFF0286
#define		T8STOP		0xFFFF0287
#define		T8INT			0xFFFF0288
#define		T8STAT		0xFFFF0289

#define		T9DATA		0xFFFF0290
#define		T9CLK			0xFFFF0294
#define		T9CFG			0xFFFF0295
#define		T9START		0xFFFF0296
#define		T9STOP		0xFFFF0297
#define		T9INT			0xFFFF0298
#define		T9STAT		0xFFFF0299

#define		TADATA		0xFFFF02A0
#define		TACLK			0xFFFF02A4
#define		TACFG			0xFFFF02A5
#define		TASTART		0xFFFF02A6
#define		TASTOP		0xFFFF02A7
#define		TAINT			0xFFFF02A8
#define		TASTAT		0xFFFF0229

#define		TBDATA		0xFFFF02B0
#define		TBCLK			0xFFFF02B4
#define		TBCFG			0xFFFF02B5
#define		TBSTART		0xFFFF02B6
#define		TBSTOP		0xFFFF02B7
#define		TBINT			0xFFFF02B8
#define		TBSTAT		0xFFFF02B9

#define		TCDATA		0xFFFF02C0
#define		TCCLK			0xFFFF02C4
#define		TCCFG			0xFFFF02C5
#define		TCSTART		0xFFFF02C6
#define		TCSTOP		0xFFFF02C7
#define		TCINT			0xFFFF02C8
#define		TCSTAT		0xFFFF02C9

#define		TDDATA		0xFFFF02D0
#define		TDCLK			0xFFFF02D4
#define		TDCFG			0xFFFF02D5
#define		TDSTART		0xFFFF02D6
#define		TDSTOP		0xFFFF02D7
#define		TDINT			0xFFFF02D8
#define		TDSTAT		0xFFFF02D9

#define		TEDATA		0xFFFF02E0
#define		TECLK			0xFFFF02E4
#define		TECFG			0xFFFF02E5
#define		TESTART		0xFFFF02E6
#define		TESTOP		0xFFFF02E7
#define		TEINT			0xFFFF02E8
#define		TESTAT		0xFFFF02E9

#define		TFDATA		0xFFFF02F0
#define		TFCLK			0xFFFF02F4
#define		TFCFG			0xFFFF02F5
#define		TFSTART		0xFFFF02F6
#define		TFSTOP		0xFFFF02F7
#define		TFINT			0xFFFF02F8
#define		TFSTAT		0xFFFF02F9

// define Pulse Modulator Registers ************************************************************
#define		PM0WIDTH		0xFFFF0300
#define		PM0DELAY		0xFFFF0304
#define		PM0CFG			0xFFFF0308

#define		PM1WIDTH		0xFFFF0310
#define		PM1DELAY		0xFFFF0314
#define		PM1CFG			0xFFFF0318

#define		PM2WIDTH		0xFFFF0320
#define		PM2DELAY		0xFFFF0324
#define		PM2CFG			0xFFFF0328

#define		PM3WIDTH		0xFFFF0330
#define		PM3DELAY		0xFFFF0334
#define		PM3CFG			0xFFFF0338

#define		PM4WIDTH		0xFFFF0340
#define		PM4DELAY		0xFFFF0344
#define		PM4CFG			0xFFFF0348

#define		PM5WIDTH		0xFFFF0350
#define		PM5DELAY		0xFFFF0354
#define		PM5CFG			0xFFFF0358

#define		PM6WIDTH		0xFFFF0360
#define		PM6DELAY		0xFFFF0364
#define		PM6CFG			0xFFFF0368

#define		PM7WIDTH		0xFFFF0370
#define		PM7DELAY		0xFFFF0374
#define		PM7CFG			0xFFFF0378

// define misc Registers *******************************************************************
#define		CPU_FREQUENCY	0xFFFFFF00

//*****************************************************************************************
; some other useful definitions

#define		BIT00			0x0001
#define		BIT01			0x0002
#define		BIT02			0x0004
#define		BIT03			0x0008
#define		BIT04			0x0010
#define		BIT05			0x0020
#define		BIT06			0x0040
#define		BIT07			0x0080
#define		BIT08			0x0100
#define		BIT09			0x0200
#define		BIT10			0x0400
#define		BIT11			0x0800
#define		BIT12			0x1000
#define		BIT13			0x2000
#define		BIT14			0x4000
#define		BIT15			0x8000

#define  NBIT				0d1
#define  ZBIT  			0d2
#define  CBIT  			0d4
#define  VBIT  			0d8

; print option definitions
#define  PR_ALL		         0x7FFF
#define  PR_PROC_DEFS	0x01
#define  PR_UN_IF		      0x02
#define  PR_SYMBOL			0x04

#print	PR_ALL	; enable printing
