;Polynomial.asm

#nprint PR_PROC_DEFS    ; do not print the definitions from Processor_Definitions.h

#address NEXT_ROM		0x400
Poly_1:
   #alloc.2    4        ;integer: order of the polynomial
   #alloc.4    0f3.14159  ; SPFP: the value of X
   #alloc.4    0f2.0, 0f3.0, 0f4.0, 0f5.0 ; SPFP: array of multipliers-low order 1st


#address NEXT_PC     0x1000

#vector VECTOR_ERROR       ; to keep the assembler happy
#vector VECTOR_RTC
   reti

#vector VECTOR_START
   copy.4   #0x30000, SP
   copy.4   #Poly_1, R0
   calls    Polynomial
Loop:
   br       Loop
   
Polynomial:
; get the Order of the  polynomial, value of X, and point to table of multipliers
   copy.4   R0, R3         ; copy address of structure 
   copy.2   (R3), R5       ; get order
   incp.2   R3             ; point to X
   copy.4   (R3), R2       ; get X
   incp.4   R3             ; point to table of multipliers
   clr.4    R6             ; initialize answer
   copy.4   #0f1.0, R1     ; initialize X^n

;	R1 = X^n
;	R2 = X
;	R3 = pointing to X^0 multiplier
;	R4 = multiplier
;	R5 = order of polynomial, counts down to -1
;	R6	= answer

   copy.4   R1, R0         ; get initial value of X^n
Polynomial_1:
; Result = Result + Multiplier * X^n
   copy.4   (R3), R4       ; get multiplier
   fpsmul   R4             ; R0 = R0*R4 = A(n)*X^n
   fpsadd   R6             ; R0 = R0+R6 = (A(n)*X^n) + previous result
; set up for next iteration
   copy.4   R0, R6         ; save answer for next time
   incp.4   R3             ; point to next multiplier
   copy.4   R2, R0         ; copy of X
   fpsmul   R1             ; R0 = R0*R1 => X^(n+1) = X * X(n)
   copy.4   R0, R1         ; save it
   dbge     R4, Polynomial_1
;
   copy.4   R6, R0         ; retrieve answer
   rets
