; Exercise_8.asm

; put in the "stuff" to allow the function to be compiled

#nprint		PR_PROC_DEFS     ;do not print the standard processor definitions

;******************************* Memory Definitions *********************************

;	define the RAM values
#define     RAMSTART    0x40000				; starting address of RAM
#define     RAMSIZE     0x40000				;		and its size
#define     RAMEND      RAMSTART+ RAMSIZE	; calculate the end address of the RAM

;	define the stack size and  location
#define     STACKSIZE   0x1000       		; size of stack
#define     STACK_TOP   RAMEND - STACKSIZE ; top of the stack

;	define the values for the Address Pointer
#address    NEXT_ROM    0x400					; starting address to put any constants
#address    NEXT_PC     0x1000	    		; starting address of the program
#address    NEXT_RAM    RAMSTART    		; start of the RAM

; define the error codes used by the function
#define		ERR_INV_REGISTER		-100
#define		ERR_INV_BYTE_COUNT	ERR_INV_REGISTER - 1

#address    NEXT_PC              			; set the Address Pointer to the start of the program

#vector     VECTOR_RTC        				; dummy ISR required by the assembler
   reti

#vector     VECTOR_START         			; set the start up vector to point to the first
														;		instruction of the function

/* IOWrite - Write a data value to an I/O register.

Enter with:
	R0 = number of bytes ( 1,2,4,8 )
	R1 = register address
	R2 = data
Exit with:
	R0 = 0 = success
		= ERR_INV_BYTE_COUNT
		= ERR_INV_REGISTER  the register address is not in the I/O address range
*/

IOWrite:
	comp.4	#0xFFFF0000, r1					;within I/O address range?
	bgtu		IOWrite_err1						; branch if no

	comp.1	r0, #1								; write 1 byte?
	bne		IOWrite_2							; br if no
	copy.1	r2, (r1)
	clr.2		r0
	rets

IOWrite_2:
	comp.1	r0, #2								; write 2 bytes?
	bne		IOWrite_4							; br if no
	copy.2	r2, (r1)
	clr.2		r0
	rets

IOWrite_4:
	comp.1	r0, #4								; write 4 bytes?
	bne		IOWrite_8							; br if no
	copy.4	r2, (r1)
	clr.2		r0
	rets

IOWrite_8:
	comp.1	r0, #8								; write 8 bytes?
	bne		IOWrite_err0						; br if no
	copy.8	r2, (r1)
	clr.2		r0
	rets

IOWrite_err0:
	copy.2	#ERR_INV_BYTE_COUNT, r0
	rets

IOWrite_err1:
	copy.2	#ERR_INV_REGISTER, r0
	rets

/* PPWrite - Write a data value to a parallel output port.

This function can be considered as a subset of IOWrite since the parallel I/O port
registers are a subset of all the registers.  This function basically does a more
specific test for register validity as well as writing only one byte.

Enter with:
	R0 = register address
	R1 = data
Exit with:
	R0 = 0 = success
		= ERR_INV_REGISTER  the register address is not in the I/O address range
The register address should be in the range 0xFFFF00(0-7)8
*/
#define		PPMASK		0xFFFF0078

PPWrite:
	copy.4	r0, r2							; copy PP register for test
	or.4		#0x70, r2						; form PP mask
	comp.4	r2, #PPMASK						; valid parallel port?
	bne		PPWrite_err						; br if no
	copy.1	r1, (r0)							; write the data to the port
	clr.2		r0									; show success
	rets

PPWrite_err:
	copy.2	#ERR_INV_REGISTER, r0
	rets
