/* Exercise_6.asm

Task: implement two ISRs:
Real Time clock which maintains the seconds, minutes, hours, and days the program has been running.
A timer with 1 millisecond resolution.

 First it would be a good idea to outline the entire process:
 1.The initialization set-up just like the previous exercises and samples
 2.Program code
(a)Set the startup vector
(b)Initialize the Stack Pointer
(c)Initialize all RAM values as required by the ISRs.
(d)Enable the interrupts
 3.RTC ISR
 4.Timer ISR
*/

#nprint PR_SYMBOL                   ; do not print the symbols from Processor_Definitions.h

;********************************* Memory Definitions *******************************

;	define the RAM values
#define  RAMSTART    0x40000        ; starting address of RAM
#define  RAMSIZE     0x40000        ;		and its size
#define  RAMEND      RAMSTART+ RAMSIZE	; calculate the end address of the RAM

;	define the stack size and  location
#define  STACKSIZE   0x1000         ; size of stack
#define  STACK_TOP   RAMEND - STACKSIZE	; top of the stack

;	define the values for the Address Pointer
#address NEXT_ROM    0x400	         ; starting address to put any constants
#address NEXT_PC     0x1000         ; starting address of the program
#address NEXT_RAM    RAMSTART       ; start of the RAM

;********************************************************************************
; Define any other constants that may be needed for this task
; ***	Other values


;********************************************************************************
; Interrupt Vectors
; The interrupt vectors will be set using the alternative method  placing the #vector directive immediately before the
; code for the interrupt itself.

;********************************************************************************
; Any required constants
#address NEXT_ROM
; none required

;********************************************************************************
; Any required RAM
#address NEXT_RAM                   ; set the Address Pointer to the next available RAM

; allocate the RAM needed to store the time values
Seconds:    #alloc.1
Minutes:    #alloc.1
Hours:      #alloc.1
Days:       #alloc.2
; millisecond time value used by Timer F ISR
MilliSeconds:  #alloc.4

#define  BYTES2CLEAR NEXT_RAM - Seconds	; calculate the nbr of bytes to clear for initialization

/* Notice the interesting calculation that the assembler can do in order to
calculate the number of bytes used for storing the time values.  NEXT_RAM is
a symbol while Seconds is a label; however, you need to remember that a label
is a special case of a symbol.
You should also notice that the assembler seems to allocate two bytes for hours.
This is because the next #alloc is for two bytes - the assembler automatically
aligns it to an even address.
Even though it is not part of this exercise, it would be possible for this
"structure" to maintain real date information if a program is written to first
enter the current date and time into it.  The structure could easily be expanded
to include the month and year.  The additional values would be: DayOfMonth, Month
and Year.  In order to do this properly, there would also be a table of constants
containing the number of days for each month.  A special test or a separate table
would be required to handle Leap Year.
*/

;********************************************************************************
; Program code

#if   NEXT_ROM >= NEXT_PC
   #error "NEXT_ROM incursion into NEXT_PC"
#endif

#address NEXT_PC                 ; set the Address Pointer to the start of the program
#vector  VECTOR_START            ; set up the start up vector to point to the first instruction

;************************ begin initialization code ************************************
; first set up the stack pointer
   copy.4   #RAMEND, SP          ; set up the stack pointer to the top of the RAM
   setipl   0                    ; enable interrupts

; initialize RAM values
   copy.2   #BYTES2CLEAR, r0     ; get number of bytes in the Time structure
   copy.4   #Seconds, r1         ; get the address to start clearing
Main_1:
   clr.1    (r1)                 ; clear a byte
   incp.1   r1                   ; point to the next byte
   dbne     r0, Main_1           ; update byte count and branch if not done all bytes
; The above is a general purpose routine which will clear any number of contiguous bytes.
; Knowing that there are only nine bytes to be cleared a much shorter set of instructions is:
;	clr.1		Seconds							; clear the first byte
;	clr.8		Seconds+1						; clear the remaining bytes

; this is the appropriate point to insert code to enable the RTC interrupt

/* set up a 1-millisecond interrupt using Timer F
When programming an I/O device, it is a good idea to have a description of all the registers handy.
Review each register to see what needs to be programmed.  When writing the code to set up an ISR,
you should enable the interrupt as the last step.
*/
   iocopy.4    CPU_FREQUENCY, r0 ; get the cpu clock frequency  in Hz
   div.4       #1000, r0         ; calculate timer divisor for 1kHz
   iocopy.4    r0, TFDATA        ; set timer F divisor
   clr.1       TFCLK             ; use CPU clock
   iocopy.1    #0xC0, TFCFG      ; enable timer F to count using value in TFDATA
   iocopy.1    #1, TFINT         ; enable Timer F interrupt at IPL = 1
Main_end:
   br          Main_end	         ; loop forever  since there is no main program for this
                                 ;		exercise.

;****************************** RTC_ISR ******************************************
#vector		VECTOR_RTC
RTC_ISR:											; not strictly needed but good for documentation
/* This ISR updates the variables:
		Seconds - byte
		Minutes - byte
		Hours - byte
		Days - word
based on the interrupt occurring once per second.
*/
      ; the interrupt is cleared simply by servicing it
; update Seconds
   copy.4   #Seconds, r0         ; 3 get the address of the time structure
   inc.1 (r0)                    ; 3 update seconds
   comp.1   #60, (r0)            ; 3 done this minute?
   bgt      RTC_ISR_EXIT         ; 3/2 br if no
   clr.1	   (r0)                 ; 2 start new minute  seconds = 0
; update Minutes
   incp.1   r0                   ; 2 point to Minutes
   inc.1	   (r0)                 ; 3 update
   comp.1   #60, (r0)            ; 3 done this hour?
   bgt      RTC_ISR_EXIT         ; 3/2 br if no
   clr.1	   (r0)                 ; 2 start new hour  minutes = 0
; update Hours
   incp.1   r0                   ; 2 point to Hours
   inc.1	   (r0)                 ; 3 update
   comp.1   #24, (r0)            ; 3 done this day?
   bgt      RTC_ISR_EXIT         ; 3/2 br if no
   clr.1	   (r0)                 ; 3 start new day  hours = 0
; update Days
   incp.1   r0	                  ; 2 point to Days
   inc.2	   (r0)                 ; 3 update
RTC_ISR_EXIT:
   reti                          ; 6

/* Most of the interrupts will just update the Seconds count which takes a total of 18 clocks plus the interrupt latency.  If all values need to be updated, the total is 49 clocks plus the interrupt latency.  Assuming an average instruction takes 4 clocks, the latency will be 12 clocks:
4 for the current instruction to finish
3 to push the PC onto the stack
2 to push the PSR onto the stack
2 to retrieve the address of the ISR from the vector table
1 to place the ISR address into the PC
  This will yield between 30 and 61 clocks total to service the interrupts.
*/


;******************************* Timer F_ISR **************************************
#vector	VECTOR_TMRF             ; use Timer F for the 1 millisecond interrupt
TimerF_ISR:                      ; not strictly needed but good for documentation
// This ISR updates the variable MilliSeconds ( 4 bytes )

   iocopy.1 TFSTAT, r0           ; get status and clear the interrupt
   inc.4    MilliSeconds         ; update milliseconds count
   reti
