; Exercise 5a
/* Polynomial- this function will calculate the value of Y given all the parameters for a polynomial.
   Enter with:	R0 = address of the structure
   the structure must be stored as follows:
      #alloc.2	integer: order of the polynomial
      #alloc.4	SPFP: the value of X
      #allocb.4	SPFP: array of multipliers  lowest order first
   Exit with:		R0 = Y
   Register usage: R0, R1, R2, R3
Here is an outline of the algorithm:
   get the Order of the  polynomial and the value of X from the structure
   initialize the Multiplicand to x0 = 1
   initialize Result to 0
   initialize a pointer to the array of multipliers
   Loop:
      Result = Result + Multiplicand * (pointer to array)
      Multiplicand =  Multiplicand * X
      increment pointer to point to next Multiplier value in array
      decrement Order and branch to Loop if positive (note: 0 is  positive)
   Result now has the answer.

This algorithm makes use of a feature which is not available in most processors:
   using two halves of a register as independent registers.  This can be done because the instructions only
   operate on the number of bytes defined by the <size> value specified in the instruction.  Some processors
   have alternate register sets which can be used such as are available in the X86 processors and derivatives.
   Other processors may have enough registers to handle the algorithm without resorting to other tricks.
   As stated earlier in this book, one of the keys to efficient assembly language programming for any processor
   is a really good understanding of its register set.
*/

#def_data_size    4     ; NOTE - DEFAULT DATA SIZE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

; memory definitions
#address NEXT_PC        0x1000
#address NEXT_ROM       0x400

; allocate the structure for the polynomial function
PolyStruct:
   #alloc.2    3	       ; integer: order of the polynomial
   #alloc      0f4.0    ; SPFP: the value of X
   #alloc      0f5.0, 0f6.0, 0f7.0 ; SPFP: array of multipliers - lowest order first

#define  fpval1   0f12345.6789e5   
   #alloc      fpval1
   #alloc      fpval1*0f-1.0
   #alloc.8    fpval1
   #alloc.8    fpval1*0f-1.0

#address NEXT_RAM       0x100000
#define  STACK_BOTTOM   NEXT_RAM + 0x100000

#address NEXT_PC
#vector  VECTOR_START
Main:
   copy     #STACK_BOTTOM, SP ; initialize the stack pointer to the highest RAM
   copy     #PolyStruct, R0   ; point to the structure with the polynomial values
   calls    Polynomial
ProgramEnd:
   br       ProgramEnd        ; done - do not let the PC fall through to the function

Polynomial:
; get the Order of the  polynomial and the value of X from the structure
   copy        R0, R3      ; copy address of structure 
   copy.2      (R3), R1    ; get the order of the polynomial
   swap        R1          ; use 'other' 4 bytes for multiplicand
   fpis.1      #1          ; initialize the multiplicand to 1.0
   copy        R0, R1      ; copy for algorithm
   swap        R1          ; get order of the polynomial into low bytes
   incp.2      R3          ; point to the X value
   copy        (R3), R2    ; get the X value
   incp        R3          ; point to the array of multipliers
   swap        R3          ; use 'other' 4 bytes for answer
   clr         R3          ; initialize the answer
   swap        R3          ; retrieve array address

; R0 = floating point accumulator
; R1 = order of the polynomial and multiplicand
; R2 = X
; R3 = address of the X0 multiplier and answer

Polynomial_1:
; Result = Result + Multiplicand * (pointer to array)
   swap        R1          ; retrieve multiplicand
   copy        R1, R0      ; get working copy of multiplicand
   fpsmul      (R3)        ; R0 = multiplier * multiplicand
   swap        R3          ; get Result into low 4 bytes
   fpsadd      R3          ; R0 = Result + multiplier * multiplicand

; the following instructions are setting up for the next iteration of the loop
   copy        R0, R3	     ; save it
   swap        R3          ; retrieve address of Multiplier array

; Multiplicand =  Multiplicand * X
   copy        R1, R0      ; get multiplicand
   fpsmul      R2          ; R0 = multiplicand * X
   copy        R0, R1      ; save it

; increment pointer to point to next Multiplier value in array
   incp        R3          ; update pointer to array

; decrement Order and branch to Loop if not 0
   swap        R1          ; retrieve order of the polynomial
   dbge        R1, Polynomial_1		; branch if not done

; Result now has the answer
   swap        R3          ; retrieve answer
   copy        R3, R0      ; save for return to caller
   rets

#vector  VECTOR_RTC        ; keep the assembler happy
   reti